/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.image.IRasterConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class GrayscaleColorConverter
implements IRasterConverter {
    final int IMAGE_DEPTH = 256;
    final int INCREASE = 0;
    final int DECREASE = 1;
    public static final int _256_COLORS = 0;
    final int GRAY_SCALE = 1;
    final int CONTRASTED_COLOR = 2;
    public int[][] raster = null;
    private int[] colormap = new int[256];
    private BufferedImage image;
    private IImageViewer imgviewer;
    private final int NB_MAIN_COLORS = 8;
    private final int BLACK = 0;
    private final int BLUE = 32;
    private final int CYAN = 64;
    private final int GREEN = 96;
    private final int YELLOW = 128;
    private final int WHITE = 160;
    private final int MAGENTA = 192;
    private final int RED = 224;
    private final int BG_MAX = 64;
    private Rectangle roi = null;

    public GrayscaleColorConverter(int lut_num) {
        switch (lut_num) {
            case 0: {
                this.set256ColorsLookUpTable();
                break;
            }
            case 1: {
                this.setGrayScaleLookUpTable();
            }
        }
    }

    public void changeLookUpTable(int lut_num) {
        switch (lut_num) {
            case 0: {
                this.set256ColorsLookUpTable();
                break;
            }
            case 1: {
                this.setGrayScaleLookUpTable();
            }
        }
        if (this.image == null) {
            return;
        }
        for (int y = 0; y < this.image.getHeight(); ++y) {
            for (int x = 0; x < this.image.getWidth(); ++x) {
                this.image.setRGB(x, y, this.colormap[this.raster[x][y]]);
            }
        }
        this.imgviewer.repaint();
    }

    private void setGrayScaleLookUpTable() {
        for (int i = 0; i < 256; ++i) {
            Color color = new Color(i, i, i);
            this.colormap[i] = color.getRGB();
        }
    }

    private void set256ColorsLookUpTable() {
        int r = 0;
        int g = 0;
        int b = 0;
        int colorInc = 4;
        for (int i = 0; i < 256; ++i) {
            if (i == 0) {
                b = 0;
                g = 0;
                r = 0;
            } else if (i == 32) {
                r = 0;
                g = 127;
                b = 255;
            } else if (i == 64) {
                r = 0;
                g = 255;
                b = 255;
            } else if (i == 96) {
                r = 127;
                g = 255;
                b = 0;
            } else if (i == 128) {
                r = 255;
                g = 255;
                b = 127;
            } else if (i == 160) {
                r = 255;
                g = 255;
                b = 255;
            } else if (i == 192) {
                r = 255;
                g = 0;
                b = 255;
            } else if (i == 224) {
                r = 255;
                g = 0;
                b = 0;
            } else if (i < 32) {
                b += colorInc;
            } else if (i < 64) {
                g += colorInc;
            } else if (i < 96) {
                b -= colorInc;
            } else if (i < 128) {
                r += colorInc;
            } else if (i < 160) {
                b += colorInc;
            } else if (i < 192) {
                g -= colorInc;
            } else if (i < 224) {
                b -= colorInc;
            } else {
                r -= colorInc;
            }
            Color color = new Color(r, g, b);
            this.colormap[i] = color.getRGB();
        }
    }

    public void createColormapImage() {
        int width = 100;
        int height = 256;
        this.raster = new int[width][height];
        this.image = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.raster[x][y] = height - y - 1;
                this.image.setRGB(x, y, this.colormap[this.raster[x][y]]);
            }
        }
    }

    public void setModel(IImageViewer iv) {
        this.imgviewer = iv;
    }

    @Override
    public void setImageViewer(IImageViewer iv) {
        this.imgviewer = iv;
    }

    @Override
    public BufferedImage convertRaster(double[][] double_raster) {
        this.createImage(double_raster);
        return this.image;
    }

    public void rasterChanged(double[][] double_raster) {
        BufferedImage image = this.convertRaster(double_raster);
        this.imgviewer.setImage(image);
        this.imgviewer.setSize(new Dimension(image.getWidth(), image.getHeight()));
    }

    public void rasterChanged() {
        this.imgviewer.setImage(this.image);
        this.imgviewer.setSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
    }

    public void createImage(double[][] double_raster) {
        int width = double_raster[0].length;
        int height = double_raster.length;
        this.raster = new int[width][height];
        this.image = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.raster[x][y] = 0xFF & (int)double_raster[y][x];
                this.image.setRGB(x, y, this.colormap[this.raster[x][y]]);
            }
        }
    }

    public void createImage(int[][] int_raster) {
        this.raster = int_raster;
        int width = this.raster.length;
        int height = this.raster[0].length;
        this.image = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.image.setRGB(x, y, this.colormap[this.raster[x][y]]);
            }
        }
    }

    private Rectangle calculateROI() {
        int x;
        int y;
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        Point p0 = new Point(0, 0);
        Point p1 = new Point(width - 1, height - 1);
        int max = 0;
        int xmax = 0;
        int ymax = 0;
        int bg = 0;
        boolean idx = false;
        int z = 0;
        for (y = 5; y < height; ++y) {
            for (int x2 = 5; x2 < width; ++x2) {
                z = 0xFF & this.raster[x2][y];
                if (z > max) {
                    max = z;
                    xmax = x2;
                    ymax = y;
                }
                if (y != 0 && y != height - 1 && x2 != 0 && x2 != width - 1 || z <= bg || z >= 64) continue;
                bg = z;
            }
        }
        System.out.println(xmax + ", " + ymax + " -> " + max + " Bg = " + bg);
        p0.x = p0.y - 0;
        p1.x = width - 1;
        p1.y = height - 1;
        for (x = xmax; x > 0; --x) {
            z = 0xFF & this.raster[x][ymax];
            if (z > bg) continue;
            p0.x = x;
            break;
        }
        for (x = xmax; x < width; ++x) {
            z = 0xFF & this.raster[x][ymax];
            if (z > bg) continue;
            p1.x = x;
            break;
        }
        for (y = ymax; y > 0; --y) {
            z = 0xFF & this.raster[xmax][y];
            if (z > bg) continue;
            p0.y = y;
            break;
        }
        for (y = ymax; y < height; ++y) {
            z = 0xFF & this.raster[xmax][y];
            if (z > bg) continue;
            p1.y = y;
            break;
        }
        return new Rectangle(p0, new Dimension(p1.x - p0.x, p1.y - p0.y));
    }

    public void drawROI(boolean calculate) {
        if (calculate) {
            this.roi = this.calculateROI();
        }
        Graphics g = this.image.getGraphics();
        g.setXORMode(Color.blue);
        g.drawRect(this.roi.x, this.roi.y, this.roi.width, this.roi.height);
    }
}

