/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.dnd;

import fr.esrf.tangoatk.widget.dnd.IDropHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;

public class DropTargetListener
implements java.awt.dnd.DropTargetListener {
    int acceptableActions = 1;
    IDropHandler handler;

    public void setAccepableActions(int i) {
        this.acceptableActions = i;
    }

    public int getAcceptiableActions() {
        return this.acceptableActions;
    }

    public void setDropHandler(IDropHandler handler) {
        this.handler = handler;
    }

    public IDropHandler getDropHandler() {
        return this.handler;
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent evt) {
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getMimeType().startsWith("tango/entity") && !flavors[i].getMimeType().startsWith("tango/numberscalar") && !flavors[i].getMimeType().startsWith("tango/numberspectrum") && !flavors[i].getMimeType().startsWith("tango/numberimage") && !flavors[i].getMimeType().startsWith("tango/numberimage") && !flavors[i].getMimeType().startsWith("tango/command")) continue;
            return true;
        }
        return false;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent evt) {
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        return flavors[flavors.length - 1];
    }

    private boolean isDragOn(DropTargetDragEvent evt) {
        if (!this.isDragFlavorSupported(evt)) {
            return false;
        }
        int i = evt.getDropAction();
        return (i & this.acceptableActions) != 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        if (this.handler.isDragOn(evt.getCurrentDataFlavors())) {
            evt.acceptDrag(evt.getDropAction());
            return;
        }
        evt.rejectDrag();
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        if (this.handler.isDragOn(evt.getCurrentDataFlavors())) {
            evt.acceptDrag(evt.getDropAction());
            return;
        }
        evt.rejectDrag();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
        if (this.handler.isDragOn(evt.getCurrentDataFlavors())) {
            evt.acceptDrag(evt.getDropAction());
            return;
        }
        evt.rejectDrag();
    }

    @Override
    public void dragExit(DropTargetEvent droptargetevent) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        DataFlavor dataflavor = this.chooseDropFlavor(evt);
        if (dataflavor == null) {
            evt.rejectDrop();
            return;
        }
        int i = evt.getDropAction();
        int j = evt.getSourceActions();
        if ((j & this.acceptableActions) == 0) {
            evt.rejectDrop();
            return;
        }
        Object obj = null;
        try {
            evt.acceptDrop(this.acceptableActions);
            obj = evt.getTransferable().getTransferData(dataflavor);
            if (obj == null) {
                throw new NullPointerException();
            }
        }
        catch (Throwable throwable) {
            System.err.println("Couldn't get transfer data: " + throwable.getMessage());
            throwable.printStackTrace();
            evt.dropComplete(false);
            return;
        }
        this.handler.handleDrop(obj.toString(), dataflavor);
        evt.dropComplete(true);
    }
}

