/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.widget.device.tree.DeviceTreeCellRenderer;
import fr.esrf.tangoatk.widget.device.tree.DomainNode;
import fr.esrf.tangoatk.widget.device.tree.FamilyNode;
import fr.esrf.tangoatk.widget.device.tree.MemberNode;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.dnd.TransferHandler;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Frame;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class Tree
extends JTree {
    DomainNode[] domains;
    EventSupport propChanges;
    DefaultMutableTreeNode top;

    public Tree() {
        this.initComponents();
    }

    public void refresh() {
        this.top.removeAllChildren();
        this.importFromDb();
    }

    public synchronized void removeListeners() {
        this.propChanges.removeAtkEventListeners();
        ComponentListener[] CL = this.getComponentListeners();
        for (int i = 0; i < CL.length; ++i) {
            this.removeComponentListener(CL[i]);
        }
        FocusListener[] FL = this.getFocusListeners();
        for (int i = 0; i < FL.length; ++i) {
            this.removeFocusListener(FL[i]);
        }
        HierarchyBoundsListener[] HBL = this.getHierarchyBoundsListeners();
        for (int i = 0; i < HBL.length; ++i) {
            this.removeHierarchyBoundsListener(HBL[i]);
        }
        HierarchyListener[] HL = this.getHierarchyListeners();
        for (int i = 0; i < HL.length; ++i) {
            this.removeHierarchyListener(HL[i]);
        }
        InputMethodListener[] IML = this.getInputMethodListeners();
        for (int i = 0; i < IML.length; ++i) {
            this.removeInputMethodListener(IML[i]);
        }
        KeyListener[] KL = this.getKeyListeners();
        for (int i = 0; i < KL.length; ++i) {
            this.removeKeyListener(KL[i]);
        }
        MouseListener[] ML = this.getMouseListeners();
        for (int i = 0; i < ML.length; ++i) {
            this.removeMouseListener(ML[i]);
        }
        MouseMotionListener[] MML = this.getMouseMotionListeners();
        for (int i = 0; i < MML.length; ++i) {
            this.removeMouseMotionListener(MML[i]);
        }
        MouseWheelListener[] MWL = this.getMouseWheelListeners();
        for (int i = 0; i < MWL.length; ++i) {
            this.removeMouseWheelListener(MWL[i]);
        }
        PropertyChangeListener[] PCL = this.getPropertyChangeListeners();
        for (int i = 0; i < PCL.length; ++i) {
            this.removePropertyChangeListener(PCL[i]);
        }
    }

    protected void error(Exception e) {
        this.propChanges.fireReadErrorEvent(this, e);
    }

    public void importFromDb() {
        try {
            this.propChanges.fireStatusEvent(this, "Importing from database...");
            Database db = new Database();
            String[] dms = db.get_device_domain("*");
            this.addDomains(this.top, db, dms);
        }
        catch (DevFailed e) {
            this.error(new ATKException(e));
        }
        this.propChanges.fireStatusEvent(this, "Importing from database...Done");
        this.expandRow(0);
    }

    public void addErrorListener(IErrorListener l) {
        this.propChanges.addErrorListener(l);
    }

    public void removeErrorListener(IErrorListener l) {
        this.propChanges.removeErrorListener(l);
    }

    public void addStatusListener(IStatusListener l) {
        this.propChanges.addStatusListener(l);
    }

    public void removeStatusListener(IStatusListener l) {
        this.propChanges.removeStatusListener(l);
    }

    protected void initComponents() {
        this.propChanges = new EventSupport();
        this.top = new DefaultMutableTreeNode("Devices");
        this.setTransferHandler(new TransferHandler());
        this.setCellRenderer(new DeviceTreeCellRenderer(this.getCellRenderer()));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (Tree.this.getPathForLocation(e.getX(), e.getY()) != null) {
                    Tree.this.clearSelection();
                    Tree.this.setSelectionPath(Tree.this.getPathForLocation(e.getX(), e.getY()));
                }
            }
        });
        ((DefaultTreeModel)this.getModel()).setRoot(this.top);
    }

    protected void addDomains(DefaultMutableTreeNode top, Database db, String[] dms) throws DevFailed {
        this.domains = new DomainNode[dms.length];
        for (int i = 0; i < dms.length; ++i) {
            String name = dms[i];
            this.domains[i] = new DomainNode(name, db);
            this.addFamilies(this.domains[i], db, db.get_device_family(name + "/*"));
            top.add(this.domains[i]);
        }
    }

    protected void addFamilies(DomainNode top, Database db, String[] fms) throws DevFailed {
        for (int i = 0; i < fms.length; ++i) {
            String name = fms[i];
            String[] members = db.get_device_member(top.getName() + "/" + name + "/*");
            FamilyNode family = new FamilyNode(top, name, db);
            this.initialAddMembers(family, db, members);
            top.add(family);
        }
    }

    protected void initialAddMembers(FamilyNode top, Database db, String[] members) throws DevFailed {
        for (int i = 0; i < members.length; ++i) {
            String m = members[i];
            MemberNode member = new MemberNode(top, m, db);
            top.add(member);
        }
    }

    protected void addAttributes(DefaultMutableTreeNode top, AttributeList attributes) {
        NodeFactory nodeFactory = NodeFactory.getInstance();
        for (int j = 0; j < attributes.size(); ++j) {
            IAttribute attribute = (IAttribute)attributes.get(j);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeFactory.getNode4Entity(attribute));
            top.add(node);
        }
    }

    protected void addCommands(DefaultMutableTreeNode top, CommandList commands) {
        NodeFactory nodeFactory = NodeFactory.getInstance();
        for (int j = 0; j < commands.size(); ++j) {
            ICommand command = (ICommand)commands.get(j);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeFactory.getNode4Entity(command));
            top.add(node);
        }
    }

    protected void addMembers(FamilyNode family) {
        if (family.isFilled()) {
            return;
        }
        JDialog waitingDialog = new JDialog((Frame)null, "Importing devices on " + family + "...");
        waitingDialog.setVisible(true);
        ATKGraphicsUtils.centerDialog(waitingDialog, 400, 0);
        this.propChanges.fireStatusEvent(this, "Importing devices on " + family + "...");
        family.setFilled(true);
        List members = family.getChildren();
        Vector<Device> devices = new Vector<Device>();
        DeviceFactory factory = DeviceFactory.getInstance();
        for (int i = 0; i < members.size(); ++i) {
            String fqName = ((MemberNode)members.get(i)).getName();
            try {
                devices.add(factory.getDevice(fqName));
                continue;
            }
            catch (Exception e) {
                family.setFilled(false);
                this.error(new ConnectionException(e));
            }
        }
        this.addDevices(family, devices);
        waitingDialog.setVisible(false);
        waitingDialog = null;
        this.propChanges.fireStatusEvent(this, "Importing devices on " + family + "...done");
    }

    protected void addDevices(FamilyNode family, List devices) {
        MemberNode device = null;
        DefaultMutableTreeNode attributes = null;
        DefaultMutableTreeNode commands = null;
        for (int i = 0; i < devices.size(); ++i) {
            AttributeList al = new AttributeList();
            CommandList cl = new CommandList();
            IDevice d = (IDevice)devices.get(i);
            device = family.getChild(d.getName());
            device.setAttributeList(al);
            device.setCommandList(cl);
            device.setDevice(d);
            try {
                al.add(d.getName() + "/*");
            }
            catch (ATKException e) {
                this.error(e);
            }
            if (al.size() > 0) {
                attributes = new DefaultMutableTreeNode("Attributes");
                device.add(attributes);
                this.addAttributes(attributes, al);
            }
            try {
                cl.add(d.getName() + "/*");
            }
            catch (ConnectionException e) {
                this.error(e);
            }
            if (cl.size() <= 0) continue;
            commands = new DefaultMutableTreeNode("commands");
            device.add(commands);
            this.addCommands(commands, cl);
        }
    }

    public void setShowEntities(boolean b) {
        if (!b) {
            return;
        }
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath tp = event.getPath();
                Object[] path = tp.getPath();
                if (path.length == 3) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[2];
                    if (!(node instanceof FamilyNode)) {
                        return;
                    }
                    Tree.this.addMembers((FamilyNode)node);
                }
            }
        });
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Tree tree = new Tree();
        tree.setShowEntities(true);
        frame.setContentPane(tree);
        frame.pack();
        frame.setVisible(true);
    }
}

