/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceApplication;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SingletonStatusViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StateViewer
extends JPanel
implements IStateListener {
    IDevice device;
    String state = "UNKNOWN";
    boolean externalSetText = false;
    boolean stateClickable = true;
    IDeviceApplication application;
    private boolean stateInTooltip = false;
    IDevicePopUp popUp = SingletonStatusViewer.getInstance();
    private JLabel textLabel;
    private JLabel valueLabel;

    public StateViewer() {
        this.initComponents();
        UIManagerHelper.setAll("StateViewer.Label", this.textLabel);
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.textLabel.setText("Not Connected");
        this.textLabel.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 4, 0, 3);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.weighty = 0.1;
        this.add((Component)this.textLabel, gridBagConstraints1);
        this.valueLabel.setBackground(Color.red);
        this.valueLabel.setFont(new Font("Dialog", 0, 12));
        this.valueLabel.setPreferredSize(new Dimension(40, 14));
        this.valueLabel.setOpaque(true);
        this.valueLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StateViewer.this.valueLabelMouseClicked(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 4);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.2;
        gridBagConstraints1.weighty = 0.2;
        this.add((Component)this.valueLabel, gridBagConstraints1);
    }

    protected void valueLabelMouseClicked(MouseEvent evt) {
        if ((evt.getModifiers() & 4) != 0) {
            if (this.application == null) {
                return;
            }
            this.application.setModel(this.device);
            this.application.run();
            return;
        }
        if (this.stateClickable && this.device != null) {
            this.popUp.setModel(this.device);
            this.popUp.setVisible(true);
        }
    }

    public IDevicePopUp getPopUp() {
        return this.popUp;
    }

    public void setPopUp(IDevicePopUp v) {
        this.popUp = v;
    }

    public void setModel(IDevice devModel) {
        Device dev;
        this.clearModel();
        if (devModel == null) {
            return;
        }
        this.device = devModel;
        if (this.device instanceof Device && !(dev = (Device)this.device).areDevPropertiesLoaded()) {
            dev.loadDevProperties();
        }
        this.device.addStateListener(this);
        this.setState(this.device.getState());
        if (!this.externalSetText) {
            this.textLabel.setText(this.device.getName());
        }
        this.valueLabel.setToolTipText(this.device.getName());
    }

    public void clearModel() {
        if (this.device != null) {
            this.device.removeStateListener(this);
            this.textLabel.setText("Not Connected");
            this.state = "UNKNOWN";
            this.device = null;
        }
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }

    public JLabel getValueLabel() {
        return this.valueLabel;
    }

    public IDevice getModel() {
        return this.device;
    }

    private void setState(String state) {
        this.state = state;
        this.valueLabel.setBackground(ATKConstant.getColor4State(state, this.device.getInvertedOpenClose(), this.device.getInvertedInsertExtract()));
        if (this.stateInTooltip && this.device != null) {
            this.valueLabel.setToolTipText(this.device.getName() + " : " + state);
        }
    }

    public String getState() {
        return this.state;
    }

    public void setLabel(String label) {
        this.externalSetText = true;
        this.textLabel.setText(label);
    }

    public String getLabel() {
        return this.textLabel.getText();
    }

    public void setLabelVisible(boolean visible) {
        this.textLabel.setVisible(visible);
    }

    public boolean isLabelVisible() {
        return this.textLabel.isVisible();
    }

    public void setStateVisible(boolean visible) {
        this.valueLabel.setVisible(visible);
    }

    public boolean isStateVisible() {
        return this.valueLabel.isVisible();
    }

    @Override
    public void stateChange(StateEvent evt) {
        this.setState(evt.getState());
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.setState("UNKNOWN");
    }

    public void setStateText(String text) {
        this.valueLabel.setText(text);
    }

    public String getStateText() {
        return this.valueLabel.getText();
    }

    public void setStateFont(Font font) {
        this.valueLabel.setFont(font);
    }

    @Override
    public void setFont(Font font) {
        if (this.valueLabel != null) {
            this.valueLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        super.setFont(font);
    }

    public Font getStateFont() {
        return this.valueLabel.getFont();
    }

    public void setStateForeground(Color color) {
        this.valueLabel.setForeground(color);
    }

    public Color getStateForeground() {
        return this.valueLabel.getForeground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.valueLabel != null) {
            this.valueLabel.setForeground(color);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setStateHorizontalAlignment(int i) {
        this.valueLabel.setHorizontalAlignment(i);
    }

    public int getStateHorizontalAlignment() {
        return this.valueLabel.getHorizontalAlignment();
    }

    public void setStatePreferredSize(Dimension dimension) {
        this.valueLabel.setPreferredSize(dimension);
    }

    public Dimension getStatePreferredSize() {
        return this.valueLabel.getPreferredSize();
    }

    public void setStateBorder(Border border) {
        if (this.valueLabel == null) {
            return;
        }
        this.valueLabel.setBorder(border);
    }

    public Border getStateBorder() {
        if (this.valueLabel == null) {
            return null;
        }
        return this.valueLabel.getBorder();
    }

    public boolean getStateInTooltip() {
        return this.stateInTooltip;
    }

    public void setStateInTooltip(boolean b) {
        if (this.stateInTooltip != b) {
            if (!b && this.device != null) {
                this.valueLabel.setToolTipText(this.device.getName());
            }
            this.stateInTooltip = b;
        }
    }

    public void setStateClickable(boolean clickable) {
        this.stateClickable = clickable;
    }

    public boolean isStateClickable() {
        return this.stateClickable;
    }

    public void setApplication(IDeviceApplication runnable) {
        this.application = runnable;
    }

    public IDeviceApplication getApplication() {
        return this.application;
    }
}

