/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ThreeStateSwitch;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ThreeStateSwitchCommandViewer
extends ThreeStateSwitch
implements ActionListener,
INumberScalarListener {
    ICommand onCmd = null;
    ICommand offCmd = null;
    INumberScalar stateAtt = null;

    public ThreeStateSwitchCommandViewer() {
        this.addActionListener(this);
    }

    public ThreeStateSwitchCommandViewer(String title, Font tFont) {
        super(title, tFont);
        this.addActionListener(this);
    }

    public void setModel(INumberScalar stateAttribute, ICommand onCommand, ICommand offCommand) {
        if (this.stateAtt != null) {
            this.stateAtt.removeNumberScalarListener(this);
            this.onCmd.removeErrorListener(this);
            this.offCmd.removeErrorListener(this);
            this.stateAtt = null;
        }
        if (stateAttribute != null) {
            this.stateAtt = stateAttribute;
            this.onCmd = onCommand;
            this.offCmd = offCommand;
            this.stateAtt.addNumberScalarListener(this);
            this.onCmd.addErrorListener(this);
            this.offCmd.addErrorListener(this);
        }
    }

    public void clearModel() {
        this.setModel(null, null, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.getState()) {
            case 1: {
                this.onCmd.execute();
                break;
            }
            case 2: {
                this.offCmd.execute();
                break;
            }
        }
    }

    @Override
    public void errorChange(ErrorEvent e) {
        if (e.getSource() == this.onCmd) {
            JOptionPane.showMessageDialog(this, "Failed to switch on:\n" + e.getError().getMessage());
        } else if (e.getSource() == this.offCmd) {
            JOptionPane.showMessageDialog(this, "Failed to switch off:\n" + e.getError().getMessage());
        } else if (e.getSource() == this.stateAtt) {
            this.setState(0);
        }
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void numberScalarChange(NumberScalarEvent e) {
        if (e.getSource() == this.stateAtt) {
            int s = (int)e.getValue();
            switch (s) {
                case 1: {
                    this.setState(1);
                    break;
                }
                case 0: {
                    this.setState(2);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel jp = new JPanel();
        ThreeStateSwitchCommandViewer stv = new ThreeStateSwitchCommandViewer();
        stv.setBorder(BorderFactory.createEtchedBorder());
        jp.add(stv);
        f.setContentPane(jp);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

