/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.widget.command.PropertyFrame;
import fr.esrf.tangoatk.widget.command.ScalarCommandInput;
import fr.esrf.tangoatk.widget.command.SimpleCommandOutput;
import fr.esrf.tangoatk.widget.device.DeviceViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SimpleCommandViewer
extends JPanel
implements IResultListener {
    ICommand model;
    DeviceViewer dv = new DeviceViewer();
    JFrame deviceFrame = new JFrame();
    List<List> input = new Vector<List>();
    public PropertyFrame propertyFrame = new PropertyFrame();
    private JButton infoButton;
    private JButton deviceButton;
    private JLabel descriptionLabel;
    private ScalarCommandInput scalarCommandInput;
    private SimpleCommandOutput simpleCommandOutput;

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand icommand) {
        if (this.model != null) {
            this.model.removeResultListener(this);
        }
        this.model = icommand;
        if (this.getBorder() != null) {
            ((TitledBorder)this.getBorder()).setTitle(this.model.getName());
        }
        this.clearInput();
        this.clearOutput();
        this.model.addResultListener(this);
        this.propertyFrame.setModel(this.model);
        this.propertyFrame.pack();
        this.dv.setModel(this.model.getDevice());
        this.deviceFrame.getContentPane().add(this.dv);
        this.deviceFrame.pack();
        this.scalarCommandInput.setInputEnabled(this.model.takesInput());
        Property property = this.model.getProperty("in_type_desc");
        if (property != null) {
            this.descriptionLabel.setText(property.getPresentation());
        }
    }

    private void initComponents() {
        this.infoButton = new JButton();
        this.deviceButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.scalarCommandInput = new ScalarCommandInput();
        this.simpleCommandOutput = new SimpleCommandOutput();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Not Connected"));
        this.infoButton.setText("Info");
        this.infoButton.setToolTipText("Click to get Command info");
        this.infoButton.addActionListener(new _cls1());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 3;
        gridbagconstraints.anchor = 17;
        this.add((Component)this.infoButton, gridbagconstraints);
        this.deviceButton.setText("Device");
        this.deviceButton.addActionListener(new _cls2());
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 3;
        gridbagconstraints.anchor = 17;
        this.add((Component)this.deviceButton, gridbagconstraints);
        this.descriptionLabel.setFont(new Font("Dialog", 0, 12));
        this.descriptionLabel.setHorizontalAlignment(2);
        this.descriptionLabel.setText("Not Connected");
        this.descriptionLabel.setBorder(new TitledBorder("Description"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.gridwidth = 3;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.descriptionLabel, gridbagconstraints);
        this.scalarCommandInput.setMinimumSize(new Dimension(200, 17));
        this.scalarCommandInput.setPreferredSize(new Dimension(200, 60));
        this.scalarCommandInput.addPropertyChangeListener(new _cls3());
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 3;
        gridbagconstraints.fill = 1;
        gridbagconstraints.weighty = 0.01;
        this.add((Component)this.scalarCommandInput, gridbagconstraints);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 3;
        gridbagconstraints.fill = 1;
        gridbagconstraints.weightx = 0.1;
        gridbagconstraints.weighty = 0.3;
        this.add((Component)this.simpleCommandOutput, gridbagconstraints);
    }

    private void scalarCommandInputPropertyChange(PropertyChangeEvent propertychangeevent) {
        if ("execute".equals(propertychangeevent.getPropertyName())) {
            this.input.set(0, this.scalarCommandInput.getInput());
            if (this.model == null) {
                return;
            }
            this.model.execute(this.input);
        }
    }

    private void deviceButtonActionPerformed(ActionEvent actionevent) {
        this.deviceFrame.setVisible(true);
    }

    private void infoButtonActionPerformed(ActionEvent actionevent) {
        this.propertyFrame.setVisible(true);
    }

    @Override
    public void errorChange(ErrorEvent errorevent) {
        this.simpleCommandOutput.setResult(errorevent.getError().toString());
    }

    @Override
    public void resultChange(ResultEvent resultevent) {
        this.simpleCommandOutput.setResult(resultevent.getResult());
    }

    public void setDeviceButtonVisible(boolean flag) {
        this.deviceButton.setVisible(flag);
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButton.isVisible();
    }

    public void setDescriptionVisible(boolean flag) {
        this.descriptionLabel.setVisible(flag);
    }

    public boolean isDescriptionVisible() {
        return this.descriptionLabel.isVisible();
    }

    public void setInfoButtonVisible(boolean flag) {
        this.infoButton.setVisible(flag);
    }

    public boolean isInfoButtonVisible() {
        return this.infoButton.isVisible();
    }

    public void setInputVisible(boolean flag) {
        this.scalarCommandInput.setVisible(flag);
    }

    public boolean isInputVisible() {
        return this.scalarCommandInput.isVisible();
    }

    public void setOutputVisible(boolean flag) {
        this.simpleCommandOutput.setVisible(flag);
    }

    public boolean isOutputVisible() {
        return this.simpleCommandOutput.isVisible();
    }

    public void clearInput() {
        this.scalarCommandInput.setInput(null);
    }

    public void clearOutput() {
        this.simpleCommandOutput.setResult("");
    }

    public void setOutputFont(Font font) {
        if (this.simpleCommandOutput == null) {
            return;
        }
        this.simpleCommandOutput.setFont(font);
    }

    public Font getOutputFont() {
        if (this.simpleCommandOutput == null) {
            return this.getFont();
        }
        return this.simpleCommandOutput.getFont();
    }

    public void setInputFont(Font font) {
        if (this.scalarCommandInput == null) {
            return;
        }
        this.scalarCommandInput.setFont(font);
    }

    public Font getInputFont() {
        if (this.scalarCommandInput == null) {
            return this.getFont();
        }
        return this.scalarCommandInput.getFont();
    }

    public void setDescriptionFont(Font font) {
        if (this.descriptionLabel == null) {
            return;
        }
        this.descriptionLabel.setFont(font);
    }

    public Font getDescriptionFont() {
        if (this.descriptionLabel == null) {
            return this.getFont();
        }
        return this.descriptionLabel.getFont();
    }

    public void setDeviceButtonFont(Font font) {
        if (this.deviceButton == null) {
            return;
        }
        this.deviceButton.setFont(font);
    }

    public Font getDeviceButtonFont() {
        if (this.deviceButton == null) {
            return this.getFont();
        }
        return this.deviceButton.getFont();
    }

    public void setInfoButtonFont(Font font) {
        if (this.infoButton == null) {
            return;
        }
        this.infoButton.setFont(font);
    }

    public Font getInfoButtonFont() {
        if (this.infoButton == null) {
            return this.getFont();
        }
        return this.infoButton.getFont();
    }

    private void serializeInit() {
        System.out.println(this.scalarCommandInput + " " + this.deviceButton + " " + this.infoButton);
        this.scalarCommandInput.addPropertyChangeListener(new _cls3());
        this.deviceButton.addActionListener(new _cls2());
        this.infoButton.addActionListener(new _cls1());
    }

    private void readObject(ObjectInputStream objectinputstream) throws IOException, ClassNotFoundException {
        objectinputstream.defaultReadObject();
        this.serializeInit();
    }

    public static void main(String[] args) throws Exception {
        CommandList commandlist = new CommandList();
        commandlist.add("eas/test-api/1/IOString");
        SimpleCommandViewer simplecommandviewer = new SimpleCommandViewer();
        simplecommandviewer.setModel((ICommand)commandlist.get(0));
        JFrame jframe = new JFrame();
        jframe.getContentPane().add(simplecommandviewer);
        jframe.pack();
        jframe.setVisible(true);
    }

    public SimpleCommandViewer() {
        this.initComponents();
        this.input.add(new Vector());
    }

    private class _cls3
    implements PropertyChangeListener {
        private _cls3() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertychangeevent) {
            SimpleCommandViewer.this.scalarCommandInputPropertyChange(propertychangeevent);
        }
    }

    private class _cls2
    implements ActionListener {
        private _cls2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            SimpleCommandViewer.this.deviceButtonActionPerformed(actionevent);
        }
    }

    private class _cls1
    implements ActionListener {
        private _cls1() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            SimpleCommandViewer.this.infoButtonActionPerformed(actionevent);
        }
    }
}

