/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.ScalarVoidCommand;
import fr.esrf.tangoatk.core.command.StringVoidCommand;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OptionComboCommandViewer
extends JPanel
implements ActionListener,
IErrorListener {
    private JComboBox jComboBox;
    private JLabel jLabel;
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "userActionCmd";
    private Font theFont;
    private ICommand model = null;
    private String[] valueList = null;
    private String[] optionList = new String[]{"None"};
    private String title = null;

    public OptionComboCommandViewer() {
        if (this.title == null) {
            this.title = new String("no title");
        }
        this.theFont = new Font("Dialog", 0, 14);
        this.initComponents();
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.jComboBox.setModel(this.comboModel);
        this.jComboBox.setActionCommand(this.defActionCmd);
    }

    public OptionComboCommandViewer(String cmdTitle) {
        this.title = cmdTitle;
        if (this.title == null) {
            this.title = new String("no title");
        }
        this.theFont = new Font("Dialog", 0, 14);
        this.initComponents();
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.jComboBox.setModel(this.comboModel);
        this.jComboBox.setActionCommand(this.defActionCmd);
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel.setText(this.title);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.add((Component)this.jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jComboBox, gridBagConstraints);
        this.jComboBox.addActionListener(this);
    }

    public void enableExecution() {
        this.jComboBox.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.jComboBox.setActionCommand("dummy");
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font ft) {
        if (ft != null) {
            this.theFont = ft;
            this.jLabel.setFont(this.theFont);
            this.jComboBox.setFont(this.theFont);
        }
    }

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand optionCmdModel) {
        if (this.model != null) {
            this.model.removeErrorListener(this);
            this.model = null;
        }
        if (optionCmdModel != null && optionCmdModel instanceof ScalarVoidCommand) {
            this.model = optionCmdModel;
            this.model.addErrorListener(this);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public String[] getOptionList() {
        return this.optionList;
    }

    public void setOptionList(String[] optStrList) {
        DefaultComboBoxModel<String> cbModel = null;
        if (optStrList == null) {
            String[] opts = new String[]{"None"};
            this.optionList = opts;
        } else {
            this.optionList = optStrList;
        }
        cbModel = new DefaultComboBoxModel<String>(this.optionList);
        this.jComboBox.setModel(cbModel);
        this.comboModel = cbModel;
    }

    public String[] getValueList() {
        return this.valueList;
    }

    public void setValueList(String[] valueList) {
        this.valueList = valueList;
    }

    public String getCmdOption(JComboBox source) {
        String cmdOption = (String)source.getSelectedItem();
        if (this.valueList == null || this.valueList.length == 0) {
            return cmdOption;
        }
        int index = source.getSelectedIndex();
        if (index < this.valueList.length) {
            cmdOption = this.valueList[index];
        }
        return cmdOption;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle == null ? new String("no title") : newTitle;
        this.jLabel.setText(this.title);
    }

    public int getSelectedIndex() {
        return this.jComboBox.getSelectedIndex();
    }

    public void setSelectedIndex(int idx) throws IllegalArgumentException {
        this.jComboBox.setSelectedIndex(idx);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = null;
        String cmdOption = null;
        Vector<String> inarg = new Vector<String>();
        cb = (JComboBox)e.getSource();
        cmdOption = this.getCmdOption(cb);
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            this.jComboBox.setActionCommand(this.defActionCmd);
            return;
        }
        if (cmdOption == null) {
            return;
        }
        if (this.model == null) {
            return;
        }
        inarg.add(0, cmdOption);
        this.model.execute(inarg);
    }

    @Override
    public void errorChange(ErrorEvent e) {
        if (e.getSource() == this.model) {
            JOptionPane.showMessageDialog(this, "Failed to execute command:\n" + e.getError().getMessage());
        }
    }

    public static void main(String[] args) {
        String[] opts = new String[]{"ext", "imm", "bus"};
        CommandList commandlist = new CommandList();
        JFrame f = new JFrame();
        JPanel jp = new JPanel();
        OptionComboCommandViewer optCmd = new OptionComboCommandViewer();
        optCmd.setBorder(BorderFactory.createEtchedBorder());
        jp.add(optCmd);
        try {
            IEntity ie = commandlist.add("sr/Agilent_4395a/1/SetTriggerSource");
            if (ie instanceof StringVoidCommand) {
                System.out.println("Oui c'est un stringVoid command");
            } else {
                System.out.println("Desolee ce n'est pas un stringVoid command");
            }
            if (ie instanceof ICommand) {
                ICommand ic = (ICommand)ie;
                optCmd.setModel(ic);
                optCmd.setOptionList(opts);
                optCmd.setTitle(ic.getNameSansDevice());
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to sr/agilent/1/SetTriggerSource");
        }
        f.setContentPane(jp);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

