/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EndGroupExecutionEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommandGroup;
import fr.esrf.tangoatk.core.IEndGroupExecutionListener;
import fr.esrf.tangoatk.core.command.VoidVoidCommandGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GroupCommandViewer
extends JButton
implements IEndGroupExecutionListener {
    protected ICommandGroup cmdgModel;
    private String buttonLabel = "Not Specified";
    private boolean hasConfirmation = true;
    protected Component confirmDialParent = null;
    protected String confirmTitle = "Command Execute Confirm Window";
    protected String confirmMessage = "Do you really want to execute this command?\n";

    public GroupCommandViewer() {
        this.setText("command-group");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupCommandViewer.this.executeButtonActionPerformed(evt);
            }
        });
    }

    public void setButtonLabel(String lab) {
        if (lab == null) {
            this.buttonLabel = "Not Specified";
            return;
        }
        if (lab.length() <= 0) {
            this.buttonLabel = "Not Specified";
            return;
        }
        this.buttonLabel = lab;
        this.setText(lab);
    }

    public String getButtonLabel() {
        return this.buttonLabel;
    }

    public boolean getHasConfirmation() {
        return this.hasConfirmation;
    }

    public void setHasConfirmation(boolean conf) {
        this.hasConfirmation = conf;
    }

    public Component getConfirmDialParent() {
        return this.confirmDialParent;
    }

    public void setConfirmDialParent(Component parent) {
        this.confirmDialParent = parent;
    }

    public String getConfirmTitle() {
        return this.confirmTitle;
    }

    public void setConfirmTitle(String title) {
        this.confirmTitle = title;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void setConfirmMessage(String msg) {
        this.confirmMessage = msg;
    }

    protected void executeButtonActionPerformed(ActionEvent actionevent) {
        if (this.cmdgModel == null) {
            return;
        }
        if (this.hasConfirmation) {
            int userAnswer = 1;
            try {
                userAnswer = JOptionPane.showConfirmDialog(this.confirmDialParent, this.confirmMessage, this.confirmTitle, 0);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (userAnswer != 0) {
                return;
            }
        }
        this.cmdgModel.execute();
    }

    @Override
    public void endGroupExecution(EndGroupExecutionEvent evt) {
        this.setEnabled(true);
    }

    @Override
    public void errorChange(ErrorEvent errorevent) {
    }

    public void setModel(ICommandGroup cmdg) {
        this.clearModel();
        if (cmdg == null) {
            return;
        }
        if (cmdg.size() <= 0) {
            return;
        }
        if (!(cmdg instanceof VoidVoidCommandGroup)) {
            return;
        }
        this.cmdgModel = cmdg;
        this.cmdgModel.addEndGroupExecutionListener(this);
        if (!this.buttonLabel.equalsIgnoreCase("Not Specified")) {
            this.setText(this.buttonLabel);
            return;
        }
        String cmdname = cmdg.getCmdName();
        if (cmdname != null) {
            this.setText(cmdname);
        }
    }

    public void clearModel() {
        if (this.cmdgModel != null) {
            this.cmdgModel.removeEndGroupExecutionListener(this);
            if (this.buttonLabel.equalsIgnoreCase("Not Specified")) {
                this.setText("command-group");
            }
            this.cmdgModel = null;
        }
    }

    public static void main(String[] args) {
        VoidVoidCommandGroup cmdg = new VoidVoidCommandGroup();
        GroupCommandViewer gcv = new GroupCommandViewer();
        gcv.setConfirmMessage("Do you really want to execute On?");
        try {
            cmdg.add("jlp/test/1/On");
            cmdg.add("jlp/test/2/On");
            gcv.setModel(cmdg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeviceFactory.getInstance().setTraceMode(16);
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        f.getContentPane().add((Component)gcv, gbc);
        f.pack();
        f.setVisible(true);
    }
}

