/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CommandComboViewer
extends JComboBox
implements ActionListener {
    private JFrame argFrame = null;
    private AnyCommandViewer acv = null;
    private boolean borderVisble;
    private boolean infoButtonVisible;
    private boolean cancelButtonVisible;
    private boolean deviceButtonVisible;
    private boolean descriptionVisible;
    private boolean keyboardActive = false;
    private CommandList commandList = null;
    private JComboBox.KeySelectionManager superKeyManager;

    public CommandComboViewer() {
        this.addActionListener(this);
        JComboBox.KeySelectionManager manager = new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                int sel = CommandComboViewer.this.commandSelectionForKey(aKey, aModel);
                return sel;
            }
        };
        this.superKeyManager = this.getKeySelectionManager();
        this.setKeySelectionManager(manager);
    }

    protected void commandsActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        ICommand command = (ICommand)cb.getSelectedItem();
        if (command instanceof InvalidCommand) {
            JOptionPane.showMessageDialog(this, command.getName() + " is not supported. It probably takes an array as input.", "Error", 1);
            return;
        }
        if (command instanceof VoidVoidCommand) {
            command.execute();
            return;
        }
        if (this.acv == null) {
            this.acv = new AnyCommandViewer();
            this.argFrame = new JFrame();
            this.argFrame.getContentPane().add(this.acv);
        }
        this.acv.initialize(command);
        this.acv.setDeviceButtonVisible(this.deviceButtonVisible);
        this.acv.setDescriptionVisible(this.descriptionVisible);
        this.acv.setInfoButtonVisible(this.infoButtonVisible);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        if (!command.takesInput()) {
            command.execute();
        }
        this.argFrame.setTitle(command.getName());
        this.argFrame.pack();
        this.argFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.commandsActionPerformed(e);
    }

    public void setModel(CommandList list) {
        this.commandList = list;
        super.setModel(list);
    }

    public ComboBoxModel getModel() {
        return super.getModel();
    }

    public CommandList getCmdListModel() {
        return this.commandList;
    }

    public boolean isBorderVisible() {
        return this.borderVisble;
    }

    public void setBorderVisible(boolean v) {
        this.borderVisble = v;
    }

    public boolean isInfoButtonVisible() {
        return this.infoButtonVisible;
    }

    public void setInfoButtonVisible(boolean v) {
        this.infoButtonVisible = v;
    }

    public boolean isCancelButtonVisible() {
        return this.cancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean v) {
        this.cancelButtonVisible = v;
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButtonVisible;
    }

    public void setDeviceButtonVisible(boolean v) {
        this.deviceButtonVisible = v;
    }

    public boolean isDescriptionVisible() {
        return this.descriptionVisible;
    }

    public void setDescriptionVisible(boolean v) {
        this.descriptionVisible = v;
    }

    public boolean isKeyboardActive() {
        return this.keyboardActive;
    }

    public void setKeyboardActive(boolean v) {
        this.keyboardActive = v;
    }

    private int commandSelectionForKey(char aKey, ComboBoxModel aModel) {
        if (this.keyboardActive) {
            return this.superKeyManager.selectionForKey(aKey, aModel);
        }
        return -1;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        CommandComboViewer ccv = new CommandComboViewer();
        CommandList clist = new CommandList();
        try {
            clist.add("fp/test/1/*");
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to fp/test/1/*");
            System.exit(-1);
        }
        ccv.setModel(clist);
        f.getContentPane().add(ccv);
        f.pack();
        f.setVisible(true);
    }
}

