/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

class TrendSelectionNode
extends DefaultMutableTreeNode
implements INumberScalarListener,
IBooleanScalarListener,
ISpectrumListener,
PropertyChangeListener,
IEnumScalarListener,
IDevStateScalarListener {
    private String devname = "";
    private INumberScalar model;
    private IEnumScalar modele;
    private IBooleanScalar modelb;
    private IDevStateScalar modelst;
    private INumberSpectrum models;
    private int spectrumIdx;
    private int selected;
    private JLDataView data;
    private JLDataView minAlarmData;
    private JLDataView maxAlarmData;
    private long lastErrorTime = 0L;
    private double minAlarm;
    private double maxAlarm;
    private boolean showMinAlarm;
    private boolean showMaxAlarm;
    static GregorianCalendar calendar = new GregorianCalendar();
    static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    Trend chart;

    public TrendSelectionNode(Trend g) {
        this.devname = "Trend";
        this.model = null;
        this.modele = null;
        this.modelb = null;
        this.modelst = null;
        this.models = null;
        this.data = null;
        this.chart = g;
    }

    public TrendSelectionNode(Trend g, String name) {
        this.devname = name;
        this.data = null;
        this.model = null;
        this.modele = null;
        this.modelb = null;
        this.modelst = null;
        this.models = null;
        this.chart = g;
    }

    public TrendSelectionNode(Trend g, String name, INumberScalar model, int selection, Color c) {
        this.devname = name;
        this.model = model;
        this.modele = null;
        this.modelb = null;
        this.modelst = null;
        this.models = null;
        this.selected = selection;
        this.showMinAlarm = false;
        this.showMaxAlarm = false;
        this.chart = g;
        this.data = new JLDataView();
        this.data.setColor(c);
        this.data.setMarkerColor(c);
        this.minAlarmData = new JLDataView();
        this.minAlarmData.setColor(c);
        this.minAlarmData.setMarkerColor(c);
        this.minAlarmData.setStyle(2);
        this.maxAlarmData = new JLDataView();
        this.maxAlarmData.setColor(c);
        this.maxAlarmData.setMarkerColor(c);
        this.maxAlarmData.setStyle(2);
        INumberScalarHistory[] history = model.getNumberScalarHistory();
        if (history != null) {
            for (int i = 0; i < history.length; ++i) {
                this.data.add(history[i].getTimestamp(), history[i].getValue());
            }
        }
        model.addNumberScalarListener(this);
        model.getProperty("label").addPresentationListener(this);
        model.getProperty("unit").addPresentationListener(this);
        model.getProperty("format").addPresentationListener(this);
        model.getProperty("min_alarm").addPresentationListener(this);
        model.getProperty("max_alarm").addPresentationListener(this);
    }

    public TrendSelectionNode(Trend g, String name, IEnumScalar model, int selection, Color c) {
        this.devname = name;
        this.model = null;
        this.modele = model;
        this.modelb = null;
        this.modelst = null;
        this.models = null;
        this.selected = selection;
        this.showMinAlarm = false;
        this.showMaxAlarm = false;
        this.chart = g;
        this.data = new JLDataView();
        this.data.setColor(c);
        this.data.setMarkerColor(c);
        this.minAlarmData = null;
        this.maxAlarmData = null;
        this.modele.addEnumScalarListener(this);
        model.getProperty("label").addPresentationListener(this);
        model.getProperty("unit").addPresentationListener(this);
    }

    public TrendSelectionNode(Trend g, String name, IBooleanScalar model, int selection, Color c) {
        this.devname = name;
        this.model = null;
        this.modele = null;
        this.modelb = model;
        this.modelst = null;
        this.models = null;
        this.selected = selection;
        this.showMinAlarm = false;
        this.showMaxAlarm = false;
        this.chart = g;
        this.data = new JLDataView();
        this.data.setColor(c);
        this.data.setMarkerColor(c);
        this.minAlarmData = null;
        this.maxAlarmData = null;
        this.modelb.addBooleanScalarListener(this);
        this.modelb.getProperty("label").addPresentationListener(this);
        this.modelb.getProperty("unit").addPresentationListener(this);
        this.modelb.getProperty("format").addPresentationListener(this);
    }

    public TrendSelectionNode(Trend g, String name, IDevStateScalar model, int selection, Color c) {
        this.devname = name;
        this.model = null;
        this.modele = null;
        this.modelb = null;
        this.modelst = model;
        this.models = null;
        this.selected = selection;
        this.showMinAlarm = false;
        this.showMaxAlarm = false;
        this.chart = g;
        this.data = new JLDataView();
        this.data.setColor(c);
        this.data.setMarkerColor(c);
        if (this.chart.displayDeviceNames()) {
            this.data.setName(this.devname + "/" + this.modelst.getLabel());
        } else {
            this.data.setName(this.modelst.getLabel());
        }
        this.minAlarmData = null;
        this.maxAlarmData = null;
        this.modelst.addDevStateScalarListener(this);
        this.modelst.getProperty("label").addPresentationListener(this);
    }

    public TrendSelectionNode(Trend g, String name, INumberSpectrum model, int sIdx, int selection, Color c) {
        this.devname = name;
        this.model = null;
        this.modele = null;
        this.modelb = null;
        this.modelst = null;
        this.models = model;
        this.spectrumIdx = sIdx;
        this.selected = selection;
        this.showMinAlarm = false;
        this.showMaxAlarm = false;
        this.chart = g;
        this.data = new JLDataView();
        this.data.setColor(c);
        this.data.setMarkerColor(c);
        this.minAlarmData = null;
        this.maxAlarmData = null;
        this.models.addSpectrumListener(this);
        this.models.getProperty("label").addPresentationListener(this);
        this.models.getProperty("unit").addPresentationListener(this);
        this.models.getProperty("format").addPresentationListener(this);
    }

    public void refreshNode() {
        String name;
        if (this.model != null) {
            this.data.setUnit(this.model.getUnit());
            this.data.setUserFormat(this.model.getFormat());
            if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
                if (this.chart.displayDeviceNames()) {
                    name = this.devname + "/" + this.model.getLabel();
                    this.data.setName(name);
                    this.minAlarmData.setName(name + " [Min alarm]");
                    this.maxAlarmData.setName(name + " [Max alarm]");
                } else {
                    name = this.model.getLabel();
                    this.data.setName(name);
                    this.minAlarmData.setName(name + " [Min alarm]");
                    this.maxAlarmData.setName(name + " [Max alarm]");
                }
            } else {
                name = this.model.getName();
                this.data.setName(name);
                this.minAlarmData.setName(name + " [Min alarm]");
                this.maxAlarmData.setName(name + " [Max alarm]");
            }
            this.minAlarm = this.model.getMinAlarm();
            this.maxAlarm = this.model.getMaxAlarm();
        }
        if (this.modele != null) {
            this.data.setUnit(this.modele.getUnit());
            this.data.setUserFormat("%d");
            if (this.modele.getLabel().length() > 0 && !this.modele.getLabel().equalsIgnoreCase("not specified")) {
                if (this.chart.displayDeviceNames()) {
                    name = this.devname + "/" + this.modele.getLabel();
                    this.data.setName(name);
                } else {
                    name = this.modele.getLabel();
                    this.data.setName(name);
                }
            } else {
                name = this.modele.getName();
                this.data.setName(name);
            }
        }
        if (this.modelb != null) {
            this.data.setUnit(this.modelb.getUnit());
            this.data.setUserFormat(this.modelb.getFormat());
            if (this.modelb.getLabel().length() > 0 && !this.modelb.getLabel().equalsIgnoreCase("not specified")) {
                if (this.chart.displayDeviceNames()) {
                    name = this.devname + "/" + this.modelb.getLabel();
                    this.data.setName(name);
                } else {
                    name = this.modelb.getLabel();
                    this.data.setName(name);
                }
            } else {
                name = this.modelb.getName();
                this.data.setName(name);
            }
        }
        if (this.modelst != null) {
            if (this.modelst.getLabel().length() > 0 && !this.modelst.getLabel().equalsIgnoreCase("not specified")) {
                if (this.chart.displayDeviceNames()) {
                    name = this.devname + "/" + this.modelst.getLabel();
                    this.data.setName(name);
                } else {
                    name = this.modelst.getLabel();
                    this.data.setName(name);
                }
            } else {
                name = this.modelst.getName();
                this.data.setName(name);
            }
        }
        if (this.models != null) {
            this.data.setUnit(this.models.getUnit());
            this.data.setUserFormat(this.models.getFormat());
            if (this.models.getLabel().length() > 0 && !this.models.getLabel().equalsIgnoreCase("not specified")) {
                if (this.chart.displayDeviceNames()) {
                    name = this.devname + "/" + this.models.getLabel();
                    this.data.setName(name + " (" + Integer.toString(this.spectrumIdx) + ")");
                } else {
                    name = this.models.getLabel();
                    this.data.setName(name + " (" + Integer.toString(this.spectrumIdx) + ")");
                }
            } else {
                name = this.models.getName();
                this.data.setName(name + " (" + Integer.toString(this.spectrumIdx) + ")");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.model != null || this.modelb != null || this.modele != null || this.modelst != null || this.models != null) {
            this.refreshNode();
            this.chart.refreshNode(this);
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void showMinAlarm() {
        if (this.model != null) {
            this.showMinAlarm = true;
            switch (this.selected) {
                case 2: {
                    this.chart.getChart().getY1Axis().addDataView(this.minAlarmData);
                    break;
                }
                case 3: {
                    this.chart.getChart().getY2Axis().addDataView(this.minAlarmData);
                }
            }
        }
    }

    public void hideMinAlarm() {
        if (this.model != null) {
            this.showMinAlarm = false;
            switch (this.selected) {
                case 2: {
                    this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                    break;
                }
                case 3: {
                    this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                }
            }
        }
    }

    public boolean isShowingMinAlarm() {
        return this.showMinAlarm;
    }

    public void showMaxAlarm() {
        if (this.model != null) {
            this.showMaxAlarm = true;
            switch (this.selected) {
                case 2: {
                    this.chart.getChart().getY1Axis().addDataView(this.maxAlarmData);
                    break;
                }
                case 3: {
                    this.chart.getChart().getY2Axis().addDataView(this.maxAlarmData);
                }
            }
        }
    }

    public void hideMaxAlarm() {
        if (this.model != null) {
            this.showMaxAlarm = false;
            switch (this.selected) {
                case 2: {
                    this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                    break;
                }
                case 3: {
                    this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                }
            }
        }
    }

    public boolean isShowingMaxAlarm() {
        return this.showMaxAlarm;
    }

    public void setSelected(int s) {
        switch (s) {
            case 0: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                    }
                }
                break;
            }
            case 1: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                    }
                }
                this.chart.getChart().getXAxis().addDataView(this.data);
                break;
            }
            case 2: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                    }
                }
                this.chart.getChart().getY1Axis().addDataView(this.data);
                if (this.showMinAlarm) {
                    this.chart.getChart().getY1Axis().addDataView(this.minAlarmData);
                }
                if (!this.showMaxAlarm) break;
                this.chart.getChart().getY1Axis().addDataView(this.maxAlarmData);
                break;
            }
            case 3: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                    }
                }
                this.chart.getChart().getY2Axis().addDataView(this.data);
                if (this.showMinAlarm) {
                    this.chart.getChart().getY2Axis().addDataView(this.minAlarmData);
                }
                if (!this.showMaxAlarm) break;
                this.chart.getChart().getY2Axis().addDataView(this.maxAlarmData);
            }
        }
        this.selected = s;
    }

    @Override
    public boolean isLeaf() {
        return this.model != null || this.modele != null || this.modelb != null || this.modelst != null || this.models != null;
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public IBooleanScalar getBooleanModel() {
        return this.modelb;
    }

    public IDevStateScalar getDevStateModel() {
        return this.modelst;
    }

    public IEnumScalar getEnumModel() {
        return this.modele;
    }

    public INumberSpectrum getSpectrumModel() {
        return this.models;
    }

    public boolean hasModel() {
        return this.model != null || this.modele != null || this.modelb != null || this.modelst != null || this.models != null;
    }

    public JLDataView getData() {
        return this.data;
    }

    public JLDataView getMinAlarmData() {
        return this.minAlarmData;
    }

    public JLDataView getMaxAlarmData() {
        return this.maxAlarmData;
    }

    public void delItem(INumberScalar model) {
        int i = 0;
        int j = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        if (found) {
            TrendSelectionNode dev = (TrendSelectionNode)this.getChildAt(i);
            found = false;
            j = 0;
            int nb_att = dev.getChildCount();
            while (j < nb_att && !found) {
                found = attname.equals(dev.getChild(j).getModelName());
                if (found) continue;
                ++j;
            }
            if (found) {
                dev.getChild(j).setSelected(0);
                dev.getChild(j).clearModel();
                dev.remove(j);
                if (nb_att == 1) {
                    this.remove(i);
                }
            }
        }
    }

    public TrendSelectionNode addItem(Trend g, INumberScalar model, Color c) {
        int i = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        TrendSelectionNode nn = new TrendSelectionNode(g, devname, model, 0, c);
        if (found) {
            this.getChild(i).add(nn);
        } else {
            TrendSelectionNode n = new TrendSelectionNode(g, devname);
            this.add(n);
            n.add(nn);
        }
        return nn;
    }

    public TrendSelectionNode addItem(Trend g, IEnumScalar model, Color c) {
        int i = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        TrendSelectionNode nn = new TrendSelectionNode(g, devname, model, 0, c);
        if (found) {
            this.getChild(i).add(nn);
        } else {
            TrendSelectionNode n = new TrendSelectionNode(g, devname);
            this.add(n);
            n.add(nn);
        }
        return nn;
    }

    public TrendSelectionNode addItem(Trend g, IBooleanScalar model, Color c) {
        int i = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        TrendSelectionNode nn = new TrendSelectionNode(g, devname, model, 0, c);
        if (found) {
            this.getChild(i).add(nn);
        } else {
            TrendSelectionNode n = new TrendSelectionNode(g, devname);
            this.add(n);
            n.add(nn);
        }
        return nn;
    }

    public TrendSelectionNode addItem(Trend g, IDevStateScalar model, Color c) {
        int i = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        TrendSelectionNode nn = new TrendSelectionNode(g, devname, model, 0, c);
        if (found) {
            this.getChild(i).add(nn);
        } else {
            TrendSelectionNode n = new TrendSelectionNode(g, devname);
            this.add(n);
            n.add(nn);
        }
        return nn;
    }

    public TrendSelectionNode addItem(Trend g, INumberSpectrum model, int sIdx, Color c) {
        int i = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        TrendSelectionNode nn = new TrendSelectionNode(g, devname, model, sIdx, 0, c);
        if (found) {
            this.getChild(i).add(nn);
        } else {
            TrendSelectionNode n = new TrendSelectionNode(g, devname);
            this.add(n);
            n.add(nn);
        }
        return nn;
    }

    public Vector getSelectableItems() {
        Vector<TrendSelectionNode> v;
        if (this.isLeaf()) {
            v = new Vector<TrendSelectionNode>();
            v.add(this);
        } else {
            int nb = this.getChildCount();
            v = new Vector();
            for (int i = 0; i < nb; ++i) {
                TrendSelectionNode child = this.getChild(i);
                v.addAll(child.getSelectableItems());
            }
        }
        return v;
    }

    public void showOptions() {
        if (this.data != null) {
            this.chart.getChart().showDataOptionDialog(this.data);
        }
    }

    public String getModelName() {
        if (this.model != null) {
            return this.model.getName();
        }
        if (this.modelb != null) {
            return this.modelb.getName();
        }
        if (this.modele != null) {
            return this.modele.getName();
        }
        if (this.modelst != null) {
            return this.modelst.getName();
        }
        if (this.models != null) {
            return this.models.getName() + "/" + Integer.toString(this.spectrumIdx);
        }
        return "";
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeNumberScalarListener(this);
            this.model.getProperty("label").removePresentationListener(this);
            this.model.getProperty("unit").removePresentationListener(this);
            this.model.getProperty("format").removePresentationListener(this);
            this.model.getProperty("min_alarm").removePresentationListener(this);
            this.model.getProperty("max_alarm").removePresentationListener(this);
        }
        if (this.modele != null) {
            this.modele.removeEnumScalarListener(this);
            this.modele.getProperty("label").removePresentationListener(this);
            this.modele.getProperty("unit").removePresentationListener(this);
        }
        if (this.modelb != null) {
            this.modelb.removeBooleanScalarListener(this);
            this.modelb.getProperty("label").removePresentationListener(this);
            this.modelb.getProperty("unit").removePresentationListener(this);
            this.modelb.getProperty("format").removePresentationListener(this);
        }
        if (this.modelst != null) {
            this.modelst.removeDevStateScalarListener(this);
            this.modelst.getProperty("label").removePresentationListener(this);
        }
        if (this.models != null) {
            this.models.removeSpectrumListener(this);
            this.models.getProperty("label").removePresentationListener(this);
            this.models.getProperty("unit").removePresentationListener(this);
            this.models.getProperty("format").removePresentationListener(this);
        }
        this.data = null;
        this.minAlarmData = null;
        this.maxAlarmData = null;
        this.model = null;
        this.modelb = null;
        this.modelst = null;
        this.models = null;
    }

    public TrendSelectionNode getChild(int id) {
        return (TrendSelectionNode)this.getChildAt(id);
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        if (this.model == null) {
            return;
        }
        boolean ok = true;
        DataList lv = this.data.getLastValueRaw();
        double x = evt.getTimeStamp();
        double y = evt.getValue();
        if (lv != null) {
            boolean bl = ok = lv.x != x || lv.y != y;
        }
        if (ok) {
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(evt.getTimeStamp(), evt.getValue());
                this.chart.getChart().garbageData(this.data);
                if (this.showMinAlarm) {
                    this.minAlarmData.add(evt.getTimeStamp(), this.minAlarm);
                    this.chart.getChart().garbageData(this.minAlarmData);
                }
                if (this.showMaxAlarm) {
                    this.maxAlarmData.add(evt.getTimeStamp(), this.maxAlarm);
                    this.chart.getChart().garbageData(this.maxAlarmData);
                }
            } else {
                this.chart.getChart().addData(this.data, evt.getTimeStamp(), evt.getValue());
                if (this.showMinAlarm) {
                    this.chart.getChart().addData(this.minAlarmData, evt.getTimeStamp(), this.minAlarm);
                }
                if (this.showMaxAlarm) {
                    this.chart.getChart().addData(this.maxAlarmData, evt.getTimeStamp(), this.maxAlarm);
                }
            }
        }
    }

    @Override
    public void booleanScalarChange(BooleanScalarEvent evt) {
        double y;
        if (this.modelb == null) {
            return;
        }
        boolean ok = true;
        DataList lv = this.data.getLastValueRaw();
        double x = evt.getTimeStamp();
        double d = y = evt.getValue() ? 1.0 : 0.0;
        if (lv != null) {
            boolean bl = ok = lv.x != x || lv.y != y;
        }
        if (ok) {
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(evt.getTimeStamp(), y);
                this.chart.getChart().garbageData(this.data);
            } else {
                this.chart.getChart().addData(this.data, evt.getTimeStamp(), y);
            }
        }
    }

    @Override
    public void devStateScalarChange(DevStateScalarEvent evt) {
        if (this.modelst == null) {
            return;
        }
        boolean ok = true;
        DataList lv = this.data.getLastValueRaw();
        double x = evt.getTimeStamp();
        double y = this.modelst.getDevState().value();
        if (lv != null) {
            boolean bl = ok = lv.x != x || lv.y != y;
        }
        if (ok) {
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                if (lv != null && lv.y != y) {
                    this.data.add(evt.getTimeStamp(), lv.y);
                }
                this.data.add(evt.getTimeStamp(), y);
                this.chart.getChart().garbageData(this.data);
            } else {
                if (lv != null && lv.y != y) {
                    this.chart.getChart().addData(this.data, evt.getTimeStamp(), lv.y);
                }
                this.chart.getChart().addData(this.data, evt.getTimeStamp(), y);
            }
        }
    }

    @Override
    public void enumScalarChange(EnumScalarEvent evt) {
        if (this.modele == null) {
            return;
        }
        boolean ok = true;
        DataList lv = this.data.getLastValueRaw();
        double x = evt.getTimeStamp();
        double y = this.modele.getShortValueFromEnumScalar(evt.getValue());
        if (lv != null) {
            boolean bl = ok = lv.x != x || lv.y != y;
        }
        if (ok) {
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(evt.getTimeStamp(), y);
                this.chart.getChart().garbageData(this.data);
            } else {
                this.chart.getChart().addData(this.data, evt.getTimeStamp(), y);
            }
        }
    }

    @Override
    public void spectrumChange(NumberSpectrumEvent evt) {
        if (this.models == null) {
            return;
        }
        boolean ok = true;
        DataList lv = this.data.getLastValueRaw();
        double x = evt.getTimeStamp();
        int lgth = evt.getValue().length;
        double y = this.spectrumIdx >= 0 && this.spectrumIdx < lgth ? evt.getValue()[this.spectrumIdx] : Double.NaN;
        if (lv != null) {
            boolean bl = ok = lv.x != x || lv.y != y;
        }
        if (ok) {
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(evt.getTimeStamp(), y);
                this.chart.getChart().garbageData(this.data);
            } else {
                this.chart.getChart().addData(this.data, evt.getTimeStamp(), y);
            }
        }
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        if (!this.hasModel()) {
            return;
        }
        if (this.lastErrorTime != evt.getTimeStamp()) {
            this.lastErrorTime = evt.getTimeStamp();
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(this.lastErrorTime, Double.NaN);
                this.chart.getChart().garbageData(this.data);
                if (this.showMinAlarm) {
                    this.minAlarmData.add(evt.getTimeStamp(), this.minAlarm);
                    this.chart.getChart().garbageData(this.minAlarmData);
                }
                if (this.showMaxAlarm) {
                    this.maxAlarmData.add(evt.getTimeStamp(), this.maxAlarm);
                    this.chart.getChart().garbageData(this.maxAlarmData);
                }
            } else {
                this.chart.getChart().addData(this.data, this.lastErrorTime, Double.NaN);
                if (this.showMinAlarm) {
                    this.chart.getChart().addData(this.minAlarmData, evt.getTimeStamp(), this.minAlarm);
                }
                if (this.showMaxAlarm) {
                    this.chart.getChart().addData(this.maxAlarmData, evt.getTimeStamp(), this.maxAlarm);
                }
            }
        }
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public String toString() {
        if (this.model != null) {
            if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
                return this.model.getLabel();
            }
            return this.model.getNameSansDevice();
        }
        if (this.modele != null) {
            if (this.modele.getLabel().length() > 0 && !this.modele.getLabel().equalsIgnoreCase("not specified")) {
                return this.modele.getLabel();
            }
            return this.modele.getNameSansDevice();
        }
        if (this.modelb != null) {
            if (this.modelb.getLabel().length() > 0 && !this.modelb.getLabel().equalsIgnoreCase("not specified")) {
                return this.modelb.getLabel();
            }
            return this.modelb.getNameSansDevice();
        }
        if (this.modelst != null) {
            if (this.modelst.getLabel().length() > 0 && !this.modelst.getLabel().equalsIgnoreCase("not specified")) {
                return this.modelst.getLabel();
            }
            return this.modelst.getNameSansDevice();
        }
        if (this.models != null) {
            if (this.models.getLabel().length() > 0 && !this.models.getLabel().equalsIgnoreCase("not specified")) {
                return this.models.getLabel() + " (" + Integer.toString(this.spectrumIdx) + ")";
            }
            return this.models.getNameSansDevice() + " (" + Integer.toString(this.spectrumIdx) + ")";
        }
        return this.devname;
    }
}

