/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringScalarEditor
extends JTextField
implements IStringScalarListener,
JDrawable {
    private IStringScalar model = null;
    private String lastSet = null;
    private String errorText = "Read Error";
    private boolean updateImmediately = false;
    static String[] exts = new String[]{"invalidText", "updateImmediately"};

    public StringScalarEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringScalarEditor.this.textInsertActionPerformed();
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (StringScalarEditor.this.updateImmediately) {
                    StringScalarEditor.this.textInsertActionPerformed();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (StringScalarEditor.this.updateImmediately) {
                    StringScalarEditor.this.textInsertActionPerformed();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (StringScalarEditor.this.updateImmediately) {
                    StringScalarEditor.this.textInsertActionPerformed();
                }
            }
        });
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void setModel(IStringScalar is) {
        if (this.model != null) {
            this.model.removeStringScalarListener(this);
        }
        if (is == null) {
            this.model = null;
            return;
        }
        if (!is.isWritable()) {
            throw new IllegalArgumentException("StringScalarEditor: Only accept writeable attribute.");
        }
        this.model = is;
        this.model.addStringScalarListener(this);
        this.model.refresh();
        String textFieldString = this.model.getString();
        if (textFieldString == null) {
            textFieldString = "NULL";
        }
        this.setText(textFieldString);
        this.lastSet = textFieldString;
    }

    public IStringScalar getModel() {
        return this.model;
    }

    @Override
    public void stringScalarChange(StringScalarEvent e) {
        String set = null;
        long now = System.currentTimeMillis();
        if (this.model != null) {
            set = this.hasFocus() ? this.model.getStringDeviceSetPoint() : this.model.getStringSetPoint();
        }
        if (set != null) {
            if (!set.equals(this.lastSet)) {
                this.setText(set);
                this.lastSet = set;
            }
        } else {
            this.setText("NULL");
            this.lastSet = "NULL";
        }
    }

    public void setErrorText(String text) {
        this.errorText = text;
    }

    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public void errorChange(ErrorEvent e) {
        this.setText(this.errorText);
        this.lastSet = this.errorText;
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    private void textInsertActionPerformed() {
        this.lastSet = this.getText();
        if (this.model != null) {
            this.model.setString(this.lastSet);
        }
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        StringScalarEditor sse = new StringScalarEditor();
        try {
            IStringScalar att = (IStringScalar)attList.add("dev/test/10/String_attr_w");
            sse.setModel(att);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        attList.startRefresher();
        JFrame mainFrame = new JFrame();
        mainFrame.getContentPane().add(sse);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    @Override
    public void initForEditing() {
        this.setText("");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupAllowed) {
        if (name.equalsIgnoreCase("invalidText")) {
            this.setErrorText(value);
            return true;
        }
        if (name.equalsIgnoreCase("updateImmediately")) {
            this.updateImmediately = value.equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equals("invalidText")) {
            return this.getErrorText();
        }
        if (name.equalsIgnoreCase("updateImmediately")) {
            return this.updateImmediately ? "true" : "false";
        }
        return "";
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equalsIgnoreCase("invalidText")) {
            return "Text displayed when the qulaity factor is INVALID\nor when the connection is lost.";
        }
        if (extName.equalsIgnoreCase("updateImmediately")) {
            return "Write immediately to device on text change";
        }
        return "";
    }
}

