/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class StringScalarComboEditor
extends JComboBox
implements ActionListener,
IStringScalarListener,
JDrawable {
    static String[] exts = new String[]{"valueList"};
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private String jdrawExts = "";
    private Font theFont;
    private IStringScalar stringModel = null;
    private String[] defOptionList = new String[]{"None"};
    private String[] optionList = new String[]{"None"};

    public StringScalarComboEditor() {
        this.theFont = new Font("Dialog", 0, 14);
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IStringScalar getStringModel() {
        return this.stringModel;
    }

    public void setStringModel(IStringScalar m) {
        String[] valList = null;
        int valListSize = 0;
        String[] newOptions = null;
        if (this.stringModel != null) {
            this.stringModel.removeStringScalarListener(this);
            this.stringModel = null;
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        if (m == null) {
            return;
        }
        if (!m.isWritable()) {
            throw new IllegalArgumentException("StringScalarComboEditor: Only accept writable attribute.");
        }
        this.stringModel = m;
        String invalidOpt = "???";
        valList = this.stringModel.getPossibleValues();
        newOptions = null;
        if (valList != null && (valListSize = valList.length) > 0) {
            newOptions = new String[valListSize];
            for (int index = 0; index < valListSize; ++index) {
                newOptions[index] = new String(valList[index]);
            }
        }
        if (newOptions == null) {
            newOptions = new String[]{new String(invalidOpt + " ")};
        }
        if (newOptions != null) {
            this.optionList = newOptions;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        this.stringModel.addStringScalarListener(this);
        this.stringModel.refresh();
    }

    @Override
    public void stringScalarChange(StringScalarEvent evt) {
        String set = null;
        int currentSelection = this.getSelectedIndex();
        set = this.hasFocus() ? this.stringModel.getStringDeviceSetPoint() : this.stringModel.getStringSetPoint();
        if (set == null) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException iaex) {
                System.out.println("caught exception : " + iaex.getMessage());
            }
            return;
        }
        if (this.optionList == null) {
            return;
        }
        for (int index = 0; index < this.optionList.length; ++index) {
            if (!set.equalsIgnoreCase(this.optionList[index])) continue;
            if (currentSelection != index) {
                this.changeCurrentSelection(index);
            }
            return;
        }
        try {
            this.changeCurrentSelection(-1);
        }
        catch (IllegalArgumentException iaex) {
            System.out.println("caught exception : " + iaex.getMessage());
        }
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent e) {
        if (this.stringModel == null) {
            return;
        }
        int currentSelection = this.getSelectedIndex();
        if (currentSelection != -1) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException iaex) {
                System.out.println("caught exception : " + iaex.getMessage());
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = null;
        String cmdOption = null;
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.stringModel == null) {
            return;
        }
        cb = (JComboBox)e.getSource();
        cmdOption = (String)cb.getSelectedItem();
        if (cmdOption == null) {
            return;
        }
        this.stringModel.setString(cmdOption);
    }

    private void changeCurrentSelection(int newIndex) {
        this.disableExecution();
        this.setSelectedIndex(newIndex);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equalsIgnoreCase("valueList")) {
            return "The list of values to be proposed in the ComboBox.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("valueList")) {
            this.jdrawExts = "";
            String[] c = value.split(",");
            if (c.length <= 0) {
                this.showJdrawError(popupErr, "valueList", "String value list expected: str,str,str");
                return false;
            }
            this.jdrawExts = value;
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("valueList")) {
            return this.jdrawExts;
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "StringScalarComboEditor: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        StringScalarComboEditor ssce = new StringScalarComboEditor();
        String[] vals = new String[]{"short", "long"};
        JFrame mainFrame = null;
        try {
            IEntity ie = attList.add("elin/gun/run/PulseType");
            IStringScalar pulseType = ie instanceof IStringScalar ? (IStringScalar)ie : null;
            if (pulseType == null) {
                System.exit(-1);
            }
            pulseType.setPossibleValues(vals);
            ssce.setStringModel(pulseType);
        }
        catch (Exception e) {
            System.out.println("caught exception : " + e.getMessage());
            System.exit(-1);
        }
        attList.startRefresher();
        mainFrame = new JFrame();
        mainFrame.setContentPane(ssce);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

