/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.StringImageEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JTableRow;
import java.awt.Color;
import javax.swing.JFrame;

public class StringImageTableViewer
extends JTableRow
implements IStringImageListener {
    private IStringImage attModel = null;
    private boolean qualityEnabled = false;
    private Color background = this.getBackground();

    public IStringImage getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IStringImage siModel) {
        this.clearModel();
        if (siModel != null) {
            this.attModel = siModel;
            this.attModel.addStringImageListener(this);
            this.attModel.refresh();
            this.setStringImageValue(this.attModel.getValue());
        } else {
            this.setStringImageValue(null);
        }
    }

    public boolean getQualityEnabled() {
        return this.qualityEnabled;
    }

    public void setQualityEnabled(boolean b) {
        this.qualityEnabled = b;
        if (!this.qualityEnabled) {
            super.setBackground(this.background);
            this.repaint();
        }
    }

    public void clearModel() {
        if (this.attModel != null) {
            this.attModel.removeStringImageListener(this);
            this.attModel = null;
            this.clearData();
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        super.setBackground(bg);
    }

    @Override
    public void stringImageChange(StringImageEvent e) {
        this.setStringImageValue(e.getValue());
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
        String state = evt.getState();
        if (!this.qualityEnabled) {
            return;
        }
        super.setBackground(ATKConstant.getColor4Quality(state));
        this.repaint();
    }

    @Override
    public void errorChange(ErrorEvent evt) {
    }

    protected void setStringImageValue(String[][] val) {
        if (val == null) {
            this.clearData();
            return;
        }
        if (val.length == 0) {
            this.clearData();
            return;
        }
        int nbCol = val[0].length;
        if (nbCol == 0) {
            this.clearData();
            return;
        }
        super.setData(val, 0, 0);
    }

    public static void main(String[] args) {
        IStringImage ismAtt = null;
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        StringImageTableViewer sitv = new StringImageTableViewer();
        try {
            IEntity ie = attl.add("fp/test/1/string_image_ro");
            if (!(ie instanceof IStringImage)) {
                System.out.println("fp/test/1/string_image_ro is not a IStringImage");
                System.exit(-1);
            }
            ismAtt = (IStringImage)ie;
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to fp/test/1/string_image_ro");
            System.exit(-1);
        }
        f.setContentPane(sitv);
        f.setDefaultCloseOperation(3);
        sitv.setAttModel(ismAtt);
        attl.startRefresher();
        f.pack();
        f.setVisible(true);
    }
}

