/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import java.awt.Font;

public class StateStatusViewer
extends JAutoScrolledText
implements IDevStateScalarListener,
IStringScalarListener {
    private IDevStateScalar stateModel = null;
    private IStringScalar statusModel = null;
    private String currentState = new String("UNKNOWN");
    private String currentStatus = new String("UNKNOWN");

    public StateStatusViewer() {
        this.setBackground(ATKConstant.getColor4State(this.currentState));
        this.setOpaque(true);
        this.setText(this.currentStatus);
        this.setFont(new Font("Dialog", 0, 14));
    }

    public void setStateModel(IDevStateScalar stateAtt) {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateScalarListener(this);
            this.stateModel = null;
            this.setToolTipText(null);
        }
        if (stateAtt == null) {
            return;
        }
        this.stateModel = stateAtt;
        stateAtt.addDevStateScalarListener(this);
        this.setToolTipText(stateAtt.getName());
        this.setCurrentState(stateAtt.getDeviceValue());
    }

    public IDevStateScalar getStateModel() {
        return this.stateModel;
    }

    public void setStatusModel(IStringScalar statusAtt) {
        if (this.statusModel != null) {
            this.statusModel.removeStringScalarListener(this);
            this.statusModel = null;
        }
        if (statusAtt == null) {
            return;
        }
        this.statusModel = statusAtt;
        this.statusModel.addStringScalarListener(this);
        this.currentStatus = new String(this.statusModel.getStringDeviceValue());
        this.setText(this.currentStatus);
    }

    public IStringScalar getStatusModel() {
        return this.statusModel;
    }

    @Override
    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        this.setCurrentState(devStateScalarEvent.getValue());
    }

    @Override
    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.stateModel) {
            this.setCurrentState("UNKNOWN");
            return;
        }
        if (!this.currentStatus.equals("UNKNOWN")) {
            this.currentStatus = new String("UNKNOWN");
            this.setText(this.currentStatus);
        }
    }

    @Override
    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    @Override
    public void stringScalarChange(StringScalarEvent stringScalarEvent) {
        String val = stringScalarEvent.getValue();
        if (!val.equals(this.currentStatus)) {
            this.currentStatus = new String(val);
            this.setText(this.currentStatus);
        }
    }

    private void setCurrentState(String stateStr) {
        if (!this.currentState.equals(stateStr)) {
            this.currentState = new String(stateStr);
            this.setBackground(ATKConstant.getColor4State(this.currentState));
        }
    }
}

