/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class SimpleStringSpectrumViewer
extends JPanel
implements IStringSpectrumListener {
    private static final Font viewerFont = new Font("Monospaced", 0, 12);
    private JScrollPane jScrollPane1;
    private JTextArea strSpectText;
    private boolean viewEnd = false;
    IStringSpectrum model;

    public SimpleStringSpectrumViewer() {
        this.initComponents();
        this.strSpectText.setFont(viewerFont);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.strSpectText = new JTextArea();
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("StringSpectrum"));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.strSpectText.setLineWrap(false);
        this.strSpectText.setEditable(false);
        this.strSpectText.setColumns(50);
        this.strSpectText.setRows(10);
        this.strSpectText.setText("Unknown");
        this.strSpectText.setBackground(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.strSpectText);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void setModel(IStringSpectrum strSpectAtt) {
        if (this.model != null) {
            this.model.removeListener(this);
        }
        this.strSpectText.setText("");
        this.model = strSpectAtt;
        if (this.model != null) {
            this.setBorder(new TitledBorder(this.model.getNameSansDevice()));
            this.model.addListener(this);
            this.model.refresh();
        }
    }

    public IStringSpectrum getModel() {
        return this.model;
    }

    public int getRows() {
        return this.strSpectText.getRows();
    }

    public void setRows(int rows) {
        this.strSpectText.setRows(rows);
    }

    public int getColumns() {
        return this.strSpectText.getColumns();
    }

    public void setColumns(int columns) {
        this.strSpectText.setColumns(columns);
    }

    public JTextArea getText() {
        return this.strSpectText;
    }

    public void setStrTextArea(String s) {
        if (s.equals(this.strSpectText.getText())) {
            return;
        }
        this.strSpectText.setText(s);
        if (this.isViewEnd()) {
            this.placeTextToEnd();
        }
    }

    @Override
    public void stringSpectrumChange(StringSpectrumEvent evt) {
        String str;
        if (evt.getValue() == null) {
            str = "StringSpectrumAttribute is null.\n";
        } else {
            String[] str_array = null;
            str_array = evt.getValue();
            int attr_size = str_array.length;
            StringBuffer strbuff = new StringBuffer(attr_size);
            for (int ind_str = 0; ind_str < attr_size; ++ind_str) {
                strbuff.append(str_array[ind_str]);
                strbuff.append("\n");
            }
            str = strbuff.toString();
        }
        this.setStrTextArea(str);
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.setStrTextArea("Unknown");
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
        if ("VALID".equals(evt.getState())) {
            this.strSpectText.setBackground(this.getBackground());
            return;
        }
        this.strSpectText.setBackground(ATKConstant.getColor4Quality(evt.getState()));
    }

    public boolean isViewEnd() {
        return this.viewEnd;
    }

    public void setViewEnd(boolean viewEnd) {
        this.viewEnd = viewEnd;
        if (this.isViewEnd()) {
            this.placeTextToEnd();
        }
    }

    private void placeTextToEnd() {
        this.strSpectText.setCaretPosition(this.strSpectText.getDocument().getLength());
    }

    public static void main(String[] args) {
        AttributeList atl = new AttributeList();
        SimpleStringSpectrumViewer sssv = new SimpleStringSpectrumViewer();
        sssv.setViewEnd(true);
        try {
            IStringSpectrum attr = (IStringSpectrum)atl.add("sr/rf-plc/tra2-1/InterlockHistory");
            sssv.setModel(attr);
            atl.startRefresher();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        IEntity ie = null;
        ie = atl.get("sys/MSTATUS/RF-TRA/Devices");
        if (ie == null) {
            System.out.println("Cannot retreive the attribute from the list.");
        } else if (ie instanceof IStringSpectrum) {
            System.out.println("the attribute retreived from the list.");
        } else {
            System.out.println("the attribute retreived is not IStringSpectrum");
        }
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        f.getContentPane().add((Component)sssv, gbc);
        f.pack();
        f.setVisible(true);
    }
}

