/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceApplication;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SingletonStatusViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SimpleStateViewer
extends JSmoothLabel
implements IDevStateScalarListener {
    protected IDevStateScalar model = null;
    private String currentState = "UNKNOWN";
    protected boolean stateClickable = true;
    private IDeviceApplication application;
    private IDevicePopUp popUp = SingletonStatusViewer.getInstance();
    protected boolean hasToolTip = true;
    protected boolean stateInTooltip = true;

    public SimpleStateViewer() {
        this.setFont(ATKConstant.labelFont);
        this.setPreferredSize(new Dimension(40, 14));
        this.setOpaque(true);
        this.setState("UNKNOWN");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleStateViewer.this.stateViewerMouseClicked(evt);
            }
        });
    }

    protected void stateViewerMouseClicked(MouseEvent evt) {
        if (!this.stateClickable) {
            return;
        }
        if (this.model == null) {
            return;
        }
        IDevice dev = this.model.getDevice();
        if ((evt.getModifiers() & 4) != 0) {
            if (this.application == null) {
                return;
            }
            this.application.setModel(dev);
            this.application.run();
        } else {
            this.popUp.setModel(dev);
            this.popUp.setVisible(true);
        }
    }

    public void setHasToolTip(boolean b) {
        if (this.hasToolTip == b) {
            return;
        }
        this.hasToolTip = b;
        if (!this.hasToolTip) {
            this.setToolTipText(null);
            return;
        }
    }

    public void setModel(IDevStateScalar stateAtt) {
        if (this.model != null) {
            this.clearModel();
        }
        if (stateAtt == null) {
            return;
        }
        this.model = stateAtt;
        if (!stateAtt.areAttPropertiesLoaded()) {
            stateAtt.loadAttProperties();
        }
        this.model.addDevStateScalarListener(this);
        if (this.hasToolTip) {
            this.setToolTipText(this.model.getDevice().getName());
        }
        this.model.refresh();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeDevStateScalarListener(this);
            this.model = null;
            this.setState("UNKNOWN");
            if (this.hasToolTip) {
                this.setToolTipText("no device");
            } else {
                this.setToolTipText(null);
            }
        }
    }

    public IDevStateScalar getModel() {
        return this.model;
    }

    private void setState(String state) {
        this.currentState = state;
        if (this.model != null) {
            this.setBackground(ATKConstant.getColor4State(this.currentState, this.model.getInvertedOpenClose(), this.model.getInvertedInsertExtract()));
            if (this.hasToolTip && this.stateInTooltip) {
                this.setToolTipText(this.model.getDevice().getName() + " : " + this.currentState);
            }
        } else {
            this.setBackground(ATKConstant.getColor4State(state));
            if (this.hasToolTip) {
                this.setToolTipText("");
            } else {
                this.setToolTipText(null);
            }
        }
    }

    public void setStateClickable(boolean clickable) {
        this.stateClickable = clickable;
    }

    public boolean getStateClickable() {
        return this.stateClickable;
    }

    public void setApplication(IDeviceApplication runnable) {
        this.application = runnable;
    }

    public IDeviceApplication getApplication() {
        return this.application;
    }

    public IDevicePopUp getPopUp() {
        return this.popUp;
    }

    public void setPopUp(IDevicePopUp v) {
        this.popUp = v;
    }

    @Override
    public void devStateScalarChange(DevStateScalarEvent evt) {
        this.setState(evt.getValue());
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.setState("UNKNOWN");
    }

    public static void main(String[] args) {
        final AttributeList attList = new AttributeList();
        Font large_font = new Font("Dialog", 0, 18);
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                attList.startRefresher();
            }
        });
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        try {
            GridBagConstraints gdbc = new GridBagConstraints();
            gdbc.insets = new Insets(5, 5, 5, 5);
            SimpleStateViewer sstv = new SimpleStateViewer();
            sstv.setFont(large_font);
            sstv.setHorizontalAlignment(CENTER_ALIGNMENT);
            sstv.setStateClickable(false);
            IDevStateScalar attState = (IDevStateScalar)attList.add("dev/test/10/State_attr_rw");
            sstv.setModel(attState);
            sstv.setText("    ");
            gdbc.gridx = 0;
            gdbc.gridy = 0;
            jp.add((Component)sstv, gdbc);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setContentPane(jp);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

