/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SignalScalarCheckBoxViewer
extends JCheckBox
implements ActionListener,
IBooleanScalarListener,
INumberScalarListener,
ISetErrorListener,
JDrawable {
    protected IAttribute attModel = null;
    protected String trueLabel = null;
    protected String falseLabel = null;
    protected String fixedLabel = null;
    protected boolean hasToolTip = false;
    protected boolean qualityEnabled = false;
    protected Color background;
    protected String[] exts = new String[]{"text"};
    protected boolean enabled;

    public SignalScalarCheckBoxViewer() {
        this.addActionListener(this);
        this.background = this.getBackground();
        this.enabled = this.isEnabled();
    }

    public SignalScalarCheckBoxViewer(String title) {
        super(title);
        this.addActionListener(this);
        this.background = this.getBackground();
        this.enabled = this.isEnabled();
    }

    public IAttribute getAttModel() {
        return this.attModel;
    }

    public void setBooleanScalarModel(IBooleanScalar boolModel) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (boolModel != null) {
            this.attModel = boolModel;
            ((IBooleanScalar)this.attModel).addBooleanScalarListener(this);
            if (this.attModel.isWritable()) {
                this.attModel.addSetErrorListener(this);
            }
            if (this.trueLabel == null && this.falseLabel == null && this.fixedLabel == null) {
                this.setText(boolModel.getLabel());
            }
            if (this.hasToolTip) {
                this.setToolTipText(boolModel.getName());
            }
            this.setBoolValue(((IBooleanScalar)this.attModel).getDeviceValue());
        }
    }

    public void setNumberScalarModel(INumberScalar numModel) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (numModel != null) {
            this.attModel = numModel;
            ((INumberScalar)this.attModel).addNumberScalarListener(this);
            if (this.attModel.isWritable()) {
                this.attModel.addSetErrorListener(this);
            }
            if (this.trueLabel == null && this.falseLabel == null && this.fixedLabel == null) {
                this.setText(numModel.getLabel());
            }
            if (this.hasToolTip) {
                this.setToolTipText(numModel.getName());
            }
            this.setBoolValue(((INumberScalar)this.attModel).getNumberScalarDeviceValue());
        }
    }

    public void clearModel() {
        if (this.attModel != null) {
            if (this.attModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attModel).removeBooleanScalarListener(this);
            } else if (this.attModel instanceof INumberScalar) {
                ((INumberScalar)this.attModel).removeNumberScalarListener(this);
            }
            if (this.attModel.isWritable()) {
                this.attModel.removeSetErrorListener(this);
            }
            this.attModel = null;
            this.setText("");
        }
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String tLabel) {
        this.trueLabel = tLabel;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (this.isSelected()) {
            this.setText(this.trueLabel);
        }
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String fLabel) {
        this.falseLabel = fLabel;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (!this.isSelected()) {
            this.setText(this.falseLabel);
        }
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean b) {
        if (this.hasToolTip != b) {
            if (!b) {
                this.setToolTipText(null);
            } else if (this.attModel != null) {
                this.setToolTipText(this.attModel.getName());
            }
            this.hasToolTip = b;
        }
    }

    public boolean getQualityEnabled() {
        return this.qualityEnabled;
    }

    public void setQualityEnabled(boolean b) {
        this.qualityEnabled = b;
        if (!this.qualityEnabled) {
            super.setBackground(this.background);
            this.repaint();
        }
    }

    @Override
    public void initForEditing() {
        this.setText("CheckBox");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equalsIgnoreCase("text")) {
            return "Overrides text given by the model.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return this.exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("text")) {
            this.fixedLabel = value;
            if (this.fixedLabel.length() == 0) {
                this.fixedLabel = null;
                this.setText("CheckBox");
            } else {
                this.setText(this.fixedLabel);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("text") && this.fixedLabel != null) {
            return this.fixedLabel;
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.attModel == null) {
            return;
        }
        if (!this.attModel.isWritable()) {
            this.setSelected(!this.isSelected());
            return;
        }
        if (this.attModel instanceof IBooleanScalar) {
            if (this.isSelected()) {
                ((IBooleanScalar)this.attModel).setValue(true);
            } else {
                ((IBooleanScalar)this.attModel).setValue(false);
            }
        } else if (this.attModel instanceof INumberScalar) {
            if (this.isSelected()) {
                ((INumberScalar)this.attModel).setValue(1.0);
            } else {
                ((INumberScalar)this.attModel).setValue(0.0);
            }
        }
    }

    @Override
    public void booleanScalarChange(BooleanScalarEvent e) {
        this.setBoolValue(e.getValue());
    }

    @Override
    public void numberScalarChange(NumberScalarEvent e) {
        this.setBoolValue(e.getValue());
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
        String state = evt.getState();
        if (!this.qualityEnabled) {
            return;
        }
        super.setBackground(ATKConstant.getColor4Quality(state));
        this.repaint();
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        super.setEnabled(false);
    }

    protected void setBoolValue(boolean val) {
        if (this.enabled && !this.isEnabled()) {
            super.setEnabled(this.enabled);
        }
        this.setSelected(val);
        if (this.trueLabel != null || this.falseLabel != null) {
            if (val) {
                this.setText(this.trueLabel);
            } else {
                this.setText(this.falseLabel);
            }
        }
    }

    protected void setBoolValue(double val) {
        this.setBoolValue(val != 0.0);
    }

    @Override
    public void setErrorOccured(ErrorEvent evt) {
        if (this.attModel == null) {
            return;
        }
        if (evt.getSource() != this.attModel) {
            return;
        }
        if (this.attModel instanceof IBooleanScalar) {
            this.setBoolValue(((IBooleanScalar)this.attModel).getDeviceValue());
        } else if (this.attModel instanceof INumberScalar) {
            this.setBoolValue(((INumberScalar)this.attModel).getNumberScalarDeviceValue());
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        super.setBackground(bg);
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        super.setEnabled(b);
    }

    public static void main(String[] args) {
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        SignalScalarCheckBoxViewer bsv = new SignalScalarCheckBoxViewer();
        String attributeName = "tango/tangotest/1/boolean_scalar";
        try {
            IEntity ie;
            if (args.length > 0) {
                attributeName = args[0];
            }
            if (!((ie = attl.add(attributeName)) instanceof IBooleanScalar) && !(ie instanceof INumberScalar)) {
                System.out.println(attributeName + " is not a valid attribute");
                System.exit(0);
            }
            if (ie instanceof IBooleanScalar) {
                bsv.setBooleanScalarModel((IBooleanScalar)ie);
            } else {
                bsv.setNumberScalarModel((INumberScalar)ie);
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to " + attributeName);
        }
        f.setContentPane(bsv);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

