/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.LabelItem;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ScalarLevelMeterViewer
extends JComponent
implements INumberScalarListener {
    private INumberScalar numberModel = null;
    private double min;
    private double max;
    private double value = Double.NaN;
    private Color viewBackground = Color.WHITE;
    private int nbDiv = 30;
    private Vector<LabelItem> labels;
    private boolean drawGradient = true;

    public ScalarLevelMeterViewer() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(200, 100));
        this.min = 0.0;
        this.max = 100.0;
        this.labels = new Vector();
        this.setFont(new Font("Dialog", 0, 10));
        this.addLabel(0.0, "0%");
        this.addLabel(0.25, "25%");
        this.addLabel(0.5, "50%");
        this.addLabel(0.75, "75%");
        this.addLabel(1.0, "100%");
        this.numberModel = null;
    }

    public void setDrawGradient(boolean draw) {
        this.drawGradient = draw;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setViewBackground(Color c) {
        this.viewBackground = c;
    }

    public Color getViewBackground() {
        return this.viewBackground;
    }

    public void addLabel(double x, String label) {
        LabelItem l = new LabelItem(x, label);
        this.labels.add(l);
    }

    public void clearLabel() {
        this.labels.clear();
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        this.value = evt.getValue();
        this.repaint();
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.value = Double.NaN;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
        }
        int nbPoint = (this.nbDiv + 1) * 2;
        int[] xPoint = new int[nbPoint];
        int[] yPoint = new int[nbPoint];
        double xCenter = (double)w / 2.0;
        double yCenter = 2.0 * (double)h + 10.0;
        double r = 2.0 * (double)h - 20.0;
        double rIn = 2.0 * (double)h - (double)h / 3.0 - 20.0;
        double rOut = 2.0 * (double)h - 10.0;
        double alpha = Math.asin((xCenter - 30.0) / r);
        double deltaA = 2.0 * alpha / (double)this.nbDiv;
        double angle = -alpha;
        for (int i = 0; i <= this.nbDiv; ++i) {
            xPoint[i] = (int)(r * Math.sin(angle) + xCenter);
            xPoint[nbPoint - 1 - i] = (int)(rIn * Math.sin(angle) + xCenter);
            yPoint[i] = (int)(-r * Math.cos(angle) + yCenter);
            yPoint[nbPoint - 1 - i] = (int)(-rIn * Math.cos(angle) + yCenter);
            angle += deltaA;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.drawGradient) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.GREEN, w - 50, 1.0f, Color.ORANGE, false);
            g2.setPaint(gp);
        } else {
            g.setColor(this.viewBackground);
        }
        g.fillPolygon(xPoint, yPoint, nbPoint);
        g.setColor(this.getForeground());
        g.drawPolygon(xPoint, yPoint, nbPoint);
        for (int i = 0; i < this.labels.size(); ++i) {
            angle = alpha * (2.0 * this.labels.get((int)i).x - 1.0);
            int x1 = (int)(r * Math.sin(angle) + xCenter);
            int y1 = (int)(-r * Math.cos(angle) + yCenter);
            int x2 = (int)(rOut * Math.sin(angle) + xCenter);
            int y2 = (int)(-rOut * Math.cos(angle) + yCenter);
            g.drawLine(x1, y1, x2, y2);
            g.setFont(this.getFont());
            int ws = ATKGraphicsUtils.measureString((String)this.labels.get((int)i).label, (Font)this.getFont()).width;
            g.drawString(this.labels.get((int)i).label, x2 - ws / 2, y2 - 3);
        }
        if (!Double.isNaN(this.value)) {
            angle = this.value < this.min ? -alpha : (this.value > this.max ? alpha : alpha * (2.0 * (this.value - this.min) / (this.max - this.min) - 1.0));
            Stroke old = g2.getStroke();
            BasicStroke bs = new BasicStroke(2.0f);
            if (bs != null) {
                g2.setStroke(bs);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int x1 = (int)(r * Math.sin(angle) + xCenter);
            int y1 = (int)(-r * Math.cos(angle) + yCenter);
            int x2 = (int)(rIn * Math.sin(angle) + xCenter);
            int y2 = (int)(-rIn * Math.cos(angle) + yCenter);
            g.drawLine(x1, y1, x2, y2);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setStroke(old);
        }
        this.paintBorder(g);
    }

    public void clearModel() {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener(this);
            this.numberModel = null;
        }
    }

    public void setModel(INumberScalar model) {
        this.clearModel();
        if (model != null) {
            this.numberModel = model;
            this.numberModel.addNumberScalarListener(this);
            this.numberModel.refresh();
        }
    }

    public static void main(String[] args) throws Exception {
        AttributeList attributeList = new AttributeList();
        ScalarLevelMeterViewer slmv = new ScalarLevelMeterViewer();
        String attributeName = "jlp/test/1/att_un";
        if (args != null && args.length > 0) {
            attributeName = args[0];
        }
        IAttribute attribute = null;
        try {
            attribute = (IAttribute)attributeList.add(attributeName);
        }
        catch (Exception e) {
            attribute = null;
        }
        if (attribute instanceof INumberScalar) {
            slmv.setModel((INumberScalar)attribute);
        } else {
            System.err.println(attributeName + " is not a valid attribute or is not available");
            System.exit(1);
        }
        slmv.setBorder(BorderFactory.createLoweredBevelBorder());
        slmv.setForeground(Color.BLACK);
        slmv.clearLabel();
        slmv.addLabel(0.0, "-1");
        slmv.addLabel(0.25, "");
        slmv.addLabel(0.5, "0");
        slmv.addLabel(0.75, "");
        slmv.addLabel(1.0, "1");
        slmv.setMin(-1.0);
        slmv.setMax(1.0);
        attribute.refresh();
        JFrame f = new JFrame();
        f.setContentPane(slmv);
        f.pack();
        f.setVisible(true);
        attributeList.startRefresher();
    }
}

