/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScalarInput
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String textButton = "Write";
    private boolean buttonEnabled = true;
    private boolean valueEditable = true;
    private Color backgroundButton = Color.GRAY;
    private Color backgroundField = Color.WHITE;
    private IAttribute scalarModel = null;
    private JTextField attributeTextField = new JTextField();
    private JButton writeButton = new JButton();

    public ScalarInput() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.attributeTextField.setMinimumSize(new Dimension(74, 17));
        this.attributeTextField.setPreferredSize(new Dimension(74, 17));
        this.attributeTextField.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.attributeTextField, gridBagConstraints);
        this.writeButton.setText(this.textButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.add((Component)this.writeButton, gridBagConstraints);
    }

    public IAttribute getScalarModel() {
        return this.scalarModel;
    }

    public void setScalarModel(IAttribute scalarModel) {
        this.scalarModel = scalarModel;
        if (scalarModel == null) {
            return;
        }
        if (!scalarModel.isWritable()) {
            this.setValueEditable(false);
            this.setButtonEnabled(false);
        }
    }

    public void clearModel() {
        this.scalarModel = null;
        this.textButton = "Write";
        this.attributeTextField.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.scalarModel == null || arg0.getSource() instanceof JTextField) {
            return;
        }
        try {
            if (this.scalarModel instanceof INumberScalar) {
                ((INumberScalar)this.scalarModel).setValue(this.getValue());
            } else if (this.scalarModel instanceof IStringScalar) {
                ((IStringScalar)this.scalarModel).setValue(this.attributeTextField.getText());
            } else if (this.scalarModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.scalarModel).setValue(this.getBooleanValue());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot write attribute because " + e.getMessage());
        }
    }

    private double getValue() {
        String tmpStringValue = this.attributeTextField.getText();
        double tmpDoubleValue = 0.0;
        try {
            tmpDoubleValue = Double.parseDouble(tmpStringValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return tmpDoubleValue;
    }

    private boolean getBooleanValue() {
        String tmpStringValue = this.attributeTextField.getText();
        if (this.getValue() == 1.0) {
            tmpStringValue = "true";
        }
        return Boolean.parseBoolean(tmpStringValue);
    }

    public boolean isButtonEnabled() {
        return this.buttonEnabled;
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.buttonEnabled = buttonEnabled;
        this.writeButton.setEnabled(buttonEnabled);
    }

    public String getTextButton() {
        return this.textButton;
    }

    public void setTextButton(String textButton) {
        this.textButton = textButton;
        this.writeButton.setText(textButton);
    }

    public boolean isValueEditable() {
        return this.valueEditable;
    }

    public void setValueEditable(boolean valueEditable) {
        this.valueEditable = valueEditable;
        this.attributeTextField.setEditable(valueEditable);
    }

    public Color getBackgroundButton() {
        return this.backgroundButton;
    }

    public void setBackgroundButton(Color backgroundButton) {
        if (backgroundButton == null) {
            return;
        }
        this.backgroundButton = backgroundButton;
        this.writeButton.setBackground(backgroundButton);
    }

    public Color getBackgroundField() {
        return this.backgroundField;
    }

    public void setBackgroundField(Color backgroundField) {
        if (backgroundField == null) {
            return;
        }
        this.backgroundField = backgroundField;
        this.attributeTextField.setBackground(backgroundField);
    }

    @Override
    public void setFont(Font arg0) {
        if (arg0 == null || this.writeButton == null || this.attributeTextField == null) {
            return;
        }
        this.writeButton.setFont(arg0);
        this.attributeTextField.setFont(arg0);
        super.setFont(arg0);
    }

    public void setNumberValue(double avalue) {
        if (!this.attributeTextField.hasFocus()) {
            this.attributeTextField.setText(Double.toString(avalue));
        }
    }

    public void setStringValue(String avalue) {
        if (!this.attributeTextField.hasFocus()) {
            this.attributeTextField.setText(avalue);
        }
    }

    public void setBooleanValue(boolean avalue) {
        if (!this.attributeTextField.hasFocus()) {
            this.attributeTextField.setText(Boolean.toString(avalue));
        }
    }

    public void writeNumberValue(double avalue) {
        this.attributeTextField.setText(Double.toString(avalue));
        if (this.scalarModel != null && this.scalarModel.isWritable() && this.scalarModel instanceof INumberScalar) {
            ((INumberScalar)this.scalarModel).setValue(avalue);
        }
    }

    public void writeStringValue(String avalue) {
        this.attributeTextField.setText(avalue);
        if (this.scalarModel != null && this.scalarModel.isWritable() && this.scalarModel instanceof IStringScalar) {
            ((IStringScalar)this.scalarModel).setValue(avalue);
        }
    }

    public String getText() {
        return this.attributeTextField.getText();
    }

    public void writeBooleanValue(boolean avalue) {
        this.attributeTextField.setText(Boolean.toString(avalue));
        if (this.scalarModel != null && this.scalarModel.isWritable() && this.scalarModel instanceof IBooleanScalar) {
            ((IBooleanScalar)this.scalarModel).setValue(avalue);
        }
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        ScalarInput si = new ScalarInput();
        try {
            if (args.length != 0) {
                si.setScalarModel((IAttribute)attributeList.add(args[0]));
            } else {
                si.setScalarModel((IAttribute)attributeList.add("LT1/AE/CH.1/current"));
            }
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        JFrame f = new JFrame();
        f.getContentPane().add(si);
        f.pack();
        f.setVisible(true);
    }
}

