/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class NumberSpectrumTrendViewer
extends JPanel
implements ISpectrumListener,
IAttributeStateListener,
IErrorListener,
ActionListener {
    protected INumberSpectrum model;
    protected JLabel nameLabel;
    protected static final String DEFAULT_NAME = "No Attribute";
    protected AttributePolledList attList;
    protected Vector<JLDataView> views;
    protected JLChart chart;
    protected JToolBar theToolBar;
    protected JButton optionButton;
    protected JButton stopButton;
    protected JButton startButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton zoomButton;
    protected JButton timeButton;
    protected JButton resetButton;
    protected JPanel innerPanel;
    protected String lastConfig = "";
    protected static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black, Color.white};
    protected static final int[] defaultMarkerStyle = new int[]{2, 9, 8, 4, 1, 7, 10, 5, 3, 6};

    public NumberSpectrumTrendViewer() {
        this.initComponents();
        this.addComponents();
    }

    public void setModel(String attributeName) {
        if (attributeName == null || "".equals(attributeName.trim())) {
            this.setModel((INumberSpectrum)null);
            return;
        }
        this.attList.stopRefresher();
        this.attList.clear();
        this.chart.getY1Axis().clearDataView();
        this.views.clear();
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        try {
            this.model = (INumberSpectrum)this.attList.add(attributeName);
            this.model.addSpectrumListener(this);
            this.attList.add(this.model);
            this.attList.startRefresher();
            String quality = this.model.getState();
            this.nameLabel.setText(this.model.getName());
            this.nameLabel.setBackground(ATKConstant.getColor4Quality(quality));
            this.nameLabel.setToolTipText(quality);
            this.nameLabel.repaint();
            quality = null;
        }
        catch (Exception e) {
            this.model = null;
            this.nameLabel.setText(DEFAULT_NAME);
            this.nameLabel.setToolTipText(DEFAULT_NAME);
            this.nameLabel.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
            JOptionPane.showMessageDialog(this, "Failed to set " + attributeName + " as model", "Error", 0);
        }
    }

    public void setModel(INumberSpectrum attribute) {
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        if (attribute == null || !(attribute instanceof INumberSpectrum)) {
            return;
        }
        this.attList.stopRefresher();
        this.attList.clear();
        this.chart.getY1Axis().clearDataView();
        this.views.clear();
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        try {
            this.model = attribute;
            this.model.addSpectrumListener(this);
            this.attList.add(this.model);
            this.attList.startRefresher();
            String quality = this.model.getState();
            this.nameLabel.setText(this.model.getName());
            this.nameLabel.setBackground(ATKConstant.getColor4Quality(quality));
            this.nameLabel.setToolTipText(quality);
            this.nameLabel.repaint();
            quality = null;
        }
        catch (Exception e) {
            this.model = null;
            this.nameLabel.setText(DEFAULT_NAME);
            this.nameLabel.setToolTipText(DEFAULT_NAME);
            this.nameLabel.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
            JOptionPane.showMessageDialog(this, "Failed to set " + attribute.getName() + " as model", "Error", 0);
        }
    }

    public void clearModel() {
        this.setModel((INumberSpectrum)null);
    }

    @Override
    public void spectrumChange(NumberSpectrumEvent e) {
        for (int i = 0; i < e.getValue().length; ++i) {
            JLDataView data;
            if (i < this.views.size()) {
                data = this.views.get(i);
                data.add(e.getTimeStamp(), e.getValue()[i]);
                this.chart.garbageData(data);
            } else {
                data = new JLDataView();
                data.add(e.getTimeStamp(), e.getValue()[i]);
                Color drawColor = defaultColor[i % defaultColor.length];
                int markerStyle = defaultMarkerStyle[i / defaultColor.length % defaultMarkerStyle.length];
                data.setMarkerSize(3);
                data.setViewType(0);
                data.setColor(drawColor);
                data.setMarker(markerStyle);
                data.setMarkerColor(drawColor);
                data.setStyle(0);
                this.chart.getY1Axis().addDataView(data);
                this.views.add(data);
            }
            if (i < ((INumberSpectrum)e.getSource()).getXDimension()) {
                data.setLineWidth(1);
                data.setName(Integer.toString(i));
            } else {
                data.setLineWidth(2);
                data.setName(i - ((INumberSpectrum)e.getSource()).getXDimension() + "(write)");
            }
            data.setUnit(((INumberSpectrum)e.getSource()).getUnit());
            Object var3_4 = null;
        }
        this.chart.repaint();
        String quality = ((INumberSpectrum)e.getSource()).getState();
        this.nameLabel.setBackground(ATKConstant.getColor4Quality(quality));
        this.nameLabel.setToolTipText(quality);
        this.nameLabel.repaint();
        quality = null;
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
        String quality = ((INumberSpectrum)e.getSource()).getState();
        this.nameLabel.setBackground(ATKConstant.getColor4Quality(quality));
        this.nameLabel.setToolTipText(quality);
        this.nameLabel.repaint();
        quality = null;
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        for (int i = 0; i < this.views.size(); ++i) {
            JLDataView data = this.views.get(i);
            data.add(evt.getTimeStamp(), Double.NaN);
            this.chart.garbageData(data);
        }
        this.chart.repaint();
        String quality = ((INumberSpectrum)evt.getSource()).getState();
        this.nameLabel.setBackground(ATKConstant.getColor4Quality(quality));
        this.nameLabel.setToolTipText(quality);
        this.nameLabel.repaint();
        quality = null;
    }

    public void setRefreshInterval(int refreshinterval) {
        this.attList.setRefreshInterval(refreshinterval);
    }

    public int getRefreshInterval() {
        return this.attList.getRefreshInterval();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.optionButton) {
            this.chart.showOptionDialog();
        } else if (o == this.stopButton) {
            this.attList.stopRefresher();
        } else if (o == this.startButton) {
            this.attList.startRefresher();
        } else if (o == this.loadButton) {
            this.loadButtonActionPerformed();
        } else if (o == this.saveButton) {
            this.saveButtonActionPerformed();
        } else if (o == this.zoomButton) {
            if (!this.chart.isZoomed()) {
                this.chart.enterZoom();
            } else {
                this.chart.exitZoom();
            }
        } else if (o == this.timeButton) {
            this.setRefreshInterval();
        } else if (o == this.resetButton) {
            this.resetTrend();
        }
    }

    protected void initComponents() {
        this.nameLabel = new JLabel(DEFAULT_NAME, 0);
        this.nameLabel.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
        this.nameLabel.setToolTipText(DEFAULT_NAME);
        this.nameLabel.setOpaque(true);
        this.nameLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.nameLabel.getPreferredSize().height));
        this.attList = new AttributePolledList();
        this.chart = new JLChart();
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.setDisplayDuration(300000.0);
        this.chart.setLabelVisible(false);
        this.views = new Vector();
        this.theToolBar = new JToolBar();
        this.theToolBar.setFloatable(true);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_load.gif")));
        this.loadButton.setToolTipText("Load configuration");
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_save.gif")));
        this.saveButton.setToolTipText("Save configuration");
        this.optionButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_settings.gif")));
        this.optionButton.setToolTipText("Global settings");
        this.zoomButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_zoom.gif")));
        this.zoomButton.setToolTipText("Zoom");
        this.startButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_start.gif")));
        this.startButton.setToolTipText("Start monitoring");
        this.stopButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_stop.gif")));
        this.stopButton.setToolTipText("Stop monitoring");
        this.timeButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_time.gif")));
        this.timeButton.setToolTipText("Set refresh interval");
        this.resetButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_reset.gif")));
        this.resetButton.setToolTipText("Reset viewer");
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.optionButton.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.timeButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.theToolBar.add(this.loadButton);
        this.theToolBar.add(this.saveButton);
        this.theToolBar.add(this.optionButton);
        this.theToolBar.add(this.zoomButton);
        this.theToolBar.add(this.startButton);
        this.theToolBar.add(this.stopButton);
        this.theToolBar.add(this.timeButton);
        this.theToolBar.add(this.resetButton);
    }

    protected void addComponents() {
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.theToolBar, "North");
        this.innerPanel.add((Component)this.nameLabel, "North");
        this.innerPanel.add((Component)this.chart, "Center");
        this.add((Component)this.innerPanel, "Center");
    }

    protected void loadButtonActionPerformed() {
        String err;
        File f;
        int returnVal;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null && !ok && (err = this.loadSetting(f.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this, err, "Errors reading " + f.getName(), 0);
        }
    }

    public String loadSetting(String filename) {
        CfFileReader f = new CfFileReader();
        if (!f.readFile(filename)) {
            return "Failed to read " + filename;
        }
        this.lastConfig = filename;
        return this.applySettings(f);
    }

    protected String applySettings(CfFileReader f) {
        String errBuff = "";
        Vector<String> p = f.getParam("model");
        if (p == null) {
            this.clearModel();
        } else {
            this.setModel(p.get(0).toString());
        }
        p = f.getParam("refresh_time");
        this.attList.stopRefresher();
        if (p != null) {
            this.attList.setRefreshInterval(OFormat.getInt(p.get(0).toString()));
        } else {
            this.attList.setRefreshInterval(1000);
        }
        this.attList.startRefresher();
        this.chart.setMaxDisplayDuration(Double.POSITIVE_INFINITY);
        this.chart.setDisplayDuration(Double.POSITIVE_INFINITY);
        this.chart.applyConfiguration(f);
        this.chart.getXAxis().applyConfiguration("x", f);
        this.chart.getY1Axis().applyConfiguration("y1", f);
        this.chart.getY2Axis().applyConfiguration("y2", f);
        return errBuff;
    }

    public String getSettings() {
        String to_write = "";
        to_write = to_write + this.chart.getConfiguration();
        if (this.attList != null) {
            to_write = to_write + "refresh_time:" + this.attList.getRefreshInterval() + "\n";
        }
        if (this.model != null) {
            to_write = to_write + "model:'" + this.model.getName() + "'\n";
        }
        to_write = to_write + this.chart.getXAxis().getConfiguration("x");
        to_write = to_write + this.chart.getY1Axis().getConfiguration("y1");
        to_write = to_write + this.chart.getY2Axis().getConfiguration("y2");
        return to_write;
    }

    private void saveButtonActionPerformed() {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(f) == null) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                this.saveSetting(f.getAbsolutePath());
            }
        }
    }

    public void saveSetting(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            String s = this.getSettings();
            f.write(s, 0, s.length());
            f.close();
            this.lastConfig = filename;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to write " + filename, "Error", 0);
        }
    }

    protected void setRefreshInterval() {
        int old_it = this.attList.getRefreshInterval();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                this.attList.setRefreshInterval(it);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
            }
        }
    }

    public void resetTrend() {
        if (this.views != null) {
            for (int i = 0; i < this.views.size(); ++i) {
                JLDataView view = this.views.get(i);
                if (view == null) continue;
                view.reset();
            }
            this.chart.repaint();
        }
    }

    public static void main(String[] args) {
        String attributeName = args.length > 0 ? args[0] : "tango/tangotest/1/float_spectrum_ro";
        final NumberSpectrumTrendViewer viewer = new NumberSpectrumTrendViewer();
        viewer.setRefreshInterval(1000);
        JFrame f = new JFrame("NumberSpectrumTrendViewer - close once to clear model, twice to exit");
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){
            int closecount = 0;

            @Override
            public void windowClosing(WindowEvent e) {
                if (this.closecount++ == 1) {
                    System.exit(0);
                } else {
                    viewer.clearModel();
                }
            }
        });
        f.getContentPane().add(viewer);
        viewer.setModel(attributeName);
        f.setSize(800, 600);
        f.setVisible(true);
    }
}

