/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.EditableJTableRow;
import fr.esrf.tangoatk.widget.util.EditableTableRowModel;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class NumberSpectrumTableEditor
extends JFrame
implements ISpectrumListener,
TableModelListener {
    private JButton closeFileJButton;
    private JPanel dummyJPanel1;
    private JButton resetJButton;
    private JPanel dummyJPanel2;
    private JButton writeAttJButton;
    private EditableJTableRow theTable = new EditableJTableRow();
    private EditableTableRowModel etrm = this.theTable.getEditorTableRowModel();
    private boolean updatedOnce = false;
    private double A0 = 0.0;
    private double A1 = 1.0;
    protected INumberSpectrum model = null;
    private JFileChooser jfc = null;

    public NumberSpectrumTableEditor() {
        this.etrm.addTableModelListener(this);
        this.theTable.setTableRowModel(this.etrm);
        this.theTable.setEditable(true);
        this.initComponents();
        this.jfc = new JFileChooser();
        this.jfc.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        this.jfc.setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
    }

    public void setData(Object[][] data, String[] colNames) {
        this.theTable.setData(data, colNames);
    }

    public void clearData() {
        this.theTable.clearData();
    }

    public void centerWindow() {
        this.theTable.adjustColumnSize();
        this.theTable.adjustSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        this.pack();
        Dimension appsize = this.getPreferredSize();
        if (appsize.height > 600) {
            appsize.height = 600;
            if (appsize.width < 800) {
                appsize.width += 16;
            }
        }
        if (appsize.width > 800) {
            appsize.width = 800;
        }
        int x = (scrsize.width - appsize.width) / 2;
        int y = (scrsize.height - appsize.height) / 2;
        this.setBounds(x, y, appsize.width, appsize.height);
    }

    public void setXAxisAffineTransform(double a0, double a1) {
        this.A0 = a0;
        this.A1 = a1;
    }

    private void initComponents() {
        this.closeFileJButton = new JButton();
        this.dummyJPanel1 = new JPanel();
        this.writeAttJButton = new JButton();
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.theTable, gridBagConstraints);
        this.closeFileJButton.setText("Close");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.closeFileJButton, gridBagConstraints);
        this.closeFileJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberSpectrumTableEditor.this.closeJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.dummyJPanel1, gridBagConstraints);
        this.writeAttJButton.setText("Write Attribute");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.writeAttJButton, gridBagConstraints);
        this.writeAttJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberSpectrumTableEditor.this.writeAttJButtonActionPerformed(evt);
            }
        });
        this.pack();
    }

    private void closeJButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void resetJButtonActionPerformed(ActionEvent evt) {
        this.updateTable();
    }

    private void writeAttJButtonActionPerformed(ActionEvent evt) {
        double[] numberSpectrumData = null;
        if (this.theTable == null) {
            return;
        }
        if (this.theTable.getEditorTableRowModel() == null) {
            return;
        }
        this.etrm = this.theTable.getEditorTableRowModel();
        numberSpectrumData = this.etrm.parseNumberSpectrumData();
        if (numberSpectrumData == null) {
            return;
        }
        this.model.setValue(numberSpectrumData);
    }

    public void setModel(INumberSpectrum v) {
        if (this.model != null) {
            this.clearModel();
        }
        if (v != null && v.isWritable()) {
            this.model = v;
            this.etrm = this.theTable.getEditorTableRowModel();
            this.etrm.setAttributeColumnName(this.model.getName());
            this.model.addSpectrumListener(this);
            this.model.refresh();
        }
        this.repaint();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
            this.model = null;
            this.updatedOnce = false;
        }
        this.clearData();
        this.theTable = new EditableJTableRow();
        this.etrm.removeTableModelListener(this);
        this.etrm = this.theTable.getEditorTableRowModel();
        this.etrm.addTableModelListener(this);
        this.theTable.setTableRowModel(this.etrm);
        this.theTable.setEditable(true);
    }

    @Override
    public void spectrumChange(NumberSpectrumEvent e) {
        if (this.isVisible() && this.updatedOnce) {
            return;
        }
        this.updateTable();
        this.updatedOnce = true;
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
    }

    private void updateTable() {
        this.clearData();
        double[] setValue = this.model.getSpectrumSetPoint();
        String[] cols = new String[]{"Index", this.model.getName()};
        String format = this.model.getFormat();
        if (format == null) {
            format = "%g";
        }
        Object[][] data = new Object[setValue.length][2];
        for (int i = 0; i < setValue.length; ++i) {
            data[i][0] = Integer.toString(i);
            data[i][1] = ATKFormat.format(format, setValue[i]);
        }
        this.setData(data, cols);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NumberSpectrumTableEditor().setVisible(true);
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 1 || e.getType() == 0) {
            this.theTable.adjustColumnSize();
            this.theTable.adjustSize();
            this.pack();
            Dimension appsize = this.getPreferredSize();
            if (appsize.height > 600) {
                appsize.height = 600;
                if (appsize.width < 800) {
                    appsize.width += 16;
                }
            }
            if (appsize.width > 800) {
                appsize.width = 800;
            }
            this.setBounds(this.getBounds().x, this.getBounds().y, appsize.width, appsize.height);
            if (e.getType() == 1 && this.theTable.getJTable() != null) {
                this.theTable.getJTable().changeSelection(e.getLastRow(), 1, false, false);
                this.theTable.getJTable().editCellAt(e.getLastRow(), 1);
            }
        }
    }
}

