/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;

public class NumberSpectrumItemTrend
extends JLChart
implements ISpectrumListener,
IAttributeStateListener,
ActionListener {
    public static final int AXIS_NONE = 0;
    public static final int AXIS_Y1 = 1;
    public static final int AXIS_Y2 = 2;
    private boolean plotAll = true;
    private boolean plotting = true;
    protected INumberSpectrum model = null;
    protected Map<Integer, JLDataView> itemMap = new HashMap<Integer, JLDataView>();
    protected Map<JLDataView, Integer> dvAxisMap = new HashMap<JLDataView, Integer>();
    protected List<JLDataView> allItems = new Vector<JLDataView>();
    private String qualityFactor = null;
    protected static final Color[] defaultColor = new Color[]{Color.red, Color.blue, new Color(0, 120, 0), new Color(250, 70, 0), Color.magenta, new Color(120, 0, 120), Color.black, Color.pink, Color.green, Color.orange};
    protected static final int[] defaultMarkerStyle = new int[]{2, 9, 8, 4, 1, 7, 10, 5, 3, 6};

    public void setModel(INumberSpectrum insModel) {
        if (this.model != null) {
            this.clearModel();
        }
        if (insModel == null) {
            return;
        }
        this.model = insModel;
        this.model.addSpectrumListener(this);
        this.model.addStateListener(this);
        this.model.addErrorListener(this);
    }

    public void clearModel() {
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.itemMap.clear();
        this.dvAxisMap.clear();
        this.allItems.clear();
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
            this.model.removeStateListener(this);
            this.model.removeErrorListener(this);
        }
        this.repaint();
    }

    public boolean getPlotAll() {
        return this.plotAll;
    }

    public void setPlotAll(boolean b) {
        if (b == this.plotAll) {
            return;
        }
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.itemMap.clear();
        this.dvAxisMap.clear();
        this.allItems.clear();
        this.plotAll = b;
        this.repaint();
    }

    public boolean isPlotting() {
        return this.plotting;
    }

    public void setPlotting(boolean b) {
        this.plotting = b;
    }

    public void removeAllPlots() {
        boolean plotState = this.plotting;
        this.plotting = false;
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.itemMap.clear();
        this.dvAxisMap.clear();
        this.allItems.clear();
        this.repaint();
        this.plotting = plotState;
    }

    public JLDataView getDataViewForItem(int itemIndex) {
        if (itemIndex < 0) {
            return null;
        }
        if (this.plotAll && itemIndex >= this.allItems.size()) {
            return null;
        }
        if (this.plotAll) {
            return this.allItems.get(itemIndex);
        }
        Set<Integer> itemSet = this.itemMap.keySet();
        if (itemSet != null) {
            for (Integer currItem : itemSet) {
                if (currItem != itemIndex) continue;
                return this.itemMap.get(currItem);
            }
        }
        return null;
    }

    public void plotItem(int itemIndex, int axis, String plotLabel) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        if (axis != 1 && axis != 2) {
            return;
        }
        JLDataView data = this.getDataViewForItem(itemIndex);
        if (data != null) {
            this.removePlotItem(itemIndex);
        }
        Integer itemKey = new Integer(itemIndex);
        Integer axisNumber = new Integer(axis);
        Color drawColor = defaultColor[this.itemMap.size() % defaultColor.length];
        data = new JLDataView();
        data.setViewType(0);
        data.setStyle(0);
        data.setColor(drawColor);
        data.setMarkerColor(drawColor);
        data.setName(plotLabel);
        data.setUnit(this.model.getUnit());
        if (axis == 2) {
            this.getY2Axis().addDataView(data);
        } else {
            this.getY1Axis().addDataView(data);
        }
        this.itemMap.put(itemKey, data);
        this.dvAxisMap.put(data, axisNumber);
    }

    public void removePlotItem(int itemIndex) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        if (itemIndex < 0 || itemIndex >= this.model.getXDimension()) {
            return;
        }
        Set<Integer> itemSet = this.itemMap.keySet();
        if (itemSet != null) {
            for (Integer currItem : itemSet) {
                if (currItem != itemIndex) continue;
                JLDataView dv = this.itemMap.get(currItem);
                JLAxis dvAxis = dv.getAxis();
                if (dvAxis != null) {
                    this.dvAxisMap.remove(dv);
                    dvAxis.removeDataView(dv);
                }
                this.itemMap.remove(currItem);
                this.repaint();
            }
        }
    }

    public void hideItem(int itemIndex) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        JLDataView data = this.getDataViewForItem(itemIndex);
        if (data == null) {
            return;
        }
        JLAxis itemAxis = data.getAxis();
        if (itemAxis != this.getY1Axis() && itemAxis != this.getY2Axis()) {
            return;
        }
        itemAxis.removeDataView(data);
    }

    public void showItem(int itemIndex) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        JLDataView data = this.getDataViewForItem(itemIndex);
        if (data == null) {
            return;
        }
        JLAxis itemAxis = data.getAxis();
        if (itemAxis == this.getY1Axis() || itemAxis == this.getY2Axis()) {
            return;
        }
        if (!this.dvAxisMap.containsKey(data)) {
            return;
        }
        Integer itemAxisNumber = this.dvAxisMap.get(data);
        if (itemAxisNumber == null) {
            return;
        }
        if (itemAxisNumber == 1) {
            this.getY1Axis().addDataView(data);
        } else if (itemAxisNumber == 2) {
            this.getY2Axis().addDataView(data);
        }
    }

    public void changeItemAxis(int itemIndex, int newAxis) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        if (newAxis != 1 && newAxis != 2 && newAxis != 0) {
            return;
        }
        if (newAxis == 0) {
            this.hideItem(itemIndex);
            return;
        }
        JLDataView data = this.getDataViewForItem(itemIndex);
        if (data == null) {
            return;
        }
        int oldAxis = data.getAxis() == this.getY1Axis() ? 1 : (data.getAxis() == this.getY2Axis() ? 2 : 0);
        if (oldAxis == 0) {
            this.showItem(itemIndex);
            return;
        }
        if (oldAxis == newAxis) {
            return;
        }
        if (oldAxis == 1) {
            this.getY1Axis().removeDataView(data);
        } else {
            this.getY2Axis().removeDataView(data);
        }
        if (newAxis == 1) {
            this.getY1Axis().addDataView(data);
        } else {
            this.getY2Axis().addDataView(data);
        }
        if (this.dvAxisMap.containsKey(data)) {
            this.dvAxisMap.remove(data);
        }
        this.dvAxisMap.put(data, new Integer(newAxis));
    }

    private void plotAllItems(NumberSpectrumEvent e) {
        int spectrumSize = ((INumberSpectrum)e.getSource()).getXDimension();
        for (int i = 0; i < e.getValue().length && i < spectrumSize; ++i) {
            JLDataView data;
            if (i < this.allItems.size()) {
                data = this.allItems.get(i);
                if (this.qualityFactor == null) {
                    data.add(e.getTimeStamp(), Double.NaN);
                } else if (this.qualityFactor.equals("INVALID")) {
                    data.add(e.getTimeStamp(), Double.NaN);
                } else {
                    data.add(e.getTimeStamp(), e.getValue()[i]);
                }
                this.garbageData(data);
            } else {
                data = new JLDataView();
                if (this.qualityFactor == null) {
                    data.add(e.getTimeStamp(), Double.NaN);
                } else if (this.qualityFactor.equals("INVALID")) {
                    data.add(e.getTimeStamp(), Double.NaN);
                } else {
                    data.add(e.getTimeStamp(), e.getValue()[i]);
                }
                Color drawColor = defaultColor[i % defaultColor.length];
                data.setViewType(0);
                data.setStyle(0);
                data.setColor(drawColor);
                data.setMarkerColor(drawColor);
                data.setName(Integer.toString(i));
                data.setUnit(((INumberSpectrum)e.getSource()).getUnit());
                this.getY1Axis().addDataView(data);
                this.allItems.add(data);
            }
            data = null;
        }
    }

    @Override
    public void spectrumChange(NumberSpectrumEvent evt) {
        JLDataView data = null;
        double[] spectValue = evt.getValue();
        if (!this.plotting) {
            return;
        }
        if (this.plotAll) {
            this.plotAllItems(evt);
        } else {
            Set<Integer> itemSet = this.itemMap.keySet();
            if (itemSet == null) {
                return;
            }
            for (Integer currItem : itemSet) {
                data = this.itemMap.get(currItem);
                int currItemIndex = currItem;
                try {
                    double currItemValue = spectValue[currItemIndex];
                    data.add(evt.getTimeStamp(), currItemValue);
                }
                catch (Exception iobEx) {
                    data.add(evt.getTimeStamp(), Double.NaN);
                }
                this.garbageData(data);
            }
        }
        this.repaint();
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
        Set<Integer> itemSet;
        this.qualityFactor = e.getState();
        if (this.qualityFactor.equals("INVALID") && (itemSet = this.itemMap.keySet()) != null) {
            for (Integer currItem : itemSet) {
                JLDataView data = this.itemMap.get(currItem);
                data.add(e.getTimeStamp(), Double.NaN);
                this.garbageData(data);
            }
        }
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        if (!this.plotting) {
            return;
        }
        if (this.plotAll) {
            this.plotAllError(evt);
        } else {
            Set<Integer> itemSet = this.itemMap.keySet();
            if (itemSet != null) {
                for (Integer currItem : itemSet) {
                    JLDataView data = this.itemMap.get(currItem);
                    data.add(evt.getTimeStamp(), Double.NaN);
                    this.garbageData(data);
                }
            }
        }
        this.repaint();
    }

    private void plotAllError(ErrorEvent evt) {
        for (int i = 0; i < this.allItems.size(); ++i) {
            JLDataView data = this.allItems.get(i);
            data.add(evt.getTimeStamp(), Double.NaN);
            this.garbageData(data);
        }
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        NumberSpectrumItemTrend nsit = new NumberSpectrumItemTrend();
        String attributeName = args.length > 0 ? args[0] : "fp/test/1/wave";
        try {
            INumberSpectrum ins = (INumberSpectrum)attList.add(attributeName);
            nsit.getXAxis().setGridVisible(true);
            nsit.getY1Axis().setGridVisible(true);
            nsit.getY1Axis().setAutoScale(false);
            nsit.getY2Axis().setAutoScale(false);
            nsit.getY1Axis().setMinimum(0.0);
            nsit.getY1Axis().setMaximum(10.0);
            nsit.getY2Axis().setMinimum(0.0);
            nsit.getY2Axis().setMaximum(100.0);
            nsit.setPlotAll(false);
            nsit.setModel(ins);
            nsit.plotItem(30, 1, "wave[30]");
            nsit.plotItem(1, 1, "wave[1]");
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.getContentPane().add(nsit);
        attList.startRefresher();
        mainFrame.setSize(800, 600);
        mainFrame.pack();
        mainFrame.setVisible(true);
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nsit.hideItem(7);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nsit.showItem(7);
        }
    }
}

