/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class NumberScalarTextEditor
extends JTextField
implements INumberScalarListener,
PropertyChangeListener {
    String format = "";
    private INumberScalar model = null;
    private String lastSet = null;

    public NumberScalarTextEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberScalarTextEditor.this.textInsertActionPerformed(evt);
            }
        });
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        this.model.removeNumberScalarListener(this);
        this.model = null;
    }

    public void setModel(INumberScalar ins) {
        this.clearModel();
        if (ins == null) {
            return;
        }
        if (!ins.isWritable()) {
            throw new IllegalArgumentException("NumberScalarTextEditor: Only accept writeable attribute.");
        }
        this.model = ins;
        this.format = this.model.getProperty("format").getPresentation();
        this.model.addNumberScalarListener(this);
        this.model.getProperty("format").addPresentationListener(this);
        this.model.refresh();
    }

    public INumberScalar getModel() {
        return this.model;
    }

    private String getDisplayString(double value) {
        String dispStr;
        Double attDouble = new Double(value);
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            dispStr = Double.toString(value);
        } else {
            try {
                dispStr = this.format.indexOf(37) == -1 ? String.format("%.2f", value) : ATKFormat.format(this.format, attDouble);
            }
            catch (Exception e) {
                dispStr = String.format("%.2f", value);
            }
        }
        return dispStr;
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        double set = Double.NaN;
        set = this.hasFocus() ? this.model.getNumberScalarSetPointFromDevice() : this.model.getNumberScalarSetPoint();
        String strValue = this.getDisplayString(set);
        if (this.lastSet == null) {
            this.setText(strValue);
            this.lastSet = strValue;
        } else if (!this.lastSet.equals(strValue)) {
            this.setText(strValue);
            this.lastSet = strValue;
        }
    }

    @Override
    public void errorChange(ErrorEvent e) {
        this.setText("Read Error");
        this.lastSet = "Read Error";
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null) {
            if (src.getName().equalsIgnoreCase("format")) {
                this.format = src.getValue().toString();
            }
            this.model.refresh();
        }
    }

    private void textInsertActionPerformed(ActionEvent evt) {
        if (this.model == null) {
            return;
        }
        String valStr = this.getText();
        try {
            double value = Double.parseDouble(valStr);
            this.model.setValue(value);
        }
        catch (NumberFormatException nfe) {
            this.lastSet = null;
            this.model.refresh();
        }
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        NumberScalarTextEditor nste = new NumberScalarTextEditor();
        try {
            INumberScalar att = (INumberScalar)attList.add("id-carr/TD13/GAP/Position");
            nste.setModel(att);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.getContentPane().add(nste);
        mainFrame.pack();
        mainFrame.setVisible(true);
        attList.startRefresher();
    }
}

