/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NumberScalarStateViewer
extends JLabel
implements INumberScalarListener {
    private INumberScalar model = null;

    public NumberScalarStateViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.setFont(new Font("Dialog", 0, 12));
        this.setPreferredSize(new Dimension(20, 20));
        this.setMinimumSize(new Dimension(20, 20));
        this.setOpaque(true);
    }

    public static String getStringState(int numberState) {
        switch (numberState) {
            case 0: {
                return "ON";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "INSERT";
            }
            case 5: {
                return "EXTRACT";
            }
            case 6: {
                return "MOVING";
            }
            case 7: {
                return "STANDBY";
            }
            case 8: {
                return "FAULT";
            }
            case 9: {
                return "INIT";
            }
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "ALARM";
            }
            case 12: {
                return "DISABLE";
            }
        }
        return "UNKNOWN";
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public void setModel(INumberScalar ins) {
        if (this.model != null) {
            this.clearModel();
        }
        this.model = ins;
        if (this.model != null) {
            this.model.addNumberScalarListener(this);
            this.setToolTipText(this.model.getName());
        }
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeNumberScalarListener(this);
            this.model = null;
        }
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        int newStateValue = (int)evt.getValue();
        String newStateString = NumberScalarStateViewer.getStringState(newStateValue);
        this.setBackground(ATKConstant.getColor4State(newStateString));
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        NumberScalarStateViewer nssv = new NumberScalarStateViewer();
        try {
            INumberScalar att = (INumberScalar)attList.add("id14/cryospy/eh3/IcingStatus");
            nssv.setModel(att);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        attList.startRefresher();
        JFrame mainFrame = new JFrame();
        mainFrame.getContentPane().add(nssv);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

