/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class NumberScalarSpinner
extends JSpinner
implements Serializable,
INumberScalarListener,
ActionListener,
MouseListener,
KeyListener {
    private boolean displayReadValue = true;
    private boolean valueEditable = true;
    private double stepValue = 1.0;
    private boolean alarmEnabled = true;
    private SpinnerNumberModel numberSpinnerModel = null;
    private INumberScalar numberModel = null;
    public static final String ACTION_ARROW = "ARROW";
    public static final String ACTION_CHANGE_VALUE = "VALUE";

    public NumberScalarSpinner() {
        Double value = new Double(0.0);
        Double min = new Double(-1.7976931348623157E308);
        Double max = new Double(Double.MAX_VALUE);
        Double step = new Double(this.stepValue);
        this.numberSpinnerModel = new SpinnerNumberModel(value, min, max, step);
        this.setModel(this.numberSpinnerModel);
        this.getComponent(0).setName(ACTION_ARROW);
        this.getComponent(0).addMouseListener(this);
        this.getComponent(1).setName(ACTION_ARROW);
        this.getComponent(1).addMouseListener(this);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().addMouseListener(this);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setName(ACTION_CHANGE_VALUE);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().addActionListener(this);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().addKeyListener(this);
    }

    public boolean getDisplayReadValue() {
        return this.displayReadValue;
    }

    public void setDisplayReadValue(boolean isDisplayReadValue) {
        if (this.numberModel != null && !this.numberModel.isWritable()) {
            isDisplayReadValue = true;
            return;
        }
        this.displayReadValue = isDisplayReadValue;
    }

    public boolean getAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean b) {
        this.alarmEnabled = b;
    }

    public boolean getValueEditable() {
        return this.valueEditable;
    }

    public void setValueEditable(boolean editable) {
        this.valueEditable = editable;
        if (!this.numberModel.isWritable()) {
            ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(false);
        } else {
            ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(editable);
        }
    }

    public double getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(double step) {
        this.stepValue = step;
        this.numberSpinnerModel.setStepSize(new Double(step));
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void setNumberModel(INumberScalar scalar) {
        this.clearModel();
        if (scalar != null) {
            this.numberModel = scalar;
            if (!scalar.isWritable()) {
                ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(false);
            } else {
                ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(this.valueEditable);
            }
            this.numberModel.addNumberScalarListener(this);
        }
    }

    public void clearModel() {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener(this);
            this.numberModel = null;
        }
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
        if (!this.alarmEnabled) {
            return;
        }
        String state = evt.getState();
        this.setBackground(ATKConstant.getColor4Quality(state));
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        if (!this.alarmEnabled) {
            return;
        }
        this.setValue(new Double(0.0));
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    @Override
    public void setBackground(Color arg0) {
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setBackground(arg0);
    }

    @Override
    public Color getBackground() {
        return ((JSpinner.NumberEditor)this.getEditor()).getTextField().getBackground();
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        try {
            Double doubleValue = this.displayReadValue || !this.numberModel.isWritable() ? new Double(evt.getValue()) : new Double(evt.getNumberSource().getNumberScalarSetPoint());
            this.setValue(doubleValue);
        }
        catch (Exception e) {
            this.setValue(new Double(0.0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getComponent().getName().equals(ACTION_ARROW)) {
            this.arrowActionPerformed();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (((Component)e.getSource()).getName().equals(ACTION_CHANGE_VALUE)) {
            this.valueChangePerformed();
        }
    }

    public void arrowActionPerformed() {
        if (this.numberModel == null) {
            return;
        }
        if (!this.numberModel.isWritable()) {
            try {
                Double doubleValue = new Double(this.numberModel.getNumberScalarValue());
                this.setValue(doubleValue);
            }
            catch (Exception doubleValue) {
                // empty catch block
            }
            return;
        }
        double value = (Double)this.getValue();
        if (((JSpinner.NumberEditor)this.getEditor()).getTextField().hasFocus()) {
            this.numberModel.setValue(value);
        }
    }

    public void valueChangePerformed() {
        if (this.numberModel == null) {
            return;
        }
        if (!this.numberModel.isWritable()) {
            try {
                Double doubleValue = new Double(this.numberModel.getNumberScalarValue());
                this.setValue(doubleValue);
            }
            catch (Exception doubleValue) {
                // empty catch block
            }
            return;
        }
        double value = (Double)this.getValue();
        if (((JSpinner.NumberEditor)this.getEditor()).getTextField().hasFocus()) {
            this.numberModel.setValue(value);
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 38 || arg0.getKeyCode() == 40) {
            this.arrowActionPerformed();
        }
    }

    public static void main(String[] args) {
        try {
            AttributePolledList attributeList = new AttributePolledList();
            INumberScalar attribute = args.length != 0 ? (INumberScalar)attributeList.add(args[0].trim()) : (INumberScalar)attributeList.add("LT1/AE/CH.1/current".toLowerCase());
            attributeList.startRefresher();
            NumberScalarSpinner spinner = new NumberScalarSpinner();
            spinner.setNumberModel(attribute);
            spinner.setAlarmEnabled(true);
            spinner.setStepValue(2.0);
            JFrame f = new JFrame("NumberScalarSpinner");
            f.getContentPane().add(spinner);
            f.setSize(300, 50);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

