/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NumberScalarComboEditor
extends JComboBox
implements ActionListener,
INumberScalarListener,
JDrawable {
    static String[] exts = new String[]{"valueList"};
    private String jdrawExts = "";
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private String modelFormat = "";
    private String modelUnit = "";
    private String[] defOptionList = new String[]{"0.0"};
    private String[] optionList = new String[]{"0.0"};
    private INumberScalar numberModel = null;
    private boolean unitVisible = true;

    public NumberScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void setNumberModel(INumberScalar m) {
        double[] valList = null;
        int valListSize = 0;
        String[] newOptions = null;
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener(this);
            this.numberModel = null;
            this.modelFormat = "";
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        if (m == null) {
            return;
        }
        if (!m.isWritable()) {
            throw new IllegalArgumentException("NumberScalarComboEditor: Only accept writeable attribute.");
        }
        this.numberModel = m;
        this.modelFormat = this.numberModel.getProperty("format").getPresentation();
        this.modelUnit = this.numberModel.getProperty("unit").getPresentation();
        String invalidOpt = ATKFormat.format(this.modelFormat, 0.0);
        invalidOpt = invalidOpt.replace('0', '?');
        valList = this.numberModel.getPossibleValues();
        newOptions = null;
        if (valList != null && (valListSize = valList.length) > 0) {
            newOptions = new String[valListSize + 1];
            int index = 0;
            newOptions[0] = new String(invalidOpt + " ");
            for (index = 0; index < valListSize; ++index) {
                String strOpt = this.modelFormat.indexOf(37) == -1 ? AttrManip.format((String)this.modelFormat, (double)valList[index]) : ATKFormat.format(this.modelFormat, valList[index]);
                newOptions[index + 1] = this.unitVisible ? new String(strOpt + " " + this.numberModel.getUnit()) : new String(strOpt + " ");
            }
        }
        if (newOptions == null) {
            newOptions = new String[]{new String(invalidOpt + " ")};
        }
        if (newOptions != null) {
            this.optionList = newOptions;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        this.numberModel.addNumberScalarListener(this);
        this.numberModel.refresh();
    }

    public void setUnitVisible(boolean b) {
        if (this.unitVisible != b) {
            this.changeUnitVisibility(b);
        }
        this.unitVisible = b;
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    private void changeUnitVisibility(boolean newUnitVisible) {
        double[] valList = null;
        int valListSize = 0;
        String[] newOptions = null;
        if (this.numberModel == null) {
            return;
        }
        String invalidOpt = ATKFormat.format(this.modelFormat, 0.0);
        invalidOpt = invalidOpt.replace('0', '?');
        valList = this.numberModel.getPossibleValues();
        newOptions = null;
        if (valList != null && (valListSize = valList.length) > 0) {
            newOptions = new String[valListSize + 1];
            int index = 0;
            newOptions[0] = new String(invalidOpt + " ");
            for (index = 0; index < valListSize; ++index) {
                String strOpt = this.modelFormat.indexOf(37) == -1 ? AttrManip.format((String)this.modelFormat, (double)valList[index]) : ATKFormat.format(this.modelFormat, valList[index]);
                newOptions[index + 1] = newUnitVisible ? new String(strOpt + " " + this.numberModel.getUnit()) : new String(strOpt + " ");
            }
        }
        if (newOptions == null) {
            newOptions = new String[]{new String(invalidOpt + " ")};
        }
        if (newOptions != null) {
            this.optionList = newOptions;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        double set = Double.NaN;
        set = this.hasFocus() ? this.numberModel.getNumberScalarSetPointFromDevice() : this.numberModel.getNumberScalarSetPoint();
        this.changeSelectedOption(set);
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent e) {
        this.changeSelectedOption(Double.NaN);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = null;
        String cmdOption = null;
        double setValue = 0.0;
        int idx = 0;
        String optValueStr = null;
        cb = (JComboBox)e.getSource();
        cmdOption = (String)cb.getSelectedItem();
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (cmdOption == null) {
            return;
        }
        if (this.numberModel == null) {
            return;
        }
        idx = cmdOption.indexOf(" " + this.numberModel.getUnit());
        optValueStr = idx > 0 ? cmdOption.substring(0, idx) : cmdOption;
        setValue = Double.NaN;
        setValue = this.parseSelectedValue(optValueStr);
        if (!Double.isNaN(setValue)) {
            this.numberModel.setValue(setValue);
        }
    }

    private double parseSelectedValue(String doubleStr) {
        double val = Double.NaN;
        try {
            val = Double.parseDouble(doubleStr);
        }
        catch (NumberFormatException nfe) {
            val = Double.NaN;
        }
        return val;
    }

    private void changeSelectedOption(double val) {
        int index;
        double[] valList = null;
        int valListSize = 0;
        if (this.numberModel == null) {
            return;
        }
        int currentSelection = this.getSelectedIndex();
        if (Double.isNaN(val)) {
            if (currentSelection != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
        valList = this.numberModel.getPossibleValues();
        if (valList == null) {
            if (currentSelection != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
        valListSize = valList.length;
        if (valListSize <= 0) {
            if (currentSelection != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
        for (index = 0; index < valListSize; ++index) {
            if (valList[index] != val) continue;
            if (currentSelection != index + 1) {
                this.changeCurrentSelection(index + 1);
            }
            return;
        }
        if (index >= valListSize) {
            if (currentSelection != 0) {
                this.changeCurrentSelection(0);
            }
            return;
        }
    }

    private void changeCurrentSelection(int newIndex) {
        this.disableExecution();
        this.setSelectedIndex(newIndex);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equalsIgnoreCase("valueList")) {
            return "The list of values to be proposed in the ComboBox.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("valueList")) {
            this.jdrawExts = "";
            String[] c = value.split(",");
            if (c.length == 0) {
                return true;
            }
            if (c.length < 0) {
                this.showJdrawError(popupErr, "valueList", "Float value list expected: val,val,val");
                return false;
            }
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == null) {
                    this.showJdrawError(popupErr, "valueList", "Float value list expected: val,val,val; No empty value.");
                    return false;
                }
                try {
                    double d = Double.parseDouble(c[i]);
                    continue;
                }
                catch (Exception ex) {
                    this.showJdrawError(popupErr, "valueList", "Float value list expected: val,val,val; All number values.");
                    return false;
                }
            }
            this.jdrawExts = value;
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("valueList")) {
            return this.jdrawExts;
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "NumberScalarComboEditor: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public static void main(String[] args) {
        final AttributeList attList = new AttributeList();
        NumberScalarComboEditor nsce = new NumberScalarComboEditor();
        double[] vals = new double[]{0.1, 0.3, 1.0, 3.0, 10.0, 30.0, 100.0, 300.0};
        JFrame mainFrame = null;
        try {
            IEntity ie = attList.add("sr/d-tm/ntm/BandWidth");
            INumberScalar bw = ie instanceof INumberScalar ? (INumberScalar)ie : null;
            if (bw == null) {
                System.exit(-1);
            }
            bw.setPossibleValues(vals);
            nsce.setNumberModel(bw);
        }
        catch (Exception e) {
            System.out.println("caught exception : " + e.getMessage());
            System.exit(-1);
        }
        mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                attList.startRefresher();
            }
        });
        mainFrame.setContentPane(nsce);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

