/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class NumberImageViewer
extends JPanel
implements IImageListener,
MouseMotionListener,
MouseListener,
ActionListener,
KeyListener,
JDrawable {
    public static final int PROFILE_NONE = 0;
    public static final int PROFILE_FREELINE = 1;
    public static final int PROFILE_HISTO = 2;
    public static final int PROFILE_DUAL = 3;
    public static final int PROFILE_HLINE = 4;
    public static final int PROFILE_VLINE = 5;
    INumberImage model;
    protected double[][] doubleValues = null;
    private Rectangle oldSelection = null;
    protected int hMarker = -1;
    protected int vMarker = -1;
    protected int profileMode;
    private boolean showingMenu;
    private boolean snapToGrid;
    private boolean sigHistogram;
    private boolean rectXYmode;
    private boolean isNegative;
    private int integrationWidthH;
    private int integrationWidthV;
    protected int startHisto;
    private Gradient gColor;
    private int[] gColormap;
    private int iSz;
    private EventListenerList listenerList;
    protected Insets noMargin = new Insets(0, 0, 0, 0);
    private boolean autoZoom = false;
    private boolean firstRefresh = false;
    private boolean userZoom = false;
    private int verticalExtent = 1;
    private String lastConfig = "";
    private boolean isBestFit;
    private boolean autoBestFit;
    private double bfMin = 0.0;
    private double bfMax = 65536.0;
    private double autoBfMin;
    private double autoBfMax;
    private double bfa0;
    private double bfa1;
    private double curSelMin;
    private double curSelMax;
    protected JImage imagePanel;
    protected JScrollPane imageView;
    protected JPanel buttonPanel;
    protected JButton selectButton;
    protected JButton selectMaxButton;
    protected JButton selectColorButton;
    protected JButton fileButton;
    protected JButton zoomButton;
    protected JButton tableButton;
    protected JButton profileButton;
    protected JButton profileHButton;
    protected JButton profileVButton;
    protected JButton histoButton;
    protected JButton settingsButton;
    protected JButton axisButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton printButton;
    protected JScrollPane buttonView;
    private Font panelFont;
    private JPanel cfgPanel;
    private JLabel statusLabel;
    private JLabel rangeLabel;
    private JLabel avgLabel;
    private JLabel selLabel;
    protected JTextField selText;
    protected JPopupMenu imgMenu;
    protected JMenuItem infoMenuItem;
    protected JCheckBoxMenuItem bestFitMenuItem;
    protected JCheckBoxMenuItem snapToGridMenuItem;
    protected JCheckBoxMenuItem negativeMenuItem;
    protected JCheckBoxMenuItem toolbarMenuItem;
    protected JCheckBoxMenuItem statusLineMenuItem;
    protected JCheckBoxMenuItem showGradMenuItem;
    protected JMenuItem selectionMenuItem;
    protected JMenuItem selectionMaxMenuItem;
    protected JMenuItem selectionColorMenuItem;
    protected JMenuItem fileMenuItem;
    protected JMenuItem zoomMenuItem;
    protected JMenuItem tableMenuItem;
    protected JMenuItem lineProfileMenuItem;
    protected JMenuItem lineHProfileMenuItem;
    protected JMenuItem lineVProfileMenuItem;
    protected JMenuItem lineProfile2MenuItem;
    protected JMenuItem histogramMenuItem;
    protected JMenuItem settingsMenuItem;
    protected JMenuItem loadMenuItem;
    protected JMenuItem saveMenuItem;
    protected JMenuItem saveDataFileMenuItem;
    protected JMenuItem printMenuItem;
    protected JCheckBoxMenuItem displayLogMenuItem;
    private JGradientViewer gradientTool;
    protected LineProfilerViewer lineProfiler = null;
    private JFrame zoomDialog = null;
    private JPanel zoomPanel;
    private JScrollPane zoomView;
    private JImage zoomImage;
    private JPanel zoomCfgPanel;
    private JComboBox zoomCombo;
    private int zoomFactor;
    private int zoomXOrg;
    private int zoomYOrg;
    private JLabel zoomText;
    private JDialog settingsDialog = null;
    private JPanel settingsPanel;
    private LabelViewer attNameLabel;
    private JButton propButton;
    private JCheckBox sigHistogramCheck;
    private JCheckBox rectDisplayCheck;
    private JCheckBox bestFitCheck;
    private JCheckBox autoBestFitCheck;
    private JLabel minBestFitLabel;
    private JTextField minBestFitText;
    private JLabel maxBestFitLabel;
    private JTextField maxBestFitText;
    private JLabel integrationWidthHLabel;
    private JTextField integrationWidthHText;
    private JLabel integrationWidthVLabel;
    private JTextField integrationWidthVText;
    private JCheckBox snapToGridCheck;
    private JLabel snapToGridLabel;
    private JTextField snapToGridText;
    private JCheckBox negativeCheck;
    private JComboBox imageSizeCombo;
    private JLabel imageSizeLabel;
    private JGradientEditor gradViewer;
    private JButton gradButton;
    private JLabel gradLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JDialog axisDialog = null;
    private JTabbedPane tabPane;
    private AxisPanel xAxisPanel;
    private AxisPanel yAxisPanel;
    private JButton axisCloseButton;
    private JFrame tableDialog = null;
    private JTableRow tablePanel;
    SimplePropertyFrame propDialog = null;
    static String[] exts = new String[]{"toolBarVisible", "statusLineVisible", "gradientVisible", "bestFit", "zoom", "xAxis", "yAxis"};
    protected String lastSnapshotLocation = ".";
    protected FileFilter lastFileFilter = null;
    protected boolean logValues = false;
    private int rgbNaN = 0;
    private Color colorNaN = null;

    public NumberImageViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.initImagePanel();
        this.initButtonPanel();
        this.initGradient();
        this.initStatusLine();
        this.initPopupMenu();
        this.isBestFit = true;
        this.rectXYmode = false;
        this.integrationWidthH = 1;
        this.integrationWidthV = 1;
        this.setAlignToGrid(false);
        this.autoBestFit = true;
        this.sigHistogram = false;
        this.isNegative = false;
        this.showingMenu = true;
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        this.startHisto = 0;
        this.zoomFactor = 0;
        this.iSz = 1;
        this.profileMode = 0;
        this.listenerList = new EventListenerList();
    }

    protected void initImagePanel() {
        this.imagePanel = new JImage();
        this.imagePanel.setBorder(null);
        this.imagePanel.setSnapGrid(8);
        this.imageView = new JScrollPane(this.imagePanel);
        this.add((Component)this.imageView, "Center");
        this.imagePanel.addMouseMotionListener(this);
        this.imagePanel.addMouseListener(this);
        this.imagePanel.addKeyListener(this);
    }

    protected void initButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setMinimumSize(new Dimension(60, 615));
        this.buttonPanel.setPreferredSize(new Dimension(60, 615));
        this.buttonView = new JScrollPane(this.buttonPanel);
        this.buttonView.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.buttonView, "West");
        this.selectButton = new JButton();
        this.selectButton.setMargin(this.noMargin);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        this.buttonPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(this.noMargin);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 40, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        this.buttonPanel.add(this.selectMaxButton);
        this.selectColorButton = new JButton();
        this.selectColorButton.setMargin(this.noMargin);
        this.selectColorButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select_color.gif")));
        this.selectColorButton.setBounds(2, 75, 36, 36);
        this.selectColorButton.setToolTipText("Selection Color...");
        this.selectColorButton.addActionListener(this);
        this.buttonPanel.add(this.selectColorButton);
        this.fileButton = new JButton();
        this.fileButton.setMargin(this.noMargin);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 115, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        this.buttonPanel.add(this.fileButton);
        this.zoomButton = new JButton();
        this.zoomButton.setMargin(this.noMargin);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_zoom.gif")));
        this.zoomButton.setBounds(2, 155, 36, 36);
        this.zoomButton.setToolTipText("Zoom selection");
        this.zoomButton.addActionListener(this);
        this.buttonPanel.add(this.zoomButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(this.noMargin);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 195, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        this.buttonPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(this.noMargin);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 240, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        this.buttonPanel.add(this.profileButton);
        this.profileHButton = new JButton();
        this.profileHButton.setMargin(this.noMargin);
        this.profileHButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile2.gif")));
        this.profileHButton.setBounds(2, 280, 36, 36);
        this.profileHButton.setToolTipText("Horizontal profile");
        this.profileHButton.addActionListener(this);
        this.buttonPanel.add(this.profileHButton);
        this.profileVButton = new JButton();
        this.profileVButton.setMargin(this.noMargin);
        this.profileVButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile3.gif")));
        this.profileVButton.setBounds(2, 320, 36, 36);
        this.profileVButton.setToolTipText("Vertical profile");
        this.profileVButton.addActionListener(this);
        this.buttonPanel.add(this.profileVButton);
        this.histoButton = new JButton();
        this.histoButton.setMargin(this.noMargin);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 360, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        this.buttonPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(this.noMargin);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 405, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        this.buttonPanel.add(this.settingsButton);
        this.axisButton = new JButton();
        this.axisButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_axis.gif")));
        this.axisButton.setMargin(this.noMargin);
        this.axisButton.setBounds(2, 445, 36, 36);
        this.axisButton.setToolTipText("Axis settings");
        this.axisButton.addActionListener(this);
        this.buttonPanel.add(this.axisButton);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_load_settings.gif")));
        this.loadButton.setToolTipText("Load settings");
        this.loadButton.setMargin(this.noMargin);
        this.loadButton.setBounds(2, 490, 36, 36);
        this.loadButton.addActionListener(this);
        this.buttonPanel.add(this.loadButton);
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_save_settings.gif")));
        this.saveButton.setToolTipText("Save settings");
        this.saveButton.setMargin(this.noMargin);
        this.saveButton.setBounds(2, 530, 36, 36);
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_print.gif")));
        this.printButton.setToolTipText("Print Image");
        this.printButton.setMargin(this.noMargin);
        this.printButton.setBounds(2, 575, 36, 36);
        this.printButton.addActionListener(this);
        this.buttonPanel.add(this.printButton);
    }

    protected void initGradient() {
        this.gradientTool = new JGradientViewer();
        this.gradientTool.getAxis().setMinimum(0.0);
        this.gradientTool.getAxis().setMaximum(65536.0);
        this.add((Component)this.gradientTool, "East");
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
    }

    protected void initStatusLine() {
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 50));
        this.add((Component)this.cfgPanel, "South");
        this.panelFont = new Font("Dialog", 0, 11);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 3, 290, 20);
        this.cfgPanel.add(this.statusLabel);
        this.rangeLabel = new JLabel("");
        this.rangeLabel.setFont(this.panelFont);
        this.rangeLabel.setBounds(305, 3, 300, 20);
        this.cfgPanel.add(this.rangeLabel);
        this.avgLabel = new JLabel("");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setBounds(305, 25, 300, 20);
        this.cfgPanel.add(this.avgLabel);
        this.selLabel = new JLabel("Selection");
        this.selLabel.setFont(this.panelFont);
        this.selLabel.setBounds(5, 25, 55, 20);
        this.cfgPanel.add(this.selLabel);
        this.selText = new JTextField("None");
        this.selText.setMargin(this.noMargin);
        this.selText.setFont(this.panelFont);
        this.selText.setBounds(65, 25, 230, 20);
        this.selText.addKeyListener(this);
        this.cfgPanel.add(this.selText);
    }

    protected void initPopupMenu() {
        this.imgMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Image Viewer");
        this.infoMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.snapToGridMenuItem = new JCheckBoxMenuItem("Align to grid");
        this.snapToGridMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.showGradMenuItem = new JCheckBoxMenuItem("Show gradient");
        this.showGradMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.selectionColorMenuItem = new JMenuItem("Selection Color...");
        this.selectionColorMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.lineHProfileMenuItem = new JMenuItem("Horizontal Line profile");
        this.lineHProfileMenuItem.addActionListener(this);
        this.lineVProfileMenuItem = new JMenuItem("Vertical line profile");
        this.lineVProfileMenuItem.addActionListener(this);
        this.lineProfile2MenuItem = new JMenuItem("Dual profiles");
        this.lineProfile2MenuItem.addActionListener(this);
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.saveDataFileMenuItem = new JMenuItem("Save selection in data file");
        this.saveDataFileMenuItem.addActionListener(this);
        this.zoomMenuItem = new JMenuItem("Zoom selection");
        this.zoomMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.loadMenuItem = new JMenuItem("Load settings");
        this.loadMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem("Save settings");
        this.saveMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print image");
        this.printMenuItem.addActionListener(this);
        this.displayLogMenuItem = new JCheckBoxMenuItem("Display log values");
        this.displayLogMenuItem.addActionListener(this);
        this.imgMenu.add(this.infoMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.snapToGridMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(this.showGradMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.selectionColorMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.saveDataFileMenuItem);
        this.imgMenu.add(this.zoomMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.lineHProfileMenuItem);
        this.imgMenu.add(this.lineVProfileMenuItem);
        this.imgMenu.add(this.lineProfile2MenuItem);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.loadMenuItem);
        this.imgMenu.add(this.saveMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.printMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.displayLogMenuItem);
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equalsIgnoreCase("toolBarVisible")) {
            return "Displays the left toolbar.";
        }
        if (name.equalsIgnoreCase("statusLineVisible")) {
            return "Displays the bottom status line.";
        }
        if (name.equalsIgnoreCase("gradientVisible")) {
            return "Displays the right gradient scale";
        }
        if (name.equalsIgnoreCase("bestFit")) {
            return "Displays the image using the whole color range";
        }
        if (name.equalsIgnoreCase("zoom")) {
            return "zoom factor: 0=800%, 1=400%, 2=200%, 3=100%, 4=50%, 5=25%, 6=12.5%";
        }
        if (name.equalsIgnoreCase("xAxis")) {
            return JLAxis.getHelpString();
        }
        if (name.equalsIgnoreCase("yAxis")) {
            return JLAxis.getHelpString();
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        CfFileReader f;
        if (name.equalsIgnoreCase("toolBarVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setToolbarVisible(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setToolbarVisible(false);
                return true;
            }
            this.showJdrawError(popupErr, "toolBarVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("statusLineVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setStatusLineVisible(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setStatusLineVisible(false);
                return true;
            }
            this.showJdrawError(popupErr, "statusLineVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("gradientVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setGradientVisible(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setGradientVisible(false);
                return true;
            }
            this.showJdrawError(popupErr, "gradientVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("bestFit")) {
            if (value.equalsIgnoreCase("true")) {
                this.setBestFit(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setBestFit(false);
                return true;
            }
            this.showJdrawError(popupErr, "bestFit", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("zoom")) {
            int sz = 0;
            try {
                sz = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "zoom", "Wrong number syntax.");
                return false;
            }
            if (sz >= 0 && sz <= 6) {
                this.setZoom(sz);
                return false;
            }
            this.showJdrawError(popupErr, "zoom", "Invalid value: 0 to 6 allowed.");
            return false;
        }
        if (name.equalsIgnoreCase("xAxis")) {
            CfFileReader f2;
            if (!value.endsWith("\n")) {
                value = value + "\n";
            }
            if (!(f2 = new CfFileReader()).parseText(value)) {
                this.showJdrawError(popupErr, "xAxis settings", "Failed to parse given config");
                return false;
            }
            this.getXAxis().applyConfiguration("x", f2);
            return true;
        }
        if (!name.equalsIgnoreCase("yAxis")) return false;
        if (!value.endsWith("\n")) {
            value = value + "\n";
        }
        if (!(f = new CfFileReader()).parseText(value)) {
            this.showJdrawError(popupErr, "yAxis settings", "Failed to parse given config");
            return false;
        }
        this.getYAxis().applyConfiguration("y", f);
        return true;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("toolBarVisible")) {
            return this.isToolbarVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("statusLineVisible")) {
            return this.isStatusLineVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("gradientVisible")) {
            return this.isGradientVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("bestFit")) {
            return this.isBestFit() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("zoom")) {
            return Integer.toString(this.getZoom());
        }
        if (name.equalsIgnoreCase("xAxis")) {
            return this.getXAxis().getConfiguration("x");
        }
        if (name.equalsIgnoreCase("yAxis")) {
            return this.getYAxis().getConfiguration("y");
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "NumberImageViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public void addRoiListener(IRoiListener l) {
        this.listenerList.add(IRoiListener.class, l);
    }

    public void removeRoiListener(IRoiListener l) {
        this.listenerList.remove(IRoiListener.class, l);
    }

    public void fireRoiChange() {
        IRoiListener[] list = (IRoiListener[])this.listenerList.getListeners(IRoiListener.class);
        RoiEvent w = new RoiEvent(this, this.getSelection());
        for (int i = 0; i < list.length; ++i) {
            list[i].roiChange(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean b) {
        this.isBestFit = b;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBestFit(boolean b) {
        this.autoBestFit = b;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isAutoBestFit() {
        return this.autoBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFitMinMax(double min, double max) {
        if (min < max) {
            this.bfMin = min;
            this.bfMax = max;
        }
        if (!this.autoBestFit) {
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.convertImage();
                if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                    this.buildZoom();
                }
            }
        }
    }

    public double getBestFitMin() {
        return this.bfMin;
    }

    public double getBestFitMax() {
        return this.bfMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient g) {
        this.gColor = g;
        this.gColormap = g.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.gradientTool.repaint();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean b) {
        this.isNegative = b;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setAlignToGrid(boolean b) {
        this.snapToGrid = b;
        this.imagePanel.setSnapToGrid(b);
    }

    public boolean isAlignToGrid() {
        return this.snapToGrid;
    }

    public void setToolbarVisible(boolean b) {
        this.buttonView.setVisible(b);
    }

    public boolean isToolbarVisible() {
        return this.buttonView.isVisible();
    }

    public void setStatusLineVisible(boolean b) {
        this.cfgPanel.setVisible(b);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public void setGradientVisible(boolean b) {
        this.gradientTool.setVisible(b);
    }

    public boolean isGradientVisible() {
        return this.gradientTool.isVisible();
    }

    public void setShowingMenu(boolean b) {
        this.showingMenu = b;
    }

    public void setZoom(int zoomIndex) {
        switch (zoomIndex) {
            case 0: {
                this.iSz = -8;
                break;
            }
            case 1: {
                this.iSz = -4;
                break;
            }
            case 2: {
                this.iSz = -2;
                break;
            }
            case 3: {
                this.iSz = 1;
                break;
            }
            case 4: {
                this.iSz = 2;
                break;
            }
            case 5: {
                this.iSz = 4;
                break;
            }
            case 6: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
            }
        }
        if (this.iSz < 0) {
            this.imagePanel.setMarkerScale(-this.iSz);
        } else {
            this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
        }
        this.userZoom = true;
    }

    public int getZoom() {
        int s = 0;
        switch (this.iSz) {
            case -8: {
                s = 0;
                break;
            }
            case -4: {
                s = 1;
                break;
            }
            case -2: {
                s = 2;
                break;
            }
            case 1: {
                s = 3;
                break;
            }
            case 2: {
                s = 4;
                break;
            }
            case 4: {
                s = 5;
                break;
            }
            case 8: {
                s = 6;
            }
        }
        return s;
    }

    public void setAutoZoom(boolean auto) {
        this.autoZoom = auto;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets i) {
        this.imagePanel.setMargin(i);
    }

    public Dimension getCurrentImageSize() {
        if (this.doubleValues == null) {
            return new Dimension(0, 0);
        }
        int y = this.doubleValues.length;
        if (y == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.doubleValues[0].length, y);
    }

    public void setSelectionEnabled(boolean b) {
        this.imagePanel.setSelectionEnabled(b);
    }

    public boolean isSelectionEnabled() {
        return this.imagePanel.isSelectionEnabled();
    }

    public void setCrossCursor(boolean enable) {
        this.imagePanel.setCrossCursor(enable);
    }

    public void setCrossCursorColor(Color c) {
        this.imagePanel.setCursorColor(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle r) {
        this.divRect(r);
        this.imagePanel.setSelection(r.x, r.y, r.x + r.width, r.y + r.height);
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshComponents();
        }
    }

    public void setSelectionFull() {
        Dimension d = this.imagePanel.getImageSize();
        this.imagePanel.setSelection(0, 0, d.width, d.height);
        this.selectionChanged();
    }

    public Rectangle getSelection() {
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r != null) {
            this.mulRect(r);
        }
        return r;
    }

    public Rectangle getSelectionFull() {
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null || r.width == 0 || r.height == 0) {
            Dimension size = this.imagePanel.getImageSize();
            r = new Rectangle(0, 0, size.width, size.height);
        }
        this.mulRect(r);
        return r;
    }

    public int getSelectionMode() {
        return this.imagePanel.getSelectionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionMode(int m) {
        this.imagePanel.clearSelection();
        this.imagePanel.setSelectionMode(m);
        this.freePopup();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshStatusLine();
            this.refreshSelectionMinMax();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[][] v) {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.doubleValues = v;
            this.computeVerticalExtent();
            this.computeAutoZoom();
            this.convertImage();
            this.refreshComponents();
        }
        if (this.doubleValues == null) {
            this.imagePanel.setImage(null);
            this.freePopup();
        }
        this.imagePanel.revalidate();
        this.imagePanel.repaint();
        this.imageView.revalidate();
        this.imageView.repaint();
    }

    public void loadImage(String fileName) throws IOException {
        File in = new File(fileName);
        BufferedImage img = ImageIO.read(in);
        int w = img.getWidth();
        int h = img.getHeight();
        int[] tmpArray = new int[w];
        double[][] newValues = new double[h][w];
        for (int i = 0; i < h; ++i) {
            img.getRGB(0, i, w, 1, tmpArray, 0, w);
            for (int j = 0; j < w; ++j) {
                newValues[i][j] = (tmpArray[j] & 0xFF00) >> 8;
            }
        }
        this.setData(newValues);
    }

    public int addCrossMarker(int x, int y, Color c) {
        return this.imagePanel.addCrossMarker(x, y, c);
    }

    public int addRectangleMarker(int x, int y, int width, int height, Color c) {
        return this.imagePanel.addRectangleMarker(x, y, width, height, c);
    }

    public int addVerticalLineMarker(int x, Color c) {
        return this.imagePanel.addVerticalLineMarker(x, c);
    }

    public int addHorizontalLineMarker(int y, Color c) {
        return this.imagePanel.addHorizontalLineMarker(y, c);
    }

    public void setMarkerPos(int id, int x, int y, int nWidth, int nHeight) {
        this.imagePanel.setMarkerPos(id, x, y, nWidth, nHeight);
    }

    public void clearMarkers() {
        this.imagePanel.clearMarkers();
    }

    public boolean hasMarker() {
        return this.imagePanel.getMarkerNumber() > 0;
    }

    public JLAxis getXAxis() {
        return this.imagePanel.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.imagePanel.getYAxis();
    }

    public JLAxis getGradientAxis() {
        return this.gradientTool.getAxis();
    }

    public int getImageXCoord(int x) {
        if (this.iSz < 0) {
            return (x - this.imagePanel.getXOrigin()) / -this.iSz;
        }
        return (x - this.imagePanel.getXOrigin()) * this.iSz;
    }

    public int getImageYCoord(int y) {
        if (this.iSz < 0) {
            return (y - this.imagePanel.getYOrigin()) / -this.iSz;
        }
        return (y - this.imagePanel.getYOrigin()) * this.iSz;
    }

    public void setVerticalExtent(int ratio) {
        this.verticalExtent = ratio;
    }

    protected void mulRect(Rectangle r) {
        if (this.iSz < 0) {
            r.x /= -this.iSz;
            r.y /= -this.iSz;
            r.width /= -this.iSz;
            r.height /= -this.iSz;
        } else {
            r.x *= this.iSz;
            r.y *= this.iSz;
            r.width *= this.iSz;
            r.height *= this.iSz;
        }
    }

    private void divRect(Rectangle r) {
        if (this.iSz < 0) {
            r.x *= -this.iSz;
            r.y *= -this.iSz;
            r.width *= -this.iSz;
            r.height *= -this.iSz;
        } else {
            r.x /= this.iSz;
            r.y /= this.iSz;
            r.width /= this.iSz;
            r.height /= this.iSz;
        }
    }

    protected void mulPoint(Point p) {
        boolean xOk = false;
        boolean yOk = false;
        Dimension d = this.getCurrentImageSize();
        if (this.iSz < 0) {
            p.x /= -this.iSz;
            p.y /= -this.iSz;
        } else {
            if (p.x == d.width / this.iSz - 1) {
                p.x = d.width - 1;
                xOk = true;
            }
            if (p.y == d.height / this.iSz - 1) {
                p.y = d.height - 1;
                yOk = true;
            }
            if (!xOk) {
                p.x *= this.iSz;
            }
            if (!yOk) {
                p.y *= this.iSz;
            }
        }
    }

    protected void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.zoomDialog != null) {
            this.zoomImage.setImage(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    protected double[] buildProfileData(Point p1, Point p2) {
        return this.buildProfileData(p1, p2, true);
    }

    protected double[] buildProfileData(Point p1, Point p2, boolean convertPoint) {
        double[] profile;
        Dimension d = this.getCurrentImageSize();
        if (convertPoint) {
            this.mulPoint(p1);
            this.mulPoint(p2);
        }
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        int adx = Math.abs(dx);
        int ady = Math.abs(dy);
        if (dx == 0 && dy == 0) {
            return new double[0];
        }
        if (dx == 0 && dy != 0) {
            profile = new double[ady + 1];
            int ye = p1.y;
            int xe = p1.x;
            int dxi = this.integrationWidthV / 2;
            for (int i = 0; i <= ady; ++i) {
                double sum = 0.0;
                double n = 0.0;
                for (int j = -dxi; j <= dxi; ++j) {
                    sum = xe + j >= 0 && xe + j < d.width && ye >= 0 && ye < d.height ? (sum += this.doubleValues[ye][xe + j]) : Double.NaN;
                    n += 1.0;
                }
                profile[i] = sum / n;
                if (dy < 0) {
                    --ye;
                    continue;
                }
                ++ye;
            }
        } else if (dx != 0 && dy == 0) {
            profile = new double[adx + 1];
            int xe = p1.x;
            int ye = p1.y;
            int dxi = this.integrationWidthH / 2;
            for (int i = 0; i <= adx; ++i) {
                double sum = 0.0;
                double n = 0.0;
                for (int j = -dxi; j <= dxi; ++j) {
                    sum = xe >= 0 && xe < d.width && ye + j >= 0 && ye + j < d.height ? (sum += this.doubleValues[ye + j][xe]) : Double.NaN;
                    n += 1.0;
                }
                profile[i] = sum / n;
                if (dx < 0) {
                    --xe;
                    continue;
                }
                ++xe;
            }
        } else if (adx > ady) {
            double delta = (double)dy / (double)adx;
            profile = new double[adx + 1];
            int xe = p1.x;
            for (int i = 0; i <= adx; ++i) {
                int ye = p1.y + (int)(delta * (double)i);
                profile[i] = xe >= 0 && xe < d.width && ye >= 0 && ye < d.height ? this.doubleValues[ye][xe] : Double.NaN;
                if (dx < 0) {
                    --xe;
                    continue;
                }
                ++xe;
            }
        } else {
            double delta = (double)dx / (double)ady;
            profile = new double[ady + 1];
            int ye = p1.y;
            for (int i = 0; i <= ady; ++i) {
                int xe = p1.x + (int)(delta * (double)i);
                profile[i] = xe >= 0 && xe < d.width && ye >= 0 && ye < d.height ? this.doubleValues[ye][xe] : Double.NaN;
                if (dy < 0) {
                    --ye;
                    continue;
                }
                ++ye;
            }
        }
        return profile;
    }

    protected double[] buildHistogramData() {
        if (this.doubleValues == null) {
            return null;
        }
        double[] histo = new double[65536];
        this.startHisto = 0;
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r != null) {
            int i;
            this.mulRect(r);
            for (i = 0; i < 65536; ++i) {
                histo[i] = 0.0;
            }
            try {
                for (i = r.x; i < r.x + r.width; ++i) {
                    for (int j = r.y; j < r.y + r.height; ++j) {
                        int n = (int)this.doubleValues[j][i];
                        histo[n] = histo[n] + 1.0;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
                return null;
            }
            if (!this.sigHistogram) {
                return histo;
            }
            int i1 = 0;
            int i2 = 65535;
            boolean found = false;
            while (i1 < 65536 && !found) {
                found = histo[i1] > 0.0;
                if (found) continue;
                ++i1;
            }
            found = false;
            while (i2 >= 0 && !found) {
                found = histo[i2] > 0.0;
                if (found) continue;
                --i2;
            }
            int nb = i2 - i1 + 1;
            double[] nhisto = new double[nb];
            for (i = 0; i < nb; ++i) {
                nhisto[i] = histo[i1 + i];
            }
            this.startHisto = i1;
            return nhisto;
        }
        return null;
    }

    public void setSourceFromProfile(String src, int profileId) {
        switch (this.profileMode) {
            case 1: {
                Point p1 = new Point();
                Point p2 = new Point();
                try {
                    this.parseSelection(src, p1, p2);
                    this.imagePanel.setSelection(p1.x, p1.y, p2.x, p2.y);
                    this.selectionChanged();
                    this.refreshStatusLine();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                break;
            }
            case 2: {
                Point p1 = new Point();
                Point p2 = new Point();
                try {
                    this.parseSelection(src, p1, p2);
                    this.imagePanel.setSelection(p1.x, p1.y, p1.x + p2.x, p1.y + p2.y);
                    this.selectionChanged();
                    this.refreshStatusLine();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                break;
            }
            case 4: {
                try {
                    int y = Integer.parseInt(src);
                    this.setMarkerPos(this.hMarker, 0, y, 0, 0);
                    this.refreshLineProfile();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                break;
            }
            case 5: {
                try {
                    int x = Integer.parseInt(src);
                    this.setMarkerPos(this.vMarker, x, 0, 0, 0);
                    this.refreshLineProfile();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                break;
            }
            case 3: {
                try {
                    int v = Integer.parseInt(src);
                    if (profileId == 1) {
                        this.setMarkerPos(this.hMarker, 0, v, 0, 0);
                    } else {
                        this.setMarkerPos(this.vMarker, v, 0, 0, 0);
                    }
                    this.refreshLineProfile();
                    break;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
            }
        }
    }

    protected void refreshLineProfile() {
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            switch (this.profileMode) {
                case 1: {
                    Point[] p = this.imagePanel.getSelectionPoint();
                    if (p != null) {
                        this.lineProfiler.setData(this.buildProfileData(p[0], p[1]));
                    } else {
                        this.lineProfiler.setData(null);
                    }
                    this.lineProfiler.setHeader("Line profile " + this.getLineSel());
                    this.lineProfiler.setSource("Line", this.getLineSel());
                    break;
                }
                case 2: {
                    double[] v = this.buildHistogramData();
                    if (v != null) {
                        this.lineProfiler.setData(v, this.startHisto);
                    } else {
                        this.lineProfiler.setData(null);
                    }
                    this.lineProfiler.setHeader("Histogram " + this.getRectSel());
                    this.lineProfiler.setSource("Selection", this.getRectSel());
                    break;
                }
                case 4: {
                    int y = this.imagePanel.getMarkerPos((int)this.hMarker).y;
                    Rectangle r = this.getSelectionFull();
                    Point p1 = new Point(r.x, y);
                    Point p2 = new Point(r.x + r.width - 1, y);
                    this.lineProfiler.setData(this.buildProfileData(p1, p2, false));
                    this.lineProfiler.setHeader("Horizontal profile (Y=" + y + ")");
                    this.lineProfiler.setSource("Y", new Integer(y));
                    break;
                }
                case 5: {
                    int x = this.imagePanel.getMarkerPos((int)this.vMarker).x;
                    Rectangle r = this.getSelectionFull();
                    Point p3 = new Point(x, r.y);
                    Point p4 = new Point(x, r.y + r.height - 1);
                    this.lineProfiler.setData(this.buildProfileData(p3, p4, false));
                    this.lineProfiler.setHeader("Vertical profile (X=" + x + ")");
                    this.lineProfiler.setSource("X", new Integer(x));
                    break;
                }
                case 3: {
                    int x = this.imagePanel.getMarkerPos((int)this.vMarker).x;
                    int y = this.imagePanel.getMarkerPos((int)this.hMarker).y;
                    Rectangle r = this.getSelectionFull();
                    Point p1 = new Point(r.x, y);
                    Point p2 = new Point(r.x + r.width - 1, y);
                    Point p3 = new Point(x, r.y);
                    Point p4 = new Point(x, r.y + r.height - 1);
                    this.lineProfiler.setData(this.buildProfileData(p1, p2, false));
                    this.lineProfiler.setData2(this.buildProfileData(p3, p4, false));
                    this.lineProfiler.setHeader("Horizontal profile (Y=" + y + ")");
                    this.lineProfiler.setHeader2("Vertical profile (X=" + x + ")");
                    this.lineProfiler.setSource("Y", new Integer(y));
                    this.lineProfiler.setSource2("X", new Integer(x));
                }
            }
        }
    }

    private void refreshSelectionMinMax() {
        double v;
        int i;
        int j;
        if (this.doubleValues == null) {
            this.rangeLabel.setText("");
            this.avgLabel.setText("");
            return;
        }
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null || this.imagePanel.getSelectionMode() != 1) {
            this.rangeLabel.setText("");
            return;
        }
        this.mulRect(r);
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        double sum = 0.0;
        double sum2 = 0.0;
        double lgth = 0.0;
        double avg = 0.0;
        double std = 0.0;
        for (j = r.y; j < r.y + r.height; ++j) {
            for (i = r.x; i < r.x + r.width; ++i) {
                v = this.doubleValues[j][i];
                if (v > this.curSelMax) {
                    this.curSelMax = v;
                }
                if (v < this.curSelMin) {
                    this.curSelMin = v;
                }
                sum += v;
                lgth += 1.0;
            }
        }
        avg = sum / lgth;
        for (j = r.y; j < r.y + r.height; ++j) {
            for (i = r.x; i < r.x + r.width; ++i) {
                v = this.doubleValues[j][i];
                sum2 += (v - avg) * (v - avg);
            }
        }
        std = Math.sqrt(sum2 / lgth);
        Double avgD = new Double(avg);
        Double stdD = new Double(std);
        this.avgLabel.setText("Average: " + String.format("%.2f", avgD) + "  Std deviation: " + String.format("%.2f", stdD));
        if (this.curSelMin <= this.curSelMax) {
            this.rangeLabel.setText("Range: " + Double.toString(this.curSelMin) + " , " + Double.toString(this.curSelMax));
        } else {
            this.rangeLabel.setText("");
        }
    }

    private void refreshComponents() {
        this.refreshSelectionMinMax();
        this.refreshLineProfile();
        if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
            this.buildZoom();
            this.zoomView.revalidate();
            this.zoomPanel.repaint();
        }
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshComponents();
        }
        this.fireRoiChange();
    }

    private String getLineSel() {
        Point[] pts = this.imagePanel.getSelectionPoint();
        if (pts != null) {
            this.mulPoint(pts[0]);
            this.mulPoint(pts[1]);
            return "(" + pts[0].x + "," + pts[0].y + ") - (" + pts[1].x + "," + pts[1].y + ")";
        }
        return "None";
    }

    private String getRectSel() {
        Rectangle sel = this.imagePanel.getSelectionRect();
        if (sel != null) {
            this.mulRect(sel);
            if (this.rectXYmode) {
                return "(" + sel.x + "," + sel.y + ") - (" + (sel.x + sel.width - 1) + "," + (sel.y + sel.height + -1) + ")";
            }
            return "(" + sel.x + "," + sel.y + ") - [" + sel.width + "," + sel.height + "]";
        }
        return "None";
    }

    protected void refreshStatusLine() {
        int m = this.imagePanel.getSelectionMode();
        String selStr = "None";
        switch (m) {
            case 0: {
                selStr = "Line " + this.getLineSel();
                break;
            }
            case 1: {
                selStr = "Rect " + this.getRectSel();
            }
        }
        this.selText.setText(selStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showZoom() {
        this.constructZoomPanel();
        if (this.zoomDialog.isVisible()) {
            this.zoomDialog.setVisible(true);
            return;
        }
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildZoom()) {
                return;
            }
        }
        this.zoomCombo.setSelectedIndex(this.zoomFactor);
        this.zoomText.setText("");
        this.zoomDialog.setTitle("[zoom] ImageViewer");
        this.zoomDialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension _scr = toolkit.getScreenSize();
        Dimension _dlg = this.zoomDialog.getPreferredSize();
        this.zoomDialog.setBounds((_scr.width - _dlg.height) / 2, (_scr.height - _dlg.height) / 2, _dlg.width, _dlg.height);
        this.zoomDialog.setVisible(true);
    }

    private void applySettings() {
        String minStr = this.minBestFitText.getText();
        String maxStr = this.maxBestFitText.getText();
        String gridStr = this.snapToGridText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.autoBestFit = this.autoBestFitCheck.isSelected();
        this.snapToGrid = this.snapToGridCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.sigHistogram = this.sigHistogramCheck.isSelected();
        this.rectXYmode = this.rectDisplayCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        this.setAlignToGrid(this.snapToGrid);
        try {
            int iwh = Integer.parseInt(this.integrationWidthHText.getText());
            if (iwh % 2 == 0) {
                JOptionPane.showMessageDialog(null, "Integration width (H) must be an odd number", "Error", 0);
            } else {
                this.integrationWidthH = iwh;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for integration width (H)", "Error", 0);
        }
        try {
            int iwv = Integer.parseInt(this.integrationWidthVText.getText());
            if (iwv % 2 == 0) {
                JOptionPane.showMessageDialog(null, "Integration width (V) must be an odd number", "Error", 0);
            } else {
                this.integrationWidthV = iwv;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for integration width (V)", "Error", 0);
        }
        try {
            int g = Integer.parseInt(gridStr);
            this.imagePanel.setSnapGrid(g);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for grid value", "Error", 0);
        }
        if (!this.autoBestFit) {
            try {
                this.bfMin = Double.parseDouble(minStr);
                this.bfMax = Double.parseDouble(maxStr);
                if (this.bfMin >= this.bfMax) {
                    JOptionPane.showMessageDialog(null, "maximum  best fit value is lower or equal than minimum!", "Error", 0);
                    this.autoBestFit = true;
                    this.bfMin = 0.0;
                    this.bfMax = 65536.0;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Invalid syntax for maximum or minimum best fit value", "Error", 0);
                this.autoBestFit = true;
                this.bfMin = 0.0;
                this.bfMax = 65536.0;
            }
        }
        this.settingsDialog.setVisible(false);
    }

    public void saveSetting(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            String s = this.getSettings();
            f.write(s, 0, s.length());
            f.close();
            this.lastConfig = filename;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to write " + filename, "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        String to_write = "";
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            to_write = to_write + "minBestFitText:'" + this.minBestFitText.getText() + "'\n";
            to_write = to_write + "maxBestFitText:'" + this.maxBestFitText.getText() + "'\n";
            to_write = to_write + "snapToGridText:'" + this.snapToGridText.getText() + "'\n";
            to_write = to_write + "isBestFit:'" + this.bestFitCheck.isSelected() + "'\n";
            to_write = to_write + "autoBestFit:'" + this.autoBestFitCheck.isSelected() + "'\n";
            to_write = to_write + "snapToGrid:'" + this.snapToGridCheck.isSelected() + "'\n";
            to_write = to_write + "isNegative:'" + this.negativeCheck.isSelected() + "'\n";
            to_write = to_write + "sigHistogram:'" + this.sigHistogramCheck.isSelected() + "'\n";
            to_write = to_write + "zoom:'" + this.imageSizeCombo.getSelectedIndex() + "'\n";
            to_write = to_write + "toolBarVisible:'" + this.toolbarMenuItem.isSelected() + "'\n";
            to_write = to_write + "statusLineVisible:'" + this.statusLineMenuItem.isSelected() + "'\n";
            int gradientCount = this.gColor.getEntryNumber();
            to_write = to_write + "gradientCount:'" + gradientCount + "'\n";
            for (int i = 0; i < gradientCount; ++i) {
                Color gradientColor = this.gColor.getColorAt(i);
                to_write = to_write + "gradientColor_" + i + "_red:'" + gradientColor.getRed() + "'\n";
                to_write = to_write + "gradientColor_" + i + "_green:'" + gradientColor.getGreen() + "'\n";
                to_write = to_write + "gradientColor_" + i + "_blue:'" + gradientColor.getBlue() + "'\n";
                to_write = to_write + "gradientPos_" + i + ":'" + this.gColor.getPosAt(i) + "'\n";
                gradientColor = null;
            }
        }
        return to_write;
    }

    public String loadSetting(String filename) {
        CfFileReader f = new CfFileReader();
        if (!f.readFile(filename)) {
            return "Failed to read " + filename;
        }
        this.lastConfig = filename;
        return this.applySettings(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String applySettings(CfFileReader f) {
        this.constructSettingsPanel();
        String errBuff = "";
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            String minBFText = this.minBestFitText.getText();
            String maxBFText = this.maxBestFitText.getText();
            String snapTGText = this.snapToGridText.getText();
            boolean isBestFit = this.bestFitCheck.isSelected();
            boolean autoBestFit = this.autoBestFitCheck.isSelected();
            boolean snapToGrid = this.snapToGridCheck.isSelected();
            boolean isNegative = this.negativeCheck.isSelected();
            boolean sigHistogram = this.sigHistogramCheck.isSelected();
            int zoom = this.imageSizeCombo.getSelectedIndex();
            boolean toolBarVisible = this.toolbarMenuItem.isSelected();
            boolean statusLineVisible = this.statusLineMenuItem.isSelected();
            int gradientCount = 0;
            Vector<String> param = f.getParam("minBestFitText");
            if (param == null) {
                errBuff = errBuff + "Unable to find minBestFitText";
                return errBuff;
            }
            this.minBestFitText.setText(param.get(0).toString());
            param = f.getParam("maxBestFitText");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                errBuff = errBuff + "Unable to find maxBestFitText";
                return errBuff;
            }
            this.maxBestFitText.setText(param.get(0).toString());
            param = f.getParam("snapToGridText");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                errBuff = errBuff + "Unable to find snapToGridText";
                return errBuff;
            }
            this.snapToGridText.setText(param.get(0).toString());
            param = f.getParam("isBestFit");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                errBuff = errBuff + "Unable to find isBestFit";
                return errBuff;
            }
            this.bestFitCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("autoBestFit");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                errBuff = errBuff + "Unable to find autoBestFit";
                return errBuff;
            }
            this.autoBestFitCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("snapToGrid");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                errBuff = errBuff + "Unable to find snapToGrid";
                return errBuff;
            }
            this.snapToGridCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("isNegative");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                errBuff = errBuff + "Unable to find isNegative";
                return errBuff;
            }
            this.negativeCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("sigHistogram");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                errBuff = errBuff + "Unable to find sigHistogram";
                return errBuff;
            }
            this.sigHistogramCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("zoom");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                errBuff = errBuff + "Unable to find zoom";
                return errBuff;
            }
            try {
                int histoSelection = Integer.parseInt(param.get(0).toString());
                this.imageSizeCombo.setSelectedIndex(histoSelection);
            }
            catch (NumberFormatException e) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                errBuff = errBuff + "zoom: invalid number\n";
                return errBuff;
            }
            param = f.getParam("toolBarVisible");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                errBuff = errBuff + "Unable to find toolBarVisible";
                return errBuff;
            }
            this.toolbarMenuItem.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("statusLineVisible");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                this.toolbarMenuItem.setSelected(toolBarVisible);
                errBuff = errBuff + "Unable to find statusLineVisible";
                return errBuff;
            }
            this.statusLineMenuItem.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("gradientCount");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                this.toolbarMenuItem.setSelected(toolBarVisible);
                this.statusLineMenuItem.setSelected(statusLineVisible);
                errBuff = errBuff + "Unable to find gradientCount";
                return errBuff;
            }
            try {
                gradientCount = Integer.parseInt(param.get(0).toString());
            }
            catch (NumberFormatException nfe) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.snapToGridText.setText(snapTGText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.snapToGridCheck.setSelected(snapToGrid);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                this.toolbarMenuItem.setSelected(toolBarVisible);
                this.statusLineMenuItem.setSelected(statusLineVisible);
                errBuff = errBuff + "gradientCount: invalid number";
                return errBuff;
            }
            Color[] gradientColor = new Color[gradientCount];
            double[] gradientPos = new double[gradientCount];
            for (int i = 0; i < gradientCount; ++i) {
                double pos;
                int blue;
                int green;
                int red;
                param = f.getParam("gradientColor_" + i + "_red");
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientColor_" + i + "_red";
                    return errBuff;
                }
                try {
                    red = Integer.parseInt(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientColor_" + i + "_red: invalid number";
                    return errBuff;
                }
                param = f.getParam("gradientColor_" + i + "_green");
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientColor_" + i + "_green";
                    return errBuff;
                }
                try {
                    green = Integer.parseInt(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientColor_" + i + "_green: invalid number";
                    return errBuff;
                }
                param = f.getParam("gradientColor_" + i + "_blue");
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientColor_" + i + "_blue";
                    return errBuff;
                }
                try {
                    blue = Integer.parseInt(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientColor_" + i + "_blue: invalid number";
                    return errBuff;
                }
                param = f.getParam("gradientPos_" + i);
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientPos_" + i;
                    return errBuff;
                }
                try {
                    pos = Double.parseDouble(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.snapToGridText.setText(snapTGText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.snapToGridCheck.setSelected(snapToGrid);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientPos_" + i + ": invalid number";
                    return errBuff;
                }
                gradientColor[i] = new Color(red, green, blue);
                gradientPos[i] = pos;
            }
            this.gColor = new Gradient(gradientPos, gradientColor);
            this.gColormap = this.gColor.buildColorMap(65536);
            this.gradientTool.setGradient(this.gColor);
            this.applySettings();
            this.setToolbarVisible(this.toolbarMenuItem.isSelected());
            this.setStatusLineVisible(this.statusLineMenuItem.isSelected());
            this.convertImage();
            this.refreshComponents();
        }
        return errBuff;
    }

    private void saveButtonActionPerformed() {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("txt");
            }

            @Override
            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(f) == null) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                this.saveSetting(f.getAbsolutePath());
            }
        }
    }

    private void loadButtonActionPerformed() {
        String err;
        File f;
        int returnVal;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("txt");
            }

            @Override
            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null && !ok && (err = this.loadSetting(f.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this, err, "Errors reading " + f.getName(), 0);
        }
    }

    private void showAxisDialog() {
        if (this.axisDialog == null) {
            Window parent = ATKGraphicsUtils.getWindowForComponent(this);
            this.axisDialog = parent instanceof Frame ? new JDialog((Frame)parent, false) : (parent instanceof Dialog ? new JDialog((Dialog)parent, false) : new JDialog((Frame)null, false));
            this.axisDialog.setTitle("Axis settings");
            JPanel innerPanel = new JPanel(null);
            this.tabPane = new JTabbedPane();
            this.xAxisPanel = new AxisPanel(this.getXAxis(), 3, null);
            this.yAxisPanel = new AxisPanel(this.getYAxis(), 1, null);
            this.tabPane.add("X axis", this.xAxisPanel);
            this.tabPane.add("Y axis", this.yAxisPanel);
            this.tabPane.setBounds(5, 5, 300, 370);
            innerPanel.add(this.tabPane);
            this.axisCloseButton = new JButton("Close");
            this.axisCloseButton.setFont(ATKConstant.labelFont);
            this.axisCloseButton.setBounds(225, 380, 80, 25);
            innerPanel.add(this.axisCloseButton);
            this.axisCloseButton.addActionListener(this);
            innerPanel.setPreferredSize(new Dimension(310, 410));
            this.tabPane.setBounds(5, 5, 300, 370);
            this.axisDialog.setContentPane(innerPanel);
        }
        ATKGraphicsUtils.centerDialog(this.axisDialog);
        this.axisDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        ATKGraphicsUtils.centerDialog(this.settingsDialog);
        this.settingsDialog.setVisible(true);
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    private void initSettings() {
        this.minBestFitText.setText(Double.toString(this.bfMin));
        this.maxBestFitText.setText(Double.toString(this.bfMax));
        this.integrationWidthVText.setText(Integer.toString(this.integrationWidthV));
        this.integrationWidthHText.setText(Integer.toString(this.integrationWidthH));
        this.minBestFitLabel.setEnabled(!this.autoBestFit);
        this.minBestFitText.setEnabled(!this.autoBestFit);
        this.maxBestFitLabel.setEnabled(!this.autoBestFit);
        this.maxBestFitText.setEnabled(!this.autoBestFit);
        this.bestFitCheck.setSelected(this.isBestFit);
        this.autoBestFitCheck.setSelected(this.autoBestFit);
        this.sigHistogramCheck.setSelected(this.sigHistogram);
        this.snapToGridCheck.setSelected(this.snapToGrid);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
        this.snapToGridText.setText(Integer.toString(this.imagePanel.getSnapGrid()));
        this.rectDisplayCheck.setSelected(this.rectXYmode);
        this.gradViewer.setGradient(this.gColor);
    }

    private boolean buildTable() {
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            Dimension d = this.imagePanel.getImageSize();
            r = new Rectangle(0, 0, d.width, d.height);
        }
        this.mulRect(r);
        if (r.width <= 0 || r.height <= 0) {
            return false;
        }
        String attFormat = null;
        if (this.model != null) {
            attFormat = this.model.getFormat();
        }
        if (attFormat != null && attFormat.length() > 0) {
            if (attFormat.indexOf(37) == -1) {
                Object[][] d = new String[r.height][r.width];
                for (int j = 0; j < r.height; ++j) {
                    for (int i = 0; i < r.width; ++i) {
                        d[j][i] = Double.isNaN(this.doubleValues[r.y + j][r.x + i]) || Double.isInfinite(this.doubleValues[r.y + j][r.x + i]) ? Double.toString(this.doubleValues[r.y + j][r.x + i]) : AttrManip.format((String)attFormat, (double)this.doubleValues[r.y + j][r.x + i]);
                    }
                }
                this.tablePanel.setData(d, r.x, r.y);
            } else {
                Object[][] d = new String[r.height][r.width];
                for (int j = 0; j < r.height; ++j) {
                    for (int i = 0; i < r.width; ++i) {
                        double tmp = this.doubleValues[r.y + j][r.x + i];
                        d[j][i] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
                this.tablePanel.setData(d, r.x, r.y);
            }
        } else {
            Object[][] d = new Double[r.height][r.width];
            for (int j = 0; j < r.height; ++j) {
                for (int i = 0; i < r.width; ++i) {
                    d[j][i] = new Double(this.doubleValues[r.y + j][r.x + i]);
                }
            }
            this.tablePanel.setData(d, r.x, r.y);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTable() {
        this.constructTablePanel();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
    }

    private void saveDataFile() {
        this.constructTable();
        if (this.tablePanel != null) {
            this.tablePanel.saveDataFile();
        }
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel(this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void showGradientEditor() {
        Gradient g = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (g != null) {
            this.gColor = g;
            this.gColormap = g.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
            this.gradientTool.setGradient(this.gColor);
            this.gradientTool.repaint();
        }
    }

    protected void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer(this);
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberImageViewer.this.lineProfiler.setData(null);
                    NumberImageViewer.this.lineProfiler.setData2(null);
                }
            });
        }
    }

    private void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberImageViewer.this.tablePanel.clearData();
                    NumberImageViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    private void constructZoomPanel() {
        if (this.zoomDialog == null) {
            this.zoomPanel = new JPanel(new BorderLayout());
            this.zoomImage = new JImage();
            this.zoomImage.setSelectionEnabled(false);
            this.zoomImage.setMargin(new Insets(2, 2, 2, 2));
            this.zoomImage.setImage(null);
            this.zoomView = new JScrollPane(this.zoomImage);
            this.zoomPanel.add((Component)this.zoomView, "Center");
            this.zoomCfgPanel = new JPanel();
            this.zoomCfgPanel.setLayout(null);
            this.zoomCfgPanel.setPreferredSize(new Dimension(0, 25));
            this.zoomCombo = new JComboBox();
            this.zoomCombo.setFont(this.panelFont);
            this.zoomCombo.addItem("Zoom 100%");
            this.zoomCombo.addItem("Zoom 200%");
            this.zoomCombo.addItem("Zoom 300%");
            this.zoomCombo.addItem("Zoom 400%");
            this.zoomCombo.addItem("Zoom 500%");
            this.zoomCombo.addItem("Zoom 600%");
            this.zoomCombo.addItem("Zoom 700%");
            this.zoomCombo.addItem("Zoom 800%");
            this.zoomCombo.setEditable(false);
            this.zoomCombo.setBounds(5, 3, 120, 20);
            this.zoomCombo.addActionListener(this);
            this.zoomCfgPanel.add(this.zoomCombo);
            this.zoomText = new JLabel("");
            this.zoomText.setFont(this.panelFont);
            this.zoomText.setBounds(130, 3, 500, 20);
            this.zoomCfgPanel.add(this.zoomText);
            this.zoomPanel.add((Component)this.zoomCfgPanel, "South");
            this.zoomDialog = new JFrame();
            this.zoomDialog.setContentPane(this.zoomPanel);
            this.zoomDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberImageViewer.this.zoomImage.setImage(null);
                    NumberImageViewer.this.zoomDialog.dispose();
                }
            });
            this.zoomImage.addMouseMotionListener(this);
        }
    }

    private void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 330));
            this.settingsPanel.setPreferredSize(new Dimension(290, 330));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel(this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator js = new JSeparator();
            js.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(js);
            this.autoBestFitCheck = new JCheckBox("Best fit");
            this.autoBestFitCheck.setSelected(true);
            this.autoBestFitCheck.setFont(this.panelFont);
            this.autoBestFitCheck.setBounds(5, 50, 100, 20);
            this.autoBestFitCheck.setToolTipText("Generate the best fit display using maximum and minimum value of the image");
            this.autoBestFitCheck.addActionListener(this);
            this.settingsPanel.add(this.autoBestFitCheck);
            this.bestFitCheck = new JCheckBox("Enable fitting");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(120, 50, 105, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.settingsPanel.add(this.bestFitCheck);
            this.minBestFitLabel = new JLabel("Fit Min");
            this.minBestFitLabel.setFont(this.panelFont);
            this.minBestFitLabel.setBounds(5, 75, 80, 20);
            this.settingsPanel.add(this.minBestFitLabel);
            this.minBestFitText = new JTextField("");
            this.minBestFitText.setMargin(this.noMargin);
            this.minBestFitText.setFont(this.panelFont);
            this.minBestFitText.setBounds(90, 75, 50, 20);
            this.settingsPanel.add(this.minBestFitText);
            this.maxBestFitLabel = new JLabel("Fit Max");
            this.maxBestFitLabel.setFont(this.panelFont);
            this.maxBestFitLabel.setBounds(145, 75, 80, 20);
            this.maxBestFitLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.maxBestFitLabel);
            this.maxBestFitText = new JTextField("");
            this.maxBestFitText.setMargin(this.noMargin);
            this.maxBestFitText.setFont(this.panelFont);
            this.maxBestFitText.setBounds(230, 75, 50, 20);
            this.settingsPanel.add(this.maxBestFitText);
            this.gradLabel = new JLabel("Colormap");
            this.gradLabel.setFont(this.panelFont);
            this.gradLabel.setBounds(5, 100, 70, 20);
            this.settingsPanel.add(this.gradLabel);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 100, 180, 20);
            this.settingsPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 100, 20, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 125, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            this.settingsPanel.add(this.negativeCheck);
            this.imageSizeLabel = new JLabel("Image size");
            this.imageSizeLabel.setFont(this.panelFont);
            this.imageSizeLabel.setBounds(115, 125, 85, 20);
            this.imageSizeLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.imageSizeLabel);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("800  %");
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 125, 80, 22);
            this.settingsPanel.add(this.imageSizeCombo);
            JSeparator js2 = new JSeparator();
            js2.setBounds(0, 153, 500, 10);
            this.settingsPanel.add(js2);
            this.integrationWidthHLabel = new JLabel("Integration width (Horizontal profile)");
            this.integrationWidthHLabel.setFont(this.panelFont);
            this.integrationWidthHLabel.setBounds(5, 160, 220, 20);
            this.settingsPanel.add(this.integrationWidthHLabel);
            this.integrationWidthHText = new JTextField();
            this.integrationWidthHText.setEditable(true);
            this.integrationWidthHText.setBounds(230, 160, 50, 20);
            this.settingsPanel.add(this.integrationWidthHText);
            this.integrationWidthVLabel = new JLabel("Integration width (Vertical profile)");
            this.integrationWidthVLabel.setFont(this.panelFont);
            this.integrationWidthVLabel.setBounds(5, 185, 220, 20);
            this.settingsPanel.add(this.integrationWidthVLabel);
            this.integrationWidthVText = new JTextField();
            this.integrationWidthVText.setEditable(true);
            this.integrationWidthVText.setBounds(230, 185, 50, 20);
            this.settingsPanel.add(this.integrationWidthVText);
            JSeparator js3 = new JSeparator();
            js3.setBounds(0, 218, 500, 10);
            this.settingsPanel.add(js3);
            this.snapToGridCheck = new JCheckBox("Align to grid");
            this.snapToGridCheck.setSelected(false);
            this.snapToGridCheck.setFont(this.panelFont);
            this.snapToGridCheck.setBounds(5, 225, 100, 20);
            this.snapToGridCheck.setToolTipText("Align the selection to the grid");
            this.settingsPanel.add(this.snapToGridCheck);
            this.snapToGridLabel = new JLabel("Grid spacing");
            this.snapToGridLabel.setFont(this.panelFont);
            this.snapToGridLabel.setBounds(110, 225, 90, 20);
            this.settingsPanel.add(this.snapToGridLabel);
            this.snapToGridText = new JTextField("");
            this.snapToGridText.setMargin(this.noMargin);
            this.snapToGridText.setFont(this.panelFont);
            this.snapToGridText.setBounds(205, 225, 50, 20);
            this.settingsPanel.add(this.snapToGridText);
            this.sigHistogramCheck = new JCheckBox("Display significant data for histogram");
            this.sigHistogramCheck.setSelected(false);
            this.sigHistogramCheck.setFont(this.panelFont);
            this.sigHistogramCheck.setBounds(5, 250, 280, 20);
            this.sigHistogramCheck.setToolTipText("Clip the histogram to significant data");
            this.settingsPanel.add(this.sigHistogramCheck);
            this.rectDisplayCheck = new JCheckBox("Display rectangle as (x1,y1) - (x2,y2)");
            this.rectDisplayCheck.setSelected(false);
            this.rectDisplayCheck.setFont(this.panelFont);
            this.rectDisplayCheck.setBounds(5, 275, 280, 20);
            this.rectDisplayCheck.setToolTipText("Display rectangle as (x1,y1) - (x2,y2) instead of (x1,y1) - [width,height]");
            this.settingsPanel.add(this.rectDisplayCheck);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 300, 80, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 300, 80, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            Window parent = ATKGraphicsUtils.getWindowForComponent(this);
            this.settingsDialog = parent instanceof Frame ? new JDialog((Frame)parent, true) : (parent instanceof Dialog ? new JDialog((Dialog)parent, true) : new JDialog((Frame)null, true));
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(this.settingsPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshStatusAndProlfile() {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshStatusLine();
            this.refreshLineProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.selectButton || src == this.selectionMenuItem) {
            this.imagePanel.clearSelection();
            this.imagePanel.setSelectionMode(1);
            this.profileMode = 0;
            this.hMarker = -1;
            this.vMarker = -1;
            this.clearMarkers();
            this.freePopup();
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
            }
        }
        if (src == this.selectMaxButton || src == this.selectionMaxMenuItem) {
            this.setSelectionFull();
        } else if (src == this.selectColorButton || src == this.selectionColorMenuItem) {
            this.changeSelectionColor();
        } else if (src == this.fileButton || src == this.fileMenuItem) {
            this.saveFile();
        } else if (src == this.profileButton || src == this.lineProfileMenuItem) {
            this.imagePanel.setSelectionMode(0);
            this.constructLineProfiler();
            this.lineProfiler.setLineProfileMode();
            this.lineProfiler.setVisible(true);
            this.hMarker = -1;
            this.vMarker = -1;
            this.clearMarkers();
            this.profileMode = 1;
            this.refreshStatusAndProlfile();
        } else if (src == this.lineProfile2MenuItem) {
            this.setSelectionFull();
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setMode(2);
            this.lineProfiler.setVisible(true);
            this.profileMode = 3;
            Rectangle sel = this.getSelectionFull();
            this.clearMarkers();
            this.hMarker = this.addHorizontalLineMarker(sel.y + sel.height / 2, Color.GREEN);
            this.vMarker = this.addVerticalLineMarker(sel.x + sel.width / 2, Color.GREEN);
            this.refreshStatusAndProlfile();
        } else if (src == this.profileHButton || src == this.lineHProfileMenuItem) {
            this.setSelectionFull();
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setLineProfileMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 4;
            Rectangle sel = this.getSelectionFull();
            this.clearMarkers();
            this.hMarker = this.addHorizontalLineMarker(sel.y + sel.height / 2, Color.GREEN);
            this.refreshStatusAndProlfile();
        } else if (src == this.profileVButton || src == this.lineVProfileMenuItem) {
            this.setSelectionFull();
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setLineProfileMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 5;
            Rectangle sel = this.getSelectionFull();
            this.clearMarkers();
            this.vMarker = this.addVerticalLineMarker(sel.x + sel.width / 2, Color.GREEN);
            this.refreshStatusAndProlfile();
        } else if (src == this.histoButton || src == this.histogramMenuItem) {
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setHistogramMode();
            this.lineProfiler.setVisible(true);
            this.hMarker = -1;
            this.vMarker = -1;
            this.clearMarkers();
            this.profileMode = 2;
            this.refreshStatusAndProlfile();
        } else if (src == this.bestFitMenuItem) {
            this.setBestFit(!this.isBestFit());
        } else if (src == this.negativeMenuItem) {
            this.setNegative(!this.isNegative());
        } else if (src == this.snapToGridMenuItem) {
            this.setAlignToGrid(!this.isAlignToGrid());
        } else if (src == this.toolbarMenuItem) {
            this.setToolbarVisible(!this.isToolbarVisible());
        } else if (src == this.statusLineMenuItem) {
            this.setStatusLineVisible(!this.isStatusLineVisible());
        } else if (src == this.showGradMenuItem) {
            this.setGradientVisible(!this.isGradientVisible());
        } else if (src == this.zoomButton || src == this.zoomMenuItem) {
            this.showZoom();
        } else if (src == this.zoomCombo) {
            this.zoomFactor = this.zoomCombo.getSelectedIndex();
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.buildZoom();
            }
            this.zoomDialog.pack();
        } else if (src == this.settingsButton || src == this.settingsMenuItem) {
            this.showSettings();
        } else if (src == this.autoBestFitCheck) {
            this.autoBestFit = !this.autoBestFit;
            this.minBestFitLabel.setEnabled(!this.autoBestFit);
            this.minBestFitText.setEnabled(!this.autoBestFit);
            this.maxBestFitLabel.setEnabled(!this.autoBestFit);
            this.maxBestFitText.setEnabled(!this.autoBestFit);
        } else if (src == this.cancelButton) {
            this.settingsDialog.setVisible(false);
        } else if (src == this.axisButton) {
            this.showAxisDialog();
        } else if (src == this.axisCloseButton) {
            this.axisDialog.setVisible(false);
        } else if (src == this.okButton) {
            this.applySettings();
        } else if (src == this.tableButton || src == this.tableMenuItem) {
            this.showTable();
        } else if (src == this.propButton) {
            this.showPropertyFrame();
        } else if (src == this.gradButton) {
            this.showGradientEditor();
        } else if (src == this.loadButton || src == this.loadMenuItem) {
            this.loadButtonActionPerformed();
        } else if (src == this.saveButton || src == this.saveMenuItem) {
            this.saveButtonActionPerformed();
        } else if (src == this.saveDataFileMenuItem) {
            this.saveDataFile();
        } else if (src == this.printButton || src == this.printMenuItem) {
            this.printImage();
        } else if (src == this.displayLogMenuItem) {
            this.setLogValues(this.displayLogMenuItem.isSelected());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        Dimension imgsize = this.getCurrentImageSize();
        if (this.doubleValues != null) {
            if (e.getSource() == this.imagePanel) {
                int x = this.getImageXCoord(e.getX());
                int y = this.getImageYCoord(e.getY());
                if (x >= imgsize.width || y >= imgsize.height || y < 0 || x < 0) {
                    this.statusLabel.setText(this.getLabelInfoString());
                } else {
                    this.statusLabel.setText(this.getLabelInfoString() + " (" + x + "," + y + ")=" + Double.toString(this.doubleValues[y][x]));
                }
                this.refreshStatusLine();
            } else if (e.getSource() == this.zoomImage) {
                int x = (e.getX() - this.zoomImage.getXOrigin()) / (this.zoomFactor + 1) + this.zoomXOrg;
                int y = (e.getY() - this.zoomImage.getYOrigin()) / (this.zoomFactor + 1) + this.zoomYOrg;
                if (x >= imgsize.width || y >= imgsize.height || y < 0 || x < 0) {
                    this.zoomText.setText("");
                } else {
                    this.zoomText.setText("(" + x + "," + y + ") " + Double.toString(this.doubleValues[y][x]));
                }
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = this.getImageXCoord(e.getX());
        int y = this.getImageYCoord(e.getY());
        if (e.getButton() == 1 && e.getSource() == this.imagePanel) {
            switch (this.profileMode) {
                case 4: {
                    this.setMarkerPos(this.hMarker, 0, y, 0, 0);
                    this.refreshLineProfile();
                    break;
                }
                case 5: {
                    this.setMarkerPos(this.vMarker, x, 0, 0, 0);
                    this.refreshLineProfile();
                    break;
                }
                case 3: {
                    this.setMarkerPos(this.hMarker, 0, y, 0, 0);
                    this.setMarkerPos(this.vMarker, x, 0, 0, 0);
                    this.refreshLineProfile();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Rectangle newSelection = this.imagePanel.getSelectionRect();
        if (newSelection != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!newSelection.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = newSelection;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3 && this.showingMenu && e.getSource() == this.imagePanel) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.snapToGridMenuItem.setSelected(this.isAlignToGrid());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.showGradMenuItem.setSelected(this.isGradientVisible());
            this.imgMenu.show(this.imagePanel, e.getX(), e.getY());
        }
    }

    private void parseSelection(String sel, Point p1, Point p2) {
        String y2Str;
        String x2Str;
        sel = sel.substring(sel.indexOf(40) + 1);
        String x1Str = sel.substring(0, sel.indexOf(44));
        sel = sel.substring(sel.indexOf(44) + 1);
        String y1Str = sel.substring(0, sel.indexOf(41));
        if (this.imagePanel.getSelectionMode() == 0) {
            sel = sel.substring(sel.indexOf(40) + 1);
            x2Str = sel.substring(0, sel.indexOf(44));
            sel = sel.substring(sel.indexOf(44) + 1);
            y2Str = sel.substring(0, sel.indexOf(41));
        } else {
            sel = sel.substring(sel.indexOf(91) + 1);
            x2Str = sel.substring(0, sel.indexOf(44));
            sel = sel.substring(sel.indexOf(44) + 1);
            y2Str = sel.substring(0, sel.indexOf(93));
        }
        p1.x = Integer.parseInt(x1Str);
        p1.y = Integer.parseInt(y1Str);
        p2.x = Integer.parseInt(x2Str);
        p2.y = Integer.parseInt(y2Str);
        if (this.iSz < 0) {
            p1.x *= -this.iSz;
            p1.y *= -this.iSz;
            p2.x *= -this.iSz;
            p2.y *= -this.iSz;
        } else {
            p1.x /= this.iSz;
            p1.y /= this.iSz;
            p2.x /= this.iSz;
            p2.y /= this.iSz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.selText) {
            if (e.getKeyCode() == 10) {
                try {
                    Point p1 = new Point();
                    Point p2 = new Point();
                    this.parseSelection(this.selText.getText(), p1, p2);
                    if (this.imagePanel.getSelectionMode() == 0) {
                        this.imagePanel.setSelection(p1.x, p1.y, p2.x, p2.y);
                    } else {
                        this.imagePanel.setSelection(p1.x, p1.y, p1.x + p2.x, p1.y + p2.y);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                Rectangle newSelection = this.imagePanel.getSelectionRect();
                if (newSelection != null) {
                    if (this.oldSelection == null) {
                        this.selectionChanged();
                    } else if (!newSelection.equals(this.oldSelection)) {
                        this.selectionChanged();
                    }
                }
                this.oldSelection = newSelection;
                this.refreshStatusLine();
            }
        } else if (e.getSource() == this.imagePanel) {
            switch (e.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    NumberImageViewer numberImageViewer = this;
                    synchronized (numberImageViewer) {
                        this.refreshStatusLine();
                        this.refreshSelectionMinMax();
                        this.refreshLineProfile();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent errorEvent) {
        this.setData(null);
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public void imageChange(NumberImageEvent evt) {
        if (this.logValues) {
            this.setData(this.computeLog(evt.getValue()));
        } else {
            this.setData(evt.getValue());
        }
    }

    public void setModel(INumberImage v) {
        this.clearModel();
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel(v);
        }
        if (v != null) {
            this.imagePanel.setImage(null);
            this.firstRefresh = !this.userZoom;
            this.freePopup();
            this.model = v;
            this.model.addImageListener(this);
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        this.model.removeImageListener(this);
        this.model = null;
        if (this.imagePanel != null) {
            this.imagePanel.setImage(null);
        }
    }

    private void saveEdf(String filename) {
        if (this.doubleValues == null) {
            JOptionPane.showMessageDialog(this, "No data to save.");
            return;
        }
        Dimension d = this.getCurrentImageSize();
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            r = new Rectangle(0, 0, d.width, d.height);
        } else {
            this.mulRect(r);
        }
        if (r.width <= 0 || r.height <= 0) {
            JOptionPane.showMessageDialog(this, "No area selected.");
            return;
        }
        try {
            DataOutputStream fw = new DataOutputStream(new FileOutputStream(filename));
            StringBuffer to_write = new StringBuffer();
            to_write.append("{\n");
            to_write.append("HeaderID       = EH:000001:000000:000000 ;\n");
            to_write.append("Image          = 1 ;\n");
            to_write.append("ByteOrder      = LowByteFirst ;\n");
            to_write.append("DataType       = UnsignedShort ;\n");
            to_write.append("Dim_1          = " + r.width + " ;\n");
            to_write.append("Dim_2          = " + r.height + " ;\n");
            to_write.append("Size           = " + r.width * r.height * 2 + " ;\n");
            to_write.append("count_time     = 0 ;\n");
            to_write.append("point_no       = 0 ;\n");
            to_write.append("preset         = 1.0 ;\n");
            to_write.append("col_end        = " + (r.width - 1) + " ;\n");
            to_write.append("row_end        = " + (r.height - 1) + " ;\n");
            to_write.append("dir            = . ;\n");
            to_write.append("suffix         = edf ;\n");
            to_write.append("prefix         = ;\n");
            to_write.append("run            = 1 ;\n");
            to_write.append("description    = ;\n");
            to_write.append("title          = snapshot ;\n");
            for (int l = to_write.length(); l < 1022; ++l) {
                to_write.append(' ');
            }
            to_write.append("}\n");
            fw.writeBytes(to_write.toString());
            to_write = new StringBuffer();
            for (int j = r.y; j < r.y + r.height; ++j) {
                for (int i = r.x; i < r.x + r.width; ++i) {
                    int v = (int)this.doubleValues[j][i];
                    to_write.append((char)(v & 0xFF));
                    to_write.append((char)(v >> 8 & 0xFF));
                }
            }
            fw.writeBytes(to_write.toString());
            fw.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + e.getMessage());
        }
    }

    private String getLabelInfoString() {
        Dimension imgsize = this.getCurrentImageSize();
        int percent = this.iSz < 0 ? (int)(100.0 * (double)(-this.iSz)) : (int)(100.0 / (double)this.iSz);
        return percent + "% [" + imgsize.width + "," + imgsize.height + "]";
    }

    private void computeVerticalExtent() {
        int i;
        if (this.doubleValues == null) {
            return;
        }
        if (this.verticalExtent == 1) {
            return;
        }
        int dimy = this.doubleValues.length;
        if (dimy == 0) {
            return;
        }
        int dimx = this.doubleValues[0].length;
        if (dimx == 0) {
            return;
        }
        double[][] newValues = new double[(dimy - 1) * this.verticalExtent + 1][dimx];
        for (int j = 0; j < dimy - 1; ++j) {
            for (i = 0; i < dimx; ++i) {
                for (int k = 0; k < this.verticalExtent; ++k) {
                    double yup = this.doubleValues[j][i];
                    double ydown = this.doubleValues[j + 1][i];
                    double r = (double)k / (double)this.verticalExtent;
                    newValues[j * this.verticalExtent + k][i] = yup * (1.0 - r) + ydown * r;
                }
            }
        }
        int k = (dimy - 1) * this.verticalExtent;
        for (i = 0; i < dimx; ++i) {
            newValues[k][i] = this.doubleValues[dimy - 1][i];
        }
        this.doubleValues = newValues;
    }

    private void computeAutoZoom() {
        int dimy;
        if (this.doubleValues == null) {
            return;
        }
        if ((this.firstRefresh || this.autoZoom) && this.doubleValues.length > 0 && (dimy = this.doubleValues.length) > 0) {
            int sz;
            int dimx;
            if (dimx > 800 || dimy > 600) {
                for (sz = 1; (dimx > 800 || dimy > 600) && sz < 8 && dimx % 2 == 0 && dimy % 2 == 0; dimx /= 2, dimy /= 2, sz *= 2) {
                }
                this.iSz = sz;
            } else {
                for (dimx = this.doubleValues[0].length; dimx < 600 && dimy < 400 && sz < 4; dimx *= 2, dimy *= 2, sz *= 2) {
                }
                this.iSz = sz != 1 ? -sz : 1;
            }
            if (this.iSz < 0) {
                this.imagePanel.setMarkerScale(-this.iSz);
            } else {
                this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
            }
            this.firstRefresh = false;
        }
    }

    private void preComputeBestFit() {
        if (!this.isBestFit) {
            this.gradientTool.getAxis().setMinimum(0.0);
            this.gradientTool.getAxis().setMaximum(65536.0);
            this.gradientTool.repaint();
            return;
        }
        if (this.doubleValues == null) {
            return;
        }
        if (this.autoBestFit) {
            this.autoBfMin = 65536.0;
            this.autoBfMax = 0.0;
            for (int j = 0; j < this.doubleValues.length; ++j) {
                for (int i = 0; i < this.doubleValues[j].length; ++i) {
                    double v = this.doubleValues[j][i];
                    if (Double.isNaN(v) || Double.isInfinite(v)) continue;
                    if (v > this.autoBfMax) {
                        this.autoBfMax = v;
                    }
                    if (!(v < this.autoBfMin)) continue;
                    this.autoBfMin = v;
                }
            }
            if (this.autoBfMin == 65536.0 && this.autoBfMax == 0.0) {
                this.autoBfMin = 0.0;
                this.autoBfMax = 0.0;
            }
            this.bfa0 = -this.autoBfMin;
            if (this.autoBfMax == this.autoBfMin) {
                this.bfa1 = 0.0;
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax + 1.0);
                this.gradientTool.repaint();
            } else {
                this.bfa1 = 65536.0 / (this.autoBfMax - this.autoBfMin);
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax);
                this.gradientTool.repaint();
            }
        } else {
            this.bfa0 = -this.bfMin;
            this.bfa1 = this.bfMax == this.bfMin ? 0.0 : 65536.0 / (this.bfMax - this.bfMin);
            this.gradientTool.getAxis().setMinimum(this.bfMin);
            this.gradientTool.getAxis().setMaximum(this.bfMax);
            this.gradientTool.repaint();
        }
    }

    private int bestFit(double v) {
        int nv = (int)((this.bfa0 + v) * this.bfa1);
        if (nv < 0) {
            return 0;
        }
        if (nv > 65535) {
            return 65535;
        }
        return nv;
    }

    private boolean buildZoom() {
        if (this.doubleValues == null) {
            return false;
        }
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            return false;
        }
        this.mulRect(r);
        if (r.width <= 0 || r.height <= 0) {
            return false;
        }
        this.zoomXOrg = r.x;
        this.zoomYOrg = r.y;
        int zf = this.zoomFactor + 1;
        BufferedImage zoomImg = new BufferedImage(r.width * zf, r.height * zf, 1);
        int[] rgb = new int[r.width * zf];
        this.preComputeBestFit();
        for (int j = r.y; j < r.y + r.height; ++j) {
            for (int i = r.x; i < r.x + r.width; ++i) {
                int k;
                int p;
                if (this.isNegative) {
                    if (this.isBestFit) {
                        p = this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                        for (k = 0; k < zf; ++k) {
                            rgb[(i - r.x) * zf + k] = p;
                        }
                        continue;
                    }
                    p = this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                    for (k = 0; k < zf; ++k) {
                        rgb[(i - r.x) * zf + k] = p;
                    }
                    continue;
                }
                if (this.isBestFit) {
                    p = this.gColormap[this.bestFit(this.doubleValues[j][i])];
                    for (k = 0; k < zf; ++k) {
                        rgb[(i - r.x) * zf + k] = p;
                    }
                    continue;
                }
                p = this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                for (k = 0; k < zf; ++k) {
                    rgb[(i - r.x) * zf + k] = p;
                }
            }
            for (int k = 0; k < zf; ++k) {
                zoomImg.setRGB(0, (j - r.y) * zf + k, r.width * zf, 1, rgb, 0, r.width * zf);
            }
        }
        this.zoomImage.setImage(zoomImg);
        return true;
    }

    private void saveFile() {
        File f;
        int ok = 0;
        FileFilter edfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("edf");
            }

            @Override
            public String getDescription() {
                return "edf - EDF pictues (Mono 16 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter jpgFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Color 24 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter jpg8Filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter pngFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Color 24 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter png8Filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter[] filters = new FileFilter[]{edfFilter, png8Filter, pngFilter, jpg8Filter, jpgFilter};
        JFileChooser chooser = new JFileChooser(this.lastSnapshotLocation);
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i].equals(this.lastFileFilter)) continue;
            chooser.addChoosableFileFilter(filters[i]);
        }
        if (this.lastFileFilter != null) {
            chooser.addChoosableFileFilter(this.lastFileFilter);
        }
        chooser.setDialogTitle("Save snapshot");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            this.lastSnapshotLocation = f.getParentFile().getAbsolutePath();
            FileFilter filter = chooser.getFileFilter();
            if (edfFilter.equals(filter)) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("edf")) {
                    f = new File(f.getAbsolutePath() + ".edf");
                }
                this.lastFileFilter = filter;
            } else if (jpgFilter.equals(filter) || jpg8Filter.equals(filter)) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("jpg")) {
                    f = new File(f.getAbsolutePath() + ".jpg");
                }
                this.lastFileFilter = filter;
            } else if (pngFilter.equals(filter) || png8Filter.equals(filter)) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("png")) {
                    f = new File(f.getAbsolutePath() + ".png");
                }
                this.lastFileFilter = filter;
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid image format", "Error", 0);
                return;
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                if (edfFilter.equals(filter)) {
                    this.saveEdf(f.getAbsolutePath());
                } else if (jpgFilter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.getSelectionImage(), "jpg", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (jpg8Filter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "jpg", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (pngFilter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.getSelectionImage(), "png", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (png8Filter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "png", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                }
            }
        }
        pngFilter = null;
        png8Filter = null;
        jpgFilter = null;
        jpg8Filter = null;
        edfFilter = null;
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = null;
        }
        filters = null;
    }

    private BufferedImage getSelectionImage() {
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r != null && r.width * r.height != 0) {
            BufferedImage newImage = new BufferedImage(r.width, r.height, 1);
            Graphics2D g2 = newImage.createGraphics();
            g2.drawImage(this.imagePanel.getImage(), 0, 0, r.width - 1, r.height - 1, r.x, r.y, r.x + r.width - 1, r.y + r.height - 1, null);
            g2.dispose();
            return newImage;
        }
        int w = this.imagePanel.getImage().getWidth();
        int h = this.imagePanel.getImage().getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 1);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        g2.dispose();
        return newImage;
    }

    private BufferedImage get8BitImage() {
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r != null) {
            BufferedImage newImage = new BufferedImage(r.width, r.height, 10);
            Graphics2D g2 = newImage.createGraphics();
            g2.drawImage(this.imagePanel.getImage(), 0, 0, r.width - 1, r.height - 1, r.x, r.y, r.x + r.width - 1, r.y + r.height - 1, null);
            g2.dispose();
            return newImage;
        }
        int w = this.imagePanel.getImage().getWidth();
        int h = this.imagePanel.getImage().getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 10);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        g2.dispose();
        return newImage;
    }

    public void setNaNcolor(Color color) {
        this.rgbNaN = color == null ? 0 : color.getRGB();
        this.colorNaN = color;
    }

    private void convertImage() {
        if (this.doubleValues == null) {
            return;
        }
        if (this.doubleValues.length > 0) {
            int dimy = this.doubleValues.length;
            if (dimy > 0) {
                int rdimy;
                int rdimx;
                int dimx = this.doubleValues[0].length;
                BufferedImage lastImg = this.imagePanel.getImage();
                if (this.iSz < 0) {
                    rdimx = dimx * -this.iSz;
                    rdimy = dimy * -this.iSz;
                } else {
                    rdimx = dimx / this.iSz;
                    rdimy = dimy / this.iSz;
                }
                if (lastImg == null || lastImg.getHeight() != rdimy || lastImg.getWidth() != rdimx) {
                    lastImg = new BufferedImage(rdimx, rdimy, 1);
                    this.imagePanel.setImage(lastImg);
                    this.freePopup();
                    this.statusLabel.setText(this.getLabelInfoString());
                    this.refreshComponents();
                }
                int[] rgb = new int[rdimx];
                this.preComputeBestFit();
                if (this.iSz < 0) {
                    int sz = -this.iSz;
                    for (int j = 0; j < dimy; ++j) {
                        int k;
                        int c;
                        int i;
                        if (this.colorNaN == null) {
                            if (this.isBestFit) {
                                if (this.isNegative) {
                                    for (i = 0; i < dimx; ++i) {
                                        c = this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                                        for (k = 0; k < sz; ++k) {
                                            rgb[i * sz + k] = c;
                                        }
                                    }
                                } else {
                                    for (i = 0; i < dimx; ++i) {
                                        c = this.gColormap[this.bestFit(this.doubleValues[j][i])];
                                        for (k = 0; k < sz; ++k) {
                                            rgb[i * sz + k] = c;
                                        }
                                    }
                                }
                            } else if (this.isNegative) {
                                for (i = 0; i < dimx; ++i) {
                                    c = this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                                    for (k = 0; k < sz; ++k) {
                                        rgb[i * sz + k] = c;
                                    }
                                }
                            } else {
                                for (i = 0; i < dimx; ++i) {
                                    c = this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                                    for (k = 0; k < sz; ++k) {
                                        rgb[i * sz + k] = c;
                                    }
                                }
                            }
                        } else if (this.isBestFit) {
                            if (this.isNegative) {
                                for (i = 0; i < dimx; ++i) {
                                    c = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                                    for (k = 0; k < sz; ++k) {
                                        rgb[i * sz + k] = c;
                                    }
                                }
                            } else {
                                for (i = 0; i < dimx; ++i) {
                                    c = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[this.bestFit(this.doubleValues[j][i])];
                                    for (k = 0; k < sz; ++k) {
                                        rgb[i * sz + k] = c;
                                    }
                                }
                            }
                        } else if (this.isNegative) {
                            for (i = 0; i < dimx; ++i) {
                                c = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                                for (k = 0; k < sz; ++k) {
                                    rgb[i * sz + k] = c;
                                }
                            }
                        } else {
                            for (i = 0; i < dimx; ++i) {
                                c = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                                for (k = 0; k < sz; ++k) {
                                    rgb[i * sz + k] = c;
                                }
                            }
                        }
                        for (int k2 = 0; k2 < sz; ++k2) {
                            lastImg.setRGB(0, j * sz + k2, rdimx, 1, rgb, 0, rdimx);
                        }
                    }
                } else if (this.colorNaN == null) {
                    int j = 0;
                    for (int l = 0; l < rdimy; ++l) {
                        int k;
                        int i;
                        if (this.isBestFit) {
                            if (this.isNegative) {
                                i = 0;
                                for (k = 0; k < rdimx; ++k) {
                                    rgb[k] = this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                                    i += this.iSz;
                                }
                            } else {
                                i = 0;
                                for (k = 0; k < rdimx; ++k) {
                                    rgb[k] = this.gColormap[this.bestFit(this.doubleValues[j][i])];
                                    i += this.iSz;
                                }
                            }
                        } else if (this.isNegative) {
                            i = 0;
                            for (k = 0; k < rdimx; ++k) {
                                rgb[k] = this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                                i += this.iSz;
                            }
                        } else {
                            i = 0;
                            for (k = 0; k < rdimx; ++k) {
                                rgb[k] = this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                                i += this.iSz;
                            }
                        }
                        lastImg.setRGB(0, l, rdimx, 1, rgb, 0, rdimx);
                        j += this.iSz;
                    }
                } else {
                    int j = 0;
                    for (int l = 0; l < rdimy; ++l) {
                        int k;
                        int i;
                        if (this.isBestFit) {
                            if (this.isNegative) {
                                i = 0;
                                for (k = 0; k < rdimx; ++k) {
                                    rgb[k] = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                                    i += this.iSz;
                                }
                            } else {
                                i = 0;
                                for (k = 0; k < rdimx; ++k) {
                                    rgb[k] = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[this.bestFit(this.doubleValues[j][i])];
                                    i += this.iSz;
                                }
                            }
                        } else if (this.isNegative) {
                            i = 0;
                            for (k = 0; k < rdimx; ++k) {
                                rgb[k] = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                                i += this.iSz;
                            }
                        } else {
                            i = 0;
                            for (k = 0; k < rdimx; ++k) {
                                rgb[k] = Double.isNaN(this.doubleValues[j][i]) ? this.rgbNaN : this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                                i += this.iSz;
                            }
                        }
                        lastImg.setRGB(0, l, rdimx, 1, rgb, 0, rdimx);
                        j += this.iSz;
                    }
                }
                this.imagePanel.repaint();
                this.imageView.revalidate();
                return;
            }
            this.doubleValues = null;
        } else {
            this.doubleValues = null;
        }
    }

    public void printImage() {
        ATKGraphicsUtils.printComponent(this.imagePanel, "Print Image", true, 0);
    }

    public boolean isLogValues() {
        return this.logValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogValues(boolean logValues) {
        if (logValues != this.logValues) {
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                if (this.model != null) {
                    double[][] values = this.model.getValue();
                    if (logValues) {
                        this.setData(this.computeLog(values));
                    } else {
                        this.setData(values);
                    }
                }
            }
        }
        this.logValues = logValues;
    }

    protected double[][] computeLog(double[][] values) {
        if (values == null) {
            return null;
        }
        int length1 = 0;
        int length2 = 0;
        length1 = values.length;
        if (length1 > 0) {
            length2 = values[0].length;
        }
        double[][] logs = new double[length1][length2];
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                logs[i][j] = Math.log10(values[i][j]);
            }
        }
        return logs;
    }

    protected void changeSelectionColor() {
        Color selectionColor = JColorChooser.showDialog(this, "Choose Selection Color", this.imagePanel.getSelectionColor());
        if (selectionColor != null) {
            this.imagePanel.setSelectionColor(selectionColor);
            this.imagePanel.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        NumberImageViewer d = new NumberImageViewer();
        AttributeList attributeList = new AttributeList();
        final ErrorHistory errWin = new ErrorHistory();
        attributeList.addErrorListener(errWin);
        try {
            INumberImage theAtt = args.length > 0 ? (INumberImage)attributeList.add(args[0]) : (INumberImage)attributeList.add("jlp/test/1/att_image");
            d.setModel(theAtt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)d, "Center");
        JPanel panel = new JPanel();
        JButton errorBtn = new JButton("Show errors");
        errorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                errWin.setVisible(true);
            }
        });
        panel.add(errorBtn);
        JButton diagBtn = new JButton("Show diag");
        diagBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        panel.add(diagBtn);
        f.getContentPane().add((Component)panel, "South");
        f.setDefaultCloseOperation(3);
        f.setTitle("ImageViewer");
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
        attributeList.setRefreshInterval(1000);
        attributeList.startRefresher();
    }
}

