/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumber;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class NumberImageTable
extends JTable
implements IImageListener,
ISpectrumListener {
    protected INumber imageModel = null;
    protected NumberImageTableModel tableModel = new NumberImageTableModel();
    private boolean valueEditable = false;

    public NumberImageTable() {
        this.setModel(this.tableModel);
    }

    public void setImageModel(INumberImage v) {
        if (this.imageModel != null) {
            if (this.imageModel instanceof INumberImage) {
                ((INumberImage)this.imageModel).removeImageListener(this);
                this.imageModel = null;
            } else if (this.imageModel instanceof INumberSpectrum) {
                ((INumberSpectrum)this.imageModel).removeSpectrumListener(this);
                this.imageModel = null;
            }
        }
        if (v != null) {
            this.imageModel = v;
            if (this.imageModel instanceof INumberImage) {
                ((INumberImage)this.imageModel).addImageListener(this);
            } else if (this.imageModel instanceof INumberSpectrum) {
                ((INumberSpectrum)this.imageModel).addSpectrumListener(this);
            }
            if (!this.imageModel.isWritable()) {
                this.setValueEditable(false);
            }
            this.imageModel.refresh();
        }
    }

    public void setSpectrumModel(INumberSpectrum v) {
        if (this.imageModel != null) {
            if (this.imageModel instanceof INumberImage) {
                ((INumberImage)this.imageModel).removeImageListener(this);
                this.imageModel = null;
            } else if (this.imageModel instanceof INumberSpectrum) {
                ((INumberSpectrum)this.imageModel).removeSpectrumListener(this);
                this.imageModel = null;
            }
        }
        if (v != null) {
            this.imageModel = v;
            ((INumberSpectrum)this.imageModel).addSpectrumListener(this);
            if (!this.imageModel.isWritable()) {
                this.setValueEditable(false);
            }
            this.imageModel.refresh();
        }
    }

    public INumberImage getImageModel() {
        if (this.imageModel instanceof INumberImage) {
            return (INumberImage)this.imageModel;
        }
        return null;
    }

    public INumberSpectrum getSpectrumModel() {
        if (this.imageModel instanceof INumberSpectrum) {
            return (INumberSpectrum)this.imageModel;
        }
        return null;
    }

    @Override
    public void imageChange(NumberImageEvent event) {
        this.imageChange(event.getValue());
    }

    @Override
    public void spectrumChange(NumberSpectrumEvent event) {
        this.imageChange(new double[][]{event.getValue()});
    }

    public void imageChange(double[][] val) {
        double[][] formerVal;
        boolean change = false;
        if (val == null) {
            val = new double[0][0];
        }
        if ((formerVal = this.tableModel.getValue()) == null) {
            formerVal = new double[0][0];
        }
        if (val.length != formerVal.length) {
            change = true;
        } else if (val.length > 0 && val[0].length != formerVal[0].length) {
            change = true;
        } else {
            for (int i = 0; i < val.length; ++i) {
                for (int j = 0; j < val[0].length; ++j) {
                    if (val[i][j] == formerVal[i][j]) continue;
                    change = true;
                    break;
                }
                if (change) break;
            }
        }
        if (change) {
            this.tableModel.setValue(val);
        }
    }

    @Override
    public void stateChange(AttributeStateEvent arg0) {
    }

    @Override
    public void errorChange(ErrorEvent arg0) {
        double[][] formerVal = this.tableModel.getValue();
        if (formerVal != null || formerVal.length != 0 || formerVal[0].length != 0) {
            this.tableModel.setValue(new double[0][0]);
        }
    }

    public boolean isValueEditable() {
        return this.valueEditable;
    }

    public void setValueEditable(boolean valueEditable) {
        this.valueEditable = valueEditable;
    }

    public static void main(String[] args) throws ConnectionException {
        JFrame frame = new JFrame("Test NumberImageTable");
        frame.setDefaultCloseOperation(3);
        String parameter = "tango/tangotest/1/double_spectrum";
        if (args.length > 0) {
            parameter = args[0];
        }
        NumberImageTable table = new NumberImageTable();
        table.setValueEditable(true);
        AttributePolledList list = new AttributePolledList();
        IEntity image = list.add(parameter);
        if (image instanceof INumberSpectrum) {
            table.setSpectrumModel((INumberSpectrum)image);
        }
        if (image instanceof INumberImage) {
            table.setImageModel((INumberImage)image);
        }
        frame.getContentPane().add(new JScrollPane(table));
        frame.setSize(400, 400);
        frame.setVisible(true);
        list.startRefresher();
    }

    protected class NumberImageTableModel
    extends AbstractTableModel {
        double[][] value;

        @Override
        public int getRowCount() {
            if (this.value == null) {
                return 0;
            }
            return this.value.length;
        }

        @Override
        public int getColumnCount() {
            if (this.value == null) {
                return 0;
            }
            if (this.value.length == 0) {
                return 0;
            }
            return this.value[0].length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(double[][] theValue) {
            boolean changeAll = false;
            NumberImageTableModel numberImageTableModel = this;
            synchronized (numberImageTableModel) {
                double[][] tempValue = theValue;
                if (tempValue == null) {
                    tempValue = new double[0][0];
                }
                if (this.value == null) {
                    changeAll = true;
                } else if (this.value.length != tempValue.length) {
                    changeAll = true;
                } else if (this.value.length > 0 && this.value[0].length != tempValue[0].length) {
                    changeAll = true;
                }
                this.value = tempValue;
            }
            if (changeAll) {
                this.fireTableStructureChanged();
            } else {
                this.fireTableRowsUpdated(0, this.value.length);
            }
        }

        public double[][] getValue() {
            return this.value;
        }

        @Override
        public Object getValueAt(int row, int column) {
            double val = -1.0;
            val = this.value[row][column];
            return new Double(val);
        }

        @Override
        public String getColumnName(int column) {
            return Integer.toString(column);
        }

        @Override
        public void setValueAt(Object object, int row, int column) {
            try {
                double tmpDoubleValue = Double.parseDouble((String)object);
                this.writeValue(tmpDoubleValue, row, column);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void writeValue(double aValue, int row, int column) {
            double[][] tmpReadValue = NumberImageTable.this.tableModel.getValue();
            double[][] tmpNewValue = new double[0][0];
            if (tmpReadValue != null) {
                tmpNewValue = NumberImageTable.this.getSpectrumModel() != null ? new double[tmpReadValue.length][tmpReadValue[0].length / 2] : tmpReadValue;
                for (int i = 0; i < tmpNewValue.length; ++i) {
                    for (int j = 0; j < tmpNewValue[i].length; ++j) {
                        tmpNewValue[i][j] = i == row && j == column ? aValue : tmpReadValue[i][j];
                    }
                }
                if (NumberImageTable.this.getImageModel() != null) {
                    INumberImage model = NumberImageTable.this.getImageModel();
                    try {
                        model.setValue(tmpNewValue);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Write error", e.getMessage(), 0);
                    }
                }
                if (NumberImageTable.this.getSpectrumModel() != null) {
                    INumberSpectrum model = NumberImageTable.this.getSpectrumModel();
                    try {
                        model.setValue(tmpNewValue[0]);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Write error", e.getMessage(), 0);
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return NumberImageTable.this.isValueEditable();
        }
    }
}

