/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.AdvancedImagePlus;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JImageJ;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import ij.gui.Line;
import ij.gui.Roi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class NumberImageJViewer
extends JPanel
implements IImageListener,
MouseMotionListener,
MouseListener,
MouseWheelListener,
ActionListener,
KeyListener,
JDrawable {
    private static final long serialVersionUID = 1L;
    protected INumberImage model;
    protected double[][] doubleValues = null;
    protected Rectangle oldSelection = null;
    protected int profileMode;
    protected boolean showingMenu;
    protected boolean sigHistogram;
    protected boolean isNegative;
    protected int startHisto;
    protected Gradient gColor;
    protected int[] gColormap;
    protected int iSz;
    protected EventListenerList listenerList;
    protected Insets noMargin = new Insets(0, 0, 0, 0);
    protected boolean autoZoom = false;
    protected boolean firstRefresh = false;
    protected boolean userZoom = false;
    protected int verticalExtent = 1;
    protected String lastConfig = "";
    protected boolean isBestFit;
    protected boolean autoBestFit;
    protected double bfMin = 0.0;
    protected double bfMax = 65536.0;
    protected double autoBfMin;
    protected double autoBfMax;
    protected double bfa0;
    protected double bfa1;
    protected double curSelMin;
    protected double curSelMax;
    protected JImageJ imagePanel;
    protected JPanel buttonPanel;
    protected JButton selectButton;
    protected JButton selectMaxButton;
    protected JButton roiColorsButton;
    protected JPopupMenu roiColorsMenu;
    protected JMenuItem roiColorMenuItem;
    protected JMenuItem selectedRoiColorMenuItem;
    protected JMenuItem innerRoiColorMenuItem;
    protected JMenuItem selectedInnerRoiColorMenuItem;
    protected JMenuItem outerRoiColorMenuItem;
    protected JMenuItem selectedOuterRoiColorMenuItem;
    protected JButton fileButton;
    protected JButton zoomButton;
    protected JButton tableButton;
    protected JButton profileButton;
    protected JButton histoButton;
    protected JButton settingsButton;
    protected JButton axisButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton printButton;
    protected JScrollPane buttonView;
    protected Font panelFont;
    protected JPanel cfgPanel;
    protected JLabel statusLabel;
    protected JLabel rangeLabel;
    protected JLabel avgLabel;
    protected JLabel selLabel;
    protected JTextField selText;
    protected JPopupMenu imgMenu;
    protected JMenuItem infoMenuItem;
    protected JCheckBoxMenuItem bestFitMenuItem;
    protected JCheckBoxMenuItem negativeMenuItem;
    protected JCheckBoxMenuItem toolbarMenuItem;
    protected JCheckBoxMenuItem statusLineMenuItem;
    protected JCheckBoxMenuItem showGradMenuItem;
    protected JMenuItem selectionMenuItem;
    protected JMenuItem selectionMaxMenuItem;
    protected JMenuItem selectionColorMenuItem;
    protected JMenuItem fileMenuItem;
    protected JMenuItem zoomMenuItem;
    protected JMenuItem tableMenuItem;
    protected JMenuItem lineProfileMenuItem;
    protected JMenuItem histogramMenuItem;
    protected JMenuItem settingsMenuItem;
    protected JMenuItem loadMenuItem;
    protected JMenuItem saveMenuItem;
    protected JMenuItem saveDataFileMenuItem;
    protected JMenuItem printMenuItem;
    protected JCheckBoxMenuItem displayLogMenuItem;
    protected JGradientViewer gradientTool;
    protected LineProfilerViewer lineProfiler = null;
    protected JFrame zoomDialog = null;
    protected JPanel zoomPanel;
    protected JScrollPane zoomView;
    protected JImage zoomImage;
    protected JPanel zoomCfgPanel;
    protected JComboBox zoomCombo;
    protected int zoomFactor;
    protected int zoomXOrg;
    protected int zoomYOrg;
    protected JLabel zoomText;
    protected JDialog settingsDialog = null;
    protected JPanel settingsPanel;
    protected LabelViewer attNameLabel;
    protected JButton propButton;
    protected JCheckBox sigHistogramCheck;
    protected JCheckBox bestFitCheck;
    protected JCheckBox autoBestFitCheck;
    protected JLabel minBestFitLabel;
    protected JTextField minBestFitText;
    protected JLabel maxBestFitLabel;
    protected JTextField maxBestFitText;
    protected JCheckBox negativeCheck;
    protected JComboBox imageSizeCombo;
    protected JLabel imageSizeLabel;
    protected JGradientEditor gradViewer;
    protected JButton gradButton;
    protected JLabel gradLabel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JDialog axisDialog = null;
    protected JTabbedPane tabPane;
    protected AxisPanel xAxisPanel;
    protected AxisPanel yAxisPanel;
    protected JButton axisCloseButton;
    protected JFrame tableDialog = null;
    protected JTableRow tablePanel;
    SimplePropertyFrame propDialog = null;
    static String[] exts = new String[]{"toolBarVisible", "statusLineVisible", "gradientVisible", "bestFit", "xAxis", "yAxis"};
    protected String lastSnapshotLocation = ".";
    protected FileFilter lastFileFilter = null;
    protected boolean logValues = false;

    public NumberImageJViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.initImagePanel();
        this.initButtonPanel();
        this.initGradient();
        this.initStatusLine();
        this.initPopupMenu();
        this.isBestFit = true;
        this.autoBestFit = true;
        this.sigHistogram = false;
        this.isNegative = false;
        this.showingMenu = true;
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        this.startHisto = 0;
        this.zoomFactor = 0;
        this.iSz = 1;
        this.listenerList = new EventListenerList();
    }

    protected void initImagePanel() {
        this.imagePanel = new JImageJ();
        this.imagePanel.setBorder(null);
        this.add((Component)this.imagePanel, "Center");
        this.imagePanel.getImageRenderer().addMouseMotionListener(this);
        this.imagePanel.getImageRenderer().addMouseListener(this);
        this.imagePanel.getImageRenderer().addMouseWheelListener(this);
        this.imagePanel.getImageRenderer().addKeyListener(this);
    }

    protected void initButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setPreferredSize(new Dimension(60, 530));
        this.buttonView = new JScrollPane(this.buttonPanel);
        this.buttonView.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.buttonView, "West");
        this.buttonView.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                NumberImageJViewer.this.adjustToolbarSize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                NumberImageJViewer.this.adjustToolbarSize();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                NumberImageJViewer.this.adjustToolbarSize();
            }
        });
        this.selectButton = new JButton();
        this.selectButton.setMargin(this.noMargin);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        this.buttonPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(this.noMargin);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 40, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        this.buttonPanel.add(this.selectMaxButton);
        this.roiColorsButton = new JButton();
        this.roiColorsButton.setMargin(this.noMargin);
        this.roiColorsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select_color.gif")));
        this.roiColorsButton.setBounds(2, 75, 36, 36);
        this.roiColorsButton.setToolTipText("ROI Colors...");
        this.roiColorsButton.addActionListener(this);
        this.buttonPanel.add(this.roiColorsButton);
        this.roiColorsMenu = new JPopupMenu();
        this.roiColorMenuItem = new JMenuItem("ROI default color");
        this.roiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.roiColorMenuItem);
        this.selectedRoiColorMenuItem = new JMenuItem("ROI default selection color");
        this.selectedRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.selectedRoiColorMenuItem);
        this.innerRoiColorMenuItem = new JMenuItem("Interior ROI color");
        this.innerRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.innerRoiColorMenuItem);
        this.selectedInnerRoiColorMenuItem = new JMenuItem("Interior ROI selection color");
        this.selectedInnerRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.selectedInnerRoiColorMenuItem);
        this.outerRoiColorMenuItem = new JMenuItem("Exterior ROI color");
        this.outerRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.outerRoiColorMenuItem);
        this.selectedOuterRoiColorMenuItem = new JMenuItem("Exterior ROI selection color");
        this.selectedOuterRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.selectedOuterRoiColorMenuItem);
        this.fileButton = new JButton();
        this.fileButton.setMargin(this.noMargin);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 115, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        this.buttonPanel.add(this.fileButton);
        this.zoomButton = new JButton();
        this.zoomButton.setMargin(this.noMargin);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_zoom.gif")));
        this.zoomButton.setBounds(2, 155, 36, 36);
        this.zoomButton.setToolTipText("Zoom selection");
        this.zoomButton.addActionListener(this);
        this.buttonPanel.add(this.zoomButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(this.noMargin);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 195, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        this.buttonPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(this.noMargin);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 240, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        this.buttonPanel.add(this.profileButton);
        this.histoButton = new JButton();
        this.histoButton.setMargin(this.noMargin);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 275, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        this.buttonPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(this.noMargin);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 320, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        this.buttonPanel.add(this.settingsButton);
        this.axisButton = new JButton();
        this.axisButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_axis.gif")));
        this.axisButton.setMargin(this.noMargin);
        this.axisButton.setBounds(2, 365, 36, 36);
        this.axisButton.setToolTipText("Axis settings");
        this.axisButton.addActionListener(this);
        this.buttonPanel.add(this.axisButton);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_load_settings.gif")));
        this.loadButton.setToolTipText("Load settings");
        this.loadButton.setMargin(this.noMargin);
        this.loadButton.setBounds(2, 410, 36, 36);
        this.loadButton.addActionListener(this);
        this.buttonPanel.add(this.loadButton);
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_save_settings.gif")));
        this.saveButton.setToolTipText("Save settings");
        this.saveButton.setMargin(this.noMargin);
        this.saveButton.setBounds(2, 445, 36, 36);
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_print.gif")));
        this.printButton.setToolTipText("Print Image");
        this.printButton.setMargin(this.noMargin);
        this.printButton.setBounds(2, 490, 36, 36);
        this.printButton.addActionListener(this);
        this.buttonPanel.add(this.printButton);
    }

    protected void initGradient() {
        this.gradientTool = new JGradientViewer();
        this.gradientTool.getAxis().setMinimum(0.0);
        this.gradientTool.getAxis().setMaximum(65536.0);
        this.add((Component)this.gradientTool, "East");
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
    }

    protected void initStatusLine() {
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 50));
        this.add((Component)this.cfgPanel, "South");
        this.panelFont = new Font("Dialog", 0, 11);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 3, 220, 20);
        this.cfgPanel.add(this.statusLabel);
        this.rangeLabel = new JLabel("");
        this.rangeLabel.setFont(this.panelFont);
        this.rangeLabel.setBounds(235, 3, 300, 20);
        this.cfgPanel.add(this.rangeLabel);
        this.avgLabel = new JLabel("");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setBounds(235, 25, 300, 20);
        this.cfgPanel.add(this.avgLabel);
        this.selLabel = new JLabel("Selection");
        this.selLabel.setFont(this.panelFont);
        this.selLabel.setBounds(5, 25, 55, 20);
        this.cfgPanel.add(this.selLabel);
        this.selText = new JTextField("None");
        this.selText.setMargin(this.noMargin);
        this.selText.setFont(this.panelFont);
        this.selText.setBounds(65, 25, 160, 20);
        this.selText.addKeyListener(this);
        this.cfgPanel.add(this.selText);
    }

    protected void initPopupMenu() {
        this.imgMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Image Viewer");
        this.infoMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.showGradMenuItem = new JCheckBoxMenuItem("Show gradient");
        this.showGradMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.selectionColorMenuItem = new JMenuItem("Selection Color...");
        this.selectionColorMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.zoomMenuItem = new JMenuItem("Zoom selection");
        this.zoomMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.loadMenuItem = new JMenuItem("Load settings");
        this.loadMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem("Save settings");
        this.saveMenuItem.addActionListener(this);
        this.saveDataFileMenuItem = new JMenuItem("Save data file");
        this.saveDataFileMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print image");
        this.printMenuItem.addActionListener(this);
        this.displayLogMenuItem = new JCheckBoxMenuItem("Display log values");
        this.displayLogMenuItem.addActionListener(this);
        this.imgMenu.add(this.infoMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(this.showGradMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.selectionColorMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.zoomMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.loadMenuItem);
        this.imgMenu.add(this.saveMenuItem);
        this.imgMenu.add(this.saveDataFileMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.printMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.displayLogMenuItem);
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equalsIgnoreCase("toolBarVisible")) {
            return "Displays the left toolbar.";
        }
        if (name.equalsIgnoreCase("statusLineVisible")) {
            return "Displays the bottom status line.";
        }
        if (name.equalsIgnoreCase("gradientVisible")) {
            return "Displays the right gradient scale";
        }
        if (name.equalsIgnoreCase("bestFit")) {
            return "Displays the image using the whole color range";
        }
        if (name.equalsIgnoreCase("xAxis")) {
            return JLAxis.getHelpString();
        }
        if (name.equalsIgnoreCase("yAxis")) {
            return JLAxis.getHelpString();
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("toolBarVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setToolbarVisible(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setToolbarVisible(false);
                return true;
            }
            this.showJdrawError(popupErr, "toolBarVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("statusLineVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setStatusLineVisible(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setStatusLineVisible(false);
                return true;
            }
            this.showJdrawError(popupErr, "statusLineVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("gradientVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setGradientVisible(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setGradientVisible(false);
                return true;
            }
            this.showJdrawError(popupErr, "gradientVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("bestFit")) {
            if (value.equalsIgnoreCase("true")) {
                this.setBestFit(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setBestFit(false);
                return true;
            }
            this.showJdrawError(popupErr, "bestFit", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("xAxis")) {
            CfFileReader f;
            if (!value.endsWith("\n")) {
                value = value + "\n";
            }
            if (!(f = new CfFileReader()).parseText(value)) {
                this.showJdrawError(popupErr, "xAxis settings", "Failed to parse given config");
                return false;
            }
            this.getXAxis().applyConfiguration("x", f);
            return true;
        }
        if (name.equalsIgnoreCase("yAxis")) {
            CfFileReader f;
            if (!value.endsWith("\n")) {
                value = value + "\n";
            }
            if (!(f = new CfFileReader()).parseText(value)) {
                this.showJdrawError(popupErr, "yAxis settings", "Failed to parse given config");
                return false;
            }
            this.getYAxis().applyConfiguration("y", f);
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("toolBarVisible")) {
            return this.isToolbarVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("statusLineVisible")) {
            return this.isStatusLineVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("gradientVisible")) {
            return this.isGradientVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("bestFit")) {
            return this.isBestFit() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("xAxis")) {
            return this.getXAxis().getConfiguration("x");
        }
        if (name.equalsIgnoreCase("yAxis")) {
            return this.getYAxis().getConfiguration("y");
        }
        return "";
    }

    protected void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "NumberSpectrumViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public void addRoiListener(IRoiListener l) {
        this.listenerList.add(IRoiListener.class, l);
    }

    public void removeRoiListener(IRoiListener l) {
        this.listenerList.remove(IRoiListener.class, l);
    }

    public void fireRoiChange() {
        IRoiListener[] list = (IRoiListener[])this.listenerList.getListeners(IRoiListener.class);
        RoiEvent w = new RoiEvent(this, this.getSelection());
        for (int i = 0; i < list.length; ++i) {
            list[i].roiChange(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean b) {
        this.isBestFit = b;
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBestFit(boolean b) {
        this.autoBestFit = b;
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isAutoBestFit() {
        return this.autoBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFitMinMax(double min, double max) {
        if (min < max) {
            this.bfMin = min;
            this.bfMax = max;
        }
        if (!this.autoBestFit) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.convertImage();
                if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                    this.buildZoom();
                }
            }
        }
    }

    public double getBestFitMin() {
        return this.bfMin;
    }

    public double getBestFitMax() {
        return this.bfMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient g) {
        this.gColor = g;
        this.gColormap = g.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.gradientTool.repaint();
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean b) {
        this.isNegative = b;
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setToolbarVisible(boolean b) {
        this.buttonView.setVisible(b);
    }

    public boolean isToolbarVisible() {
        return this.buttonView.isVisible();
    }

    public void setStatusLineVisible(boolean b) {
        this.cfgPanel.setVisible(b);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public void setGradientVisible(boolean b) {
        this.gradientTool.setVisible(b);
    }

    public boolean isGradientVisible() {
        return this.gradientTool.isVisible();
    }

    public void setShowingMenu(boolean b) {
        this.showingMenu = b;
    }

    public void setZoom(int zoomIndex) {
        switch (zoomIndex) {
            case 0: {
                this.iSz = -8;
                break;
            }
            case 1: {
                this.iSz = -4;
                break;
            }
            case 2: {
                this.iSz = -2;
                break;
            }
            case 3: {
                this.iSz = 1;
                break;
            }
            case 4: {
                this.iSz = 2;
                break;
            }
            case 5: {
                this.iSz = 4;
                break;
            }
            case 6: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
            }
        }
        this.userZoom = true;
    }

    public int getZoom() {
        int s = 0;
        switch (this.iSz) {
            case -8: {
                s = 0;
                break;
            }
            case -4: {
                s = 1;
                break;
            }
            case -2: {
                s = 2;
                break;
            }
            case 1: {
                s = 3;
                break;
            }
            case 2: {
                s = 4;
                break;
            }
            case 4: {
                s = 5;
                break;
            }
            case 8: {
                s = 6;
            }
        }
        return s;
    }

    public void setAutoZoom(boolean auto) {
        this.autoZoom = auto;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets i) {
        this.imagePanel.setMargin(i);
    }

    public Dimension getCurrentImageSize() {
        if (this.doubleValues == null) {
            return new Dimension(0, 0);
        }
        int y = this.doubleValues.length;
        if (y == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.doubleValues[0].length, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle r) {
        if (this.imagePanel.getImagePlus() != null) {
            this.imagePanel.getImagePlus().setRoi(r);
        }
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.refreshComponents();
        }
    }

    public Rectangle getSelection() {
        Rectangle r = null;
        if (this.imagePanel.getImagePlus() != null && this.imagePanel.getImagePlus().getRoi() != null) {
            r = this.imagePanel.getImagePlus().getRoi().getBounds();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[][] v) {
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.doubleValues = v;
            this.computeVerticalExtent();
            this.computeAutoZoom();
            this.convertImage();
            this.refreshComponents();
        }
        if (this.doubleValues == null) {
            this.imagePanel.setImage(null);
            this.freePopup();
        }
        this.imagePanel.revalidate();
        this.imagePanel.repaint();
    }

    public void loadImage(String fileName) throws IOException {
        File in = new File(fileName);
        BufferedImage img = ImageIO.read(in);
        int w = img.getWidth();
        int h = img.getHeight();
        int[] tmpArray = new int[w];
        double[][] newValues = new double[h][w];
        for (int i = 0; i < h; ++i) {
            img.getRGB(0, i, w, 1, tmpArray, 0, w);
            for (int j = 0; j < w; ++j) {
                newValues[i][j] = (tmpArray[j] & 0xFF00) >> 8;
            }
        }
        this.setData(newValues);
    }

    public JImageJ getImagePanel() {
        return this.imagePanel;
    }

    public JLAxis getXAxis() {
        return this.imagePanel.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.imagePanel.getYAxis();
    }

    public JLAxis getGradientAxis() {
        return this.gradientTool.getAxis();
    }

    public int getImageXCoord(int x) {
        return x - this.imagePanel.getXOrigin();
    }

    public int getImageYCoord(int y) {
        return y - this.imagePanel.getYOrigin();
    }

    public void setVerticalExtent(int ratio) {
        this.verticalExtent = ratio;
    }

    protected void adjustToolbarSize() {
        if (this.buttonView.isVisible()) {
            this.buttonView.setPreferredSize(new Dimension(60, 0));
        }
        this.revalidate();
    }

    protected void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.zoomDialog != null) {
            this.zoomImage.setImage(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    protected double[] buildProfileData() {
        Roi tmpRoi = this.imagePanel.getImagePlus().getRoi();
        if (tmpRoi != null && tmpRoi instanceof Line) {
            return ((Line)tmpRoi).getPixels();
        }
        return null;
    }

    protected double[] buildHistogramData() {
        if (this.doubleValues == null) {
            return null;
        }
        double[] histo = new double[65536];
        this.startHisto = 0;
        Rectangle r = this.imagePanel.getCurrentRoiBounds();
        if (r != null) {
            int i;
            for (i = 0; i < 65536; ++i) {
                histo[i] = 0.0;
            }
            try {
                for (i = r.x; i < r.x + r.width; ++i) {
                    for (int j = r.y; j < r.y + r.height; ++j) {
                        int n = (int)this.doubleValues[j][i];
                        histo[n] = histo[n] + 1.0;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
                return null;
            }
            if (!this.sigHistogram) {
                return histo;
            }
            int i1 = 0;
            int i2 = 65535;
            boolean found = false;
            while (i1 < 65536 && !found) {
                found = histo[i1] > 0.0;
                if (found) continue;
                ++i1;
            }
            found = false;
            while (i2 >= 0 && !found) {
                found = histo[i2] > 0.0;
                if (found) continue;
                --i2;
            }
            int nb = i2 - i1 + 1;
            double[] nhisto = new double[nb];
            for (i = 0; i < nb; ++i) {
                nhisto[i] = histo[i1 + i];
            }
            this.startHisto = i1;
            return nhisto;
        }
        return null;
    }

    protected void refreshLineProfile() {
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            switch (this.profileMode) {
                case 1: {
                    this.lineProfiler.setData(this.buildProfileData());
                    break;
                }
                case 2: {
                    double[] v = this.buildHistogramData();
                    if (v != null) {
                        this.lineProfiler.setData(v, this.startHisto);
                        break;
                    }
                    this.lineProfiler.setData(null);
                }
            }
        }
    }

    protected void refreshSelectionMinMax() {
        double v;
        int i;
        int j;
        if (this.doubleValues == null) {
            this.rangeLabel.setText("");
            this.avgLabel.setText("");
            return;
        }
        Rectangle r = this.imagePanel.getCurrentRoiBounds();
        if (r == null) {
            this.rangeLabel.setText("");
            return;
        }
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        double sum = 0.0;
        double sum2 = 0.0;
        double lgth = 0.0;
        double avg = 0.0;
        double std = 0.0;
        Dimension size = this.imagePanel.getImageSize();
        for (j = Math.max(r.y, 0); j < r.y + r.height && j < size.height; ++j) {
            for (i = Math.max(r.x, 0); i < r.x + r.width && i < size.width; ++i) {
                v = this.doubleValues[j][i];
                if (v > this.curSelMax) {
                    this.curSelMax = v;
                }
                if (v < this.curSelMin) {
                    this.curSelMin = v;
                }
                sum += v;
                lgth += 1.0;
            }
        }
        avg = sum / lgth;
        for (j = Math.max(r.y, 0); j < r.y + r.height && j < size.height; ++j) {
            for (i = Math.max(r.x, 0); i < r.x + r.width && i < size.width; ++i) {
                v = this.doubleValues[j][i];
                sum2 += (v - avg) * (v - avg);
            }
        }
        std = Math.sqrt(sum2 / lgth);
        size = null;
        Double avgD = new Double(avg);
        Double stdD = new Double(std);
        this.avgLabel.setText("Average: " + String.format("%.2f", avgD) + "  Std deviation: " + String.format("%.2f", stdD));
        if (this.curSelMin <= this.curSelMax) {
            this.rangeLabel.setText("Range: " + Double.toString(this.curSelMin) + " , " + Double.toString(this.curSelMax));
        } else {
            this.rangeLabel.setText("");
        }
    }

    protected void refreshComponents() {
        this.refreshSelectionMinMax();
        this.refreshLineProfile();
        if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
            this.buildZoom();
            this.zoomView.revalidate();
            this.zoomPanel.repaint();
        }
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectionChanged() {
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.refreshComponents();
            this.imagePanel.repaint();
        }
        this.fireRoiChange();
    }

    protected void refreshStatusLine() {
        String selStr = "None";
        Roi tmpRoi = this.imagePanel.getImagePlus().getRoi();
        if (tmpRoi != null) {
            selStr = tmpRoi.toString();
        }
        this.selText.setText(selStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showZoom() {
        this.constructZoomPanel();
        if (this.zoomDialog.isVisible()) {
            this.zoomDialog.setVisible(true);
            return;
        }
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            if (!this.buildZoom()) {
                return;
            }
        }
        this.zoomCombo.setSelectedIndex(this.zoomFactor);
        this.zoomText.setText("");
        this.zoomDialog.setTitle("[zoom] ImageViewer");
        this.zoomDialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension _scr = toolkit.getScreenSize();
        Dimension _dlg = this.zoomDialog.getPreferredSize();
        this.zoomDialog.setBounds((_scr.width - _dlg.height) / 2, (_scr.height - _dlg.height) / 2, _dlg.width, _dlg.height);
        this.zoomDialog.setVisible(true);
    }

    protected void applySettings() {
        String minStr = this.minBestFitText.getText();
        String maxStr = this.maxBestFitText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.autoBestFit = this.autoBestFitCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.sigHistogram = this.sigHistogramCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        if (!this.autoBestFit) {
            try {
                this.bfMin = Double.parseDouble(minStr);
                this.bfMax = Double.parseDouble(maxStr);
                if (this.bfMin >= this.bfMax) {
                    JOptionPane.showMessageDialog(null, "maximum  best fit value is lower or equal than minimum!", "Error", 0);
                    this.autoBestFit = true;
                    this.bfMin = 0.0;
                    this.bfMax = 65536.0;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Invalid syntax for maximum or minimum best fit value", "Error", 0);
                this.autoBestFit = true;
                this.bfMin = 0.0;
                this.bfMax = 65536.0;
            }
        }
        this.settingsDialog.setVisible(false);
    }

    public void saveSetting(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            String s = this.getSettings();
            f.write(s, 0, s.length());
            f.close();
            this.lastConfig = filename;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to write " + filename, "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        String to_write = "";
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            to_write = to_write + "minBestFitText:'" + this.minBestFitText.getText() + "'\n";
            to_write = to_write + "maxBestFitText:'" + this.maxBestFitText.getText() + "'\n";
            to_write = to_write + "isBestFit:'" + this.bestFitCheck.isSelected() + "'\n";
            to_write = to_write + "autoBestFit:'" + this.autoBestFitCheck.isSelected() + "'\n";
            to_write = to_write + "isNegative:'" + this.negativeCheck.isSelected() + "'\n";
            to_write = to_write + "sigHistogram:'" + this.sigHistogramCheck.isSelected() + "'\n";
            to_write = to_write + "zoom:'" + this.imageSizeCombo.getSelectedIndex() + "'\n";
            to_write = to_write + "toolBarVisible:'" + this.toolbarMenuItem.isSelected() + "'\n";
            to_write = to_write + "statusLineVisible:'" + this.statusLineMenuItem.isSelected() + "'\n";
            int gradientCount = this.gColor.getEntryNumber();
            to_write = to_write + "gradientCount:'" + gradientCount + "'\n";
            for (int i = 0; i < gradientCount; ++i) {
                Color gradientColor = this.gColor.getColorAt(i);
                to_write = to_write + "gradientColor_" + i + "_red:'" + gradientColor.getRed() + "'\n";
                to_write = to_write + "gradientColor_" + i + "_green:'" + gradientColor.getGreen() + "'\n";
                to_write = to_write + "gradientColor_" + i + "_blue:'" + gradientColor.getBlue() + "'\n";
                to_write = to_write + "gradientPos_" + i + ":'" + this.gColor.getPosAt(i) + "'\n";
                gradientColor = null;
            }
        }
        return to_write;
    }

    public String loadSetting(String filename) {
        CfFileReader f = new CfFileReader();
        if (!f.readFile(filename)) {
            return "Failed to read " + filename;
        }
        this.lastConfig = filename;
        return this.applySettings(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applySettings(CfFileReader f) {
        this.constructSettingsPanel();
        String errBuff = "";
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            int i;
            String minBFText = this.minBestFitText.getText();
            String maxBFText = this.maxBestFitText.getText();
            boolean isBestFit = this.bestFitCheck.isSelected();
            boolean autoBestFit = this.autoBestFitCheck.isSelected();
            boolean isNegative = this.negativeCheck.isSelected();
            boolean sigHistogram = this.sigHistogramCheck.isSelected();
            int zoom = this.imageSizeCombo.getSelectedIndex();
            boolean toolBarVisible = this.toolbarMenuItem.isSelected();
            boolean statusLineVisible = this.statusLineMenuItem.isSelected();
            int gradientCount = 0;
            Vector<String> param = f.getParam("minBestFitText");
            if (param == null) {
                errBuff = errBuff + "Unable to find minBestFitText";
                return errBuff;
            }
            this.minBestFitText.setText(param.get(0).toString());
            param = f.getParam("maxBestFitText");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                errBuff = errBuff + "Unable to find maxBestFitText";
                return errBuff;
            }
            this.maxBestFitText.setText(param.get(0).toString());
            param = f.getParam("isBestFit");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                errBuff = errBuff + "Unable to find isBestFit";
                return errBuff;
            }
            this.bestFitCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("autoBestFit");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                errBuff = errBuff + "Unable to find autoBestFit";
                return errBuff;
            }
            this.autoBestFitCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("isNegative");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                errBuff = errBuff + "Unable to find isNegative";
                return errBuff;
            }
            this.negativeCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("sigHistogram");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                errBuff = errBuff + "Unable to find sigHistogram";
                return errBuff;
            }
            this.sigHistogramCheck.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("zoom");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                errBuff = errBuff + "Unable to find zoom";
                return errBuff;
            }
            try {
                int histoSelection = Integer.parseInt(param.get(0).toString());
                this.imageSizeCombo.setSelectedIndex(histoSelection);
            }
            catch (NumberFormatException e) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                errBuff = errBuff + "zoom: invalid number\n";
                return errBuff;
            }
            param = f.getParam("toolBarVisible");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                errBuff = errBuff + "Unable to find toolBarVisible";
                return errBuff;
            }
            this.toolbarMenuItem.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("statusLineVisible");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                this.toolbarMenuItem.setSelected(toolBarVisible);
                errBuff = errBuff + "Unable to find statusLineVisible";
                return errBuff;
            }
            this.statusLineMenuItem.setSelected("true".equalsIgnoreCase(param.get(0).toString().trim()));
            param = f.getParam("gradientCount");
            if (param == null) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                this.toolbarMenuItem.setSelected(toolBarVisible);
                this.statusLineMenuItem.setSelected(statusLineVisible);
                errBuff = errBuff + "Unable to find gradientCount";
                return errBuff;
            }
            try {
                gradientCount = Integer.parseInt(param.get(0).toString());
            }
            catch (NumberFormatException nfe) {
                this.minBestFitText.setText(minBFText);
                this.maxBestFitText.setText(maxBFText);
                this.bestFitCheck.setSelected(isBestFit);
                this.autoBestFitCheck.setSelected(autoBestFit);
                this.negativeCheck.setSelected(isNegative);
                this.sigHistogramCheck.setSelected(sigHistogram);
                this.imageSizeCombo.setSelectedIndex(zoom);
                this.toolbarMenuItem.setSelected(toolBarVisible);
                this.statusLineMenuItem.setSelected(statusLineVisible);
                errBuff = errBuff + "gradientCount: invalid number";
                return errBuff;
            }
            Color[] gradientColor = new Color[gradientCount];
            double[] gradientPos = new double[gradientCount];
            for (i = 0; i < gradientCount; ++i) {
                double pos;
                int blue;
                int green;
                int red;
                param = f.getParam("gradientColor_" + i + "_red");
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientColor_" + i + "_red";
                    return errBuff;
                }
                try {
                    red = Integer.parseInt(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientColor_" + i + "_red: invalid number";
                    return errBuff;
                }
                param = f.getParam("gradientColor_" + i + "_green");
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientColor_" + i + "_green";
                    return errBuff;
                }
                try {
                    green = Integer.parseInt(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientColor_" + i + "_green: invalid number";
                    return errBuff;
                }
                param = f.getParam("gradientColor_" + i + "_blue");
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientColor_" + i + "_blue";
                    return errBuff;
                }
                try {
                    blue = Integer.parseInt(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientColor_" + i + "_blue: invalid number";
                    return errBuff;
                }
                param = f.getParam("gradientPos_" + i);
                if (param == null) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "Unable to find gradientPos_" + i;
                    return errBuff;
                }
                try {
                    pos = Double.parseDouble(param.get(0).toString());
                }
                catch (NumberFormatException nfe) {
                    this.minBestFitText.setText(minBFText);
                    this.maxBestFitText.setText(maxBFText);
                    this.bestFitCheck.setSelected(isBestFit);
                    this.autoBestFitCheck.setSelected(autoBestFit);
                    this.negativeCheck.setSelected(isNegative);
                    this.sigHistogramCheck.setSelected(sigHistogram);
                    this.imageSizeCombo.setSelectedIndex(zoom);
                    this.toolbarMenuItem.setSelected(toolBarVisible);
                    this.statusLineMenuItem.setSelected(statusLineVisible);
                    errBuff = errBuff + "gradientPos_" + i + ": invalid number";
                    return errBuff;
                }
                gradientColor[i] = new Color(red, green, blue);
                gradientPos[i] = pos;
            }
            this.gColor = new Gradient();
            if (gradientCount == 5) {
                this.gColor.buildRainbowGradient();
            }
            for (i = 0; i < gradientCount; ++i) {
                this.gColor.setColorAt(i, gradientColor[i]);
                this.gColor.setPosAt(i, gradientPos[i]);
            }
            this.gColormap = this.gColor.buildColorMap(65536);
            this.applySettings();
            this.setToolbarVisible(this.toolbarMenuItem.isSelected());
            this.setStatusLineVisible(this.statusLineMenuItem.isSelected());
            this.convertImage();
            this.refreshComponents();
        }
        return errBuff;
    }

    protected void saveButtonActionPerformed() {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(f) == null) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                this.saveSetting(f.getAbsolutePath());
            }
        }
    }

    protected void loadButtonActionPerformed() {
        String err;
        File f;
        int returnVal;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null && !ok && (err = this.loadSetting(f.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this, err, "Errors reading " + f.getName(), 0);
        }
    }

    protected void showAxisDialog() {
        if (this.axisDialog == null) {
            Window parent = ATKGraphicsUtils.getWindowForComponent(this);
            this.axisDialog = parent instanceof Frame ? new JDialog((Frame)parent, false) : (parent instanceof Dialog ? new JDialog((Dialog)parent, false) : new JDialog((Frame)null, false));
            this.axisDialog.setTitle("Axis settings");
            JPanel innerPanel = new JPanel(null);
            this.tabPane = new JTabbedPane();
            this.xAxisPanel = new AxisPanel(this.getXAxis(), 3, null);
            this.yAxisPanel = new AxisPanel(this.getYAxis(), 1, null);
            this.tabPane.add("X axis", this.xAxisPanel);
            this.tabPane.add("Y axis", this.yAxisPanel);
            this.tabPane.setBounds(5, 5, 300, 370);
            innerPanel.add(this.tabPane);
            this.axisCloseButton = new JButton("Close");
            this.axisCloseButton.setFont(ATKConstant.labelFont);
            this.axisCloseButton.setBounds(225, 380, 80, 25);
            innerPanel.add(this.axisCloseButton);
            this.axisCloseButton.addActionListener(this);
            innerPanel.setPreferredSize(new Dimension(310, 410));
            this.tabPane.setBounds(5, 5, 300, 370);
            this.axisDialog.setContentPane(innerPanel);
            this.axisDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    NumberImageJViewer.this.imagePanel.getImageRenderer().revalidate();
                    NumberImageJViewer.this.imagePanel.revalidate();
                }
            });
        }
        ATKGraphicsUtils.centerDialog(this.axisDialog);
        this.axisDialog.setVisible(true);
    }

    private void initSettings() {
        this.minBestFitText.setText(Double.toString(this.bfMin));
        this.maxBestFitText.setText(Double.toString(this.bfMax));
        this.minBestFitLabel.setEnabled(!this.autoBestFit);
        this.minBestFitText.setEnabled(!this.autoBestFit);
        this.maxBestFitLabel.setEnabled(!this.autoBestFit);
        this.maxBestFitText.setEnabled(!this.autoBestFit);
        this.bestFitCheck.setSelected(this.isBestFit);
        this.autoBestFitCheck.setSelected(this.autoBestFit);
        this.sigHistogramCheck.setSelected(this.sigHistogram);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        ATKGraphicsUtils.centerDialog(this.settingsDialog);
        this.settingsDialog.setVisible(true);
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    public double[][] getData(Roi roi) {
        int i;
        int j;
        double[][] result;
        Rectangle imageBounds;
        boolean innerRoi = false;
        if (this.doubleValues == null || this.imagePanel == null || this.imagePanel.getImagePlus() == null) {
            return null;
        }
        if (!this.imagePanel.getImagePlus().getInnerRois().contains(roi) && !this.imagePanel.getImagePlus().getOuterRois().contains(roi)) {
            roi = null;
        }
        if (roi == null || this.imagePanel.getImagePlus().getInnerRois().contains(roi)) {
            innerRoi = true;
        } else if (this.imagePanel.getImagePlus().getOuterRois().contains(roi)) {
            innerRoi = false;
        }
        Dimension d = this.imagePanel.getImageSize();
        Rectangle roiBounds = imageBounds = new Rectangle(0, 0, d.width, d.height);
        d = null;
        if (roi != null) {
            roiBounds = roi.getBounds();
        }
        int roiX = Math.max(roiBounds.x, 0);
        if (imageBounds.width > 0 && roiX > imageBounds.width - 1) {
            roiX = imageBounds.width - 1;
        }
        int roiY = Math.max(roiBounds.y, 0);
        if (imageBounds.height > 0 && roiY > imageBounds.height - 1) {
            roiY = imageBounds.height - 1;
        }
        int roiWidth = Math.min(imageBounds.width - roiX, roiBounds.x + roiBounds.width - roiX);
        int roiHeight = Math.min(imageBounds.height - roiY, roiBounds.y + roiBounds.height - roiY);
        roiBounds.x = roiX;
        roiBounds.y = roiY;
        roiBounds.width = roiWidth;
        roiBounds.height = roiHeight;
        if (innerRoi ? roiBounds.width <= 0 || roiBounds.height <= 0 : imageBounds.width <= 0 || imageBounds.height <= 0) {
            return new double[0][0];
        }
        if (innerRoi) {
            result = new double[roiBounds.height][roiBounds.width];
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    result[j][i] = Double.NaN;
                }
            }
        } else {
            result = new double[imageBounds.height][imageBounds.width];
            for (j = 0; j < imageBounds.height; ++j) {
                for (i = 0; i < imageBounds.width; ++i) {
                    result[j][i] = Double.NaN;
                }
            }
        }
        if (innerRoi) {
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    if (roi != null && !roi.contains(roiBounds.x + i, roiBounds.y + j)) continue;
                    result[j][i] = this.doubleValues[roiBounds.y + j][roiBounds.x + i];
                }
            }
        } else {
            int j2;
            int i2;
            for (i2 = 0; i2 < imageBounds.width; ++i2) {
                for (j2 = 0; j2 < roiBounds.y; ++j2) {
                    result[j2][i2] = this.doubleValues[j2][i2];
                }
            }
            for (i2 = 0; i2 < imageBounds.width; ++i2) {
                for (j2 = roiBounds.y + roiBounds.height; j2 < imageBounds.height; ++j2) {
                    result[j2][i2] = this.doubleValues[j2][i2];
                }
            }
            for (i2 = 0; i2 < roiBounds.x; ++i2) {
                for (j2 = roiBounds.y; j2 < roiBounds.y + roiBounds.height; ++j2) {
                    result[j2][i2] = this.doubleValues[j2][i2];
                }
            }
            for (i2 = roiBounds.x + roiBounds.width; i2 < imageBounds.width; ++i2) {
                for (j2 = roiBounds.y; j2 < roiBounds.y + roiBounds.height; ++j2) {
                    result[j2][i2] = this.doubleValues[j2][i2];
                }
            }
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    int x = roiBounds.x + i;
                    int y = roiBounds.y + j;
                    if (roi.contains(x, y)) continue;
                    result[j][i] = this.doubleValues[y][x];
                }
            }
        }
        return result;
    }

    public double[][] getData(Roi roi, double[][] imageData, boolean innerRoi) {
        int i;
        int j;
        double[][] result;
        int width = 0;
        int height = 0;
        if (imageData == null) {
            imageData = this.doubleValues;
        }
        if (imageData == null) {
            return null;
        }
        if (imageData.length > 0) {
            height = imageData.length;
            width = imageData[0].length;
        }
        Rectangle roiBounds = new Rectangle(0, 0, width, height);
        if (roi != null) {
            roiBounds = roi.getBounds();
        }
        int roiX = Math.max(roiBounds.x, 0);
        if (width > 0 && roiX > width - 1) {
            roiX = width - 1;
        }
        int roiY = Math.max(roiBounds.y, 0);
        if (height > 0 && roiY > height - 1) {
            roiY = height - 1;
        }
        int roiWidth = Math.min(width - roiX, roiBounds.x + roiBounds.width - roiX);
        int roiHeight = Math.min(height - roiY, roiBounds.y + roiBounds.height - roiY);
        roiBounds.x = roiX;
        roiBounds.y = roiY;
        roiBounds.width = roiWidth;
        roiBounds.height = roiHeight;
        if (innerRoi ? roiBounds.width <= 0 || roiBounds.height <= 0 : width <= 0 || height <= 0) {
            return new double[0][0];
        }
        if (innerRoi) {
            result = new double[roiBounds.height][roiBounds.width];
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    result[j][i] = Double.NaN;
                }
            }
        } else {
            result = new double[height][width];
            for (j = 0; j < height; ++j) {
                for (i = 0; i < width; ++i) {
                    result[j][i] = Double.NaN;
                }
            }
        }
        if (innerRoi) {
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    if (roi != null && !roi.contains(roiBounds.x + i, roiBounds.y + j)) continue;
                    result[j][i] = imageData[roiBounds.y + j][roiBounds.x + i];
                }
            }
        } else {
            int j2;
            int i2;
            for (i2 = 0; i2 < width; ++i2) {
                for (j2 = 0; j2 < roiBounds.y; ++j2) {
                    result[j2][i2] = imageData[j2][i2];
                }
            }
            for (i2 = 0; i2 < width; ++i2) {
                for (j2 = roiBounds.y + roiBounds.height; j2 < height; ++j2) {
                    result[j2][i2] = imageData[j2][i2];
                }
            }
            for (i2 = 0; i2 < roiBounds.x; ++i2) {
                for (j2 = roiBounds.y; j2 < roiBounds.y + roiBounds.height; ++j2) {
                    result[j2][i2] = imageData[j2][i2];
                }
            }
            for (i2 = roiBounds.x + roiBounds.width; i2 < width; ++i2) {
                for (j2 = roiBounds.y; j2 < roiBounds.y + roiBounds.height; ++j2) {
                    result[j2][i2] = imageData[j2][i2];
                }
            }
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    int x = roiBounds.x + i;
                    int y = roiBounds.y + j;
                    if (roi.contains(x, y)) continue;
                    result[j][i] = imageData[y][x];
                }
            }
        }
        return result;
    }

    protected boolean buildTable() {
        int i;
        int j;
        Object[][] stringData;
        Rectangle imageBounds;
        boolean innerRoi = false;
        if (this.doubleValues == null || this.imagePanel == null || this.imagePanel.getImagePlus() == null) {
            return false;
        }
        Roi roi = this.imagePanel.getImagePlus().getValidatedRoi();
        if (roi == null) {
            innerRoi = true;
        } else if (this.imagePanel.getImagePlus().getInnerRois().contains(roi)) {
            innerRoi = true;
        } else if (this.imagePanel.getImagePlus().getOuterRois().contains(roi)) {
            innerRoi = false;
        } else {
            roi = null;
            innerRoi = true;
        }
        Dimension d = this.imagePanel.getImageSize();
        Rectangle roiBounds = imageBounds = new Rectangle(0, 0, d.width, d.height);
        d = null;
        if (roi != null) {
            roiBounds = roi.getBounds();
        }
        int roiX = Math.max(roiBounds.x, 0);
        if (imageBounds.width > 0 && roiX > imageBounds.width - 1) {
            roiX = imageBounds.width - 1;
        }
        int roiY = Math.max(roiBounds.y, 0);
        if (imageBounds.height > 0 && roiY > imageBounds.height - 1) {
            roiY = imageBounds.height - 1;
        }
        int roiWidth = Math.min(imageBounds.width - roiX, roiBounds.x + roiBounds.width - roiX);
        int roiHeight = Math.min(imageBounds.height - roiY, roiBounds.y + roiBounds.height - roiY);
        roiBounds.x = roiX;
        roiBounds.y = roiY;
        roiBounds.width = roiWidth;
        roiBounds.height = roiHeight;
        if (innerRoi) {
            stringData = new String[roiBounds.height][roiBounds.width];
            for (j = 0; j < roiBounds.height; ++j) {
                for (i = 0; i < roiBounds.width; ++i) {
                    stringData[j][i] = "NaN";
                }
            }
        } else {
            stringData = new String[imageBounds.height][imageBounds.width];
            for (j = 0; j < imageBounds.height; ++j) {
                for (i = 0; i < imageBounds.width; ++i) {
                    stringData[j][i] = "NaN";
                }
            }
        }
        String attFormat = null;
        if (this.model != null) {
            attFormat = this.model.getFormat();
        }
        if (attFormat != null && attFormat.length() > 0) {
            if (attFormat.indexOf(37) == -1) {
                if (innerRoi) {
                    for (int j2 = 0; j2 < roiBounds.height; ++j2) {
                        for (int i2 = 0; i2 < roiBounds.width; ++i2) {
                            if (roi != null && !roi.contains(roiBounds.x + i2, roiBounds.y + j2)) continue;
                            double tmp = this.doubleValues[roiBounds.y + j2][roiBounds.x + i2];
                            stringData[j2][i2] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : AttrManip.format((String)attFormat, (double)tmp);
                        }
                    }
                } else {
                    int j3;
                    int i3;
                    for (i3 = 0; i3 < imageBounds.width; ++i3) {
                        for (j3 = 0; j3 < roiBounds.y; ++j3) {
                            double tmp = this.doubleValues[j3][i3];
                            stringData[j3][i3] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : AttrManip.format((String)attFormat, (double)tmp);
                        }
                    }
                    for (i3 = 0; i3 < imageBounds.width; ++i3) {
                        for (j3 = roiBounds.y + roiBounds.height; j3 < imageBounds.height; ++j3) {
                            double tmp = this.doubleValues[j3][i3];
                            stringData[j3][i3] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : AttrManip.format((String)attFormat, (double)tmp);
                        }
                    }
                    for (i3 = 0; i3 < roiBounds.x; ++i3) {
                        for (j3 = roiBounds.y; j3 < roiBounds.y + roiBounds.height; ++j3) {
                            double tmp = this.doubleValues[j3][i3];
                            stringData[j3][i3] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : AttrManip.format((String)attFormat, (double)tmp);
                        }
                    }
                    for (i3 = roiBounds.x + roiBounds.width; i3 < imageBounds.width; ++i3) {
                        for (j3 = roiBounds.y; j3 < roiBounds.y + roiBounds.height; ++j3) {
                            double tmp = this.doubleValues[j3][i3];
                            stringData[j3][i3] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : AttrManip.format((String)attFormat, (double)tmp);
                        }
                    }
                    for (int j4 = 0; j4 < roiBounds.height; ++j4) {
                        for (int i4 = 0; i4 < roiBounds.width; ++i4) {
                            int x = roiBounds.x + i4;
                            int y = roiBounds.y + j4;
                            if (roi.contains(x, y)) continue;
                            double tmp = this.doubleValues[y][x];
                            stringData[y][x] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : AttrManip.format((String)attFormat, (double)tmp);
                        }
                    }
                }
            } else if (innerRoi) {
                for (int j5 = 0; j5 < roiBounds.height; ++j5) {
                    for (int i5 = 0; i5 < roiBounds.width; ++i5) {
                        if (roi != null && !roi.contains(roiBounds.x + i5, roiBounds.y + j5)) continue;
                        double tmp = this.doubleValues[roiBounds.y + j5][roiBounds.x + i5];
                        stringData[j5][i5] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
            } else {
                int j6;
                int i6;
                for (i6 = 0; i6 < imageBounds.width; ++i6) {
                    for (j6 = 0; j6 < roiBounds.y; ++j6) {
                        double tmp = this.doubleValues[j6][i6];
                        stringData[j6][i6] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
                for (i6 = 0; i6 < imageBounds.width; ++i6) {
                    for (j6 = roiBounds.y + roiBounds.height; j6 < imageBounds.height; ++j6) {
                        double tmp = this.doubleValues[j6][i6];
                        stringData[j6][i6] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
                for (i6 = 0; i6 < roiBounds.x; ++i6) {
                    for (j6 = roiBounds.y; j6 < roiBounds.y + roiBounds.height; ++j6) {
                        double tmp = this.doubleValues[j6][i6];
                        stringData[j6][i6] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
                for (i6 = roiBounds.x + roiBounds.width; i6 < imageBounds.width; ++i6) {
                    for (j6 = roiBounds.y; j6 < roiBounds.y + roiBounds.height; ++j6) {
                        double tmp = this.doubleValues[j6][i6];
                        stringData[j6][i6] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
                for (int j7 = 0; j7 < roiBounds.height; ++j7) {
                    for (int i7 = 0; i7 < roiBounds.width; ++i7) {
                        int x = roiBounds.x + i7;
                        int y = roiBounds.y + j7;
                        if (roi.contains(x, y)) continue;
                        double tmp = this.doubleValues[y][x];
                        stringData[y][x] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? Double.toString(tmp) : ATKFormat.format(attFormat, tmp);
                    }
                }
            }
        } else if (innerRoi) {
            for (int j8 = 0; j8 < roiBounds.height; ++j8) {
                for (int i8 = 0; i8 < roiBounds.width; ++i8) {
                    if (roi != null && !roi.contains(roiBounds.x + i8, roiBounds.y + j8)) continue;
                    stringData[j8][i8] = Double.toString(this.doubleValues[roiBounds.y + j8][roiBounds.x + i8]);
                }
            }
        } else {
            int j9;
            int i9;
            for (i9 = 0; i9 < imageBounds.width; ++i9) {
                for (j9 = 0; j9 < roiBounds.y; ++j9) {
                    stringData[j9][i9] = Double.toString(this.doubleValues[j9][i9]);
                }
            }
            for (i9 = 0; i9 < imageBounds.width; ++i9) {
                for (j9 = roiBounds.y + roiBounds.height; j9 < imageBounds.height; ++j9) {
                    stringData[j9][i9] = Double.toString(this.doubleValues[j9][i9]);
                }
            }
            for (i9 = 0; i9 < roiBounds.x; ++i9) {
                for (j9 = roiBounds.y; j9 < roiBounds.y + roiBounds.height; ++j9) {
                    stringData[j9][i9] = Double.toString(this.doubleValues[j9][i9]);
                }
            }
            for (i9 = roiBounds.x + roiBounds.width; i9 < imageBounds.width; ++i9) {
                for (j9 = roiBounds.y; j9 < roiBounds.y + roiBounds.height; ++j9) {
                    stringData[j9][i9] = Double.toString(this.doubleValues[j9][i9]);
                }
            }
            for (int j10 = 0; j10 < roiBounds.height; ++j10) {
                for (int i10 = 0; i10 < roiBounds.width; ++i10) {
                    int x = roiBounds.x + i10;
                    int y = roiBounds.y + j10;
                    if (roi.contains(x, y)) continue;
                    stringData[j10][i10] = Double.toString(this.doubleValues[y][x]);
                }
            }
        }
        if (innerRoi) {
            this.tablePanel.setData(stringData, roiBounds.x, roiBounds.y);
        } else {
            this.tablePanel.setData(stringData, 0, 0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    protected void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel(this.model);
            this.propDialog.setVisible(true);
        }
    }

    protected void showGradientEditor() {
        Gradient g = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (g != null) {
            this.gColor = g;
            this.gColormap = g.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
            this.gradientTool.setGradient(this.gColor);
            this.gradientTool.repaint();
        }
    }

    protected void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer();
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberImageJViewer.this.lineProfiler.setData(null);
                    NumberImageJViewer.this.lineProfiler.dispose();
                }
            });
        }
    }

    protected void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberImageJViewer.this.tablePanel.clearData();
                    NumberImageJViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    protected void constructZoomPanel() {
        if (this.zoomDialog == null) {
            this.zoomPanel = new JPanel(new BorderLayout());
            this.zoomImage = new JImage();
            this.zoomImage.setSelectionEnabled(false);
            this.zoomImage.setMargin(new Insets(2, 2, 2, 2));
            this.zoomImage.setImage(null);
            this.zoomView = new JScrollPane(this.zoomImage);
            this.zoomPanel.add((Component)this.zoomView, "Center");
            this.zoomCfgPanel = new JPanel();
            this.zoomCfgPanel.setLayout(null);
            this.zoomCfgPanel.setPreferredSize(new Dimension(0, 25));
            this.zoomCombo = new JComboBox();
            this.zoomCombo.setFont(this.panelFont);
            this.zoomCombo.addItem("Zoom 100%");
            this.zoomCombo.addItem("Zoom 200%");
            this.zoomCombo.addItem("Zoom 300%");
            this.zoomCombo.addItem("Zoom 400%");
            this.zoomCombo.addItem("Zoom 500%");
            this.zoomCombo.addItem("Zoom 600%");
            this.zoomCombo.addItem("Zoom 700%");
            this.zoomCombo.addItem("Zoom 800%");
            this.zoomCombo.setEditable(false);
            this.zoomCombo.setBounds(5, 3, 120, 20);
            this.zoomCombo.addActionListener(this);
            this.zoomCfgPanel.add(this.zoomCombo);
            this.zoomText = new JLabel("");
            this.zoomText.setFont(this.panelFont);
            this.zoomText.setBounds(130, 3, 500, 20);
            this.zoomCfgPanel.add(this.zoomText);
            this.zoomPanel.add((Component)this.zoomCfgPanel, "South");
            this.zoomDialog = new JFrame();
            this.zoomDialog.setContentPane(this.zoomPanel);
            this.zoomDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberImageJViewer.this.zoomImage.setImage(null);
                    NumberImageJViewer.this.zoomDialog.dispose();
                }
            });
            this.zoomImage.addMouseMotionListener(this);
        }
    }

    protected void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 245));
            this.settingsPanel.setPreferredSize(new Dimension(290, 245));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel(this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator js = new JSeparator();
            js.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(js);
            this.autoBestFitCheck = new JCheckBox("Best fit");
            this.autoBestFitCheck.setSelected(true);
            this.autoBestFitCheck.setFont(this.panelFont);
            this.autoBestFitCheck.setBounds(5, 50, 100, 20);
            this.autoBestFitCheck.setToolTipText("Generate the best fit display using maximum and minimum value of the image");
            this.autoBestFitCheck.addActionListener(this);
            this.settingsPanel.add(this.autoBestFitCheck);
            this.bestFitCheck = new JCheckBox("Enable fitting");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(120, 50, 105, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.settingsPanel.add(this.bestFitCheck);
            this.minBestFitLabel = new JLabel("Fit Min");
            this.minBestFitLabel.setFont(this.panelFont);
            this.minBestFitLabel.setBounds(5, 75, 80, 20);
            this.settingsPanel.add(this.minBestFitLabel);
            this.minBestFitText = new JTextField("");
            this.minBestFitText.setMargin(this.noMargin);
            this.minBestFitText.setFont(this.panelFont);
            this.minBestFitText.setBounds(90, 75, 50, 20);
            this.settingsPanel.add(this.minBestFitText);
            this.maxBestFitLabel = new JLabel("Fit Max");
            this.maxBestFitLabel.setFont(this.panelFont);
            this.maxBestFitLabel.setBounds(145, 75, 80, 20);
            this.maxBestFitLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.maxBestFitLabel);
            this.maxBestFitText = new JTextField("");
            this.maxBestFitText.setMargin(this.noMargin);
            this.maxBestFitText.setFont(this.panelFont);
            this.maxBestFitText.setBounds(230, 75, 50, 20);
            this.settingsPanel.add(this.maxBestFitText);
            this.gradLabel = new JLabel("Colormap");
            this.gradLabel.setFont(this.panelFont);
            this.gradLabel.setBounds(5, 100, 70, 20);
            this.settingsPanel.add(this.gradLabel);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 100, 180, 20);
            this.settingsPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 100, 20, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 125, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            this.settingsPanel.add(this.negativeCheck);
            this.imageSizeLabel = new JLabel("Image size");
            this.imageSizeLabel.setFont(this.panelFont);
            this.imageSizeLabel.setBounds(115, 125, 85, 20);
            this.imageSizeLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.imageSizeLabel);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("800  %");
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 125, 80, 22);
            this.settingsPanel.add(this.imageSizeCombo);
            JSeparator js2 = new JSeparator();
            js2.setBounds(0, 153, 500, 10);
            this.settingsPanel.add(js2);
            this.sigHistogramCheck = new JCheckBox("Display significative data for histogram");
            this.sigHistogramCheck.setSelected(false);
            this.sigHistogramCheck.setFont(this.panelFont);
            this.sigHistogramCheck.setBounds(5, 185, 280, 20);
            this.sigHistogramCheck.setToolTipText("Clip the histogram to significative data");
            this.settingsPanel.add(this.sigHistogramCheck);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 215, 80, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 215, 80, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            Window parent = ATKGraphicsUtils.getWindowForComponent(this);
            this.settingsDialog = parent instanceof Frame ? new JDialog((Frame)parent, true) : (parent instanceof Dialog ? new JDialog((Dialog)parent, true) : new JDialog((Frame)null, true));
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(this.settingsPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.selectButton || evt.getSource() == this.selectionMenuItem) {
            this.imagePanel.deleteAllROIs();
            this.profileMode = 0;
            this.freePopup();
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
            }
        }
        if (evt.getSource() == this.selectMaxButton || evt.getSource() == this.selectionMaxMenuItem) {
            Dimension d = this.imagePanel.getImageSize();
            this.imagePanel.setSelection(0, 0, d.width, d.height);
            this.selectionChanged();
        } else if (evt.getSource() == this.roiColorsButton) {
            this.roiColorsMenu.show(this.roiColorsButton, this.roiColorsButton.getWidth(), 0);
        } else if (evt.getSource() == this.roiColorMenuItem || evt.getSource() == this.selectionColorMenuItem) {
            this.changeROIColor();
        } else if (evt.getSource() == this.selectedRoiColorMenuItem) {
            this.changeROISelectionColor();
        } else if (evt.getSource() == this.innerRoiColorMenuItem) {
            this.changeInteriorROIColor();
        } else if (evt.getSource() == this.selectedInnerRoiColorMenuItem) {
            this.changeInteriorROISelectionColor();
        } else if (evt.getSource() == this.outerRoiColorMenuItem) {
            this.changeExteriorROIColor();
        } else if (evt.getSource() == this.selectedOuterRoiColorMenuItem) {
            this.changeExteriorROISelectionColor();
        } else if (evt.getSource() == this.fileButton || evt.getSource() == this.fileMenuItem) {
            this.saveFile();
        } else {
            if (evt.getSource() == this.profileButton || evt.getSource() == this.lineProfileMenuItem) {
                Serializable rois;
                AdvancedImagePlus imp = this.imagePanel.getImagePlus();
                if (imp != null) {
                    rois = imp.getAllRois();
                    if (rois != null) {
                        for (int i = 0; i < ((Vector)rois).size(); ++i) {
                            if (!(((Vector)rois).get(i) instanceof Line)) continue;
                            imp.setHandledRoi((Roi)((Vector)rois).get(i));
                            break;
                        }
                        rois = null;
                    }
                    imp = null;
                }
                this.constructLineProfiler();
                this.lineProfiler.setLineProfileMode();
                this.lineProfiler.setVisible(true);
                this.profileMode = 1;
                rois = this;
                synchronized (rois) {
                    this.refreshStatusLine();
                    this.refreshLineProfile();
                }
            }
            if (evt.getSource() == this.histoButton || evt.getSource() == this.histogramMenuItem) {
                this.constructLineProfiler();
                this.lineProfiler.setHistogramMode();
                this.lineProfiler.setVisible(true);
                this.profileMode = 2;
                NumberImageJViewer imp = this;
                synchronized (imp) {
                    this.refreshStatusLine();
                    this.refreshLineProfile();
                }
            }
            if (evt.getSource() == this.bestFitMenuItem) {
                this.setBestFit(!this.isBestFit());
            } else if (evt.getSource() == this.negativeMenuItem) {
                this.setNegative(!this.isNegative());
            } else if (evt.getSource() == this.toolbarMenuItem) {
                this.setToolbarVisible(!this.isToolbarVisible());
            } else if (evt.getSource() == this.statusLineMenuItem) {
                this.setStatusLineVisible(!this.isStatusLineVisible());
            } else if (evt.getSource() == this.showGradMenuItem) {
                this.setGradientVisible(!this.isGradientVisible());
            } else if (evt.getSource() == this.zoomButton || evt.getSource() == this.zoomMenuItem) {
                this.showZoom();
            } else if (evt.getSource() == this.zoomCombo) {
                this.zoomFactor = this.zoomCombo.getSelectedIndex();
                NumberImageJViewer imp = this;
                synchronized (imp) {
                    this.buildZoom();
                }
                this.zoomImage.revalidate();
                this.zoomPanel.revalidate();
                this.zoomView.revalidate();
                this.zoomDialog.pack();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension _scr = toolkit.getScreenSize();
                Dimension _dlg = this.zoomDialog.getPreferredSize();
                this.zoomDialog.setBounds((_scr.width - _dlg.height) / 2, (_scr.height - _dlg.height) / 2, _dlg.width, _dlg.height);
            } else if (evt.getSource() == this.settingsButton || evt.getSource() == this.settingsMenuItem) {
                this.showSettings();
            } else if (evt.getSource() == this.autoBestFitCheck) {
                this.autoBestFit = !this.autoBestFit;
                this.minBestFitLabel.setEnabled(!this.autoBestFit);
                this.minBestFitText.setEnabled(!this.autoBestFit);
                this.maxBestFitLabel.setEnabled(!this.autoBestFit);
                this.maxBestFitText.setEnabled(!this.autoBestFit);
            } else if (evt.getSource() == this.cancelButton) {
                this.settingsDialog.setVisible(false);
            } else if (evt.getSource() == this.axisButton) {
                this.showAxisDialog();
            } else if (evt.getSource() == this.axisCloseButton) {
                this.axisDialog.setVisible(false);
            } else if (evt.getSource() == this.okButton) {
                this.applySettings();
            } else if (evt.getSource() == this.tableButton || evt.getSource() == this.tableMenuItem) {
                this.showTable();
            } else if (evt.getSource() == this.propButton) {
                this.showPropertyFrame();
            } else if (evt.getSource() == this.gradButton) {
                this.showGradientEditor();
            } else if (evt.getSource() == this.loadButton || evt.getSource() == this.loadMenuItem) {
                this.loadButtonActionPerformed();
            } else if (evt.getSource() == this.saveButton || evt.getSource() == this.saveMenuItem) {
                this.saveButtonActionPerformed();
            } else if (evt.getSource() == this.saveDataFileMenuItem) {
                this.saveDataFile();
            } else if (evt.getSource() == this.printButton || evt.getSource() == this.printMenuItem) {
                this.printImage();
            } else if (evt.getSource() == this.displayLogMenuItem) {
                this.setLogValues(this.displayLogMenuItem.isSelected());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.imagePanel.getImageRenderer()) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
                this.refreshLineProfile();
            }
        }
        this.mouseMoved(e);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        Dimension imgsize = this.getCurrentImageSize();
        if (this.doubleValues != null) {
            if (e.getSource() == this.imagePanel.getImageRenderer()) {
                int x = (int)Math.floor((double)(e.getX() - this.imagePanel.getXOrigin()) / this.imagePanel.getZoom());
                int y = (int)Math.floor((double)(e.getY() - this.imagePanel.getYOrigin()) / this.imagePanel.getZoom());
                if (x >= imgsize.width || y >= imgsize.height || y < 0 || x < 0) {
                    this.statusLabel.setText(this.getLabelInfoString());
                } else {
                    this.statusLabel.setText(this.getLabelInfoString() + " (" + x + "," + y + ")=" + Double.toString(this.doubleValues[y][x]));
                }
                this.refreshStatusLine();
            } else if (e.getSource() == this.zoomImage) {
                int x = (e.getX() - this.zoomImage.getXOrigin()) / (this.zoomFactor + 1) + this.zoomXOrg;
                int y = (e.getY() - this.zoomImage.getYOrigin()) / (this.zoomFactor + 1) + this.zoomYOrg;
                if (x >= imgsize.width || y >= imgsize.height || y < 0 || x < 0) {
                    this.zoomText.setText("");
                } else {
                    this.zoomText.setText("(" + x + "," + y + ") " + Double.toString(this.doubleValues[y][x]));
                }
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.imagePanel.getImageRenderer()) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
                this.refreshLineProfile();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Rectangle newSelection = this.imagePanel.getCurrentRoiBounds();
        if (newSelection != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!newSelection.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = newSelection;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3 && this.showingMenu && e.getSource() == this.imagePanel.getImageRenderer()) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.showGradMenuItem.setSelected(this.isGradientVisible());
            this.imgMenu.show(this.imagePanel.getImageRenderer(), e.getX(), e.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getSource() == this.imagePanel.getImageRenderer()) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.statusLabel.setText(this.getLabelInfoString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.selText) {
            if (e.getKeyCode() == 10) {
                String sel = this.selText.getText();
                try {
                    sel = sel.substring(sel.indexOf(40) + 1);
                    String x1Str = sel.substring(0, sel.indexOf(44));
                    sel = sel.substring(sel.indexOf(44) + 1);
                    String y1Str = sel.substring(0, sel.indexOf(41));
                    sel = sel.substring(sel.indexOf(91) + 1);
                    String x2Str = sel.substring(0, sel.indexOf(44));
                    sel = sel.substring(sel.indexOf(44) + 1);
                    String y2Str = sel.substring(0, sel.indexOf(93));
                    int x1 = Integer.parseInt(x1Str);
                    int y1 = Integer.parseInt(y1Str);
                    int x2 = Integer.parseInt(x2Str);
                    int y2 = Integer.parseInt(y2Str);
                    this.imagePanel.setSelection(x1, y1, x1 + x2, y1 + y2);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                Rectangle newSelection = this.imagePanel.getCurrentRoiBounds();
                if (newSelection != null) {
                    if (this.oldSelection == null) {
                        this.selectionChanged();
                    } else if (!newSelection.equals(this.oldSelection)) {
                        this.selectionChanged();
                    }
                }
                this.oldSelection = newSelection;
                this.refreshStatusLine();
            }
        } else if (e.getSource() == this.imagePanel.getImageRenderer()) {
            switch (e.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    NumberImageJViewer numberImageJViewer = this;
                    synchronized (numberImageJViewer) {
                        this.refreshStatusLine();
                        this.refreshSelectionMinMax();
                        this.refreshLineProfile();
                        break;
                    }
                }
                case 45: 
                case 107: 
                case 109: 
                case 521: {
                    NumberImageJViewer numberImageJViewer = this;
                    synchronized (numberImageJViewer) {
                        this.statusLabel.setText(this.getLabelInfoString());
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent errorEvent) {
        this.setData(null);
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public void imageChange(NumberImageEvent evt) {
        if (this.logValues) {
            this.setData(this.computeLog(evt.getValue()));
        } else {
            this.setData(evt.getValue());
        }
    }

    public void setModel(INumberImage v) {
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel(v);
        }
        if (this.model != null) {
            this.model.removeImageListener(this);
            this.model = null;
        }
        if (v != null) {
            this.imagePanel.setImage(null);
            this.firstRefresh = !this.userZoom;
            this.freePopup();
            this.model = v;
            this.model.addImageListener(this);
            this.model.refresh();
        }
    }

    public INumberImage getModel() {
        return this.model;
    }

    public void clearModel() {
        this.setModel(null);
    }

    protected void saveEdf(String filename) {
        if (this.doubleValues == null) {
            JOptionPane.showMessageDialog(this, "No data to save.");
            return;
        }
        Dimension d = this.getCurrentImageSize();
        Rectangle r = this.imagePanel.getCurrentRoiBounds();
        if (r == null) {
            r = new Rectangle(0, 0, d.width, d.height);
        }
        if (r.width <= 0 || r.height <= 0) {
            JOptionPane.showMessageDialog(this, "No area selected.");
            return;
        }
        try {
            FileWriter fw = new FileWriter(filename);
            StringBuffer to_write = new StringBuffer();
            to_write.append("{\n");
            to_write.append("HeaderID       = EH:000001:000000:000000 ;\n");
            to_write.append("Image          = 1 ;\n");
            to_write.append("ByteOrder      = LowByteFirst ;\n");
            to_write.append("DataType       = UnsignedShort ;\n");
            to_write.append("Dim_1          = " + r.width + " ;\n");
            to_write.append("Dim_2          = " + r.height + " ;\n");
            to_write.append("Size           = " + r.width * r.height * 2 + " ;\n");
            to_write.append("count_time     = 0 ;\n");
            to_write.append("point_no       = 0 ;\n");
            to_write.append("preset         = 1.0 ;\n");
            to_write.append("col_end        = " + (r.width - 1) + " ;\n");
            to_write.append("row_end        = " + (r.height - 1) + " ;\n");
            to_write.append("dir            = . ;\n");
            to_write.append("suffix         = edf ;\n");
            to_write.append("prefix         = ;\n");
            to_write.append("run            = 1 ;\n");
            to_write.append("description    = ;\n");
            to_write.append("title          = snapshot ;\n");
            for (int l = to_write.length(); l < 1022; ++l) {
                to_write.append(' ');
            }
            to_write.append("}\n");
            fw.write(to_write.toString());
            char[] bytes = new char[2];
            for (int j = r.y; j < r.y + r.height; ++j) {
                for (int i = r.x; i < r.x + r.width; ++i) {
                    int v = (int)this.doubleValues[j][i];
                    bytes[0] = (char)(v & 0xFF);
                    bytes[1] = (char)(v >> 8 & 0xFF);
                    fw.write(bytes);
                }
            }
            fw.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTable() {
        this.constructTablePanel();
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
    }

    private void saveDataFile() {
        this.constructTable();
        if (this.tablePanel != null) {
            this.tablePanel.saveDataFile();
        }
    }

    protected String getLabelInfoString() {
        Dimension imgsize = this.getCurrentImageSize();
        int percent = (int)(100.0 * this.imagePanel.getZoom());
        return percent + "% [" + imgsize.width + "," + imgsize.height + "]";
    }

    protected void computeVerticalExtent() {
        int i;
        if (this.doubleValues == null) {
            return;
        }
        if (this.verticalExtent == 1) {
            return;
        }
        int dimy = this.doubleValues.length;
        if (dimy == 0) {
            return;
        }
        int dimx = this.doubleValues[0].length;
        if (dimx == 0) {
            return;
        }
        double[][] newValues = new double[(dimy - 1) * this.verticalExtent + 1][dimx];
        for (int j = 0; j < dimy - 1; ++j) {
            for (i = 0; i < dimx; ++i) {
                for (int k = 0; k < this.verticalExtent; ++k) {
                    double yup = this.doubleValues[j][i];
                    double ydown = this.doubleValues[j + 1][i];
                    double r = (double)k / (double)this.verticalExtent;
                    newValues[j * this.verticalExtent + k][i] = yup * (1.0 - r) + ydown * r;
                }
            }
        }
        int k = (dimy - 1) * this.verticalExtent;
        for (i = 0; i < dimx; ++i) {
            newValues[k][i] = this.doubleValues[dimy - 1][i];
        }
        this.doubleValues = newValues;
    }

    protected void computeAutoZoom() {
        int dimy;
        if (this.doubleValues == null) {
            return;
        }
        if ((this.firstRefresh || this.autoZoom) && this.doubleValues.length > 0 && (dimy = this.doubleValues.length) > 0) {
            int sz;
            int dimx;
            if (dimx > 800 || dimy > 600) {
                for (sz = 1; (dimx > 800 || dimy > 600) && sz < 8 && dimx % 2 == 0 && dimy % 2 == 0; dimx /= 2, dimy /= 2, sz *= 2) {
                }
                this.iSz = sz;
            } else {
                for (dimx = this.doubleValues[0].length; dimx < 600 && dimy < 400 && sz < 4; dimx *= 2, dimy *= 2, sz *= 2) {
                }
                this.iSz = sz != 1 ? -sz : 1;
            }
            this.firstRefresh = false;
        }
    }

    protected void preComputeBestFit() {
        if (!this.isBestFit) {
            this.gradientTool.getAxis().setMinimum(0.0);
            this.gradientTool.getAxis().setMaximum(65536.0);
            this.gradientTool.repaint();
            return;
        }
        if (this.doubleValues == null) {
            return;
        }
        if (this.autoBestFit) {
            this.autoBfMin = 65536.0;
            this.autoBfMax = 0.0;
            for (int j = 0; j < this.doubleValues.length; ++j) {
                for (int i = 0; i < this.doubleValues[j].length; ++i) {
                    double v = this.doubleValues[j][i];
                    if (Double.isNaN(v) || Double.isInfinite(v)) continue;
                    if (v > this.autoBfMax) {
                        this.autoBfMax = v;
                    }
                    if (!(v < this.autoBfMin)) continue;
                    this.autoBfMin = v;
                }
            }
            if (this.autoBfMin == 65536.0 && this.autoBfMax == 0.0) {
                this.autoBfMin = 0.0;
                this.autoBfMax = 0.0;
            }
            this.bfa0 = -this.autoBfMin;
            if (this.autoBfMax == this.autoBfMin) {
                this.bfa1 = 0.0;
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax + 1.0);
                this.gradientTool.repaint();
            } else {
                this.bfa1 = 65536.0 / (this.autoBfMax - this.autoBfMin);
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax);
                this.gradientTool.repaint();
            }
        } else {
            this.bfa0 = -this.bfMin;
            this.bfa1 = this.bfMax == this.bfMin ? 0.0 : 65536.0 / (this.bfMax - this.bfMin);
            this.gradientTool.getAxis().setMinimum(this.bfMin);
            this.gradientTool.getAxis().setMaximum(this.bfMax);
            this.gradientTool.repaint();
        }
    }

    protected int bestFit(double v) {
        int nv = (int)((this.bfa0 + v) * this.bfa1);
        if (nv < 0) {
            return 0;
        }
        if (nv > 65535) {
            return 65535;
        }
        return nv;
    }

    protected boolean buildZoom() {
        if (this.doubleValues == null) {
            return false;
        }
        Rectangle r = null;
        if (this.imagePanel.getImagePlus().getSelectedRois().size() > 0) {
            r = this.imagePanel.getImagePlus().getSelectedRois().get(this.imagePanel.getImagePlus().getSelectedRois().size() - 1).getBounds();
        }
        if (r == null) {
            return false;
        }
        if (r.width <= 0 || r.height <= 0) {
            return false;
        }
        this.zoomXOrg = r.x;
        this.zoomYOrg = r.y;
        int zf = this.zoomFactor + 1;
        BufferedImage zoomImg = new BufferedImage(r.width * zf, r.height * zf, 1);
        int[] rgb = new int[r.width * zf];
        this.preComputeBestFit();
        for (int j = r.y; j < r.y + r.height; ++j) {
            for (int i = r.x; i < r.x + r.width; ++i) {
                int k;
                int p;
                if (this.isNegative) {
                    if (this.isBestFit) {
                        p = this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                        for (k = 0; k < zf; ++k) {
                            rgb[(i - r.x) * zf + k] = p;
                        }
                        continue;
                    }
                    p = this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                    for (k = 0; k < zf; ++k) {
                        rgb[(i - r.x) * zf + k] = p;
                    }
                    continue;
                }
                if (this.isBestFit) {
                    p = this.gColormap[this.bestFit(this.doubleValues[j][i])];
                    for (k = 0; k < zf; ++k) {
                        rgb[(i - r.x) * zf + k] = p;
                    }
                    continue;
                }
                p = this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                for (k = 0; k < zf; ++k) {
                    rgb[(i - r.x) * zf + k] = p;
                }
            }
            for (int k = 0; k < zf; ++k) {
                zoomImg.setRGB(0, (j - r.y) * zf + k, r.width * zf, 1, rgb, 0, r.width * zf);
            }
        }
        this.zoomImage.setImage(zoomImg);
        return true;
    }

    protected void saveFile() {
        File f;
        int ok = 0;
        FileFilter edfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("edf");
            }

            @Override
            public String getDescription() {
                return "edf - EDF pictues (Mono 16 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter jpgFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Color 24 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter jpg8Filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter pngFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Color 24 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter png8Filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter[] filters = new FileFilter[]{pngFilter, png8Filter, jpgFilter, jpg8Filter, edfFilter};
        JFileChooser chooser = new JFileChooser(this.lastSnapshotLocation);
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i].equals(this.lastFileFilter)) continue;
            chooser.addChoosableFileFilter(filters[i]);
        }
        if (this.lastFileFilter != null) {
            chooser.addChoosableFileFilter(this.lastFileFilter);
        }
        chooser.setDialogTitle("Save snapshot");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            this.lastSnapshotLocation = f.getParentFile().getAbsolutePath();
            FileFilter filter = chooser.getFileFilter();
            if (edfFilter.equals(filter)) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("edf")) {
                    f = new File(f.getAbsolutePath() + ".edf");
                }
                this.lastFileFilter = filter;
            } else if (jpgFilter.equals(filter) || jpg8Filter.equals(filter)) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("jpg")) {
                    f = new File(f.getAbsolutePath() + ".jpg");
                }
                this.lastFileFilter = filter;
            } else if (pngFilter.equals(filter) || png8Filter.equals(filter)) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("png")) {
                    f = new File(f.getAbsolutePath() + ".png");
                }
                this.lastFileFilter = filter;
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid image format", "Error", 0);
                return;
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                if (edfFilter.equals(filter)) {
                    this.saveEdf(f.getAbsolutePath());
                } else if (jpgFilter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "jpg", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (jpg8Filter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "jpg", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (pngFilter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "png", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (png8Filter.equals(filter)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "png", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                }
            }
        }
        pngFilter = null;
        png8Filter = null;
        jpgFilter = null;
        jpg8Filter = null;
        edfFilter = null;
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = null;
        }
        filters = null;
    }

    protected BufferedImage get8BitImage() {
        int w = this.imagePanel.getImage().getWidth();
        int h = this.imagePanel.getImage().getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 10);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        g2.dispose();
        return newImage;
    }

    protected void convertImage() {
        if (this.doubleValues == null) {
            return;
        }
        if (this.doubleValues.length > 0) {
            int dimy = this.doubleValues.length;
            if (dimy > 0) {
                int dimx = this.doubleValues[0].length;
                BufferedImage lastImg = this.imagePanel.getImage();
                if (lastImg == null || lastImg.getHeight() != dimy || lastImg.getWidth() != dimx) {
                    lastImg = new BufferedImage(dimx, dimy, 1);
                    this.imagePanel.setImage(lastImg);
                    this.freePopup();
                    this.statusLabel.setText(this.getLabelInfoString());
                    this.refreshComponents();
                }
                int[] rgb = new int[dimx];
                this.preComputeBestFit();
                for (int j = 0; j < dimy; ++j) {
                    int c;
                    int i;
                    if (this.isBestFit) {
                        if (this.isNegative) {
                            for (i = 0; i < dimx; ++i) {
                                rgb[i] = c = this.gColormap[~this.bestFit(this.doubleValues[j][i]) & 0xFFFF];
                            }
                        } else {
                            for (i = 0; i < dimx; ++i) {
                                rgb[i] = c = this.gColormap[this.bestFit(this.doubleValues[j][i])];
                            }
                        }
                    } else if (this.isNegative) {
                        for (i = 0; i < dimx; ++i) {
                            rgb[i] = c = this.gColormap[~((int)this.doubleValues[j][i]) & 0xFFFF];
                        }
                    } else {
                        for (i = 0; i < dimx; ++i) {
                            rgb[i] = c = this.gColormap[(int)this.doubleValues[j][i] & 0xFFFF];
                        }
                    }
                    lastImg.setRGB(0, j, dimx, 1, rgb, 0, dimx);
                }
                double zoom = this.iSz < 0 ? (double)(-this.iSz) : 1.0 / (double)this.iSz;
                this.imagePanel.refreshImage();
                this.imagePanel.setZoom(zoom);
                return;
            }
            this.doubleValues = null;
        } else {
            this.doubleValues = null;
        }
    }

    public void printImage() {
        ATKGraphicsUtils.printComponent(this.imagePanel, "Print Image", true, 0);
    }

    public boolean isLogValues() {
        return this.logValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogValues(boolean logValues) {
        if (logValues != this.logValues) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                if (this.model != null) {
                    double[][] values = this.model.getValue();
                    if (logValues) {
                        this.setData(this.computeLog(values));
                    } else {
                        this.setData(values);
                    }
                }
            }
        }
        this.logValues = logValues;
    }

    protected double[][] computeLog(double[][] values) {
        if (values == null) {
            return null;
        }
        int length1 = 0;
        int length2 = 0;
        length1 = values.length;
        if (length1 > 0) {
            length2 = values[0].length;
        }
        double[][] logs = new double[length1][length2];
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                logs[i][j] = Math.log10(values[i][j]);
            }
        }
        return logs;
    }

    protected void changeROIColor() {
        this.roiColorsMenu.setVisible(false);
        Color roiColor = JColorChooser.showDialog(this, "Choose ROI Color", this.imagePanel.getRoiColor());
        if (roiColor != null) {
            this.imagePanel.setRoiColor(roiColor);
            this.imagePanel.repaint();
        }
    }

    protected void changeROISelectionColor() {
        this.roiColorsMenu.setVisible(false);
        Color roiColor = JColorChooser.showDialog(this, "Choose ROI Selection Color", this.imagePanel.getRoiSelectionColor());
        if (roiColor != null) {
            this.imagePanel.setRoiSelectionColor(roiColor);
            this.imagePanel.repaint();
        }
    }

    protected void changeInteriorROIColor() {
        this.roiColorsMenu.setVisible(false);
        Color roiColor = JColorChooser.showDialog(this, "Choose Interior ROI Color", this.imagePanel.getRoiInsideColor());
        if (roiColor != null) {
            this.imagePanel.setRoiInsideColor(roiColor);
            this.imagePanel.repaint();
        }
    }

    protected void changeInteriorROISelectionColor() {
        this.roiColorsMenu.setVisible(false);
        Color roiColor = JColorChooser.showDialog(this, "Choose Interior ROI Selection Color", this.imagePanel.getRoiInsideSelectionColor());
        if (roiColor != null) {
            this.imagePanel.setRoiInsideSelectionColor(roiColor);
            this.imagePanel.repaint();
        }
    }

    protected void changeExteriorROIColor() {
        this.roiColorsMenu.setVisible(false);
        Color roiColor = JColorChooser.showDialog(this, "Choose Exterior ROI Color", this.imagePanel.getRoiOutsideColor());
        if (roiColor != null) {
            this.imagePanel.setRoiOutsideColor(roiColor);
            this.imagePanel.repaint();
        }
    }

    protected void changeExteriorROISelectionColor() {
        this.roiColorsMenu.setVisible(false);
        Color roiColor = JColorChooser.showDialog(this, "Choose Exterior ROI Selection Color", this.imagePanel.getRoiOutsideSelectionColor());
        if (roiColor != null) {
            this.imagePanel.setRoiOutsideSelectionColor(roiColor);
            this.imagePanel.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        NumberImageJViewer d = new NumberImageJViewer();
        AttributeList attributeList = new AttributeList();
        final ErrorHistory errWin = new ErrorHistory();
        attributeList.addErrorListener(errWin);
        try {
            String attFullName = args.length > 0 ? args[0] : "jlp/test/1/att_image";
            INumberImage theAtt = (INumberImage)attributeList.add(attFullName);
            d.setModel(theAtt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)d, "Center");
        JPanel panel = new JPanel();
        JButton errorBtn = new JButton("Show errors");
        errorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                errWin.setVisible(true);
            }
        });
        panel.add(errorBtn);
        JButton diagBtn = new JButton("Show diag");
        diagBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        panel.add(diagBtn);
        f.getContentPane().add((Component)panel, "South");
        f.setDefaultCloseOperation(3);
        f.setTitle("ImageViewer");
        f.pack();
        f.setVisible(true);
        attributeList.setRefreshInterval(1000);
        attributeList.refresh();
    }
}

