/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.util.AttrDualSpectrum;
import fr.esrf.tangoatk.core.util.INonAttrNumberSpectrum;
import fr.esrf.tangoatk.core.util.INonAttrSpectrumListener;
import fr.esrf.tangoatk.core.util.NonAttrNumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class NonAttrNumberSpectrumViewer
extends JLChart
implements INonAttrSpectrumListener,
IJLChartActionListener {
    protected int current_model_number = 0;
    protected int maximum_model_number = 9;
    protected INonAttrNumberSpectrum[] models = new INonAttrNumberSpectrum[this.maximum_model_number];
    protected JLDataView[] dvy = new JLDataView[this.maximum_model_number];
    protected JLDataView dvx;
    protected String lastConfig = "";
    public static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    public static final int Y1_AXIS = 0;
    public static final int Y2_AXIS = 1;

    public NonAttrNumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.getXAxis().setLabelFormat(0);
        this.dvx = new JLDataView();
        this.getXAxis().addDataView(this.dvx);
        this.addUserAction("Save Settings");
        this.addUserAction("Load Settings");
        this.addJLChartActionListener(this);
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.current_model_number; ++i) {
            this.models[i].removeNonAttrSpectrumListener(this);
            if (this.getY1Axis().getViews().contains(this.dvy[i])) {
                this.getY1Axis().removeDataView(this.dvy[i]);
                continue;
            }
            this.getY2Axis().removeDataView(this.dvy[i]);
        }
        this.current_model_number = 0;
    }

    @Override
    public String[] buildPanelString(SearchInfo si) {
        String[] str = new String[]{si.dataView.getExtendedName() + " " + si.axis.getAxeName(), "Index= " + new Double(si.value.x).intValue(), "X= " + si.xdataView.formatValue(si.xdataView.getTransformedValue(si.xvalue.y)), "Y= " + si.dataView.formatValue(si.dataView.getTransformedValue(si.value.y)) + " " + si.dataView.getUnit()};
        return str;
    }

    protected int findModelIndex(INonAttrNumberSpectrum v) {
        int model_index = -1;
        while (++model_index < this.current_model_number && this.models[model_index] != v) {
        }
        if (model_index == this.current_model_number) {
            model_index = -1;
        }
        return model_index;
    }

    @Override
    public void spectrumChange(NonAttrNumberSpectrumEvent numberSpectrumEvent) {
        INonAttrNumberSpectrum source = (INonAttrNumberSpectrum)numberSpectrumEvent.getSource();
        int model_index = this.findModelIndex(source);
        if (model_index != -1) {
            double[] xvalue = numberSpectrumEvent.getXValue();
            double[] yvalue = numberSpectrumEvent.getYValue();
            int length = xvalue.length;
            this.dvx.reset();
            for (int i = 0; i < length; ++i) {
                this.dvx.add(i, xvalue[i]);
            }
            length = yvalue.length;
            JLDataView dvy_i = this.dvy[model_index];
            dvy_i.reset();
            for (int i = 0; i < length; ++i) {
                dvy_i.add(i, yvalue[i]);
            }
            this.repaint();
        }
    }

    public void addModel(INonAttrNumberSpectrum v) {
        this.addModel(v, 0);
    }

    public void addModel(INonAttrNumberSpectrum v, int axis) {
        if (axis != 0 && axis != 1) {
            return;
        }
        if (v != null && this.current_model_number < this.maximum_model_number && this.findModelIndex(v) == -1) {
            this.models[this.current_model_number] = v;
            if (this.current_model_number == 0) {
                this.dvx.setName(v.getXName());
            }
            JLDataView dvy_new = new JLDataView();
            dvy_new.setUnit(v.getYUnit());
            dvy_new.setName(v.getYName());
            dvy_new.setColor(defaultColor[this.current_model_number]);
            dvy_new.setMarkerColor(defaultColor[this.current_model_number]);
            if (axis == 0) {
                this.getY1Axis().addDataView(dvy_new);
            } else {
                this.getY2Axis().addDataView(dvy_new);
            }
            this.dvy[this.current_model_number] = dvy_new;
            ++this.current_model_number;
            v.addNonAttrSpectrumListener(this);
        }
    }

    public String setSettings(String cfg) {
        CfFileReader f = new CfFileReader();
        if (!f.parseText(cfg)) {
            return "NumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        Vector<String> p = f.getParam("graph_title");
        if (p != null) {
            this.setHeader(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam("label_visible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("graph_background")) != null) {
            this.setBackground(OFormat.getColor(p));
        }
        if ((p = f.getParam("title_font")) != null) {
            this.setHeaderFont(OFormat.getFont(p));
        }
        JLAxis a = this.getXAxis();
        p = f.getParam("xgrid");
        if (p != null) {
            a.setGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("xsubgrid")) != null) {
            a.setSubGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("xgrid_style")) != null) {
            a.setGridStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("xmin")) != null) {
            a.setMinimum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("xmax")) != null) {
            a.setMaximum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("xautoscale")) != null) {
            a.setAutoScale(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("xcale")) != null) {
            a.setScale(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("xformat")) != null) {
            a.setLabelFormat(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("xtitle")) != null) {
            a.setName(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam("xcolor")) != null) {
            a.setAxisColor(OFormat.getColor(p));
        }
        if ((p = f.getParam("xlabel_font")) != null) {
            a.setFont(OFormat.getFont(p));
        }
        a = this.getY1Axis();
        p = f.getParam("y1grid");
        if (p != null) {
            a.setGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("y1subgrid")) != null) {
            a.setSubGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("y1grid_style")) != null) {
            a.setGridStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("y1min")) != null) {
            a.setMinimum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("y1max")) != null) {
            a.setMaximum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("y1autoscale")) != null) {
            a.setAutoScale(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("y1cale")) != null) {
            a.setScale(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("y1format")) != null) {
            a.setLabelFormat(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("y1title")) != null) {
            a.setName(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam("y1color")) != null) {
            a.setAxisColor(OFormat.getColor(p));
        }
        if ((p = f.getParam("y1label_font")) != null) {
            a.setFont(OFormat.getFont(p));
        }
        a = this.getY2Axis();
        p = f.getParam("y2grid");
        if (p != null) {
            a.setGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("y2subgrid")) != null) {
            a.setSubGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("y2grid_style")) != null) {
            a.setGridStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("y2min")) != null) {
            a.setMinimum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("y2max")) != null) {
            a.setMaximum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("y2autoscale")) != null) {
            a.setAutoScale(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("y2cale")) != null) {
            a.setScale(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("y2format")) != null) {
            a.setLabelFormat(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("y2title")) != null) {
            a.setName(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam("y2color")) != null) {
            a.setAxisColor(OFormat.getColor(p));
        }
        if ((p = f.getParam("y2label_font")) != null) {
            a.setFont(OFormat.getFont(p));
        }
        return "";
    }

    public String getSettings() {
        String to_write = "";
        to_write = to_write + "graph_title:'" + this.getHeader() + "'\n";
        to_write = to_write + "label_visible:" + this.isLabelVisible() + "\n";
        to_write = to_write + "graph_background:" + OFormat.color(this.getBackground()) + "\n";
        to_write = to_write + "title_font:" + OFormat.font(this.getHeaderFont()) + "\n";
        to_write = to_write + "xgrid:" + this.getXAxis().isGridVisible() + "\n";
        to_write = to_write + "xsubgrid:" + this.getXAxis().isSubGridVisible() + "\n";
        to_write = to_write + "xgrid_style:" + this.getXAxis().getGridStyle() + "\n";
        to_write = to_write + "xmin:" + this.getXAxis().getMinimum() + "\n";
        to_write = to_write + "xmax:" + this.getXAxis().getMaximum() + "\n";
        to_write = to_write + "xautoscale:" + this.getXAxis().isAutoScale() + "\n";
        to_write = to_write + "xcale:" + this.getXAxis().getScale() + "\n";
        to_write = to_write + "xformat:" + this.getXAxis().getLabelFormat() + "\n";
        to_write = to_write + "xtitle:'" + this.getXAxis().getName() + "'\n";
        to_write = to_write + "xcolor:" + OFormat.color(this.getXAxis().getAxisColor()) + "\n";
        to_write = to_write + "xlabel_font:" + OFormat.font(this.getXAxis().getFont()) + "\n";
        to_write = to_write + "y1grid:" + this.getY1Axis().isGridVisible() + "\n";
        to_write = to_write + "y1subgrid:" + this.getY1Axis().isSubGridVisible() + "\n";
        to_write = to_write + "y1grid_style:" + this.getY1Axis().getGridStyle() + "\n";
        to_write = to_write + "y1min:" + this.getY1Axis().getMinimum() + "\n";
        to_write = to_write + "y1max:" + this.getY1Axis().getMaximum() + "\n";
        to_write = to_write + "y1autoscale:" + this.getY1Axis().isAutoScale() + "\n";
        to_write = to_write + "y1cale:" + this.getY1Axis().getScale() + "\n";
        to_write = to_write + "y1format:" + this.getY1Axis().getLabelFormat() + "\n";
        to_write = to_write + "y1title:'" + this.getY1Axis().getName() + "'\n";
        to_write = to_write + "y1color:" + OFormat.color(this.getY1Axis().getAxisColor()) + "\n";
        to_write = to_write + "y1label_font:" + OFormat.font(this.getY1Axis().getFont()) + "\n";
        to_write = to_write + "y2grid:" + this.getY2Axis().isGridVisible() + "\n";
        to_write = to_write + "y2subgrid:" + this.getY2Axis().isSubGridVisible() + "\n";
        to_write = to_write + "y2grid_style:" + this.getY2Axis().getGridStyle() + "\n";
        to_write = to_write + "y2min:" + this.getY2Axis().getMinimum() + "\n";
        to_write = to_write + "y2max:" + this.getY2Axis().getMaximum() + "\n";
        to_write = to_write + "y2autoscale:" + this.getY2Axis().isAutoScale() + "\n";
        to_write = to_write + "y2cale:" + this.getY2Axis().getScale() + "\n";
        to_write = to_write + "y2format:" + this.getY2Axis().getLabelFormat() + "\n";
        to_write = to_write + "y2title:'" + this.getY2Axis().getName() + "'\n";
        to_write = to_write + "y2color:" + OFormat.color(this.getY2Axis().getAxisColor()) + "\n";
        to_write = to_write + "y2label_font:" + OFormat.font(this.getY2Axis().getFont()) + "\n";
        Vector<JLDataView> views = new Vector<JLDataView>();
        if (this.getXAxis().isXY()) {
            views.addAll(this.getXAxis().getViews());
        }
        views.addAll(this.getY1Axis().getViews());
        views.addAll(this.getY2Axis().getViews());
        to_write = to_write + "dv_number:" + views.size() + "\n";
        for (int i = 0; i < views.size(); ++i) {
            JLDataView data = (JLDataView)views.get(i);
            to_write = to_write + "dv" + i + "_name:'" + data.getName() + "'\n";
            to_write = to_write + data.getConfiguration("dv" + i);
            data = null;
        }
        views.clear();
        views = null;
        return to_write;
    }

    public String setSetting(String txt) {
        CfFileReader f = new CfFileReader();
        if (!f.parseText(txt)) {
            return "NonAttrNumberSpectrumViewer.setSettings: Failed to parse given text";
        }
        return this.applySettings(f);
    }

    public void saveSetting(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            String s = this.getSettings();
            f.write(s, 0, s.length());
            f.close();
            this.lastConfig = filename;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Failed to write " + filename, "Error", 0);
        }
    }

    public String loadSetting(String filename) {
        CfFileReader f = new CfFileReader();
        if (!f.readFile(filename)) {
            return "Failed to read " + filename;
        }
        this.lastConfig = filename;
        return this.applySettings(f);
    }

    protected String applySettings(CfFileReader f) {
        String errBuff = "";
        this.setMaxDisplayDuration(Double.POSITIVE_INFINITY);
        this.setDisplayDuration(Double.POSITIVE_INFINITY);
        Vector<String> p = f.getParam("dv_number");
        Vector<JLDataView> views = new Vector<JLDataView>();
        if (this.getXAxis().isXY()) {
            views.addAll(this.getXAxis().getViews());
        }
        views.addAll(this.getY1Axis().getViews());
        views.addAll(this.getY2Axis().getViews());
        if (p != null) {
            int nbDv;
            try {
                nbDv = Integer.parseInt(p.get(0).toString());
            }
            catch (NumberFormatException e) {
                errBuff = errBuff + "dv_number: invalid number\n";
                return errBuff;
            }
            for (int i = 0; i < nbDv; ++i) {
                p = f.getParam("dv" + i + "_name");
                if (p == null) {
                    errBuff = errBuff + "Unable to find dv" + i + "_name param\n";
                    return errBuff;
                }
                String name = p.get(0).toString();
                for (int j = 0; j < views.size(); ++j) {
                    JLDataView data = (JLDataView)views.get(j);
                    if (name.equals(data.getName())) {
                        data.applyConfiguration("dv" + i, f);
                        break;
                    }
                    data = null;
                }
                name = null;
            }
        } else {
            boolean nbDv = false;
        }
        views.clear();
        views = null;
        this.applyConfiguration(f);
        this.getXAxis().applyConfiguration("x", f);
        this.getY1Axis().applyConfiguration("y1", f);
        this.getY2Axis().applyConfiguration("y2", f);
        return errBuff;
    }

    protected void loadButtonActionPerformed() {
        File f;
        int returnVal;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showOpenDialog(null)) == 0 && (f = chooser.getSelectedFile()) != null && !ok) {
            String err = this.loadSetting(f.getAbsolutePath());
            if (err.length() > 0) {
                JOptionPane.showMessageDialog(null, err, "Errors reading " + f.getName(), 0);
            }
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(JLChartActionEvent evt) {
        if (evt.getName().equals("Load Settings")) {
            this.loadButtonActionPerformed();
        } else if (evt.getName().equals("Save Settings")) {
            this.saveButtonActionPerformed();
        }
    }

    protected void saveButtonActionPerformed() {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showSaveDialog(null)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(f) == null) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(null, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                this.saveSetting(f.getAbsolutePath());
            }
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent evt) {
        return false;
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame();
        final NonAttrNumberSpectrumViewer viewer = new NonAttrNumberSpectrumViewer();
        try {
            AttributePolledList attributelist = new AttributePolledList();
            String xAttributeName = "";
            String yAttributeName = "";
            IAttribute xAttribute = null;
            IAttribute yAttribute = null;
            AttrDualSpectrum attributeDualSpectrum = null;
            final AttrDualSpectrum[] attributeDualSpectrumList = new AttrDualSpectrum[args.length - 1];
            JButton button = new JButton("remove/add");
            button.setToolTipText("Removes/Adds the models of the viewer");
            if (args.length >= 2) {
                xAttributeName = args[0].trim();
                xAttribute = (IAttribute)attributelist.add(xAttributeName);
                for (int i = 1; i < args.length; ++i) {
                    yAttributeName = args[i].trim();
                    yAttribute = (IAttribute)attributelist.add(yAttributeName);
                    attributeDualSpectrum = new AttrDualSpectrum(xAttribute.getDevice(), xAttribute.getNameSansDevice(), yAttribute.getDevice(), yAttribute.getNameSansDevice());
                    attributeDualSpectrum.setRefreshInterval(1000);
                    attributeDualSpectrumList[i - 1] = attributeDualSpectrum;
                }
                for (int j = 0; j < attributeDualSpectrumList.length; ++j) {
                    viewer.addModel(attributeDualSpectrumList[j], 0);
                }
                attributelist.addRefresherListener(new IRefresherListener(){

                    @Override
                    public void refreshStep() {
                        for (int i = 0; i < attributeDualSpectrumList.length; ++i) {
                            attributeDualSpectrumList[i].refresh();
                        }
                        viewer.repaint();
                    }
                });
                button.addActionListener(new ActionListener(){
                    int count = 1;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        switch (this.count) {
                            case 0: {
                                for (int j = 0; j < attributeDualSpectrumList.length; ++j) {
                                    viewer.addModel(attributeDualSpectrumList[j], 0);
                                }
                                this.count = 1;
                                break;
                            }
                            case 1: {
                                viewer.reset();
                                this.count = 0;
                            }
                        }
                    }
                });
            } else {
                xAttributeName = "tango/tangotest/1/double_spectrum_ro";
                yAttributeName = "tango/tangotest/1/float_spectrum_ro";
                String yname2 = "tango/tangotest/1/short_spectrum_ro";
                xAttribute = (IAttribute)attributelist.add(xAttributeName);
                yAttribute = (IAttribute)attributelist.add(yAttributeName);
                IAttribute yattr2 = (IAttribute)attributelist.add(yname2);
                final AttrDualSpectrum dual = new AttrDualSpectrum(xAttribute.getDevice(), xAttribute.getNameSansDevice(), yAttribute.getDevice(), yAttribute.getNameSansDevice());
                dual.setYUnit("UNITE");
                dual.setYName("NOM");
                dual.setRefreshInterval(1000);
                final AttrDualSpectrum dual2 = new AttrDualSpectrum(xAttribute.getDevice(), xAttribute.getNameSansDevice(), yattr2.getDevice(), yattr2.getNameSansDevice());
                dual2.setRefreshInterval(1000);
                viewer.addModel(dual, 0);
                viewer.addModel(dual2, 1);
                attributelist.addRefresherListener(new IRefresherListener(){

                    @Override
                    public void refreshStep() {
                        dual.refresh();
                        dual2.refresh();
                        viewer.repaint();
                    }
                });
                button.addActionListener(new ActionListener(){
                    int count = 1;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        switch (this.count) {
                            case 0: {
                                viewer.addModel(dual, 0);
                                viewer.addModel(dual2, 1);
                                this.count = 1;
                                break;
                            }
                            case 1: {
                                viewer.reset();
                                this.count = 0;
                            }
                        }
                    }
                });
            }
            GridBagConstraints gbc1 = new GridBagConstraints();
            gbc1.fill = 1;
            gbc1.gridx = 0;
            gbc1.gridy = 0;
            gbc1.weighty = 1.0;
            gbc1.weightx = 1.0;
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.fill = 2;
            gbc2.gridx = 0;
            gbc2.gridy = 1;
            gbc2.weighty = 0.0;
            gbc2.weightx = 1.0;
            button.setMargin(new Insets(0, 0, 0, 0));
            jframe.getContentPane().setLayout(new GridBagLayout());
            jframe.getContentPane().add((Component)viewer, gbc1);
            jframe.getContentPane().add((Component)button, gbc2);
            jframe.setDefaultCloseOperation(3);
            jframe.setTitle("DualSpectrumViewer:");
            jframe.setSize(640, 480);
            jframe.setVisible(true);
            attributelist.startRefresher();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

