/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.MultiScalarTableViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.command.ConfirmCommandViewer;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MultiAttAndCmdTableViewer
extends MultiScalarTableViewer {
    CmdButtonRenderAndEdit cmdRendEdit = null;

    public MultiAttAndCmdTableViewer() {
        this.tabModel = new MultiAttAndCmdViewerTableModel();
        super.setModel(this.tabModel);
        this.setRowMargin(0);
        this.cmdRendEdit = new CmdButtonRenderAndEdit((JTable)this);
        this.addMouseListener(this.cmdRendEdit);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object obj = this.tabModel.getValueAt(row, column);
        if (obj != null && obj instanceof VoidVoidCommandViewer) {
            return this.cmdRendEdit;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Object obj = this.tabModel.getValueAt(row, column);
        if (obj != null && obj instanceof VoidVoidCommandViewer) {
            return this.cmdRendEdit;
        }
        if (obj != null && obj instanceof SimpleScalarViewer) {
            return this.cellRendererAndEditor;
        }
        if (obj != null && obj instanceof SimpleEnumScalarViewer) {
            return this.cellRendererAndEditor;
        }
        if (obj != null && obj instanceof BooleanScalarCheckBoxViewer) {
            return this.cellRendererAndEditor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tabModel.isCellEditable(row, column);
    }

    public void setModelAt(IEntity ient, int r, int c) {
        if (ient instanceof IAttribute) {
            IAttribute iatt = (IAttribute)ient;
            super.setModelAt(iatt, r, c);
            return;
        }
        if (!(ient instanceof VoidVoidCommand)) {
            System.out.println("Unsupported type of model; Only voidVoidCommands and scalar attributes are accepted; setModelAt failed.");
            return;
        }
        if (r < 0 || c < 0) {
            return;
        }
        if (r >= this.nbRows || c >= this.nbColumns) {
            return;
        }
        if (this.entityModels == null) {
            this.initModels();
        }
        this.clearModelAt(r, c);
        if (ient == null) {
            return;
        }
        this.entityModels[r][c] = ient;
        VoidVoidCommand cmd = (VoidVoidCommand)ient;
        this.addCmdAt(cmd, r, c);
    }

    public void setConfirmCommandAt(ICommand ic, int r, int c, String confirmMsg) {
        if (confirmMsg == null) {
            this.setModelAt(ic, r, c);
            return;
        }
        if (confirmMsg.isEmpty()) {
            this.setModelAt(ic, r, c);
            return;
        }
        if (!(ic instanceof VoidVoidCommand)) {
            System.out.println("Unsupported type of model; Only voidVoidCommands and scalar attributes are accepted; setModelAt failed.");
            return;
        }
        if (r < 0 || c < 0) {
            return;
        }
        if (r >= this.nbRows || c >= this.nbColumns) {
            return;
        }
        if (this.entityModels == null) {
            this.initModels();
        }
        this.clearModelAt(r, c);
        this.entityModels[r][c] = ic;
        VoidVoidCommand cmd = (VoidVoidCommand)ic;
        this.addConfirmCmdAt(cmd, r, c, confirmMsg);
    }

    private void addCmdAt(VoidVoidCommand cmd, int r, int c) {
        VoidVoidCommandViewer cmdViewer = new VoidVoidCommandViewer();
        cmdViewer.setFont(this.getFont());
        cmdViewer.setModel(cmd);
        cmdViewer.setMargin(new Insets(1, 1, 1, 1));
        MultiAttAndCmdViewerTableModel tm = (MultiAttAndCmdViewerTableModel)this.tabModel;
        tm.addCommandAt(r, c, cmd, cmdViewer);
    }

    private void addConfirmCmdAt(VoidVoidCommand cmd, int r, int c, String msg) {
        ConfirmCommandViewer cmdViewer = new ConfirmCommandViewer();
        cmdViewer.setFont(this.getFont());
        cmdViewer.setConfirmDialParent(this);
        cmdViewer.setConfirmTitle("Confirm Command");
        cmdViewer.setConfirmMessage(msg);
        cmdViewer.setModel(cmd);
        cmdViewer.setMargin(new Insets(1, 1, 1, 1));
        MultiAttAndCmdViewerTableModel tm = (MultiAttAndCmdViewerTableModel)this.tabModel;
        tm.addCommandAt(r, c, cmd, cmdViewer);
    }

    private void initModels() {
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows before calling initAttModels.");
            return;
        }
        TableModel tm = super.getModel();
        if (!(tm instanceof MultiAttAndCmdViewerTableModel)) {
            this.tabModel = new MultiAttAndCmdViewerTableModel();
            this.setModel(this.tabModel);
        }
        this.entityModels = new IEntity[this.nbRows][this.nbColumns];
        for (int i = 0; i < this.nbRows; ++i) {
            for (int j = 0; j < this.nbColumns; ++j) {
                this.entityModels[i][j] = null;
            }
        }
        if (this.columnIdents == null) {
            this.columnIdents = new String[this.nbColumns];
        }
        this.tabModel.init();
        this.initColumnHeaderRenderers();
    }

    @Override
    public void clearModelAt(int r, int c) {
        if (this.entityModels == null) {
            return;
        }
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows before calling clearModelAt.");
            return;
        }
        if (r < 0 || c < 0) {
            return;
        }
        if (r >= this.nbRows || c >= this.nbColumns) {
            return;
        }
        if (this.entityModels[r][c] == null) {
            return;
        }
        if (this.entityModels[r][c] instanceof VoidVoidCommand) {
            MultiAttAndCmdViewerTableModel tm = (MultiAttAndCmdViewerTableModel)this.tabModel;
            tm.removeCmdAt(r, c);
            this.entityModels[r][c] = null;
            return;
        }
        super.clearModelAt(r, c);
    }

    @Override
    public void clearModel() {
        if (this.entityModels == null) {
            return;
        }
        for (int i = 0; i < this.entityModels.length; ++i) {
            for (int j = 0; j < this.entityModels[i].length; ++j) {
                this.clearModelAt(i, j);
            }
        }
        this.entityModels = null;
        this.columnIdents = null;
        this.rowIdents = null;
        this.nbRows = 0;
        this.nbColumns = 0;
        this.tabModel.setColumnCount(0);
        this.tabModel.setRowCount(0);
        this.tabModel = new MultiAttAndCmdViewerTableModel();
        this.setModel(this.tabModel);
    }

    public static void main(String[] args) {
        String[] colLabs = new String[]{"att_un", "att_deux", "att_trois", "att_cinq", "att_six", "att_bool", ""};
        String[] rowLabs = new String[]{"jlp/test/1", "jlp/test/2"};
        AttributeList attl = new AttributeList();
        CommandList cmdl = new CommandList();
        JFrame f = new JFrame();
        MultiAttAndCmdTableViewer mstv = new MultiAttAndCmdTableViewer();
        IAttribute[][] attArray = null;
        mstv.setUnitVisible(false);
        mstv.setFont(new Font("Dialog", 0, 14));
        mstv.setNbRows(2);
        mstv.setNbColumns(7);
        mstv.setRowIdents(rowLabs);
        mstv.setColumnIdents(colLabs);
        attArray = new IAttribute[2][6];
        try {
            IAttribute att;
            attArray[0][0] = att = (IAttribute)attl.add("jlp/test/1/att_un");
            mstv.setModelAt(att, 0, 0);
            attArray[0][1] = att = (IAttribute)attl.add("jlp/test/1/att_deux");
            mstv.setModelAt(att, 0, 1);
            attArray[0][2] = att = (IAttribute)attl.add("jlp/test/1/att_trois");
            mstv.setModelAt(att, 0, 2);
            attArray[0][3] = att = (IAttribute)attl.add("jlp/test/1/att_cinq");
            mstv.setModelAt(att, 0, 3);
            attArray[0][4] = att = (IAttribute)attl.add("jlp/test/1/att_six");
            mstv.setModelAt(att, 0, 4);
            attArray[0][5] = att = (IAttribute)attl.add("jlp/test/1/att_boolean");
            mstv.setModelAt(att, 0, 5);
            attArray[1][0] = att = (IAttribute)attl.add("jlp/test/2/att_un");
            mstv.setModelAt(att, 1, 0);
            attArray[1][1] = att = (IAttribute)attl.add("jlp/test/2/att_deux");
            mstv.setModelAt(att, 1, 1);
            attArray[1][2] = att = (IAttribute)attl.add("jlp/test/2/att_trois");
            mstv.setModelAt(att, 1, 2);
            attArray[1][3] = att = (IAttribute)attl.add("jlp/test/2/att_cinq");
            mstv.setModelAt(att, 1, 3);
            attArray[1][4] = att = (IAttribute)attl.add("jlp/test/2/att_six");
            mstv.setModelAt(att, 1, 4);
            attArray[1][5] = att = (IAttribute)attl.add("jlp/test/2/att_boolean");
            mstv.setModelAt(att, 1, 5);
            ICommand cmd = (ICommand)cmdl.add("jlp/test/1/Reset");
            mstv.setModelAt(cmd, 0, 6);
            cmd = (ICommand)cmdl.add("jlp/test/2/On");
            mstv.setConfirmCommandAt(cmd, 1, 6, "Do you want to turn On?");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Cannot connect to jlp/test/1");
        }
        mstv.setRowHeight(25);
        mstv.setRowMargin(1);
        TableColumn column = null;
        for (int i = 0; i < colLabs.length; ++i) {
            column = mstv.getColumnModel().getColumn(i + 1);
            if (colLabs[i].isEmpty()) {
                column.setPreferredWidth(35);
                continue;
            }
            column.setPreferredWidth(column.getWidth());
        }
        attl.startRefresher();
        mstv.setPreferredScrollableViewportSize(new Dimension(700, 70));
        JScrollPane scrollPane = new JScrollPane(mstv);
        f.setContentPane(scrollPane);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    class CmdButtonRenderAndEdit
    extends MultiScalarTableViewer.MultiScalarCellRendererAndEditor
    implements TableCellRenderer,
    TableCellEditor {
        JButton rendererBtn;
        JButton editorBtn;
        boolean isCmdRenderAndEdit;
        MultiAttAndCmdViewerTableModel tm;

        CmdButtonRenderAndEdit(JTable tbl) {
            super(tbl);
            this.tm = null;
            if (this.table.getModel() instanceof MultiAttAndCmdViewerTableModel) {
                this.tm = (MultiAttAndCmdViewerTableModel)this.table.getModel();
            }
        }

        private boolean isMouseOnCmd() {
            int col;
            int row = MultiAttAndCmdTableViewer.this.getSelectedRow();
            Object obj = this.table.getValueAt(row, col = MultiAttAndCmdTableViewer.this.getSelectedColumn());
            return obj instanceof VoidVoidCommandViewer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof VoidVoidCommandViewer) {
                this.rendererBtn = (JButton)value;
                if (isSelected) {
                    this.rendererBtn.setForeground(table.getSelectionForeground());
                    this.rendererBtn.setBackground(table.getSelectionBackground());
                } else {
                    this.rendererBtn.setForeground(table.getForeground());
                    this.rendererBtn.setBackground(UIManager.getColor("Button.background"));
                }
                return this.rendererBtn;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof VoidVoidCommandViewer) {
                this.editorBtn = (JButton)value;
                this.editorValue = value;
                return this.editorBtn;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean isCmd = this.isMouseOnCmd();
            if (isCmd && this.table.isEditing() && this.table.getCellEditor() == this) {
                this.isCmdRenderAndEdit = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean isCmd = this.isMouseOnCmd();
            if (isCmd) {
                if (this.isCmdRenderAndEdit && this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.isCmdRenderAndEdit = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class MultiAttAndCmdViewerTableModel
    extends MultiScalarTableViewer.MultiScalarViewerTableModel {
        MultiAttAndCmdViewerTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            Object obj = this.getValueAt(row, column);
            if (obj != null && obj instanceof VoidVoidCommandViewer) {
                return true;
            }
            return super.isCellEditable(row, column);
        }

        @Override
        protected void init() {
            if (MultiAttAndCmdTableViewer.this.entityModels == null) {
                return;
            }
            if (MultiAttAndCmdTableViewer.this.entityModels.length != MultiAttAndCmdTableViewer.this.nbRows) {
                MultiAttAndCmdTableViewer.this.nbRows = MultiAttAndCmdTableViewer.this.entityModels.length;
            }
            if (MultiAttAndCmdTableViewer.this.entityModels[0].length != MultiAttAndCmdTableViewer.this.nbColumns) {
                MultiAttAndCmdTableViewer.this.nbColumns = MultiAttAndCmdTableViewer.this.entityModels[0].length;
            }
            if (MultiAttAndCmdTableViewer.this.rowIdents != null && MultiAttAndCmdTableViewer.this.rowIdents.length != MultiAttAndCmdTableViewer.this.nbRows) {
                MultiAttAndCmdTableViewer.this.rowIdents = null;
            }
            if (MultiAttAndCmdTableViewer.this.rowIdents != null) {
                int j;
                this.hasRowLabels = true;
                Object[] colIds = null;
                if (MultiAttAndCmdTableViewer.this.columnIdents != null) {
                    colIds = new String[MultiAttAndCmdTableViewer.this.columnIdents.length + 1];
                    colIds[0] = " ";
                    for (j = 0; j < MultiAttAndCmdTableViewer.this.columnIdents.length; ++j) {
                        colIds[j + 1] = MultiAttAndCmdTableViewer.this.columnIdents[j];
                    }
                } else {
                    colIds = new String[MultiAttAndCmdTableViewer.this.nbColumns + 1];
                    for (j = 0; j < MultiAttAndCmdTableViewer.this.nbColumns + 1; ++j) {
                        colIds[j] = " ";
                    }
                }
                this.tableData = new Object[MultiAttAndCmdTableViewer.this.entityModels.length][MultiAttAndCmdTableViewer.this.entityModels[0].length + 1];
                this.setDataVector(this.tableData, colIds);
                for (int i = 0; i < MultiAttAndCmdTableViewer.this.nbRows; ++i) {
                    this.setValueAt(MultiAttAndCmdTableViewer.this.rowIdents[i], i, 0);
                }
            } else {
                this.tableData = new Object[MultiAttAndCmdTableViewer.this.entityModels.length][MultiAttAndCmdTableViewer.this.entityModels[0].length];
                this.setDataVector(this.tableData, MultiAttAndCmdTableViewer.this.columnIdents);
            }
        }

        void addCommandAt(int r, int c, ICommand icmd, VoidVoidCommandViewer cmdViewer) {
            VoidVoidCommand vvc = null;
            if (icmd instanceof VoidVoidCommand) {
                vvc = (VoidVoidCommand)icmd;
            }
            if (vvc == null) {
                return;
            }
            int col = c;
            if (this.hasRowLabels) {
                col = c + 1;
            }
            this.setValueAt(cmdViewer, r, col);
            ArrayList<Integer> cmdIndexes = new ArrayList<Integer>();
            cmdIndexes.add(0, new Integer(r));
            cmdIndexes.add(1, new Integer(col));
            if (!this.entityMap.containsKey(icmd)) {
                this.entityMap.put(icmd, cmdIndexes);
            }
            this.fireTableDataChanged();
        }

        void removeCmdAt(int r, int c) {
            Object obj;
            int col = c;
            if (this.hasRowLabels) {
                col = c + 1;
            }
            if ((obj = this.getValueAt(r, col)) == null) {
                return;
            }
            if (obj instanceof VoidVoidCommandViewer) {
                VoidVoidCommandViewer vvViewer = (VoidVoidCommandViewer)obj;
                this.removeCmdAt(vvViewer, r, col);
                return;
            }
        }

        private void removeCmdAt(VoidVoidCommandViewer cmdv, int r, int c) {
            cmdv.setModel((ICommand)null);
            cmdv = null;
            this.setValueAt(null, r, c);
            this.fireTableDataChanged();
        }
    }
}

