/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class EnumScalarComboEditor
extends JComboBox
implements ActionListener,
IEnumScalarListener,
JDrawable,
PropertyChangeListener {
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private Font theFont;
    private IEnumScalar enumModel = null;
    private String[] defOptionList = new String[]{"None"};
    private String[] optionList = new String[]{"None"};
    private boolean hasConfirmWindow = false;
    protected String confirmTitle = "Confirm attribute set value";
    protected String confirmMessage = "Do you want to set the value of the attribute?\n";

    public EnumScalarComboEditor() {
        this.theFont = new Font("Dialog", 0, 14);
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public boolean getHasConfirmWindow() {
        return this.hasConfirmWindow;
    }

    public void setHasConfirmWindow(boolean flag) {
        this.hasConfirmWindow = flag;
    }

    public String getConfirmTitle() {
        return this.confirmTitle;
    }

    public void setConfirmTitle(String title) {
        this.confirmTitle = title;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void setConfirmMessage(String msg) {
        this.confirmMessage = msg;
    }

    public IEnumScalar getEnumModel() {
        return this.enumModel;
    }

    public void setEnumModel(IEnumScalar m) {
        String[] valList = null;
        int valListSize = 0;
        String[] newOptions = null;
        if (this.enumModel != null) {
            this.enumModel.removeEnumScalarListener(this);
            this.enumModel = null;
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        if (m == null) {
            return;
        }
        if (!m.isWritable()) {
            throw new IllegalArgumentException("EnumScalarComboEditor: Only accept writable attribute.");
        }
        this.enumModel = m;
        String invalidOpt = "???";
        valList = this.enumModel.getSetEnumValues();
        newOptions = null;
        if (valList != null && (valListSize = valList.length) > 0) {
            newOptions = new String[valListSize];
            for (int index = 0; index < valListSize; ++index) {
                newOptions[index] = new String(valList[index]);
            }
        }
        if (newOptions == null) {
            newOptions = new String[]{new String(invalidOpt + " ")};
        }
        if (newOptions != null) {
            this.optionList = newOptions;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
        this.changeCurrentSelection(-1);
        this.enumModel.addEnumScalarListener(this);
        Property p = this.enumModel.getProperty("enum_label");
        if (p != null) {
            p.addPresentationListener(this);
        }
        this.enumModel.refresh();
    }

    @Override
    public void enumScalarChange(EnumScalarEvent evt) {
        String set = null;
        int currentSelection = this.getSelectedIndex();
        set = this.hasFocus() ? this.enumModel.getEnumScalarSetPointFromDevice() : this.enumModel.getEnumScalarSetPoint();
        if (set == null) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException iaex) {
                System.out.println("caught exception : " + iaex.getMessage());
            }
            return;
        }
        if (this.optionList == null) {
            return;
        }
        for (int index = 0; index < this.optionList.length; ++index) {
            if (!set.equals(this.optionList[index])) continue;
            if (currentSelection != index) {
                this.changeCurrentSelection(index);
            }
            return;
        }
        try {
            this.changeCurrentSelection(-1);
        }
        catch (IllegalArgumentException iaex) {
            System.out.println("caught exception : " + iaex.getMessage());
        }
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent e) {
        if (this.enumModel == null) {
            return;
        }
        int currentSelection = this.getSelectedIndex();
        if (currentSelection != -1) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException iaex) {
                System.out.println("caught exception : " + iaex.getMessage());
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = null;
        String cmdOption = null;
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.enumModel == null) {
            return;
        }
        cb = (JComboBox)e.getSource();
        cmdOption = (String)cb.getSelectedItem();
        if (cmdOption == null) {
            return;
        }
        if (!this.hasConfirmWindow) {
            this.enumModel.setEnumScalarValue(cmdOption);
            return;
        }
        cb.hidePopup();
        this.enumModel.refresh();
        int userAnswer = 1;
        try {
            String msg = this.confirmMessage + "New value = " + cmdOption + "\n";
            userAnswer = JOptionPane.showConfirmDialog(this, msg, this.confirmTitle, 0);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (userAnswer == 0) {
            this.enumModel.setEnumScalarValue(cmdOption);
        }
    }

    private void changeCurrentSelection(int newIndex) {
        this.disableExecution();
        this.setSelectedIndex(newIndex);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return new String[0];
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        return true;
    }

    @Override
    public String getExtendedParam(String name) {
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (src == null) {
            return;
        }
        if (src.getName().equalsIgnoreCase("enum_label") && src instanceof StringArrayProperty) {
            StringArrayProperty sap = (StringArrayProperty)src;
            String[] newEnums = sap.getStringArrayValue();
            this.updateEnumLabels(newEnums);
        }
    }

    private void updateEnumLabels(String[] enums) {
        if (enums == null) {
            return;
        }
        if (enums.length < 1) {
            return;
        }
        String[] newOptions = new String[enums.length];
        System.arraycopy(enums, 0, newOptions, 0, enums.length);
        this.optionList = newOptions;
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.changeCurrentSelection(-1);
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        EnumScalarComboEditor esce = new EnumScalarComboEditor();
        JFrame mainFrame = null;
        esce.setHasConfirmWindow(true);
        try {
            IEnumScalar enumAtt;
            IEntity ie = attList.add("//acudebian7:10000/test/universal/1/DevFloatRO_quality_");
            if (ie instanceof IEnumScalar) {
                enumAtt = (IEnumScalar)ie;
                System.out.println("Is an IEnumScalar!");
            } else {
                enumAtt = null;
            }
            if (enumAtt == null) {
                System.exit(-1);
            }
            esce.setEnumModel(enumAtt);
        }
        catch (Exception e) {
            System.out.println("caught exception : " + e.getMessage());
            System.exit(-1);
        }
        attList.startRefresher();
        mainFrame = new JFrame();
        mainFrame.setContentPane(esce);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

