/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class DualSpectrumImageViewer
extends JLChart
implements IImageListener,
IJLChartActionListener,
IJLChartListener {
    INumberImage model;
    JLDataView dvy;
    SimplePropertyFrame pf = null;

    public DualSpectrumImageViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.getY1Axis().addDataView(this.dvy);
        this.addUserAction("Attribute properties");
        this.addJLChartActionListener(this);
        this.setJLChartListener(this);
    }

    @Override
    public void actionPerformed(JLChartActionEvent evt) {
        if (evt.getName().equals("Attribute properties")) {
            if (this.pf == null) {
                this.pf = new SimplePropertyFrame();
                this.pf.setModel(this.model);
            }
            this.pf.setVisible(true);
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent evt) {
        return this.model != null;
    }

    @Override
    public String[] clickOnChart(JLChartEvent e) {
        String[] ret = new String[]{this.model.getName(), "X=" + e.getTransformedXValue(), "Y=" + e.getTransformedYValue() + " " + this.model.getUnit()};
        return ret;
    }

    @Override
    public void errorChange(ErrorEvent errorEvent) {
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public void imageChange(NumberImageEvent evt) {
        double[][] values = evt.getValue();
        if (values.length >= 2) {
            int length = values[0].length;
            this.dvy.reset();
            for (int i = 0; i < length; ++i) {
                this.dvy.add(values[0][i], values[1][i]);
            }
            this.repaint();
        }
    }

    public JLDataView getYView() {
        return this.dvy;
    }

    public void setModel(INumberImage v) {
        if (this.model != null) {
            this.model.removeImageListener(this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
        }
        this.model = v;
        if (this.model != null) {
            this.dvy.setUnit(v.getUnit());
            this.dvy.setName(v.getName());
            this.model.addImageListener(this);
            if (this.pf != null) {
                this.pf.setModel(this.model);
            }
        }
    }

    public String setSettings(String cfg) {
        CfFileReader f = new CfFileReader();
        if (!f.parseText(cfg)) {
            return "DualSpectrumImageViewer.setSettings: Failed to parse given config";
        }
        this.applyConfiguration(f);
        this.getXAxis().applyConfiguration("x", f);
        this.getY1Axis().applyConfiguration("y1", f);
        this.dvy.applyConfiguration("dvy", f);
        return "";
    }

    public String getSettings() {
        String to_write = "";
        to_write = to_write + this.getConfiguration();
        to_write = to_write + this.getXAxis().getConfiguration("x");
        to_write = to_write + this.getY1Axis().getConfiguration("y1");
        to_write = to_write + this.dvy.getConfiguration("dvy");
        return to_write;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        DualSpectrumImageViewer d = new DualSpectrumImageViewer();
        if (args.length != 1) {
            JOptionPane.showMessageDialog(null, "Invalid parameters:\nUsage: DualSpectrumImageViewer full_att_name (where full_att_name is a 2 lines image attribue)", "Error", 0);
            System.exit(0);
        }
        try {
            AttributeList attributeList = new AttributeList();
            INumberImage theAtt = (INumberImage)attributeList.add(args[0]);
            d.setModel(theAtt);
            f.getContentPane().setLayout(new GridLayout(1, 1));
            f.getContentPane().add(d);
            f.setDefaultCloseOperation(3);
            f.setTitle("DualSpectrumViewer:" + args[0]);
            f.setSize(640, 480);
            f.setVisible(true);
            attributeList.setRefreshInterval(3000);
            attributeList.startRefresher();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

