/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.DigitalNumberViewer;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DigitalNumberScalarViewer
extends DigitalNumberViewer
implements INumberScalarListener,
PropertyChangeListener,
IErrorListener,
JDrawable {
    INumberScalar model = null;
    boolean alarmEnabled = true;
    Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    String userFormat = null;
    private boolean hasToolTip = false;
    private boolean qualityInTooltip = false;
    static String[] exts = new String[]{"userFormat", "alarmEnabled", "validBackground", "fontSize"};

    public DigitalNumberScalarViewer() {
        this.setOpaque(true);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    public void setUserFormat(String format) {
        if (format == null || format.equals("")) {
            this.userFormat = null;
        } else {
            this.userFormat = format;
            this.setFormat(this.userFormat);
        }
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equalsIgnoreCase("userFormat")) {
            return "Overrides the tango attribute format property when specified.\nSupports C format, ex:%5.2f .";
        }
        if (name.equalsIgnoreCase("alarmEnabled")) {
            return "When enabled, the background color change with the\nTango attribute quality factor.\nDefault colors are: ( unless they have been changed with\nATKConstant.setColor4Quality() )\n VALID   => Green\n INVALID => Grey\n ALARM   => Orange\n WARNING => Orange\n CHANGING => Blue\n UNKNOWN => Grey\nPossible values are: true, false.";
        }
        if (name.equalsIgnoreCase("validBackground")) {
            return "Sets the background color (r,g,b) for the VALID quality factor for this viewer.\nHas effect only if alarmEnabled is true.";
        }
        if (name.equalsIgnoreCase("fontSize")) {
            return "Sets the digit size.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("userFormat")) {
            this.setUserFormat(value);
            return true;
        }
        if (name.equalsIgnoreCase("alarmEnabled")) {
            if (value.equalsIgnoreCase("true")) {
                this.setAlarmEnabled(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setAlarmEnabled(false);
                return true;
            }
            this.showJdrawError(popupErr, "alarmEnabled", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("validBackground")) {
            String[] c = value.split(",");
            if (c.length != 3) {
                this.showJdrawError(popupErr, "validBackground", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int r = Integer.parseInt(c[0]);
                int g = Integer.parseInt(c[1]);
                int b = Integer.parseInt(c[2]);
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    this.showJdrawError(popupErr, "validBackground", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setBackgroundColor(new Color(r, g, b));
                return true;
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "validBackground", "Wrong integer syntax.");
                return false;
            }
        }
        if (name.equalsIgnoreCase("fontSize")) {
            try {
                int s = Integer.parseInt(value);
                if (s <= 10) {
                    this.showJdrawError(popupErr, "fontSize", "Parameter must be greater than 10");
                    return false;
                }
                this.setFontSize(s);
                return true;
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "fontSize", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("userFormat")) {
            if (this.userFormat == null) {
                return "";
            }
            return this.userFormat;
        }
        if (name.equals("alarmEnabled")) {
            return this.isAlarmEnabled() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("validBackground")) {
            Color c = this.backgroundColor;
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        if (name.equalsIgnoreCase("fontSize")) {
            return Integer.toString(this.getFontSize());
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "DigitalNumberScalarViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    @Override
    public void numberScalarChange(NumberScalarEvent evt) {
        this.setValue(evt.getValue());
    }

    public void setAlarmEnabled(boolean b) {
        this.alarmEnabled = b;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    @Override
    public void stateChange(AttributeStateEvent evt) {
        String state = evt.getState();
        if (this.hasToolTip && this.qualityInTooltip) {
            IAttribute attSource = (IAttribute)evt.getSource();
            this.setToolTipText(attSource.getName() + " : " + state);
        }
        if (state.equals("INVALID")) {
            this.setValue(Double.NaN);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (state.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            this.repaint();
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(state));
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.setValue(Double.NaN);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null) {
            if (src.getName().equalsIgnoreCase("format") && this.userFormat == null) {
                this.setFormat(src.getValue().toString());
            }
            this.model.refresh();
        }
    }

    public void setModel(INumberScalar scalar) {
        this.clearModel();
        if (scalar != null) {
            if (this.userFormat == null) {
                this.setFormat(scalar.getProperty("format").getPresentation());
            }
            this.model = scalar;
            this.model.addNumberScalarListener(this);
            this.model.getProperty("format").addPresentationListener(this);
            if (this.hasToolTip) {
                this.setToolTipText(scalar.getName());
            }
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.hasToolTip) {
            this.setToolTipText(null);
        }
        if (this.model != null) {
            this.model.removeNumberScalarListener(this);
            this.model.getProperty("format").removePresentationListener(this);
            this.model = null;
        }
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean b) {
        if (this.hasToolTip == b) {
            return;
        }
        this.hasToolTip = b;
        if (!this.hasToolTip) {
            this.setToolTipText(null);
            return;
        }
        if (this.model != null) {
            this.setToolTipText(this.model.getName());
        }
    }

    public boolean getQualityInTooltip() {
        return this.qualityInTooltip;
    }

    public void setQualityInTooltip(boolean b) {
        INumberScalar attModel = null;
        if (!this.hasToolTip) {
            this.qualityInTooltip = b;
            return;
        }
        if (this.qualityInTooltip != b) {
            if (this.model != null) {
                attModel = this.model;
            }
            if (!b && attModel != null) {
                this.setToolTipText(attModel.getName());
            }
            this.qualityInTooltip = b;
        }
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        DigitalNumberScalarViewer snv = new DigitalNumberScalarViewer();
        String attributeName = "jlp/test/1/att_un";
        IAttribute attribute = null;
        try {
            attribute = (IAttribute)attributeList.add(attributeName);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage(null, "jlp/test/1", e);
            attribute = null;
        }
        snv.setModel((INumberScalar)attribute);
        snv.setBorder(BorderFactory.createLoweredBevelBorder());
        snv.setBackgroundColor(Color.WHITE);
        snv.setForeground(Color.BLACK);
        snv.setHasToolTip(true);
        if (attribute != null) {
            attribute.refresh();
        }
        JFrame f = new JFrame();
        f.setContentPane(snv);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
        attributeList.startRefresher();
    }
}

