/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class DevStateScalarComboEditor
extends JComboBox
implements ActionListener,
IDevStateScalarListener {
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private IDevStateScalar stateModel = null;
    private String[] defOptionList = new String[]{"ON", "OFF", "CLOSE", "OPEN", "INSERT", "EXTRACT", "MOVING", "STANDBY", "FAULT", "INIT", "RUNNING", "ALARM", "DISABLE", "UNKNOWN"};
    private String[] optionList = new String[]{"None"};

    public DevStateScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IDevStateScalar getStateModel() {
        return this.stateModel;
    }

    public void setStateModel(IDevStateScalar m) {
        this.clearModel();
        if (m == null) {
            return;
        }
        if (!m.isWritable()) {
            throw new IllegalArgumentException("DevStateScalarComboEditor: Only accept writable attribute.");
        }
        this.stateModel = m;
        this.optionList = this.defOptionList;
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.changeCurrentSelection(-1);
        this.stateModel.addDevStateScalarListener(this);
        this.stateModel.refresh();
    }

    public void clearModel() {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateScalarListener(this);
            this.stateModel = null;
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
    }

    @Override
    public void devStateScalarChange(DevStateScalarEvent e) {
        String set = null;
        int currentSelection = this.getSelectedIndex();
        set = this.hasFocus() ? this.stateModel.getDeviceSetPoint() : this.stateModel.getSetPoint();
        if (set == null) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException iaex) {
                System.out.println("caught exception : " + iaex.getMessage());
            }
            return;
        }
        if (this.optionList == null) {
            return;
        }
        for (int index = 0; index < this.optionList.length; ++index) {
            if (!set.equals(this.optionList[index])) continue;
            if (currentSelection != index) {
                this.changeCurrentSelection(index);
            }
            return;
        }
        try {
            this.changeCurrentSelection(-1);
        }
        catch (IllegalArgumentException iaex) {
            System.out.println("caught exception : " + iaex.getMessage());
        }
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent e) {
        if (this.stateModel == null) {
            return;
        }
        int currentSelection = this.getSelectedIndex();
        if (currentSelection != -1) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException iaex) {
                System.out.println("caught exception : " + iaex.getMessage());
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = null;
        String cmdOption = null;
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.stateModel == null) {
            return;
        }
        cb = (JComboBox)e.getSource();
        cmdOption = (String)cb.getSelectedItem();
        if (cmdOption == null) {
            return;
        }
        this.stateModel.setValue(cmdOption);
    }

    private void changeCurrentSelection(int newIndex) {
        this.disableExecution();
        this.setSelectedIndex(newIndex);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        DevStateScalarComboEditor dssce = new DevStateScalarComboEditor();
        JFrame mainFrame = null;
        try {
            IDevStateScalar stateAtt;
            IEntity ie = attList.add("dev/test/10/State_attr_rw");
            if (ie instanceof IDevStateScalar) {
                stateAtt = (IDevStateScalar)ie;
                System.out.println("Is an IDevStateScalar!");
            } else {
                stateAtt = null;
            }
            if (stateAtt == null) {
                System.exit(-1);
            }
            dssce.setStateModel(stateAtt);
        }
        catch (Exception e) {
            System.out.println("caught exception : " + e.getMessage());
            System.exit(-1);
        }
        attList.startRefresher();
        mainFrame = new JFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setContentPane(dssce);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

