/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.widget.attribute.BooleanChart;
import fr.esrf.tangoatk.widget.attribute.BooleanConfigPanel;
import fr.esrf.tangoatk.widget.attribute.BooleanTrendRenderer;
import fr.esrf.tangoatk.widget.attribute.BooleanTrendSelectionNode;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.IControlee;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class BooleanTrend
extends JPanel
implements IControlee,
ActionListener,
IJLChartActionListener,
IRefresherListener {
    public static final int SEL_NONE = 0;
    public static final int SEL_Y1 = 2;
    public static final int SEL_Y2 = 3;
    public static final int DEVICE_LABEL_AUTO = 0;
    public static final int DEVICE_LABEL_NEVER = 1;
    public static final int DEVICE_LABEL_ALWAYS = 2;
    static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    protected JFrame parent = null;
    protected JToolBar theToolBar;
    protected JPopupMenu toolMenu;
    protected JButton optionButton;
    protected JMenuItem optionMenuI;
    protected JButton stopButton;
    protected JMenuItem stopMenuI;
    protected JButton startButton;
    protected JMenuItem startMenuI;
    protected JButton loadButton;
    protected JMenuItem loadMenuI;
    protected JButton saveButton;
    protected JMenuItem saveMenuI;
    protected JButton zoomButton;
    protected JMenuItem zoomMenuI;
    protected JButton timeButton;
    protected JMenuItem timeMenuI;
    protected JButton cfgButton;
    protected JMenuItem cfgMenuI;
    protected JButton resetButton;
    protected JMenuItem resetMenuI;
    protected JMenuItem showtoolMenuI;
    protected JPanel innerPanel;
    protected JLabel dateLabel;
    protected JScrollPane treeView = null;
    protected JTree mainTree = null;
    protected DefaultTreeModel mainTreeModel = null;
    protected BooleanTrendSelectionNode rootNode = null;
    protected JPopupMenu treeMenu;
    protected JMenuItem addY1MenuItem;
    protected JMenuItem addY2MenuItem;
    protected JMenuItem removeMenuItem;
    protected JMenuItem optionMenuItem;
    protected JMenuItem attOptionMenuItem;
    protected BooleanChart theGraph;
    protected String graphTitle = "";
    protected BooleanConfigPanel cfgPanel = null;
    protected static Point framePos = new Point(0, 0);
    protected static Point frameDimension = new Point(640, 480);
    protected AttributePolledList attList = null;
    protected BooleanTrendSelectionNode lastAdded = null;
    protected AttributePolledList lastCreatedList = null;
    protected SimplePropertyFrame propFrame = null;
    protected String lastConfig = "";
    protected boolean singleDevice = true;
    protected int isShowingDeviceName = 0;
    protected static final GregorianCalendar calendar = new GregorianCalendar();
    protected static final SimpleDateFormat genFormat = new SimpleDateFormat("EEE dd/MM/yy HH:mm:ss");
    protected Map buttonMap = new HashMap();
    public static final String start = "START";
    public static final String stop = "STOP";
    public static final String save = "SAVE";
    public static final String load = "LOAD";
    public static final String zoom = "ZOOM";
    public static final String time = "TIME";
    public static final String option = "OPTION";
    public static final String config = "CONFIG";
    public static final String reset = "RESET";
    protected int timePrecision = 0;
    protected static final String[] labels = new String[]{"true", "false"};
    protected static final double[] labelPositions = new double[]{1.0, 0.0};
    protected static final double[] defaultMinMax = new double[]{-0.01, 1.1};
    protected static final IEntityFilter booleanFilter = new IEntityFilter(){

        @Override
        public boolean keep(IEntity entity) {
            return entity instanceof IBooleanScalar;
        }
    };

    public BooleanTrend(JFrame parent) {
        this();
        this.parent = parent;
    }

    public BooleanTrend() {
        this.theToolBar = new JToolBar();
        this.toolMenu = new JPopupMenu();
        this.optionButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_settings.gif")));
        this.optionButton.setToolTipText("Global settings");
        this.optionMenuI = new JMenuItem("Global settings");
        this.stopButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_stop.gif")));
        this.stopButton.setToolTipText("Stop monitoring");
        this.stopMenuI = new JMenuItem("Stop monitoring");
        this.startButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_start.gif")));
        this.startButton.setToolTipText("Start monitoring");
        this.startMenuI = new JMenuItem("Start monitoring");
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_load.gif")));
        this.loadButton.setToolTipText("Load configuration");
        this.loadMenuI = new JMenuItem("Load configuration");
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_save.gif")));
        this.saveButton.setToolTipText("Save configuration");
        this.saveMenuI = new JMenuItem("Save configuration");
        this.zoomButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_zoom.gif")));
        this.zoomButton.setToolTipText("Zoom");
        this.zoomMenuI = new JMenuItem("Zoom");
        this.timeButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_time.gif")));
        this.timeButton.setToolTipText("Set refresh interval");
        this.timeMenuI = new JMenuItem("Set refresh interval");
        this.cfgButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_config.gif")));
        this.cfgButton.setToolTipText("Add new attribute");
        this.cfgMenuI = new JMenuItem("Add new attribute");
        this.resetButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_reset.gif")));
        this.resetButton.setToolTipText("Reset trend");
        this.resetMenuI = new JMenuItem("Reset trend");
        this.showtoolMenuI = new JMenuItem("Hide toolbar");
        this.theToolBar.setFloatable(true);
        this.loadButton.addActionListener(this);
        this.loadMenuI.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.saveMenuI.addActionListener(this);
        this.optionButton.addActionListener(this);
        this.optionMenuI.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.zoomMenuI.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.stopMenuI.addActionListener(this);
        this.startButton.addActionListener(this);
        this.startMenuI.addActionListener(this);
        this.timeButton.addActionListener(this);
        this.timeMenuI.addActionListener(this);
        this.cfgButton.addActionListener(this);
        this.cfgMenuI.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.resetMenuI.addActionListener(this);
        this.showtoolMenuI.addActionListener(this);
        this.theToolBar.add(this.loadButton);
        this.theToolBar.add(this.saveButton);
        this.theToolBar.add(this.optionButton);
        this.theToolBar.add(this.zoomButton);
        this.theToolBar.add(this.startButton);
        this.theToolBar.add(this.stopButton);
        this.theToolBar.add(this.timeButton);
        this.theToolBar.add(this.cfgButton);
        this.theToolBar.add(this.resetButton);
        this.buttonMap.put(load, this.loadButton);
        this.buttonMap.put(save, this.saveButton);
        this.buttonMap.put(option, this.optionButton);
        this.buttonMap.put(zoom, this.zoomButton);
        this.buttonMap.put(start, this.startButton);
        this.buttonMap.put(stop, this.stopButton);
        this.buttonMap.put(time, this.timeButton);
        this.buttonMap.put(config, this.cfgButton);
        this.buttonMap.put(reset, this.resetButton);
        this.toolMenu.add(this.loadMenuI);
        this.toolMenu.add(this.saveMenuI);
        this.toolMenu.add(this.optionMenuI);
        this.toolMenu.add(this.zoomMenuI);
        this.toolMenu.add(this.startMenuI);
        this.toolMenu.add(this.stopMenuI);
        this.toolMenu.add(this.timeMenuI);
        this.toolMenu.add(this.cfgMenuI);
        this.toolMenu.add(this.resetMenuI);
        this.toolMenu.add(this.showtoolMenuI);
        this.theGraph = new BooleanChart();
        this.theGraph.setBorder(new EtchedBorder());
        this.theGraph.setBackground(new Color(180, 180, 180));
        this.theGraph.getY1Axis().setAutoScale(false);
        this.theGraph.getY1Axis().setMinimum(defaultMinMax[0]);
        this.theGraph.getY1Axis().setMaximum(defaultMinMax[1]);
        this.theGraph.getY1Axis().setLabels(labels, labelPositions);
        this.theGraph.getY2Axis().setAutoScale(false);
        this.theGraph.getY2Axis().setMinimum(defaultMinMax[0]);
        this.theGraph.getY2Axis().setMaximum(defaultMinMax[1]);
        this.theGraph.getY2Axis().setLabels(labels, labelPositions);
        this.theGraph.getXAxis().setAutoScale(true);
        this.theGraph.setDisplayDuration(300000.0);
        this.theGraph.addUserAction("chkShow toolbar");
        this.theGraph.addUserAction("chkShow selection tree");
        this.theGraph.addUserAction("chkShow date");
        this.theGraph.addUserAction("Load configuration");
        this.theGraph.addUserAction("Save configuration");
        this.theGraph.addJLChartActionListener(this);
        this.theGraph.setMaxDisplayDuration(8.64E7);
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.theToolBar, "North");
        this.innerPanel.add((Component)this.theGraph, "Center");
        this.add((Component)this.innerPanel, "Center");
        this.treeMenu = new JPopupMenu();
        this.addY1MenuItem = new JMenuItem("Add to Y1");
        this.addY2MenuItem = new JMenuItem("Add to Y2");
        this.removeMenuItem = new JMenuItem("Remove");
        this.optionMenuItem = new JMenuItem("Graphic properties");
        this.attOptionMenuItem = new JMenuItem("Attribute properties");
        this.treeMenu.add(this.addY1MenuItem);
        this.treeMenu.add(this.addY2MenuItem);
        this.treeMenu.add(this.removeMenuItem);
        this.treeMenu.add(this.optionMenuItem);
        this.treeMenu.add(this.attOptionMenuItem);
        this.addY1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = BooleanTrend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (selNode.getModel() == null || selNode.getSelected() == 2) continue;
                    selNode.setSelected(2);
                }
                BooleanTrend.this.mainTree.repaint();
                BooleanTrend.this.theGraph.repaint();
            }
        });
        this.addY2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = BooleanTrend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (selNode.getModel() == null || selNode.getSelected() == 3) continue;
                    selNode.setSelected(3);
                }
                BooleanTrend.this.mainTree.repaint();
                BooleanTrend.this.theGraph.repaint();
            }
        });
        this.removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = BooleanTrend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (selNode.getModel() == null) continue;
                    selNode.setSelected(0);
                }
                BooleanTrend.this.mainTree.repaint();
                BooleanTrend.this.theGraph.repaint();
            }
        });
        this.optionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)BooleanTrend.this.mainTree.getSelectionPath().getLastPathComponent();
                IBooleanScalar m = selNode.getModel();
                if (m != null) {
                    selNode.showOptions();
                }
            }
        });
        this.attOptionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)BooleanTrend.this.mainTree.getSelectionPath().getLastPathComponent();
                IBooleanScalar m = selNode.getModel();
                if (m != null) {
                    if (BooleanTrend.this.propFrame == null) {
                        BooleanTrend.this.propFrame = new SimplePropertyFrame();
                    }
                    BooleanTrend.this.propFrame.setModel(m);
                    BooleanTrend.this.propFrame.setVisible(true);
                }
            }
        });
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.dateLabel = new JLabel();
        this.dateLabel.setText(genFormat.format(calendar.getTime()));
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setVisible(false);
        this.add((Component)this.dateLabel, "South");
    }

    void refreshNode(BooleanTrendSelectionNode n) {
        this.theGraph.repaint();
        this.mainTreeModel.nodeChanged(n);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.optionButton || o == this.optionMenuI) {
            this.optionButtonActionPerformed();
        } else if (o == this.stopButton || o == this.stopMenuI) {
            this.attList.stopRefresher();
        } else if (o == this.startButton || o == this.startMenuI) {
            this.attList.startRefresher();
        } else if (o == this.loadButton || o == this.loadMenuI) {
            this.loadButtonActionPerformed();
        } else if (o == this.saveButton || o == this.saveMenuI) {
            this.saveButtonActionPerformed();
        } else if (o == this.zoomButton || o == this.zoomMenuI) {
            if (!this.theGraph.isZoomed()) {
                this.theGraph.enterZoom();
            } else {
                this.theGraph.exitZoom();
            }
        } else if (o == this.timeButton || o == this.timeMenuI) {
            this.setRefreshInterval();
        } else if (o == this.cfgButton || o == this.cfgMenuI) {
            if (this.cfgPanel == null) {
                Window w = ATKGraphicsUtils.getWindowForComponent(this);
                this.cfgPanel = w instanceof Frame ? new BooleanConfigPanel((Frame)w, this) : (w instanceof Dialog ? new BooleanConfigPanel((Dialog)w, this) : new BooleanConfigPanel((Frame)null, this));
            }
            this.cfgPanel.showPanel();
        } else if (o == this.showtoolMenuI) {
            boolean b = this.isButtonBarVisible();
            b = !b;
            this.setButtonBarVisible(b);
        } else if (o == this.resetButton || o == this.resetMenuI) {
            this.resetTrend();
        }
    }

    @Override
    public void actionPerformed(JLChartActionEvent evt) {
        if (evt.getName().equals("Show toolbar")) {
            this.setButtonBarVisible(evt.getState());
        } else if (evt.getName().equals("Show selection tree")) {
            this.setSelectionTreeVisible(evt.getState());
        } else if (evt.getName().equals("Show date")) {
            this.setDateVisible(evt.getState());
        } else if (evt.getName().equalsIgnoreCase("Load configuration")) {
            this.loadButtonActionPerformed();
        } else if (evt.getName().equalsIgnoreCase("Save configuration")) {
            this.saveButtonActionPerformed();
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent evt) {
        if (evt.getName().equals("Show toolbar")) {
            return this.isButtonBarVisible();
        }
        if (evt.getName().equals("Show selection tree")) {
            return this.isSelectionTreeVisible();
        }
        if (evt.getName().equals("Show date")) {
            return this.isDateVisible();
        }
        return false;
    }

    public int getTimePrecision() {
        return this.timePrecision;
    }

    public void setTimePrecision(int timePrecision) {
        this.timePrecision = timePrecision;
        if (this.theGraph != null) {
            this.theGraph.setTimePrecision(timePrecision);
        }
    }

    @Override
    public void refreshStep() {
        if (this.isDateVisible()) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            this.dateLabel.setText(genFormat.format(calendar.getTime()));
        }
        this.theGraph.repaint();
    }

    private void setRefreshInterval() {
        int old_it = this.attList.getRefreshInterval();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                this.attList.setRefreshInterval(it);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.parent, "Invalid number !", "Error", 0);
            }
        }
    }

    private void updateModel() {
        this.singleDevice = true;
        if (this.attList != null) {
            int i;
            int sz = this.attList.size();
            if (sz > 1) {
                IBooleanScalar s = (IBooleanScalar)this.attList.get(0);
                String dName = s.getDevice().getName();
                for (i = 1; i < sz && this.singleDevice; ++i) {
                    s = (IBooleanScalar)this.attList.get(i);
                    this.singleDevice = dName.equalsIgnoreCase(s.getDevice().getName());
                }
            }
            Vector v = this.rootNode.getSelectableItems();
            for (i = 0; i < v.size(); ++i) {
                ((BooleanTrendSelectionNode)v.get(i)).refreshNode();
            }
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public void setModel(AttributePolledList list) {
        int i;
        this.theGraph.unselectAll();
        if (this.attList != null) {
            this.attList.stopRefresher();
            this.attList.removeRefresherListener(this);
            this.attList.clear();
        }
        if (this.rootNode != null) {
            Vector dv = this.rootNode.getSelectableItems();
            for (i = 0; i < dv.size(); ++i) {
                BooleanTrendSelectionNode n = (BooleanTrendSelectionNode)dv.get(i);
                n.clearModel();
            }
        }
        if (this.lastCreatedList != null) {
            this.lastCreatedList.stopRefresher();
            this.lastCreatedList.clear();
            this.lastCreatedList = null;
        }
        this.rootNode = new BooleanTrendSelectionNode(this);
        if (list != null) {
            for (i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof IBooleanScalar)) continue;
                int j = i;
                this.lastAdded = this.rootNode.addItem(this, (IBooleanScalar)list.get(j), defaultColor[j % defaultColor.length]);
            }
        }
        BooleanTrendRenderer renderer = new BooleanTrendRenderer();
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setCellRenderer(renderer);
        this.mainTree.setEditable(false);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setRootVisible(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BooleanTrend.this.revalidate();
                int selRow = BooleanTrend.this.mainTree.getRowForLocation(e.getX(), e.getY());
                TreePath[] selPaths = BooleanTrend.this.mainTree.getSelectionPaths();
                if (selRow != -1 && e.getClickCount() == 1 && e.getButton() == 3 && selPaths != null && selPaths.length > 0) {
                    if (selPaths.length == 1) {
                        BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)selPaths[0].getLastPathComponent();
                        if (selNode.getModel() != null) {
                            BooleanTrend.this.addY1MenuItem.setEnabled(selNode.getSelected() != 2);
                            BooleanTrend.this.addY2MenuItem.setEnabled(selNode.getSelected() != 3);
                            BooleanTrend.this.removeMenuItem.setEnabled(selNode.getSelected() != 0);
                            BooleanTrend.this.treeMenu.show(BooleanTrend.this.mainTree, e.getX(), e.getY());
                        } else if (selNode == BooleanTrend.this.rootNode) {
                            if (BooleanTrend.this.isButtonBarVisible()) {
                                BooleanTrend.this.showtoolMenuI.setText("Hide toolbar");
                            } else {
                                BooleanTrend.this.showtoolMenuI.setText("Show toolbar");
                            }
                            BooleanTrend.this.toolMenu.show(BooleanTrend.this.mainTree, e.getX(), e.getY());
                        }
                    } else {
                        BooleanTrendSelectionNode lastAttributeNode = null;
                        int attributeCount = 0;
                        boolean containsRootNode = false;
                        for (int i = 0; i < selPaths.length; ++i) {
                            BooleanTrendSelectionNode selNode = (BooleanTrendSelectionNode)selPaths[i].getLastPathComponent();
                            if (selNode.getModel() != null) {
                                ++attributeCount;
                                lastAttributeNode = selNode;
                                continue;
                            }
                            if (selNode != BooleanTrend.this.rootNode) continue;
                            containsRootNode = true;
                        }
                        if (attributeCount > 0) {
                            if (attributeCount == 1) {
                                BooleanTrend.this.addY1MenuItem.setEnabled(lastAttributeNode.getSelected() != 2);
                                BooleanTrend.this.addY2MenuItem.setEnabled(lastAttributeNode.getSelected() != 3);
                                BooleanTrend.this.removeMenuItem.setEnabled(lastAttributeNode.getSelected() != 0);
                            } else {
                                BooleanTrend.this.addY1MenuItem.setEnabled(true);
                                BooleanTrend.this.addY2MenuItem.setEnabled(true);
                                BooleanTrend.this.removeMenuItem.setEnabled(true);
                            }
                            BooleanTrend.this.treeMenu.show(BooleanTrend.this.mainTree, e.getX(), e.getY());
                            lastAttributeNode = null;
                        } else if (containsRootNode) {
                            if (BooleanTrend.this.isButtonBarVisible()) {
                                BooleanTrend.this.showtoolMenuI.setText("Hide toolbar");
                            } else {
                                BooleanTrend.this.showtoolMenuI.setText("Show toolbar");
                            }
                            BooleanTrend.this.toolMenu.show(BooleanTrend.this.mainTree, e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        this.innerPanel.add((Component)this.treeView, "West");
        this.attList = list;
        if (this.attList != null) {
            this.attList.addRefresherListener(this);
        }
        this.updateModel();
    }

    public void addAttribute(String name) {
        try {
            if (this.attList == null) {
                AttributePolledList alist = new AttributePolledList();
                alist.setFilter(booleanFilter);
                alist.add(name);
                this.setModel(alist);
                this.lastCreatedList = alist;
                alist.setRefreshInterval(1000);
                alist.startRefresher();
            } else if (this.attList.get(name) == null) {
                IBooleanScalar scalar = (IBooleanScalar)this.attList.add(name);
                int i = this.attList.size();
                this.lastAdded = this.rootNode.addItem(this, scalar, defaultColor[i % defaultColor.length]);
                this.mainTreeModel = new DefaultTreeModel(this.rootNode);
                this.mainTree.setModel(this.mainTreeModel);
            }
            TreePath np = new TreePath(this.lastAdded.getPath());
            this.mainTree.setSelectionPath(np);
            this.mainTree.expandPath(np);
            this.mainTree.makeVisible(np);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.updateModel();
        this.theGraph.repaint();
        this.innerPanel.revalidate();
    }

    public void addAttribute(IBooleanScalar scalar) {
        if (this.attList == null) {
            AttributePolledList alist = new AttributePolledList();
            alist.setFilter(booleanFilter);
            alist.add(scalar);
            this.setModel(alist);
            this.lastCreatedList = alist;
            alist.setRefreshInterval(1000);
            alist.startRefresher();
        } else if (!this.attList.contains(scalar)) {
            this.attList.add(scalar);
            int i = this.attList.size();
            this.lastAdded = this.rootNode.addItem(this, scalar, defaultColor[i % defaultColor.length]);
            this.mainTreeModel = new DefaultTreeModel(this.rootNode);
            this.mainTree.setModel(this.mainTreeModel);
        }
        TreePath np = new TreePath(this.lastAdded.getPath());
        this.mainTree.setSelectionPath(np);
        this.mainTree.expandPath(np);
        this.mainTree.makeVisible(np);
        this.updateModel();
        this.theGraph.repaint();
        this.innerPanel.revalidate();
    }

    public void removeAttribute(IBooleanScalar scalar) {
        this.lastAdded = null;
        if (this.attList.contains(scalar)) {
            System.out.println("Removing " + scalar.getName());
            this.rootNode.delItem(scalar);
            this.attList.remove(scalar.getName());
            this.mainTreeModel = new DefaultTreeModel(this.rootNode);
            this.mainTree.setModel(this.mainTreeModel);
            this.innerPanel.revalidate();
            this.updateModel();
        }
    }

    public AttributePolledList getModel() {
        return this.attList;
    }

    private void optionButtonActionPerformed() {
        this.theGraph.showOptionDialog();
    }

    private void saveButtonActionPerformed() {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("txt");
            }

            @Override
            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showSaveDialog(this.parent)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(f) == null) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this.parent, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                this.saveSetting(f.getAbsolutePath());
            }
        }
    }

    private void loadButtonActionPerformed() {
        String err;
        File f;
        int returnVal;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showOpenDialog(this.parent)) == 0 && (f = chooser.getSelectedFile()) != null && !ok && (err = this.loadSetting(f.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this.parent, err, "Errors reading " + f.getName(), 0);
        }
    }

    public String getSettings() {
        String to_write = "";
        to_write = to_write + this.theGraph.getConfiguration();
        to_write = to_write + "toolbar_visible:" + this.isButtonBarVisible() + "\n";
        to_write = to_write + "tree_visible:" + this.isSelectionTreeVisible() + "\n";
        to_write = to_write + "date_visible:" + this.isDateVisible() + "\n";
        if (this.graphTitle.length() > 0) {
            to_write = to_write + "frame_title:'" + this.graphTitle + "'\n";
        }
        to_write = to_write + "window_pos:" + this.getLocationOnScreen().x + "," + this.getLocationOnScreen().y + "\n";
        to_write = to_write + "window_size:" + this.getSize().width + "," + this.getSize().height + "\n";
        to_write = to_write + "show_device_name:" + this.isShowingDeviceNames() + "\n";
        if (this.attList != null) {
            to_write = to_write + "refresh_time:" + this.attList.getRefreshInterval() + "\n";
        }
        to_write = to_write + this.theGraph.getXAxis().getConfiguration("x");
        to_write = to_write + this.theGraph.getY1Axis().getConfiguration("y1");
        to_write = to_write + this.theGraph.getY2Axis().getConfiguration("y2");
        if (this.rootNode == null) {
            return to_write;
        }
        Vector dv = this.rootNode.getSelectableItems();
        to_write = to_write + "dv_number:" + dv.size() + "\n";
        for (int i = 0; i < dv.size(); ++i) {
            BooleanTrendSelectionNode n = (BooleanTrendSelectionNode)dv.get(i);
            to_write = to_write + "dv" + i + "_name:'" + n.getModelName() + "'\n";
            to_write = to_write + "dv" + i + "_selected:" + n.getSelected() + "\n";
            to_write = to_write + n.getData().getConfiguration("dv" + i);
        }
        return to_write;
    }

    private String applySettings(CfFileReader f) {
        int i;
        int nbDv;
        String errBuff = "";
        this.theGraph.setMaxDisplayDuration(Double.POSITIVE_INFINITY);
        this.theGraph.setDisplayDuration(Double.POSITIVE_INFINITY);
        AttributePolledList alist = new AttributePolledList();
        alist.setFilter(booleanFilter);
        Vector<String> p = f.getParam("dv_number");
        if (p != null) {
            try {
                nbDv = Integer.parseInt(p.get(0).toString());
            }
            catch (NumberFormatException e) {
                errBuff = errBuff + "dv_number: invalid number\n";
                return errBuff;
            }
            for (i = 0; i < nbDv; ++i) {
                p = f.getParam("dv" + i + "_name");
                if (p == null) {
                    errBuff = errBuff + "Unable to find dv" + i + "_name param\n";
                    return errBuff;
                }
                try {
                    alist.add(p.get(0).toString());
                    continue;
                }
                catch (Exception e) {
                    errBuff = errBuff + e.getMessage() + "\n";
                }
            }
            if (nbDv > 0) {
                if (this.attList != null) {
                    this.innerPanel.remove(this.treeView);
                    this.treeView = null;
                    this.mainTree = null;
                }
                if ((p = f.getParam("refresh_time")) != null) {
                    alist.setRefreshInterval(OFormat.getInt(p.get(0).toString()));
                } else {
                    alist.setRefreshInterval(1000);
                }
                alist.startRefresher();
                this.setModel(alist);
                this.lastCreatedList = alist;
            }
        } else {
            nbDv = 0;
        }
        this.innerPanel.revalidate();
        this.theGraph.applyConfiguration(f);
        this.theGraph.setMaxDisplayDuration(8.64E7);
        p = f.getParam("toolbar_visible");
        if (p != null) {
            this.setButtonBarVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("tree_visible")) != null) {
            this.setSelectionTreeVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("date_visible")) != null) {
            this.setDateVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("frame_title")) != null) {
            this.graphTitle = p.get(0).toString();
        }
        if ((p = f.getParam("window_pos")) != null) {
            framePos = OFormat.getPoint(p);
        }
        if ((p = f.getParam("window_size")) != null) {
            frameDimension = OFormat.getPoint(p);
        }
        if ((p = f.getParam("show_device_name")) != null) {
            this.setShowingDeviceNames(OFormat.getInt(p.get(0).toString()));
        }
        this.theGraph.getXAxis().applyConfiguration("x", f);
        this.theGraph.getY1Axis().applyConfiguration("y1", f);
        this.theGraph.getY2Axis().applyConfiguration("y2", f);
        if (this.rootNode == null) {
            return errBuff;
        }
        Vector dv = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode n = null;
        for (i = 0; i < nbDv; ++i) {
            String pref = "dv" + i;
            p = f.getParam(pref + "_name");
            String attName = p.get(0).toString();
            p = f.getParam(pref + "_selected");
            if (p == null) continue;
            int s = OFormat.getInt(p.get(0).toString());
            int j = 0;
            boolean found = false;
            while (!found && j < dv.size()) {
                n = (BooleanTrendSelectionNode)dv.get(j);
                found = n.getModelName().equals(attName);
                if (found) continue;
                ++j;
            }
            if (!found) continue;
            if (s > 0) {
                n.setSelected(s);
            }
            JLDataView d = n.getData();
            d.applyConfiguration(pref, f);
        }
        return errBuff;
    }

    public String setSetting(String txt) {
        CfFileReader f = new CfFileReader();
        if (!f.parseText(txt)) {
            return "Trend.setSettings: Failed to parse given text";
        }
        return this.applySettings(f);
    }

    public void saveSetting(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            String s = this.getSettings();
            f.write(s, 0, s.length());
            f.close();
            this.lastConfig = filename;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parent, "Failed to write " + filename, "Error", 0);
        }
    }

    public String loadSetting(String filename) {
        CfFileReader f = new CfFileReader();
        if (!f.readFile(filename)) {
            return "Failed to read " + filename;
        }
        this.lastConfig = filename;
        return this.applySettings(f);
    }

    public String getTitle() {
        return this.graphTitle;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = 0;
        return d;
    }

    public void setLegendVisible(boolean b) {
    }

    public boolean isLegendVisible() {
        return false;
    }

    public void setSamplingRate(double rate) {
    }

    public double getSamplingRate() {
        return 0.0;
    }

    public void setXAxisLength(int length) {
    }

    public int getXAxisLength() {
        return 0;
    }

    public void setLogarithmicScale(boolean logarithmic) {
    }

    public boolean isLogarithmicScale() {
        return false;
    }

    public void setListVisible(boolean b) {
    }

    public boolean isListVisible() {
        return false;
    }

    public void setShowingNames(boolean b) {
    }

    public boolean isShowingNames() {
        return false;
    }

    public void setShowingDeviceNames(int mode) {
        this.isShowingDeviceName = mode;
    }

    public int isShowingDeviceNames() {
        return this.isShowingDeviceName;
    }

    boolean displayDeviceNames() {
        switch (this.isShowingDeviceName) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return !this.singleDevice;
    }

    public void setButtonBarVisible(boolean b) {
        if (this.theToolBar != null) {
            this.theToolBar.setVisible(b);
        }
    }

    public boolean isButtonBarVisible() {
        if (this.theToolBar != null) {
            return this.theToolBar.isVisible();
        }
        return false;
    }

    public void setDateVisible(boolean b) {
        if (this.dateLabel != null) {
            this.dateLabel.setVisible(b);
        }
    }

    public boolean isDateVisible() {
        if (this.dateLabel != null) {
            return this.dateLabel.isVisible();
        }
        return false;
    }

    public void setSelectionTreeVisible(boolean b) {
        if (this.treeView != null) {
            this.treeView.setVisible(b);
            this.revalidate();
        }
    }

    public boolean isSelectionTreeVisible() {
        if (this.treeView != null) {
            return this.treeView.isVisible();
        }
        return false;
    }

    public JLChart getChart() {
        return this.theGraph;
    }

    @Override
    public void ok() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void disableButton(String buttonName) {
        JButton b = (JButton)this.buttonMap.get(buttonName);
        if (b != null) {
            b.setEnabled(false);
        }
    }

    public void enableButton(String buttonName) {
        JButton b = (JButton)this.buttonMap.get(buttonName);
        if (b != null) {
            b.setEnabled(true);
        }
    }

    public void addToAxis(String attributeName, int axisSelection, boolean addToModel) {
        if (addToModel) {
            try {
                if (this.getModel() == null) {
                    this.addAttribute(attributeName);
                } else if (this.getModel().get(attributeName) == null) {
                    this.addAttribute(attributeName);
                }
            }
            catch (ClassCastException e) {
                return;
            }
        }
        if (this.rootNode == null) {
            return;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (BooleanTrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attributeName);
            if (present) continue;
            ++i;
        }
        if (present) {
            switch (axisSelection) {
                case 0: 
                case 2: 
                case 3: {
                    attributeNode.setSelected(axisSelection);
                    this.mainTree.repaint();
                    this.theGraph.repaint();
                }
            }
            return;
        }
    }

    public void addToAxis(IBooleanScalar attribute, int axisSelection, boolean addToModel) {
        if (addToModel) {
            if (this.getModel() == null) {
                this.addAttribute(attribute);
            } else if (this.getModel().get(attribute.getName()) == null) {
                this.addAttribute(attribute);
            }
        }
        if (this.rootNode == null) {
            return;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (BooleanTrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attribute.getName());
            if (present) continue;
            ++i;
        }
        if (present) {
            switch (axisSelection) {
                case 0: 
                case 2: 
                case 3: {
                    attributeNode.setSelected(axisSelection);
                    this.mainTree.repaint();
                    this.theGraph.repaint();
                }
            }
            return;
        }
    }

    public int getAxisForAttribute(String attributeName) {
        int selectedAxis = 0;
        if (this.rootNode == null) {
            return selectedAxis;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (BooleanTrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attributeName);
            if (present) continue;
            ++i;
        }
        if (present) {
            selectedAxis = attributeNode.getSelected();
        }
        return selectedAxis;
    }

    public JLDataView getDataViewForAttribute(String attributeName) {
        JLDataView selectedData = null;
        if (this.rootNode == null) {
            return selectedData;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (BooleanTrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attributeName);
            if (present) continue;
            ++i;
        }
        if (present) {
            selectedData = attributeNode.getData();
        }
        return selectedData;
    }

    public void setMaxDisplayDuration(double maxDisplay) {
        this.theGraph.setMaxDisplayDuration(maxDisplay);
    }

    public double getMaxDisplayDuration() {
        return this.theGraph.getMaxDisplayDuration();
    }

    public void resetTrend() {
        if (this.rootNode != null) {
            Vector dv = this.rootNode.getSelectableItems();
            for (int i = 0; i < dv.size(); ++i) {
                BooleanTrendSelectionNode n = (BooleanTrendSelectionNode)dv.get(i);
                if (n == null || n.getData() == null) continue;
                n.getData().reset();
            }
            this.theGraph.repaint();
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame f = new JFrame();
        BooleanTrend t = new BooleanTrend();
        String entityName = "jlp/test/1/att_boolean";
        if (args.length > 0) {
            entityName = args[0];
        }
        try {
            t.addToAxis(entityName, 2, true);
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to " + entityName);
            System.out.println("Try to load " + entityName + " as a file");
            try {
                t.loadSetting(entityName);
            }
            catch (Exception e) {
                System.out.println("Failed to load " + entityName + " as a file. Exiting...");
                System.exit(-1);
            }
        }
        f.setDefaultCloseOperation(3);
        if (t.getTitle().length() > 0) {
            f.setTitle(t.getTitle());
        } else {
            f.setTitle("BooleanTrends");
        }
        f.setContentPane(t);
        Image image = Toolkit.getDefaultToolkit().getImage(t.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_icon.gif"));
        if (image != null) {
            f.setIconImage(image);
        }
        f.pack();
        f.setBounds(BooleanTrend.framePos.x, BooleanTrend.framePos.y, BooleanTrend.frameDimension.x, BooleanTrend.frameDimension.y);
        f.setVisible(true);
    }
}

