/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.Property;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BooleanSpectrumViewer
extends JPanel
implements IBooleanSpectrumListener,
PropertyChangeListener {
    public static final int TOOLTIP_NONE = 0;
    public static final int TOOLTIP_ATTNAME = 1;
    public static final int TOOLTIP_VALUE = 2;
    public static final int TOOLTIP_ATTNAME_VALUE = 3;
    public static final int DISPLAY_ICON = 0;
    public static final int DISPLAY_TEXT = 1;
    public static final int DISPLAY_ICON_TEXT = 2;
    private static ImageIcon TRUE_ICON = null;
    private static ImageIcon FALSE_ICON = null;
    private static ImageIcon ERROR_ICON = null;
    private static final String TRUE_LABEL = "True";
    private static final String FALSE_LABEL = "False";
    private static final String ERROR_LABEL = "Unknown";
    private Vector<JLabel> labelJLabels;
    private Vector<JLabel> valueJLabels;
    private Font globalFont;
    private boolean booleanLabelVisible;
    private int displayMode;
    private int toolTipMode;
    private ImageIcon trueIcon = null;
    private ImageIcon falseIcon = null;
    private ImageIcon errorIcon = null;
    private String trueLabel = null;
    private String falseLabel = null;
    private String errorLabel = null;
    private IBooleanSpectrum model;
    String[] modelBooleanLabels;
    String modelLabel;

    public BooleanSpectrumViewer() {
        URL url;
        if (TRUE_ICON == null && (url = this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/true.png")) != null) {
            TRUE_ICON = new ImageIcon(url);
        }
        if (FALSE_ICON == null && (url = this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/false.png")) != null) {
            FALSE_ICON = new ImageIcon(url);
        }
        if (ERROR_ICON == null && (url = this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/unknown.png")) != null) {
            ERROR_ICON = new ImageIcon(url);
        }
        this.trueIcon = TRUE_ICON;
        this.falseIcon = FALSE_ICON;
        this.errorIcon = ERROR_ICON;
        this.trueLabel = TRUE_LABEL;
        this.falseLabel = FALSE_LABEL;
        this.errorLabel = ERROR_LABEL;
        this.model = null;
        this.modelBooleanLabels = null;
        this.modelLabel = null;
        this.globalFont = new Font("Dialog", 0, 12);
        this.booleanLabelVisible = true;
        this.displayMode = 2;
        this.toolTipMode = 1;
        this.setLayout(new GridBagLayout());
    }

    public ImageIcon getTrueIcon() {
        return this.trueIcon;
    }

    public void setTrueIcon(ImageIcon ticon) {
        if (ticon == this.falseIcon || ticon == this.errorIcon) {
            return;
        }
        this.trueIcon = ticon;
    }

    public ImageIcon getFalseIcon() {
        return this.falseIcon;
    }

    public void setFalseIcon(ImageIcon ficon) {
        if (ficon == this.trueIcon || ficon == this.errorIcon) {
            return;
        }
        this.falseIcon = ficon;
    }

    public ImageIcon getErrorIcon() {
        return this.errorIcon;
    }

    public void setErrorIcon(ImageIcon eicon) {
        if (eicon == this.falseIcon || eicon == this.trueIcon) {
            return;
        }
        this.errorIcon = eicon;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String tl) {
        if (tl == null) {
            return;
        }
        if (tl.equalsIgnoreCase(this.falseLabel) || tl.equalsIgnoreCase(this.errorLabel)) {
            return;
        }
        this.trueLabel = tl;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String fl) {
        if (fl == null) {
            return;
        }
        if (fl.equalsIgnoreCase(this.trueLabel) || fl.equalsIgnoreCase(this.errorLabel)) {
            return;
        }
        this.falseLabel = fl;
    }

    public String getErrorLabel() {
        return this.errorLabel;
    }

    public void setErrorLabel(String el) {
        if (el == null) {
            return;
        }
        if (el.equalsIgnoreCase(this.falseLabel) || el.equalsIgnoreCase(this.trueLabel)) {
            return;
        }
        this.errorLabel = el;
    }

    public IBooleanSpectrum getModel() {
        return this.model;
    }

    public void setModel(IBooleanSpectrum boolSpec) {
        this.clearModel();
        if (boolSpec == null) {
            return;
        }
        this.model = boolSpec;
        if (!this.model.areAttPropertiesLoaded()) {
            this.model.loadAttProperties();
        }
        this.modelBooleanLabels = this.model.getBooleanLabels();
        this.modelLabel = this.model.getLabel();
        this.initComponents();
        this.setVisible(true);
        this.model.getProperty("label").addPresentationListener(this);
        this.model.addBooleanSpectrumListener(this);
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeBooleanSpectrumListener(this);
            this.model.getProperty("label").removePresentationListener(this);
            this.removeComponents();
            this.model = null;
            this.modelBooleanLabels = null;
            this.modelLabel = null;
        }
    }

    public Font getGlobalFont() {
        return this.globalFont;
    }

    public void setGlobalFont(Font ft) {
        int idx;
        JLabel jlab = null;
        if (ft == null) {
            return;
        }
        this.globalFont = ft;
        if (this.labelJLabels != null) {
            for (idx = 0; idx < this.labelJLabels.size(); ++idx) {
                jlab = this.labelJLabels.get(idx);
                jlab.setFont(this.globalFont);
            }
        }
        if (this.valueJLabels != null) {
            for (idx = 0; idx < this.valueJLabels.size(); ++idx) {
                jlab = this.valueJLabels.get(idx);
                jlab.setFont(this.globalFont);
            }
        }
    }

    public boolean getBooleanLabelVisible() {
        return this.booleanLabelVisible;
    }

    public void setBooleanLabelVisible(boolean blv) {
        if (this.booleanLabelVisible != blv) {
            this.booleanLabelVisible = blv;
            this.changeBooleanLabelVisibility();
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int dispMode) {
        if (dispMode == this.displayMode) {
            return;
        }
        this.displayMode = dispMode;
    }

    public int getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(int ttMode) {
        if (ttMode == this.toolTipMode) {
            return;
        }
        this.toolTipMode = ttMode;
    }

    private void removeComponents() {
        if (this.labelJLabels != null) {
            this.labelJLabels.removeAllElements();
        }
        if (this.valueJLabels != null) {
            this.valueJLabels.removeAllElements();
        }
        this.removeAll();
        this.labelJLabels = null;
        this.valueJLabels = null;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        boolean[] booleanValueElements = this.model.getDeviceValue();
        if (booleanValueElements == null) {
            return;
        }
        if (booleanValueElements.length <= 0) {
            return;
        }
        this.labelJLabels = new Vector();
        this.valueJLabels = new Vector();
        GridBagConstraints gbc = new GridBagConstraints();
        int idx = 0;
        while (idx < booleanValueElements.length) {
            JLabel elemLabel = new JLabel();
            JLabel elemValue = new JLabel();
            String ttip = null;
            if (this.toolTipMode == 1) {
                ttip = this.model.getName() + "[" + idx + "]";
            } else if (this.toolTipMode == 2) {
                ttip = Boolean.toString(booleanValueElements[idx]);
            } else if (this.toolTipMode == 3) {
                ttip = this.model.getName() + "[" + idx + "] = " + Boolean.toString(booleanValueElements[idx]);
            }
            elemLabel.setFont(this.globalFont);
            elemLabel.setBackground(this.getBackground());
            elemLabel.setToolTipText(ttip);
            if (this.modelBooleanLabels != null && idx < this.modelBooleanLabels.length) {
                elemLabel.setText(this.modelBooleanLabels[idx]);
            } else {
                elemLabel.setText(this.modelLabel + "[" + idx + "]");
            }
            elemValue.setFont(this.globalFont);
            elemValue.setToolTipText(ttip);
            this.displayBooleanValue(elemValue, booleanValueElements[idx]);
            this.labelJLabels.add(elemLabel);
            this.valueJLabels.add(elemValue);
            elemLabel.setHorizontalAlignment(4);
            gbc.gridx = 0;
            gbc.gridy = idx;
            gbc.fill = 2;
            gbc.anchor = 13;
            gbc.insets = new Insets(6, 6, 6, 6);
            this.add((Component)elemLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = idx++;
            gbc.fill = 2;
            gbc.insets = new Insets(6, 6, 6, 6);
            this.add((Component)elemValue, gbc);
            elemLabel.setVisible(this.booleanLabelVisible);
        }
    }

    private void changeBooleanLabelVisibility() {
        JLabel jlab = null;
        if (this.labelJLabels == null) {
            return;
        }
        for (int idx = 0; idx < this.labelJLabels.size(); ++idx) {
            try {
                jlab = this.labelJLabels.get(idx);
                jlab.setVisible(this.booleanLabelVisible);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateSpectrumValues(boolean[] newBooleans) {
        if (this.valueJLabels == null) {
            return;
        }
        for (int idx = 0; idx < newBooleans.length && idx < this.valueJLabels.size(); ++idx) {
            this.displayBooleanValue(this.valueJLabels.get(idx), newBooleans[idx]);
            this.updateValueInTooltip(idx, newBooleans[idx]);
        }
    }

    private void displayBooleanValue(JLabel valueLabel, boolean value) {
        if (this.displayMode == 2) {
            if (value) {
                valueLabel.setIcon(this.trueIcon);
                valueLabel.setText(this.trueLabel);
            } else {
                valueLabel.setIcon(this.falseIcon);
                valueLabel.setText(this.falseLabel);
            }
            return;
        }
        if (this.displayMode == 0) {
            valueLabel.setText("");
            if (value) {
                valueLabel.setIcon(this.trueIcon);
            } else {
                valueLabel.setIcon(this.falseIcon);
            }
            return;
        }
        if (this.displayMode == 1) {
            valueLabel.setIcon(null);
            if (value) {
                valueLabel.setText(this.trueLabel);
            } else {
                valueLabel.setText(this.falseLabel);
            }
            return;
        }
    }

    private void updateValueInTooltip(int index, boolean val) {
        if (this.toolTipMode == 1) {
            return;
        }
        if (this.toolTipMode == 0) {
            return;
        }
        String ttip = this.toolTipMode == 2 ? Boolean.toString(val) : this.model.getName() + "[" + index + "] = " + Boolean.toString(val);
        if (this.labelJLabels != null && index < this.labelJLabels.size()) {
            this.labelJLabels.get(index).setToolTipText(ttip);
        }
        if (this.valueJLabels != null && index < this.valueJLabels.size()) {
            this.valueJLabels.get(index).setToolTipText(ttip);
        }
    }

    private void setNewAttLabel(String newLabel) {
        this.modelLabel = newLabel;
        if (this.labelJLabels == null) {
            return;
        }
        for (int idx = 0; idx < this.labelJLabels.size(); ++idx) {
            JLabel elemLabel = this.labelJLabels.get(idx);
            if (this.modelBooleanLabels != null && idx < this.modelBooleanLabels.length) continue;
            elemLabel.setText(this.modelLabel + "[" + idx + "]");
        }
    }

    private void displayErrorAllBooleans() {
        if (this.valueJLabels == null) {
            return;
        }
        for (int idx = 0; idx < this.valueJLabels.size(); ++idx) {
            this.displayErrorValue(this.valueJLabels.get(idx));
            this.updateTooltipWithError(idx);
        }
    }

    private void displayErrorValue(JLabel valueLabel) {
        if (this.displayMode == 2) {
            valueLabel.setIcon(this.errorIcon);
            valueLabel.setText(this.errorLabel);
            return;
        }
        if (this.displayMode == 0) {
            valueLabel.setText("");
            valueLabel.setIcon(this.errorIcon);
            return;
        }
        if (this.displayMode == 1) {
            valueLabel.setIcon(null);
            valueLabel.setText(this.errorLabel);
        }
    }

    private void updateTooltipWithError(int index) {
        if (this.toolTipMode == 1) {
            return;
        }
        if (this.toolTipMode == 0) {
            return;
        }
        String ttip = this.toolTipMode == 2 ? this.errorLabel : this.model.getName() + "[" + index + "] = " + this.errorLabel;
        if (this.labelJLabels != null && index < this.labelJLabels.size()) {
            this.labelJLabels.get(index).setToolTipText(ttip);
        }
        if (this.valueJLabels != null && index < this.valueJLabels.size()) {
            this.valueJLabels.get(index).setToolTipText(ttip);
        }
    }

    @Override
    public void booleanSpectrumChange(BooleanSpectrumEvent e) {
        if (e.getValue().length < 1) {
            this.displayErrorAllBooleans();
            return;
        }
        this.updateSpectrumValues(e.getValue());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null && src.getName().equalsIgnoreCase("label")) {
            this.setNewAttLabel(src.getValue().toString());
        }
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.displayErrorAllBooleans();
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        BooleanSpectrumViewer bsv = new BooleanSpectrumViewer();
        try {
            IBooleanSpectrum booleanSpectAtt = (IBooleanSpectrum)attList.add("id-carr/A01/carriage/GAP_LimitSwitches");
            bsv.setModel(booleanSpectAtt);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            ex.printStackTrace();
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.setPreferredSize(new Dimension(500, 800));
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(bsv);
        mainFrame.setContentPane(jsp);
        mainFrame.pack();
        attList.startRefresher();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.pack();
        mainFrame.setVisible(true);
        mainFrame.repaint();
    }
}

