/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.ISetErrorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class BooleanScalarComboEditor
extends JComboBox
implements ActionListener,
IBooleanScalarListener,
ISetErrorListener {
    private IBooleanScalar attModel = null;
    private String trueLabel = "True";
    private String falseLabel = "False";
    private DefaultComboBoxModel comboModel = null;
    protected String defActionCmd = "setAttActionCmd";
    private String[] optionList = new String[]{this.trueLabel, this.falseLabel};
    static final int trueIndex = 0;
    static final int falseIndex = 1;

    public BooleanScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IBooleanScalar getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IBooleanScalar boolModel) {
        if (this.attModel != null) {
            this.attModel.removeBooleanScalarListener(this);
            this.attModel.removeSetErrorListener(this);
            this.attModel = null;
        }
        if (boolModel == null) {
            return;
        }
        if (!boolModel.isWritable()) {
            throw new IllegalArgumentException("BooleanScalarComboEditor: Only accept writeable attribute.");
        }
        this.optionList = new String[]{this.trueLabel, this.falseLabel};
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.attModel = boolModel;
        this.attModel.addBooleanScalarListener(this);
        this.attModel.addSetErrorListener(this);
        this.attModel.refresh();
        this.repaint();
    }

    public void clearModel() {
        this.setAttModel(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selectedOption;
        JComboBox cb = null;
        boolean idx = false;
        Object optValueStr = null;
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.attModel == null) {
            return;
        }
        cb = (JComboBox)e.getSource();
        if (cb.getSelectedIndex() < 0) {
            return;
        }
        boolean bl = selectedOption = cb.getSelectedIndex() == 0;
        if (selectedOption) {
            this.attModel.setValue(true);
        } else {
            this.attModel.setValue(false);
        }
    }

    @Override
    public void booleanScalarChange(BooleanScalarEvent e) {
        boolean setpoint = this.hasFocus() ? this.attModel.getDeviceSetPoint() : this.attModel.getSetPoint();
        this.changeCurrentSelection(setpoint);
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.disableExecution();
        this.setSelectedIndex(-1);
        this.repaint();
        this.enableExecution();
    }

    @Override
    public void setErrorOccured(ErrorEvent evt) {
        if (this.attModel == null) {
            return;
        }
        if (evt.getSource() != this.attModel) {
            return;
        }
        this.changeCurrentSelection(this.attModel.getDeviceSetPoint());
    }

    private void changeCurrentSelection(boolean newValue) {
        this.disableExecution();
        if (newValue) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(1);
        }
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public static void main(String[] args) {
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        BooleanScalarComboEditor bsce = new BooleanScalarComboEditor();
        try {
            IEntity ie = attl.add("jlp/test/1/att_boolean");
            if (!(ie instanceof IBooleanScalar)) {
                System.out.println("jlp/test/1/att_boolean is not a booleanScalar");
                System.exit(0);
            }
            IBooleanScalar bAtt = (IBooleanScalar)ie;
            bsce.setAttModel(bAtt);
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to jlp/test/1/att_boolean");
            System.exit(-1);
        }
        attl.startRefresher();
        f.setContentPane(bsce);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
    }
}

