/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AttributeQualityLightViewer
extends JButton
implements IAttributeStateListener,
IErrorListener {
    private boolean viewLabel;
    private IAttribute attributeModel;
    private int chosenLabel;
    private static final String defaultName = "No attribute defined";
    public static final int label = 0;
    public static final int name = 1;
    public static final int quality = 2;
    public static final int labelAndQuality = 3;
    public static final int nameAndQuality = 4;
    public static final int customLabel = 5;
    public static final int completeName = 6;

    public AttributeQualityLightViewer() {
        this.chosenLabel = 0;
        this.viewLabel = false;
        this.setAttributeModel(null);
    }

    public AttributeQualityLightViewer(IAttribute attribute, int kindOfLabel, boolean viewLbl) {
        this.chosenLabel = kindOfLabel;
        this.viewLabel = viewLbl;
        this.setAttributeModel(attribute);
    }

    public IAttribute getAttributeModel() {
        return this.attributeModel;
    }

    public void setAttributeModel(IAttribute attrModel) {
        if (this.attributeModel != null) {
            this.attributeModel.removeStateListener(this);
            this.attributeModel.removeErrorListener(this);
        }
        this.attributeModel = null;
        this.attributeModel = attrModel;
        if (this.attributeModel != null) {
            this.attributeModel.addStateListener(this);
            this.attributeModel.addErrorListener(this);
            this.manageLabel(this.attributeModel.getState());
            this.setIcon(ATKConstant.getIcon4Quality(this.attributeModel.getState()));
        } else {
            this.manageLabel("Unknown quality");
            this.setIcon(ATKConstant.getIcon4Quality("UNKNOWN"));
        }
    }

    public void clearAttributeModel() {
        this.setAttributeModel(null);
    }

    @Override
    public void stateChange(AttributeStateEvent arg0) {
        this.manageLabel(arg0.getState());
        this.setIcon(ATKConstant.getIcon4Quality(arg0.getState()));
        this.repaint();
    }

    @Override
    public void errorChange(ErrorEvent arg0) {
        this.manageLabel("Error occured");
        this.setIcon(ATKConstant.getIcon4Quality("UNKNOWN"));
        this.repaint();
    }

    public void setViewLabel(boolean b) {
        this.viewLabel = b;
        if (this.attributeModel != null) {
            this.manageLabel(this.attributeModel.getState());
        } else {
            this.manageLabel("unknown state");
        }
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void setChosenLabel(int chosen) {
        this.chosenLabel = chosen;
    }

    public int getChosenLabel() {
        return this.chosenLabel;
    }

    private void manageLabel(String myQuality) {
        if (this.viewLabel) {
            switch (this.chosenLabel) {
                case 0: {
                    if (this.attributeModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.attributeModel.getLabel());
                    break;
                }
                case 1: {
                    if (this.attributeModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.attributeModel.getNameSansDevice());
                    break;
                }
                case 2: {
                    this.setText(myQuality);
                }
                case 4: {
                    if (this.attributeModel == null) {
                        this.setText("No attribute defined : " + myQuality);
                        break;
                    }
                    this.setText(this.attributeModel.getName() + " : " + myQuality);
                    break;
                }
                case 3: {
                    if (this.attributeModel == null) {
                        this.setText("No attribute defined : " + myQuality);
                        break;
                    }
                    this.setText(this.attributeModel.getLabel() + " : " + myQuality);
                    break;
                }
                case 6: {
                    if (this.attributeModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.attributeModel.getName());
                    break;
                }
            }
        }
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        AttributeQualityLightViewer aqlv = new AttributeQualityLightViewer();
        aqlv.setViewLabel(true);
        aqlv.setChosenLabel(3);
        try {
            if (args.length != 0) {
                aqlv.setAttributeModel((IAttribute)attributeList.add(args[0]));
            } else {
                aqlv.setAttributeModel((IAttribute)attributeList.add("test/testSignal2/1/signal"));
            }
            aqlv.setViewLabel(true);
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
            JFrame f = new JFrame(aqlv.getAttributeModel().getName().substring(0, aqlv.getAttributeModel().getName().lastIndexOf("/")));
            f.getContentPane().add(aqlv);
            f.setSize(300, 50);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

