/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLTable;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class AttributeMultiChart
extends JLChart
implements INumberScalarListener {
    protected String header = "Barchart";
    protected String xaxisName = "X";
    protected String unit = "unknown";
    protected double alarmLevel = 0.0;
    protected double faultLevel = 0.0;
    protected JLDataView alarm;
    protected JLDataView fault;
    protected JLDataView lineView;
    protected String lastConfig = "";
    protected int refreshingPeriod = 1000;
    protected Map<INumberScalar, List<Object>> dataViewHash = null;
    protected AttributeList model = null;
    protected int chartStyle;
    protected int markerStyle;
    protected Color chartColor = ATKConstant.getColor4Quality("VALID");
    protected boolean alarmEnable = true;
    protected boolean chartOnXAxis = true;
    protected boolean highAlarm = true;
    protected boolean highFault = true;
    protected JMenu multiChartMenu;
    protected JMenuItem barChartItem;
    protected JMenu dotChartMenu;
    protected JMenuItem dotItem;
    protected JMenuItem boxItem;
    protected JMenuItem triangleItem;
    protected JMenuItem diamondItem;
    protected JMenuItem starItem;
    protected JMenuItem vertLineItem;
    protected JMenuItem horizLineItem;
    protected JMenuItem crossItem;
    protected JMenuItem circleItem;
    protected JMenuItem squareItem;
    protected JMenu lineChartMenu;
    protected JMenuItem dotItem2;
    protected JMenuItem boxItem2;
    protected JMenuItem triangleItem2;
    protected JMenuItem diamondItem2;
    protected JMenuItem starItem2;
    protected JMenuItem vertLineItem2;
    protected JMenuItem horizLineItem2;
    protected JMenuItem crossItem2;
    protected JMenuItem circleItem2;
    protected JMenuItem squareItem2;
    protected JMenu tooltipMenu;
    protected JMenuItem fullNameItem;
    protected JMenuItem noDeviceNameItem;
    protected JMenuItem labelItem;
    protected JMenuItem aliasItem;
    protected JMenuItem deviceNameItem;
    protected JMenu axisInfoMenu;
    protected JMenuItem axisInfoFullNameItem;
    protected JMenuItem axisInfoNoDeviceNameItem;
    protected JMenuItem axisInfoLabelItem;
    protected JMenuItem axisInfoAliasItem;
    protected JMenuItem axisInfoDeviceNameItem;
    protected JMenuItem axisInfoIndexItem;
    protected JMenu YScale;
    protected JMenuItem logarithmic;
    protected JMenuItem linear;
    protected int displayMode = -1;
    protected int axisDisplayMode = -1;
    public static final int barChart = 0;
    public static final int dotChart = 1;
    public static final int lineChart = 2;
    public static final int DISPLAY_FULL_NAME = 0;
    public static final int DISPLAY_NAME_NO_DEVICE = 1;
    public static final int DISPLAY_LABEL = 2;
    public static final int DISPLAY_ALIAS = 3;
    public static final int DISPLAY_DEVICE_NAME = 4;
    public static final int DISPLAY_INDEX = 5;

    public AttributeMultiChart() {
        this.getXAxis().setDrawOpposite(false);
        this.getXAxis().setLabelFormat(0);
        this.getXAxis().setGridVisible(true);
        this.getXAxis().setAutoScale(true);
        this.getY1Axis().setZeroAlwaysVisible(true);
        this.dataViewHash = new HashMap<INumberScalar, List<Object>>();
        this.setMarkerStyle(5);
        this.initComponents();
        this.addUserAction("Load configuration");
        this.addUserAction("Save configuration");
        this.addUserAction("Set Refresh Interval...");
        this.multiChartMenu = new JMenu("Chart Style");
        this.barChartItem = new JMenuItem("Bar Chart");
        this.dotChartMenu = new JMenu("Dot Chart (choose marker)");
        this.lineChartMenu = new JMenu("Line Chart (choose marker)");
        this.tooltipMenu = new JMenu("Tooltip Information:");
        this.fullNameItem = new JMenuItem("Attribute's full name");
        this.noDeviceNameItem = new JMenuItem("Attribute's name wihout device");
        this.labelItem = new JMenuItem("Attribute's label");
        this.aliasItem = new JMenuItem("Attribute's alias");
        this.deviceNameItem = new JMenuItem("Attribute's parent device name");
        this.axisInfoMenu = new JMenu("X Axis Information:");
        this.axisInfoFullNameItem = new JMenuItem("Attribute's full name");
        this.axisInfoNoDeviceNameItem = new JMenuItem("Attribute's name wihout device");
        this.axisInfoLabelItem = new JMenuItem("Attribute's label");
        this.axisInfoAliasItem = new JMenuItem("Attribute's alias");
        this.axisInfoDeviceNameItem = new JMenuItem("Attribute's parent device name");
        this.axisInfoIndexItem = new JMenuItem("Attribute's index");
        this.dotItem = new JMenuItem("dot");
        this.boxItem = new JMenuItem("box");
        this.triangleItem = new JMenuItem("triangle");
        this.diamondItem = new JMenuItem("diamond");
        this.starItem = new JMenuItem("star");
        this.vertLineItem = new JMenuItem("vertical line");
        this.horizLineItem = new JMenuItem("horizontal line");
        this.crossItem = new JMenuItem("cross");
        this.circleItem = new JMenuItem("circle");
        this.squareItem = new JMenuItem("square");
        this.dotItem2 = new JMenuItem("dot");
        this.boxItem2 = new JMenuItem("box");
        this.triangleItem2 = new JMenuItem("triangle");
        this.diamondItem2 = new JMenuItem("diamond");
        this.starItem2 = new JMenuItem("star");
        this.vertLineItem2 = new JMenuItem("vertical line");
        this.horizLineItem2 = new JMenuItem("horizontal line");
        this.crossItem2 = new JMenuItem("cross");
        this.circleItem2 = new JMenuItem("circle");
        this.squareItem2 = new JMenuItem("square");
        this.barChartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(0);
            }
        });
        this.dotItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(1);
            }
        });
        this.boxItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(2);
            }
        });
        this.triangleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(3);
            }
        });
        this.diamondItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(4);
            }
        });
        this.starItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(5);
            }
        });
        this.vertLineItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(6);
            }
        });
        this.horizLineItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(7);
            }
        });
        this.crossItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(8);
            }
        });
        this.circleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(9);
            }
        });
        this.squareItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(10);
            }
        });
        this.dotItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(1);
            }
        });
        this.boxItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(2);
            }
        });
        this.triangleItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(3);
            }
        });
        this.diamondItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(4);
            }
        });
        this.starItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(5);
            }
        });
        this.vertLineItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(6);
            }
        });
        this.horizLineItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(7);
            }
        });
        this.crossItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(8);
            }
        });
        this.circleItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(9);
            }
        });
        this.squareItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(10);
            }
        });
        this.YScale = new JMenu("Y Axis Scale");
        this.logarithmic = new JMenuItem("logarithmic");
        this.linear = new JMenuItem("linear");
        this.logarithmic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.getY1Axis().setScale(1);
                AttributeMultiChart.this.repaint();
            }
        });
        this.linear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.getY1Axis().setScale(0);
                AttributeMultiChart.this.repaint();
            }
        });
        this.fullNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setDisplayMode(0);
                AttributeMultiChart.this.repaint();
            }
        });
        this.noDeviceNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setDisplayMode(1);
                AttributeMultiChart.this.repaint();
            }
        });
        this.labelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setDisplayMode(2);
                AttributeMultiChart.this.repaint();
            }
        });
        this.aliasItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setDisplayMode(3);
                AttributeMultiChart.this.repaint();
            }
        });
        this.deviceNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setDisplayMode(4);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoFullNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setAxisDisplayMode(0);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoNoDeviceNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setAxisDisplayMode(1);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoLabelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setAxisDisplayMode(2);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoAliasItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setAxisDisplayMode(3);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoDeviceNameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setAxisDisplayMode(4);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoIndexItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeMultiChart.this.setAxisDisplayMode(5);
                AttributeMultiChart.this.repaint();
            }
        });
        this.dotChartMenu.add(this.dotItem);
        this.dotChartMenu.add(this.boxItem);
        this.dotChartMenu.add(this.triangleItem);
        this.dotChartMenu.add(this.diamondItem);
        this.dotChartMenu.add(this.starItem);
        this.dotChartMenu.add(this.vertLineItem);
        this.dotChartMenu.add(this.horizLineItem);
        this.dotChartMenu.add(this.crossItem);
        this.dotChartMenu.add(this.circleItem);
        this.dotChartMenu.add(this.squareItem);
        this.lineChartMenu.add(this.dotItem2);
        this.lineChartMenu.add(this.boxItem2);
        this.lineChartMenu.add(this.triangleItem2);
        this.lineChartMenu.add(this.diamondItem2);
        this.lineChartMenu.add(this.starItem2);
        this.lineChartMenu.add(this.vertLineItem2);
        this.lineChartMenu.add(this.horizLineItem2);
        this.lineChartMenu.add(this.crossItem2);
        this.lineChartMenu.add(this.circleItem2);
        this.lineChartMenu.add(this.squareItem2);
        this.multiChartMenu.add(this.barChartItem);
        this.multiChartMenu.add(this.dotChartMenu);
        this.multiChartMenu.add(this.lineChartMenu);
        this.tooltipMenu.add(this.fullNameItem);
        this.tooltipMenu.add(this.noDeviceNameItem);
        this.tooltipMenu.add(this.labelItem);
        this.tooltipMenu.add(this.aliasItem);
        this.tooltipMenu.add(this.deviceNameItem);
        this.axisInfoMenu.add(this.axisInfoFullNameItem);
        this.axisInfoMenu.add(this.axisInfoNoDeviceNameItem);
        this.axisInfoMenu.add(this.axisInfoLabelItem);
        this.axisInfoMenu.add(this.axisInfoAliasItem);
        this.axisInfoMenu.add(this.axisInfoDeviceNameItem);
        this.axisInfoMenu.add(this.axisInfoIndexItem);
        this.YScale.add(this.linear);
        this.YScale.add(this.logarithmic);
        this.addSeparator();
        this.addMenuItem(this.multiChartMenu);
        this.addMenuItem(this.tooltipMenu);
        this.addMenuItem(this.axisInfoMenu);
        this.addMenuItem(this.YScale);
        this.removeMenuItem(1);
        this.setDisplayMode(0);
        this.setAxisDisplayMode(5);
    }

    public AttributeMultiChart(int chartStyle) {
        this();
        this.setChartStyle(chartStyle);
    }

    public AttributeMultiChart(int chartStyle, int displayMode) {
        this();
        this.setChartStyle(chartStyle);
        this.setDisplayMode(displayMode);
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(int style) {
        this.markerStyle = style;
        Set<INumberScalar> keySet = this.dataViewHash.keySet();
        block4: for (INumberScalar ns : keySet) {
            List<Object> tempList = this.dataViewHash.get(ns);
            JLDataView tempView = (JLDataView)tempList.get(0);
            switch (this.chartStyle) {
                case 0: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    tempView.setMarker(this.markerStyle);
                    continue block4;
                }
            }
            tempView.setMarker(0);
            tempView.setViewType(0);
        }
        this.repaint();
    }

    protected void initComponents() {
        this.setHeaderFont(new Font("Times", 1, 18));
        switch (this.chartStyle) {
            case 0: {
                this.setHeader("BarChart");
                break;
            }
            case 1: {
                this.setHeader("DotChart");
                break;
            }
            case 2: {
                this.setHeader("LineChart");
                break;
            }
            default: {
                this.setHeader("");
            }
        }
        this.setLabelVisible(false);
        this.setSize(640, 480);
        this.getY1Axis().setAutoScale(true);
        this.getY1Axis().setGridVisible(true);
        this.getY1Axis().setSubGridVisible(true);
        this.getXAxis().setAutoScale(false);
        this.getXAxis().setMinimum(0.0);
        this.getXAxis().setMaximum(0.0);
        this.getXAxis().setGridVisible(false);
        this.getXAxis().setSubGridVisible(false);
        this.getXAxis().setPosition(3);
        this.initLevels();
        this.setPaintAxisFirst(false);
    }

    @Override
    public String[] buildPanelString(SearchInfo si) {
        if (!this.isChartOnXAxis()) {
            String[] str = new String[]{si.dataView.getExtendedName() + " " + si.axis.getAxeName(), "Index = " + new Double(si.value.y).intValue(), "X = " + si.dataView.formatValue(si.dataView.getTransformedValue(si.value.x)) + " " + si.dataView.getUnit()};
            return str;
        }
        String[] str = new String[]{si.dataView.getExtendedName() + " " + si.axis.getAxeName(), "Index = " + new Double(si.value.x).intValue(), "Y = " + si.dataView.formatValue(si.dataView.getTransformedValue(si.value.y)) + " " + si.dataView.getUnit()};
        return str;
    }

    protected void initLevels() {
        this.alarm = new JLDataView();
        this.alarm.setName("Alarm level");
        this.alarm.setColor(ATKConstant.getColor4State("ALARM"));
        this.alarm.setLineWidth(2);
        this.getY1Axis().addDataView(this.alarm);
        this.fault = new JLDataView();
        this.fault.setName("Fault level");
        this.fault.setColor(ATKConstant.getColor4State("FAULT"));
        this.fault.setLineWidth(2);
        this.getY1Axis().addDataView(this.fault);
        this.lineView = new JLDataView();
        this.lineView.setColor(Color.black);
        this.lineView.setLineWidth(1);
        if (this.chartStyle == 2) {
            this.getY1Axis().addDataView(this.lineView);
        } else {
            this.getY1Axis().removeDataView(this.lineView);
        }
    }

    public boolean isChartOnXAxis() {
        return this.chartOnXAxis;
    }

    public void setChartOnXAxis(boolean chartOnXAxis) {
        this.chartOnXAxis = chartOnXAxis;
    }

    public void setModel(AttributeList attl) {
        Object elem;
        int idx;
        this.setChartOnXAxis(this.chartOnXAxis);
        int bar_width = 10;
        if (this.model != null) {
            this.clearModel();
            this.model = null;
        }
        if (attl == null) {
            return;
        }
        int nbAtts = attl.getSize();
        if (nbAtts <= 0) {
            return;
        }
        boolean containsNumberScalar = false;
        for (idx = 0; idx < nbAtts; ++idx) {
            elem = attl.getElementAt(idx);
            if (!(elem instanceof INumberScalar)) continue;
            containsNumberScalar = true;
            break;
        }
        if (!containsNumberScalar) {
            return;
        }
        this.model = attl;
        this.refreshingPeriod = this.model.getRefreshInterval();
        int nbNs = 0;
        this.getXAxis().setLabels(null, null);
        for (idx = 0; idx < nbAtts; ++idx) {
            INumberScalar ins;
            elem = attl.getElementAt(idx);
            if (!(elem instanceof INumberScalar) || this.dataViewHash.containsKey(ins = (INumberScalar)elem)) continue;
            JLDataView dvy_new = new JLDataView();
            dvy_new.setUnit(ins.getUnit());
            this.prepareName(dvy_new, ins);
            dvy_new.setColor(Color.black);
            dvy_new.setLineWidth(1);
            dvy_new.setBarWidth(bar_width);
            dvy_new.setFillStyle(1);
            dvy_new.setFillMethod(1);
            if (this.chartStyle == 0) {
                if (this.chartOnXAxis) {
                    dvy_new.setMarker(0);
                    dvy_new.setViewType(1);
                } else {
                    dvy_new.setLineWidth(bar_width);
                    dvy_new.setMarker(0);
                    dvy_new.setViewType(0);
                    dvy_new.setColor(this.chartColor);
                }
            } else {
                dvy_new.setMarker(5);
                dvy_new.setViewType(0);
            }
            this.getY1Axis().addDataView(dvy_new);
            ins.addNumberScalarListener(this);
            Vector<Serializable> list = new Vector<Serializable>();
            Integer XaxisValue = new Integer(nbNs);
            list.add(0, dvy_new);
            list.add(1, XaxisValue);
            this.dataViewHash.put(ins, list);
            ++nbNs;
        }
        if (this.isChartOnXAxis()) {
            this.getXAxis().setMaximum(nbNs + 1);
            this.getXAxis().setMinimum(0.0);
        } else {
            this.getY1Axis().setMaximum(nbNs + 1);
            this.getY1Axis().setMinimum(0.0);
        }
        if (this.chartOnXAxis) {
            this.getXAxis().setLabelFormat(3);
        } else {
            this.getY1Axis().setLabelFormat(3);
        }
        this.setFaultLevel(this.getFaultLevel());
        this.setAlarmLevel(this.getAlarmLevel());
        this.getXAxis().setAnnotation(2);
        this.manageLabels();
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        int nbAtts = this.model.getSize();
        if (nbAtts <= 0) {
            return;
        }
        for (int idx = 0; idx < nbAtts; ++idx) {
            INumberScalar ins;
            Object elem = this.model.getElementAt(idx);
            if (!(elem instanceof INumberScalar) || !this.dataViewHash.containsKey(ins = (INumberScalar)elem)) continue;
            ins.removeNumberScalarListener(this);
        }
        this.getY1Axis().clearDataView();
        this.dataViewHash.clear();
        this.initLevels();
    }

    public void setWidth(int bar_width) {
        if (this.model == null) {
            return;
        }
        int nbAtts = this.model.getSize();
        if (nbAtts <= 0) {
            return;
        }
        for (int idx = 0; idx < nbAtts; ++idx) {
            Object obj;
            int nbObjs;
            List<Object> dvyAndIndex;
            INumberScalar ins;
            Object elem = this.model.getElementAt(idx);
            if (!(elem instanceof INumberScalar) || !this.dataViewHash.containsKey(ins = (INumberScalar)elem) || (dvyAndIndex = this.dataViewHash.get(ins)) == null || (nbObjs = dvyAndIndex.size()) < 2 || (obj = dvyAndIndex.get(0)) == null || !(obj instanceof JLDataView)) continue;
            JLDataView dvy = (JLDataView)obj;
            if (this.chartOnXAxis) {
                dvy.setBarWidth(bar_width);
                continue;
            }
            dvy.setLineWidth(bar_width);
        }
    }

    public boolean isHighAlarm() {
        return this.highAlarm;
    }

    public void setHighAlarm(boolean highAlarm) {
        this.highAlarm = highAlarm;
    }

    public boolean isHighFault() {
        return this.highFault;
    }

    public void setHighFault(boolean highFault) {
        this.highFault = highFault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        INumberScalar source = (INumberScalar)numberScalarEvent.getSource();
        if (this.dataViewHash.containsKey(source)) {
            List<Object> dvyAndIndex = this.dataViewHash.get(source);
            if (dvyAndIndex == null) {
                return;
            }
            int nbObjs = dvyAndIndex.size();
            if (nbObjs < 2) {
                return;
            }
            Object obj = dvyAndIndex.get(0);
            if (obj == null) {
                return;
            }
            if (!(obj instanceof JLDataView)) {
                return;
            }
            JLDataView dvy = (JLDataView)obj;
            obj = dvyAndIndex.get(1);
            if (obj == null) {
                return;
            }
            if (!(obj instanceof Integer)) {
                return;
            }
            int dvyIndex = (Integer)obj;
            double yvalue = numberScalarEvent.getValue();
            dvy.reset();
            dvy.setUnit(source.getUnit());
            if (this.chartOnXAxis) {
                dvy.add(dvyIndex + 1, yvalue);
            } else if (this.chartStyle == 0) {
                dvy.add(0.0, dvyIndex + 1);
                dvy.add(yvalue, dvyIndex + 1);
            } else {
                dvy.add(yvalue, dvyIndex + 1);
            }
            if (!this.chartOnXAxis) {
                dvy.setFillStyle(0);
            }
            if (this.alarmEnable) {
                if (this.isHighFault() && yvalue > this.faultLevel || !this.isHighFault() && yvalue <= this.faultLevel) {
                    dvy.setFillColor(ATKConstant.getColor4State("FAULT"));
                    dvy.setMarkerColor(ATKConstant.getColor4State("FAULT"));
                    dvy.setColor(ATKConstant.getColor4Quality("FAULT"));
                } else if (this.isHighAlarm() && yvalue > this.alarmLevel || !this.isHighAlarm() && yvalue <= this.alarmLevel) {
                    dvy.setFillColor(ATKConstant.getColor4Quality("ALARM"));
                    dvy.setMarkerColor(ATKConstant.getColor4Quality("ALARM"));
                    dvy.setColor(ATKConstant.getColor4Quality("ALARM"));
                } else {
                    dvy.setFillColor(this.chartColor);
                    dvy.setMarkerColor(this.chartColor);
                    dvy.setColor(this.chartColor);
                }
            } else {
                dvy.setFillColor(this.chartColor);
                dvy.setMarkerColor(this.chartColor);
                dvy.setColor(this.chartColor);
            }
            JLDataView jLDataView = this.lineView;
            synchronized (jLDataView) {
                int i;
                this.lineView.reset();
                Set<INumberScalar> keySet = this.dataViewHash.keySet();
                Iterator<INumberScalar> it = keySet.iterator();
                DataList[] position = new DataList[keySet.size()];
                for (i = 0; i < position.length; ++i) {
                    position[i] = null;
                }
                while (it.hasNext()) {
                    DataList tempData;
                    INumberScalar ns = it.next();
                    List<Object> tempList = this.dataViewHash.get(ns);
                    JLDataView tempView = (JLDataView)tempList.get(0);
                    Integer tempInteger = (Integer)tempList.get(1);
                    position[tempInteger.intValue()] = tempData = tempView.getData();
                }
                for (i = 0; i < position.length; ++i) {
                    if (position[i] == null) continue;
                    if (this.chartOnXAxis) {
                        this.lineView.add(i + 1, position[i].y);
                        continue;
                    }
                    this.lineView.add(position[i].x, i + 1);
                }
            }
            this.repaint();
        }
    }

    public int getChartStyle() {
        return this.chartStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChartStyle(int style) {
        this.chartStyle = style;
        Set<INumberScalar> keySet = this.dataViewHash.keySet();
        for (INumberScalar ns : keySet) {
            List<Object> tempList = this.dataViewHash.get(ns);
            JLDataView tempView = (JLDataView)tempList.get(0);
            switch (this.chartStyle) {
                case 0: {
                    tempView.setMarker(0);
                    if (this.chartOnXAxis) {
                        tempView.setViewType(1);
                    } else {
                        tempView.setViewType(0);
                    }
                    JLDataView jLDataView = this.lineView;
                    synchronized (jLDataView) {
                        this.getY1Axis().removeDataView(this.lineView);
                        break;
                    }
                }
                case 1: {
                    tempView.setMarker(this.markerStyle);
                    tempView.setViewType(0);
                    JLDataView jLDataView = this.lineView;
                    synchronized (jLDataView) {
                        this.getY1Axis().removeDataView(this.lineView);
                        break;
                    }
                }
                case 2: {
                    tempView.setMarker(this.markerStyle);
                    tempView.setViewType(0);
                    JLDataView jLDataView = this.lineView;
                    synchronized (jLDataView) {
                        this.getY1Axis().addDataView(this.lineView);
                        break;
                    }
                }
                default: {
                    tempView.setMarker(0);
                    tempView.setViewType(0);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void stateChange(AttributeStateEvent arg0) {
    }

    @Override
    public void errorChange(ErrorEvent arg0) {
    }

    public double getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarmLevel(double alarm_level) {
        this.alarmLevel = alarm_level;
        this.getY1Axis().removeDataView(this.alarm);
        this.alarm.reset();
        if (this.chartOnXAxis) {
            this.alarm.add(0.0, alarm_level);
            int Max2 = 1;
            if (this.model != null) {
                Max2 = this.model.size() + 1;
            }
            this.alarm.add(Max2, alarm_level);
        } else {
            this.alarm.add(alarm_level, 0.0);
            int Max3 = 1;
            if (this.model != null) {
                Max3 = this.model.size() + 1;
            }
            this.alarm.add(alarm_level, Max3);
        }
        if (alarm_level != Double.MAX_VALUE) {
            this.getY1Axis().addDataView(this.alarm);
        }
    }

    public double getFaultLevel() {
        return this.faultLevel;
    }

    public void setFaultLevel(double fault_level) {
        this.faultLevel = fault_level;
        this.getY1Axis().removeDataView(this.fault);
        this.fault.reset();
        if (this.chartOnXAxis) {
            this.fault.add(0.0, fault_level);
            int Max2 = 1;
            if (this.model != null) {
                Max2 = this.model.size() + 1;
            }
            this.fault.add(Max2, fault_level);
        } else {
            this.fault.add(fault_level, 0.0);
            int Max3 = 1;
            if (this.model != null) {
                Max3 = this.model.size() + 1;
            }
            this.fault.add(fault_level, Max3);
        }
        if (fault_level != Double.MAX_VALUE) {
            this.getY1Axis().addDataView(this.fault);
        }
    }

    public String getChartHeader() {
        return this.header;
    }

    public void setChartHeader(String header) {
        this.header = header;
        this.setHeader(header);
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
        if (!this.chartOnXAxis) {
            this.getY1Axis().setName(unit);
            this.alarm.setUnit(unit);
            this.fault.setUnit(unit);
            return;
        }
        this.getXAxis().setName(unit);
        this.alarm.setUnit(unit);
        this.fault.setUnit(unit);
    }

    public String getXaxisName() {
        return this.xaxisName;
    }

    public void setXaxisName(String xaxis_name) {
        this.xaxisName = xaxis_name;
        if (this.chartOnXAxis) {
            this.getXAxis().setName(xaxis_name);
        } else {
            this.getY1Axis().setName(xaxis_name);
        }
    }

    public String getSettings() {
        INumberScalar ins;
        Object elem;
        int idx;
        String s = "";
        s = s + this.getConfiguration();
        s = s + "chartStyle:" + this.chartStyle + "\n";
        s = s + "markerStyle:" + this.markerStyle + "\n";
        s = s + "alarm:" + this.getAlarmLevel() + "\n";
        s = s + "fault:" + this.getFaultLevel() + "\n";
        if (this.model != null) {
            s = s + "refresh_time:" + this.refreshingPeriod + "\n";
        }
        s = s + this.getXAxis().getConfiguration("x");
        s = s + this.getY1Axis().getConfiguration("y1");
        s = s + this.getY2Axis().getConfiguration("y2");
        int nbAtts = this.model.getSize();
        int nbNs = 0;
        for (idx = 0; idx < nbAtts; ++idx) {
            elem = this.model.getElementAt(idx);
            if (!(elem instanceof INumberScalar) || !this.dataViewHash.containsKey(ins = (INumberScalar)elem)) continue;
            ++nbNs;
        }
        s = s + "dv_number:" + nbNs + "\n";
        nbNs = 0;
        for (idx = 0; idx < nbAtts; ++idx) {
            Object obj2;
            Object obj;
            int nbObjs;
            List<Object> dvyAndIndex;
            elem = this.model.getElementAt(idx);
            if (!(elem instanceof INumberScalar) || !this.dataViewHash.containsKey(ins = (INumberScalar)elem) || (dvyAndIndex = this.dataViewHash.get(ins)) == null || (nbObjs = dvyAndIndex.size()) < 2 || (obj = dvyAndIndex.get(0)) == null || !(obj instanceof JLDataView) || (obj2 = dvyAndIndex.get(1)) == null || !(obj2 instanceof Integer)) continue;
            int dvyIndex = (Integer)obj2;
            JLDataView dvy = (JLDataView)obj;
            s = s + "dv" + dvyIndex + "_name:'" + ins + "'\n";
            s = s + dvy.getConfiguration("dv" + dvyIndex);
        }
        return s;
    }

    public void saveSetting(String s) {
        try {
            FileWriter filewriter = new FileWriter(s);
            String s1 = this.getSettings();
            filewriter.write(s1, 0, s1.length());
            filewriter.close();
            this.lastConfig = s;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getParent(), "Failed to write " + s, "Error", 0);
            exception.printStackTrace();
        }
    }

    public String loadSetting(String s) {
        CfFileReader cffilereader = new CfFileReader();
        if (!cffilereader.readFile(s)) {
            return "Failed to read " + s;
        }
        this.lastConfig = s;
        return this.applySettings(cffilereader);
    }

    public int getRefreshingPeriod() {
        if (this.model == null) {
            return 0;
        }
        this.refreshingPeriod = this.model.getRefreshInterval();
        return this.refreshingPeriod;
    }

    public void setRefreshingPeriod(int refreshingPeriod) {
        this.refreshingPeriod = refreshingPeriod;
        if (this.model == null) {
            return;
        }
        this.model.stopRefresher();
        this.model.setRefreshInterval(refreshingPeriod);
        this.model.startRefresher();
    }

    protected String applySettings(CfFileReader cffilereader) {
        String s = "";
        String attributeListTmp = "";
        Vector<String> vector = cffilereader.getParam("dv_number");
        if (vector != null) {
            int k;
            try {
                k = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberformatexception) {
                s = s + "dv_number: invalid number\n";
                return s;
            }
            for (int i = 0; i < k; ++i) {
                vector = cffilereader.getParam("dv" + i + "_name");
                if (vector == null) {
                    s = s + "Unable to find dv" + i + "_name param\n";
                    return s;
                }
                try {
                    attributeListTmp = attributeListTmp + vector.get(0).toString() + ",";
                    continue;
                }
                catch (Exception exception) {
                    s = s + exception.getMessage() + "\n";
                    return s;
                }
            }
            if (k > 0) {
                vector = cffilereader.getParam("refresh_time");
                if (vector != null) {
                    this.setRefreshingPeriod(OFormat.getInt(vector.get(0).toString()));
                }
                attributeListTmp = attributeListTmp.substring(0, attributeListTmp.lastIndexOf(","));
                this.setAttributeListAsString(attributeListTmp);
            }
        } else {
            boolean k = false;
        }
        this.applyConfiguration(cffilereader);
        this.getXAxis().applyConfiguration("x", cffilereader);
        this.getY1Axis().applyConfiguration("y1", cffilereader);
        this.getY2Axis().applyConfiguration("y2", cffilereader);
        vector = cffilereader.getParam("dv0_barwidth");
        if (vector == null) {
            s = s + "Unable to find dv" + 0 + "_barwidth param";
            return s;
        }
        this.setWidth(Integer.parseInt(vector.get(0).toString().trim()));
        vector = cffilereader.getParam("xtitle");
        if (vector == null) {
            s = s + "Unable to find xtitle param";
            return s;
        }
        this.setXaxisName(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cffilereader.getParam("graph_title");
        if (vector == null) {
            s = s + "Unable to find graph_title param";
            return s;
        }
        this.setChartHeader(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cffilereader.getParam("y1title");
        if (vector == null) {
            s = s + "Unable to find y1title param";
            return s;
        }
        this.setUnit(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cffilereader.getParam("chartStyle");
        if (vector == null) {
            s = s + "Unable to find chartStyle param";
            return s;
        }
        this.setChartStyle(Integer.valueOf(vector.get(0).toString().replaceAll("'", "").trim()));
        vector = cffilereader.getParam("markerStyle");
        if (vector == null) {
            s = s + "Unable to find markerStyle param";
            return s;
        }
        this.setMarkerStyle(Integer.valueOf(vector.get(0).toString().replaceAll("'", "").trim()));
        vector = cffilereader.getParam("alarm");
        if (vector == null) {
            s = s + "Unable to find alarm param";
            return s;
        }
        this.setAlarmLevel(Double.valueOf(vector.get(0).toString().replaceAll("'", "").trim()).intValue());
        vector = cffilereader.getParam("fault");
        if (vector == null) {
            s = s + "Unable to find fault param";
            return s;
        }
        this.setFaultLevel(Double.valueOf(vector.get(0).toString().replaceAll("'", "").trim()).intValue());
        return s;
    }

    protected void setAttributeListAsString(String attributeListAsString) {
        String[] attrList = attributeListAsString.split(",");
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < attrList.length; ++i) {
            try {
                attributeList.add(attrList[i]);
                continue;
            }
            catch (ConnectionException e) {
                JOptionPane.showMessageDialog(this, "Failed to connect to " + attrList[i], "Error", 0);
            }
        }
        this.setModel(attributeList);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().trim().equalsIgnoreCase("Load configuration")) {
            this.loadPerformed();
        } else if (evt.getActionCommand().trim().equalsIgnoreCase("Save configuration")) {
            this.savePerformed();
        } else if (evt.getActionCommand().trim().equalsIgnoreCase("Set Refresh Interval...")) {
            int ref_period = -1;
            ref_period = this.getRefreshingPeriod();
            String refp_str = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(ref_period));
            if (refp_str != null && refp_str.length() > 0) {
                try {
                    int period_int = Integer.parseInt(refp_str);
                    this.setRefreshingPeriod(period_int);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
                    return;
                }
            }
        } else {
            super.actionPerformed(evt);
        }
    }

    @Override
    protected void showTableAll() {
        if (this.model == null) {
            return;
        }
        JLTable theTable = new JLTable();
        String[] cols = new String[]{"Attribute", "Value (" + new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss ").format(new Date()) + ")"};
        Vector<Object> data = new Vector<Object>();
        int nbViews = this.model.size();
        for (int i = 0; i < nbViews; ++i) {
            IAttribute attr = (IAttribute)this.model.getElementAt(i);
            data.add(attr.getName());
            if (attr instanceof INumberScalar) {
                data.add(new Double(((INumberScalar)attr).getNumberScalarValue()));
                continue;
            }
            data.add("NaN");
        }
        int y = nbViews;
        int x = cols.length;
        Object[][] dv = new Object[y][x];
        int count = 0;
        for (int j = 0; j < y; ++j) {
            for (int i = 0; i < x; ++i) {
                Object ln = data.get(count);
                dv[j][i] = ln;
                ++count;
            }
        }
        theTable.setData(dv, cols);
        if (!theTable.isVisible()) {
            theTable.centerWindow();
        }
        theTable.setVisible(true);
    }

    protected void loadPerformed() {
        String s;
        File file;
        if (this.model != null) {
            this.model.stopRefresher();
        }
        this.clearModel();
        boolean flag = false;
        JFileChooser jfilechooser = new JFileChooser();
        jfilechooser.setSelectedFile(new File(this.lastConfig));
        jfilechooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        int i = jfilechooser.showOpenDialog(this.getParent());
        if (i == 0 && (file = jfilechooser.getSelectedFile()) != null && !flag && (s = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this.getParent(), s, "Errors reading " + file.getName(), 0);
        }
        this.repaint();
    }

    protected void savePerformed() {
        int i = 0;
        JFileChooser jfilechooser = new JFileChooser(".");
        jfilechooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        jfilechooser.setSelectedFile(new File(this.lastConfig));
        int j = jfilechooser.showSaveDialog(this.getParent());
        if (j == 0) {
            File file = jfilechooser.getSelectedFile();
            if (MultiExtFileFilter.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file != null) {
                if (file.exists()) {
                    i = JOptionPane.showConfirmDialog(this.getParent(), "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (i == 0) {
                    this.saveSetting(file.getAbsolutePath());
                }
            }
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        if (this.displayMode != displayMode) {
            this.displayMode = displayMode;
            this.updateToolTips();
        }
    }

    public int getAxisDisplayMode() {
        return this.axisDisplayMode;
    }

    public void setAxisDisplayMode(int axisDisplayMode) {
        if (this.axisDisplayMode != axisDisplayMode) {
            this.axisDisplayMode = axisDisplayMode;
            this.manageLabels();
        }
    }

    protected void updateToolTips() {
        if (this.model != null) {
            Object elem;
            int idx;
            int nbAtts = this.model.getSize();
            boolean containsNumberScalar = false;
            for (idx = 0; idx < nbAtts; ++idx) {
                elem = this.model.getElementAt(idx);
                if (!(elem instanceof INumberScalar)) continue;
                containsNumberScalar = true;
                break;
            }
            if (!containsNumberScalar) {
                return;
            }
            this.refreshingPeriod = this.model.getRefreshInterval();
            for (idx = 0; idx < nbAtts; ++idx) {
                elem = this.model.getElementAt(idx);
                if (!(elem instanceof INumberScalar)) continue;
                INumberScalar source = (INumberScalar)elem;
                List<Object> dvyAndIndex = this.dataViewHash.get(source);
                if (dvyAndIndex == null) {
                    return;
                }
                int nbObjs = dvyAndIndex.size();
                if (nbObjs < 2) {
                    return;
                }
                Object obj = dvyAndIndex.get(0);
                if (obj == null) {
                    return;
                }
                if (!(obj instanceof JLDataView)) {
                    return;
                }
                JLDataView dvy = (JLDataView)obj;
                this.prepareName(dvy, source);
            }
        }
    }

    protected void prepareName(JLDataView view, INumberScalar scalar) {
        switch (this.getDisplayMode()) {
            case 1: {
                view.setName(scalar.getNameSansDevice());
                return;
            }
            case 2: {
                view.setName(scalar.getLabel());
                return;
            }
            case 3: {
                view.setName(scalar.getAlias());
                return;
            }
            case 4: {
                view.setName(scalar.getDevice().getName());
                return;
            }
        }
        view.setName(scalar.getName());
    }

    protected void manageLabels() {
        if (this.dataViewHash.size() > 0) {
            String[] labels = new String[this.dataViewHash.size()];
            double[] labelPositions = new double[this.dataViewHash.size()];
            Set<INumberScalar> keySet = this.dataViewHash.keySet();
            Iterator<INumberScalar> keyIterator = keySet.iterator();
            int i = 0;
            switch (this.getAxisDisplayMode()) {
                case 1: {
                    while (keyIterator.hasNext()) {
                        INumberScalar scalar = keyIterator.next();
                        List<Object> list = this.dataViewHash.get(scalar);
                        Integer xPosition = (Integer)list.get(1);
                        labels[i] = scalar.getNameSansDevice();
                        labelPositions[i++] = xPosition.doubleValue() + 1.0;
                    }
                    break;
                }
                case 2: {
                    while (keyIterator.hasNext()) {
                        INumberScalar scalar = keyIterator.next();
                        List<Object> list = this.dataViewHash.get(scalar);
                        Integer xPosition = (Integer)list.get(1);
                        labels[i] = scalar.getLabel();
                        labelPositions[i++] = xPosition.doubleValue() + 1.0;
                    }
                    break;
                }
                case 3: {
                    while (keyIterator.hasNext()) {
                        INumberScalar scalar = keyIterator.next();
                        List<Object> list = this.dataViewHash.get(scalar);
                        Integer xPosition = (Integer)list.get(1);
                        labels[i] = scalar.getAlias();
                        labelPositions[i++] = xPosition.doubleValue() + 1.0;
                    }
                    break;
                }
                case 4: {
                    while (keyIterator.hasNext()) {
                        INumberScalar scalar = keyIterator.next();
                        List<Object> list = this.dataViewHash.get(scalar);
                        Integer xPosition = (Integer)list.get(1);
                        labels[i] = scalar.getDevice().getName();
                        labelPositions[i++] = xPosition.doubleValue() + 1.0;
                    }
                    break;
                }
                case 0: {
                    while (keyIterator.hasNext()) {
                        INumberScalar scalar = keyIterator.next();
                        List<Object> list = this.dataViewHash.get(scalar);
                        Integer xPosition = (Integer)list.get(1);
                        labels[i] = scalar.getName();
                        labelPositions[i++] = xPosition.doubleValue() + 1.0;
                    }
                    break;
                }
                default: {
                    labels = null;
                    labelPositions = null;
                }
            }
            this.getXAxis().setLabels(labels, labelPositions);
        }
    }

    public Color getChartColor() {
        return this.chartColor;
    }

    public void setChartColor(Color chartColor) {
        this.chartColor = chartColor;
    }

    public boolean isAlarmEnable() {
        return this.alarmEnable;
    }

    public void setAlarmEnable(boolean alarmEnable) {
        this.alarmEnable = alarmEnable;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        final AttributeMultiChart f = new AttributeMultiChart(0);
        f.getXAxis().setTickSpacing(0.0);
        final AttributeList attributeList = new AttributeList();
        try {
            if (args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    attributeList.add(args[i]);
                }
            } else {
                attributeList.add("LT1/AE/CH.1/voltage");
                attributeList.add("LT1/AE/CH.2/voltage");
                attributeList.add("LT1/AE/CH.3/voltage");
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
            System.exit(1);
        }
        f.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    if (attributeList.isRefresherStarted()) {
                        attributeList.stopRefresher();
                    } else {
                        attributeList.startRefresher();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        f.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                f.grabFocus();
            }
        });
        f.setModel(attributeList);
        attributeList.startRefresher();
        f.setWidth(10);
        f.setHeader("AttributeMultiChart");
        f.setFaultLevel(200.0);
        f.setAlarmLevel(100.0);
        frame.getContentPane().add((Component)f, "Center");
        frame.setSize(640, 480);
        frame.setTitle(f.getHeader() + " Example 1");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }
}

