/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.util;

import fr.esrf.tangoatk.util.Timee;
import fr.esrf.tangoatk.util.myPrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class AtkTimer {
    protected Map threadMap = new HashMap();
    protected Map methodMap = new HashMap();
    protected static AtkTimer self;
    protected int maxMethodName = Integer.MIN_VALUE;
    protected String skip = "fr.esrf.TangoATK.Core.";
    myPrintWriter pw = new myPrintWriter(System.out);
    protected boolean timer = false;

    protected AtkTimer() {
        if ("on".equals(System.getProperty("TIMER"))) {
            this.timer = true;
        }
    }

    public static AtkTimer getInstance() {
        if (self == null) {
            self = new AtkTimer();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer(Thread t) {
        if (!this.timer) {
            return;
        }
        String method = this.getCaller();
        int methodLength = method.length() - this.skip.length();
        this.maxMethodName = this.maxMethodName < methodLength ? methodLength : this.maxMethodName;
        Map map = this.threadMap;
        synchronized (map) {
            Stack<Timee> s = (Stack<Timee>)this.threadMap.get(t);
            if (s == null) {
                s = new Stack<Timee>();
                this.threadMap.put(t, s);
            }
            s.push(new Timee(method));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTimer(Thread t) {
        Vector<Long> l;
        if (!this.timer) {
            return;
        }
        Timee timee = null;
        Map map = this.threadMap;
        synchronized (map) {
            Stack s = (Stack)this.threadMap.get(t);
            timee = (Timee)s.pop();
        }
        long duration = System.currentTimeMillis() - timee.getStartTime();
        String method = this.getCaller();
        if (!timee.getName().equals(method)) {
            System.out.println("not popping correct method, wanted " + method + ", got " + timee.getName() + "\n");
        }
        if ((l = (Vector<Long>)this.methodMap.get(method)) == null) {
            l = new Vector<Long>();
            this.methodMap.put(method, l);
        }
        l.add(new Long(duration));
    }

    public static String padding(int length) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    public void printResults() {
        if (!this.timer) {
            return;
        }
        System.out.println("\nMethodname" + AtkTimer.padding(this.maxMethodName - "methodName".length() + 5) + "Average\tMin\tMax\tCalls");
        for (String methodName : this.methodMap.keySet()) {
            int j;
            List l = (List)this.methodMap.get(methodName);
            long methodSum = 0L;
            long minVal = Long.MAX_VALUE;
            long maxVal = Long.MIN_VALUE;
            long val = 0L;
            for (j = 0; j < l.size(); ++j) {
                val = (Long)l.get(j);
                methodSum += val;
                maxVal = val > maxVal ? val : maxVal;
                minVal = val < minVal ? val : minVal;
            }
            String blanks = "";
            if (methodName.indexOf(this.skip) != -1) {
                methodName = methodName.substring(this.skip.length());
            }
            for (int k = 0; k < this.maxMethodName - methodName.length(); ++k) {
                blanks = blanks + " ";
            }
            String avg = new Long(methodSum / (long)j).toString();
            System.out.println(methodName + AtkTimer.padding(this.maxMethodName - methodName.length() + 5) + AtkTimer.padding(5 - avg.length()) + avg + "ms\t" + minVal + "\t" + maxVal + "\t" + j);
        }
    }

    protected String getCaller() {
        Throwable e = new Throwable();
        e.printStackTrace(this.pw);
        return this.pw.getCaller();
    }
}

