/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.util;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.util.NonAttrNumberSpectrum;

public class TimeAndValueDualSpectrum
extends NonAttrNumberSpectrum
implements IRefresherListener {
    protected AttributeList list = new AttributePolledList();
    protected INumberSpectrum timeModel;
    protected INumberSpectrum yModel;

    public TimeAndValueDualSpectrum() {
        this.list.addRefresherListener(this);
    }

    @Override
    public void refreshStep() {
        double[] xvalue = new double[]{};
        double[] yvalue = new double[]{};
        if (this.timeModel != null && this.yModel != null) {
            try {
                xvalue = this.timeModel.getSpectrumValue();
            }
            catch (Exception e) {
                xvalue = new double[]{};
            }
            try {
                yvalue = this.yModel.getSpectrumValue();
            }
            catch (Exception e) {
                yvalue = new double[]{};
            }
            this.setXYValue(xvalue, yvalue);
        }
    }

    public AttributeList getList() {
        return this.list;
    }

    public void setList(AttributeList list) {
        if (this.list != null && this.timeModel != null) {
            this.list.remove(this.timeModel.getName());
        }
        if (this.list != null && this.yModel != null) {
            this.list.remove(this.yModel.getName());
        }
        this.list = list;
        if (list != null && this.timeModel != null) {
            list.add(this.timeModel);
        }
        if (list != null && this.timeModel != null) {
            list.add(this.yModel);
        }
        list.addRefresherListener(this);
    }

    public INumberSpectrum getTimeModel() {
        return this.timeModel;
    }

    public void setTimeModel(INumberSpectrum timeModel) {
        if (this.list != null && this.timeModel != null) {
            this.list.remove(this.timeModel.getName());
        }
        this.timeModel = timeModel;
        if (this.list != null && this.timeModel != null) {
            this.list.add(this.timeModel);
        }
    }

    public INumberSpectrum getYModel() {
        return this.yModel;
    }

    public void setYModel(INumberSpectrum model) {
        if (this.list != null && this.yModel != null) {
            this.list.remove(this.yModel.getName());
        }
        this.yModel = model;
        if (this.list != null && this.yModel != null) {
            this.list.add(this.yModel);
        }
    }

    public static void main(String[] args) throws ConnectionException {
    }
}

