/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.util;

import fr.esrf.tangoatk.core.util.INonAttrNumberSpectrum;
import fr.esrf.tangoatk.core.util.INonAttrSpectrumListener;
import fr.esrf.tangoatk.core.util.NonAttrNumberSpectrumEvent;
import javax.swing.event.EventListenerList;

public class NonAttrNumberSpectrum
implements INonAttrNumberSpectrum {
    private double[] spectrumValue = null;
    private double[] xValue = null;
    private EventListenerList eventListeners = new EventListenerList();
    private String xname = "Unknown";
    private String xunit = "Unknown";
    private String yname = "Unknown";
    private String yunit = "Unknown";

    @Override
    public void addNonAttrSpectrumListener(INonAttrSpectrumListener l) {
        this.eventListeners.add(INonAttrSpectrumListener.class, l);
    }

    @Override
    public void removeNonAttrSpectrumListener(INonAttrSpectrumListener l) {
        this.eventListeners.remove(INonAttrSpectrumListener.class, l);
    }

    @Override
    public double[] getXValue() {
        return this.xValue;
    }

    @Override
    public void setXYValue(double[] xd, double[] yd) {
        int i;
        int xLength = 0;
        int yLength = 0;
        if (xd != null) {
            xLength = xd.length;
        }
        if (yd != null) {
            yLength = yd.length;
        }
        this.xValue = new double[xLength];
        for (i = 0; i < xLength; ++i) {
            this.xValue[i] = xd[i];
        }
        this.spectrumValue = new double[yLength];
        for (i = 0; i < yLength; ++i) {
            this.spectrumValue[i] = yd[i];
        }
        this.fireNonAttrNumberSpectrumEvent(this.xValue, this.spectrumValue);
    }

    @Override
    public double[] getYValue() {
        return this.spectrumValue;
    }

    protected void fireNonAttrNumberSpectrumEvent(double[] xv, double[] yv) {
        NonAttrNumberSpectrumEvent nonAttrNumberSpectrumEvent = null;
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != INonAttrSpectrumListener.class) continue;
            if (nonAttrNumberSpectrumEvent == null) {
                nonAttrNumberSpectrumEvent = new NonAttrNumberSpectrumEvent(this, xv, yv);
            }
            ((INonAttrSpectrumListener)listeners[i + 1]).spectrumChange(nonAttrNumberSpectrumEvent);
        }
    }

    @Override
    public String getXUnit() {
        return this.xunit;
    }

    @Override
    public void setXUnit(String xunit) {
        this.xunit = xunit;
    }

    @Override
    public String getXName() {
        return this.xname;
    }

    @Override
    public void setXName(String xname) {
        this.xname = xname;
    }

    @Override
    public String getYUnit() {
        return this.yunit;
    }

    @Override
    public void setYUnit(String yunit) {
        this.yunit = yunit;
    }

    @Override
    public String getYName() {
        return this.yname;
    }

    @Override
    public void setYName(String yname) {
        this.yname = yname;
    }
}

