/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.util.AttrFunctionSpectrum;

public class AttrDualSpectrum
extends AttrFunctionSpectrum {
    protected DeviceAttribute dev_attr_x;
    protected DeviceAttribute dev_attr_y;
    protected Device device_x;
    protected Device device_y;
    protected String attr_x;
    protected String attr_y;

    public AttrDualSpectrum(IDevice device_x, String attr_x, IDevice device_y, String attr_y) {
        this.device_x = (Device)device_x;
        this.device_y = (Device)device_y;
        this.attr_x = attr_x;
        this.attr_y = attr_y;
        this.setXName(attr_x);
        this.setYName(attr_y);
        try {
            AttributeInfoEx attr_info = this.device_x.getAttributeInfo(attr_x);
            this.setXUnit(attr_info.unit);
            attr_info = this.device_y.getAttributeInfo(attr_y);
            this.setYUnit(attr_info.unit);
        }
        catch (DevFailed e) {
            for (int i = 0; i < e.errors.length; ++i) {
                System.out.println("error number " + i + e.errors[i].reason + " " + e.errors[i].origin);
            }
        }
    }

    @Override
    public double[] updateX() {
        this.dev_attr_x = new DeviceAttribute(this.attr_x);
        double[] xvalue = null;
        try {
            this.dev_attr_x = this.device_x.read_attribute(this.attr_x);
            int data_type = this.dev_attr_x.getType();
            switch (data_type) {
                case 21: 
                case 22: {
                    byte[] cval = this.dev_attr_x.extractCharArray();
                    if (cval == null) {
                        cval = new byte[]{};
                    }
                    xvalue = new double[cval.length];
                    for (int i = 0; i < cval.length; ++i) {
                        xvalue[i] = cval[i];
                    }
                    break;
                }
                case 2: 
                case 6: {
                    short[] sval = this.dev_attr_x.extractShortArray();
                    if (sval == null) {
                        sval = new short[]{};
                    }
                    xvalue = new double[sval.length];
                    for (int i = 0; i < sval.length; ++i) {
                        xvalue[i] = sval[i];
                    }
                    break;
                }
                case 3: 
                case 7: 
                case 23: 
                case 24: {
                    int[] lval = this.dev_attr_x.extractLongArray();
                    if (lval == null) {
                        lval = new int[]{};
                    }
                    xvalue = new double[lval.length];
                    for (int i = 0; i < lval.length; ++i) {
                        xvalue[i] = lval[i];
                    }
                    break;
                }
                case 4: {
                    float[] fval = this.dev_attr_x.extractFloatArray();
                    if (fval == null) {
                        fval = new float[]{};
                    }
                    xvalue = new double[fval.length];
                    for (int i = 0; i < fval.length; ++i) {
                        xvalue[i] = fval[i];
                    }
                    break;
                }
                default: {
                    xvalue = this.dev_attr_x.extractDoubleArray();
                }
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return xvalue;
    }

    @Override
    public double[] updateY() {
        this.dev_attr_y = new DeviceAttribute(this.attr_y);
        double[] yvalue = null;
        try {
            int min = this.dev_attr_y.getDimX();
            yvalue = new double[min];
            this.dev_attr_y = this.device_y.read_attribute(this.attr_y);
            int data_type = this.dev_attr_y.getType();
            switch (data_type) {
                case 21: 
                case 22: {
                    byte[] cval = this.dev_attr_y.extractCharArray();
                    if (cval == null) {
                        cval = new byte[]{};
                    }
                    yvalue = new double[cval.length];
                    for (int i = 0; i < cval.length; ++i) {
                        yvalue[i] = cval[i];
                    }
                    break;
                }
                case 2: 
                case 6: {
                    short[] sval = this.dev_attr_y.extractShortArray();
                    if (sval == null) {
                        sval = new short[]{};
                    }
                    yvalue = new double[sval.length];
                    for (int i = 0; i < sval.length; ++i) {
                        yvalue[i] = sval[i];
                    }
                    break;
                }
                case 3: 
                case 7: 
                case 23: 
                case 24: {
                    int[] lval = this.dev_attr_y.extractLongArray();
                    if (lval == null) {
                        lval = new int[]{};
                    }
                    yvalue = new double[lval.length];
                    for (int i = 0; i < lval.length; ++i) {
                        yvalue[i] = lval[i];
                    }
                    break;
                }
                case 4: {
                    float[] fval = this.dev_attr_y.extractFloatArray();
                    if (fval == null) {
                        fval = new float[]{};
                    }
                    yvalue = new double[fval.length];
                    for (int i = 0; i < fval.length; ++i) {
                        yvalue[i] = fval[i];
                    }
                    break;
                }
                default: {
                    yvalue = this.dev_attr_y.extractDoubleArray();
                }
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return yvalue;
    }

    public DeviceAttribute getDev_attr_x() {
        return this.dev_attr_x;
    }

    public DeviceAttribute getDev_attr_y() {
        return this.dev_attr_y;
    }

    public Device getDevice_x() {
        return this.device_x;
    }

    public Device getDevice_y() {
        return this.device_y;
    }

    public String getAttr_x() {
        return this.attr_x;
    }

    public String getAttr_y() {
        return this.attr_y;
    }
}

