/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;

class ScalarCommandHelper
extends ACommandHelper {
    ScalarCommandHelper(ACommand command) {
        super(command);
    }

    @Override
    public DeviceData setInput(List l) {
        String input = l == null ? null : (l.size() < 1 ? null : (String)l.get(0));
        try {
            switch (this.getInType()) {
                case 1: {
                    this.data.insert(new Boolean(input).booleanValue());
                    break;
                }
                case 2: {
                    this.data.insert(Short.parseShort(input));
                    break;
                }
                case 4: {
                    this.data.insert(Float.parseFloat(input));
                    break;
                }
                case 5: {
                    this.data.insert(Double.parseDouble(input));
                    break;
                }
                case 6: {
                    this.data.insert_us(Integer.parseInt(input));
                    break;
                }
                case 7: {
                    this.data.insert_ul(Long.parseLong(input));
                    break;
                }
                case 24: {
                    this.data.insert_u64(Long.parseLong(input));
                    break;
                }
                case 3: {
                    this.data.insert(Integer.parseInt(input));
                    break;
                }
                case 23: {
                    this.data.insert(Long.parseLong(input));
                    break;
                }
                case 8: {
                    this.data.insert(input);
                }
            }
        }
        catch (Exception e) {
            this.cmdError("setInput failed with " + e + " on " + input, e);
        }
        return this.data;
    }

    @Override
    protected List<String> extractOutput(DeviceData d) {
        String val = "unsuported type";
        Vector<String> l = new Vector<String>();
        switch (this.getOutType()) {
            case 1: {
                val = d.extractBoolean() ? "TRUE" : "FALSE";
                break;
            }
            case 2: {
                val = Short.toString(d.extractShort());
                break;
            }
            case 4: {
                val = Float.toString(d.extractFloat());
                break;
            }
            case 5: {
                val = Double.toString(d.extractDouble());
                break;
            }
            case 6: {
                val = Integer.toString(d.extractUShort());
                break;
            }
            case 7: {
                val = Long.toString(d.extractULong());
                break;
            }
            case 24: {
                val = Long.toString(d.extractULong64());
                break;
            }
            case 3: {
                val = Integer.toString(d.extractLong());
                break;
            }
            case 23: {
                val = Long.toString(d.extractLong64());
                break;
            }
            case 8: {
                val = d.extractString();
                break;
            }
            case 19: {
                val = Device.toString(d.extractDevState());
            }
        }
        l.add(val);
        return l;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.serializeInit();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public String toString() {
        return "ScalarCommandHelper";
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

