/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ArrayArrayCommand;
import fr.esrf.tangoatk.core.command.ArrayScalarCommand;
import fr.esrf.tangoatk.core.command.ArrayTableCommand;
import fr.esrf.tangoatk.core.command.ArrayVoidCommand;
import fr.esrf.tangoatk.core.command.BooleanVoidCommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.ScalarArrayCommand;
import fr.esrf.tangoatk.core.command.ScalarScalarCommand;
import fr.esrf.tangoatk.core.command.ScalarTableCommand;
import fr.esrf.tangoatk.core.command.ScalarVoidCommand;
import fr.esrf.tangoatk.core.command.StringVoidCommand;
import fr.esrf.tangoatk.core.command.TableArrayCommand;
import fr.esrf.tangoatk.core.command.TableScalarCommand;
import fr.esrf.tangoatk.core.command.TableTableCommand;
import fr.esrf.tangoatk.core.command.TableVoidCommand;
import fr.esrf.tangoatk.core.command.VoidArrayCommand;
import fr.esrf.tangoatk.core.command.VoidScalarCommand;
import fr.esrf.tangoatk.core.command.VoidTableCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class CommandFactory
extends AEntityFactory {
    private Vector<ACommand> commands = new Vector();
    private String[] cmdNames = new String[0];
    private static CommandFactory instance;

    protected CommandFactory() {
    }

    @Override
    public int getSize() {
        return this.commands.size();
    }

    public static CommandFactory getInstance() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    private int getCommandPos(String fqname) {
        return Arrays.binarySearch(this.cmdNames, fqname.toLowerCase());
    }

    @Override
    protected synchronized List<IEntity> getWildCardEntities(String name, Device device) throws DevFailed {
        Vector<IEntity> list = new Vector<IEntity>();
        CommandInfo[] info = device.getCommandList();
        for (int i = 0; i < info.length; ++i) {
            String fqname = CommandFactory.getFQName(device, info[i].cmd_name);
            ICommand entity = this.getSingleCommand(fqname, info[i], device);
            list.add(entity);
        }
        return list;
    }

    private ICommand getSingleCommand(String fqname, CommandInfo info, Device device) {
        int pos = this.getCommandPos(fqname);
        if (pos >= 0) {
            return this.commands.get(pos);
        }
        return this.initCommand(device, info, -(pos + 1), fqname);
    }

    @Override
    protected synchronized IEntity getSingleEntity(String fqname, Device device) throws DevFailed {
        String name = CommandFactory.extractEntityName(fqname);
        CommandInfo info = device.getCommand(name);
        return this.getSingleCommand(fqname, info, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommand getCommand(String fqname) throws ConnectionException, DevFailed {
        Device d = null;
        IEntity ie = null;
        CommandFactory commandFactory = this;
        synchronized (commandFactory) {
            int pos = this.getCommandPos(fqname);
            if (pos >= 0) {
                ie = this.commands.get(pos);
            }
        }
        if (ie == null) {
            d = this.getDevice(CommandFactory.extractDeviceName(fqname));
            ie = this.getSingleEntity(fqname, d);
        }
        if (ie instanceof ACommand) {
            return (ACommand)ie;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACommand[] getCommands() {
        ACommand[] ret = new ACommand[this.commands.size()];
        CommandFactory commandFactory = this;
        synchronized (commandFactory) {
            for (int i = 0; i < this.commands.size(); ++i) {
                ret[i] = this.commands.get(i);
            }
        }
        return ret;
    }

    public boolean isCommand(String fqname) {
        try {
            return this.getCommand(fqname) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ACommand initCommand(Device device, CommandInfo info, int insertionPos, String fqname) {
        ACommand command = this.getCommandOfType(device.getName(), info);
        command.init(device, info.cmd_name, info);
        int lgth = this.cmdNames.length;
        String[] newCmdNames = new String[lgth + 1];
        System.arraycopy(this.cmdNames, 0, newCmdNames, 0, insertionPos);
        System.arraycopy(this.cmdNames, insertionPos, newCmdNames, insertionPos + 1, lgth - insertionPos);
        newCmdNames[insertionPos] = fqname.toLowerCase();
        this.cmdNames = newCmdNames;
        this.commands.add(insertionPos, command);
        this.dumpFactory("Adding " + fqname);
        return command;
    }

    private ACommand getCommandOfType(String devName, CommandInfo info) {
        if (info == null) {
            System.out.println("Warning, CommandFactory.getCommandOfType(): null CommandInfo pointer got from " + devName);
            return new InvalidCommand();
        }
        int inType = info.in_type;
        int outType = info.out_type;
        String name = info.cmd_name;
        if (ACommand.isTable(outType)) {
            if (ACommand.isTable(inType)) {
                return new TableTableCommand();
            }
            if (ACommand.isArray(inType)) {
                return new ArrayTableCommand();
            }
            if (ACommand.isScalar(inType)) {
                return new ScalarTableCommand();
            }
            if (ACommand.isVoid(inType)) {
                return new VoidTableCommand();
            }
        }
        if (ACommand.isArray(outType)) {
            if (ACommand.isTable(inType)) {
                return new TableArrayCommand();
            }
            if (ACommand.isArray(inType)) {
                return new ArrayArrayCommand();
            }
            if (ACommand.isScalar(inType)) {
                return new ScalarArrayCommand();
            }
            if (ACommand.isVoid(inType)) {
                return new VoidArrayCommand();
            }
        }
        if (ACommand.isScalar(outType)) {
            if (ACommand.isTable(inType)) {
                return new TableScalarCommand();
            }
            if (ACommand.isArray(inType)) {
                return new ArrayScalarCommand();
            }
            if (ACommand.isScalar(inType)) {
                return new ScalarScalarCommand();
            }
            if (ACommand.isVoid(inType)) {
                return new VoidScalarCommand();
            }
        }
        if (ACommand.isVoid(outType)) {
            if (ACommand.isTable(inType)) {
                return new TableVoidCommand();
            }
            if (ACommand.isArray(inType)) {
                return new ArrayVoidCommand();
            }
            if (ACommand.isBoolean(inType)) {
                return new BooleanVoidCommand();
            }
            if (ACommand.isString(inType)) {
                return new StringVoidCommand();
            }
            if (ACommand.isScalar(inType)) {
                return new ScalarVoidCommand();
            }
            if (ACommand.isVoid(inType)) {
                return new VoidVoidCommand();
            }
        }
        System.out.println("CommandFactory.getCommandOfType() : Warning, Unsupported type for command " + devName + " " + name + "(in type=" + inType + ",out type=" + outType + ")");
        return new InvalidCommand();
    }

    private void dumpFactory(String msg) {
        if ((DeviceFactory.getInstance().getTraceMode() & 0x400) != 0) {
            System.out.println("-- CommnadFactory : " + msg + " ------------");
            for (int i = 0; i < this.cmdNames.length; ++i) {
                System.out.println("  " + i + ":" + this.cmdNames[i]);
            }
            System.out.println("-- CommnadFactory --------------------------------------");
        }
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

