/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class UCharImageHelper
extends ANumberImageHelper {
    public UCharImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    protected void insert(DeviceAttribute da, double[][] d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        double[] flatd = NumberAttributeHelper.flatten(d);
        short[] tmp = new short[flatd.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (short)(flatd[i] / dUnitFactor);
        }
        da.insert_uc(tmp, d[0].length, d.length);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Double(d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Double(d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Double(d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Double(d));
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Double(d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Double(d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Double(d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Double(d), writable);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Double(d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Double(d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Double(d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Double(d), writable);
    }

    @Override
    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        short[] tmp = deviceAttribute.extractUCharArray();
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.retval[i][j] = tmp[k++];
            }
        }
        return this.retval;
    }

    @Override
    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] tmp = deviceAttribute.extractUCharArray();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.retval[i][j] = (double)tmp[k++] * dUnitFactor;
            }
        }
        return this.retval;
    }

    @Override
    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] tmp = deviceAttribute.extractUCharArray();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        String[][] retval_str = new String[ydim][xdim];
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                retval_str[i][j] = Integer.toString(tmp[k++]);
            }
        }
        return retval_str;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

