/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

public class StringSpectrumHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public StringSpectrumHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.attribute = attribute;
    }

    public AAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireValueChanged(String[] newValue, long timeStamp) {
        this.propChanges.fireStringSpectrumEvent((IStringSpectrum)((Object)this.attribute), newValue, timeStamp);
    }

    String[] getStringSpectrumValue(DeviceAttribute da) throws DevFailed {
        String[] tmp = da.extractStringArray();
        int nbReadElements = da.getNbRead();
        if (nbReadElements == tmp.length) {
            return tmp;
        }
        String[] retval = new String[nbReadElements];
        for (int i = 0; i < nbReadElements; ++i) {
            retval[i] = tmp[i];
        }
        return retval;
    }

    String[] getStringSpectrumSetPoint(DeviceAttribute da) throws DevFailed {
        int nbReadElements;
        String[] tmp = da.extractStringArray();
        int nbSetElements = tmp.length - (nbReadElements = da.getNbRead());
        if (nbSetElements <= 0) {
            return tmp;
        }
        String[] retval = new String[nbSetElements];
        int j = 0;
        for (int i = nbReadElements; i < tmp.length; ++i) {
            retval[j] = tmp[i];
            ++j;
        }
        return retval;
    }

    void addStringSpectrumListener(IStringSpectrumListener l) {
        this.propChanges.addStringSpectrumListener(l);
    }

    void removeStringSpectrumListener(IStringSpectrumListener l) {
        this.propChanges.removeStringSpectrumListener(l);
    }

    public String getVersion() {
        return "$Id$";
    }
}

