/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarHistory;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringAttributeHelper;
import fr.esrf.tangoatk.core.attribute.StringScalarHistory;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringScalar
extends AAttribute
implements IStringScalar {
    StringAttributeHelper stringHelper = new StringAttributeHelper(this);
    String stringValue = null;
    String setPointValue = null;
    String[] possibleValues = null;

    @Override
    public String getString() {
        return this.getStringValue();
    }

    @Override
    public void setValue(String s) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            da.insert(s);
            this.writeAtt(da);
            this.refresh();
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    @Override
    public IScalarAttribute getWritableAttribute() {
        return null;
    }

    @Override
    public IScalarAttribute getReadableAttribute() {
        return null;
    }

    @Override
    public void setString(String s) {
        this.setValue(s);
    }

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        ++this.refreshCount;
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.stringValue = att.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(att);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed e) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("StringScalar.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.stringValue = attValue.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(attValue);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringScalar.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.stringValue = null;
        this.setPointValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String newValue) {
        this.propChanges.fireStringScalarEvent(this, newValue, this.timeStamp);
    }

    @Override
    public void addStringScalarListener(IStringScalarListener l) {
        this.propChanges.addStringScalarListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeStringScalarListener(IStringScalarListener l) {
        this.propChanges.removeStringScalarListener(l);
        this.removeStateListener(l);
    }

    @Override
    public IStringScalarHistory[] getStringScalarHistory() {
        IStringScalarHistory[] attHist = null;
        try {
            attHist = (StringScalarHistory[])this.stringHelper.getScalarAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            attHist = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            attHist = null;
        }
        return attHist;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public String getStringDeviceValue() {
        String readVal = null;
        try {
            this.stringValue = readVal = this.readValueFromNetwork().extractString();
        }
        catch (DevFailed e) {
            this.stringValue = null;
            this.setPointValue = null;
            this.readAttError(e.getMessage(), new AttributeReadException(e));
        }
        catch (Exception e) {
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.getStringDeviceValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringScalar.getStringDeviceValue()------------------------------------------------");
        }
        return this.stringValue;
    }

    @Override
    public String getStringSetPoint() {
        return this.setPointValue;
    }

    @Override
    public String getStringDeviceSetPoint() {
        String setPoint;
        try {
            this.setPointValue = setPoint = this.stringHelper.getStringScalarSetPoint(this.readValueFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            setPoint = "DevFailed";
            this.setPointValue = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            setPoint = "Exception";
            this.setPointValue = null;
        }
        return setPoint;
    }

    @Override
    public void setPossibleValues(String[] vals) {
        if (vals == null) {
            return;
        }
        if (this.possibleValues == null && vals.length > 0) {
            this.possibleValues = vals;
        }
    }

    @Override
    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "StringScalar.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "StringScalar.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "StringScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "StringScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "StringScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "StringScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.stringValue = da.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(da);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed dfe) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.stringValue = null;
                this.setPointValue = null;
                System.out.println("StringScalar.periodic.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("StringScalar.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "StringScalar.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "StringScalar.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "StringScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "StringScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "StringScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "StringScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.stringValue = da.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(da);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed dfe) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.stringValue = null;
                this.setPointValue = null;
                System.out.println("StringScalar.change.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("StringScalar.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

