/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class StringImageHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;
    String[][] retval = new String[1][1];

    public StringImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireImageValueChanged(String[][] newValue, long timeStamp) {
        this.propChanges.fireStringImageEvent((IStringImage)((Object)this.attribute), newValue, timeStamp);
    }

    void insert(DeviceAttribute da, String[][] stringImg) {
        String[] flatStr = this.flatten(stringImg);
        da.insert(flatStr, stringImg.length, stringImg[0].length);
    }

    String[] flatten(String[][] src) {
        int size = src.length * src[0].length;
        String[] dst = new String[size];
        for (int i = 0; i < src.length; ++i) {
            System.arraycopy(src[i], 0, dst, i * src.length, src.length);
        }
        return dst;
    }

    String[][] getStringImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        String[] tmp = deviceAttribute.extractStringArray();
        int ydim = this.attribute.getYDimension();
        int xdim = this.attribute.getXDimension();
        if (ydim != this.retval.length || this.retval.length == 0 || xdim != this.retval[0].length) {
            this.retval = new String[ydim][xdim];
        }
        int k = 0;
        for (int y = 0; y < ydim; ++y) {
            for (int x = 0; x < xdim; ++x) {
                this.retval[y][x] = tmp[k++];
            }
        }
        return this.retval;
    }

    void addStringImageListener(IStringImageListener l) {
        this.propChanges.addStringImageListener(l);
    }

    void removeStringImageListener(IStringImageListener l) {
        this.propChanges.removeStringImageListener(l);
    }

    public String getVersion() {
        return "$Id$";
    }
}

